/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessagesResourcesEnvironment;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.Predicates;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public final class MessageHelper {
    @Deprecated
    public static Message createMessage(String key, String details, Object ... parameters) {
        return MessageHelper.createMessage(MessageType.MESSAGE, key, details, parameters);
    }

    @Deprecated
    public static Message createMessage(String key, Object ... parameters) {
        return MessageHelper.createMessage(MessageType.MESSAGE, key, null, parameters);
    }

    @Deprecated
    public static Message createWarningMessage(String key, String details, Object ... parameters) {
        return MessageHelper.createMessage(MessageType.WARNING, key, details, parameters);
    }

    @Deprecated
    public static Message createWarningMessage(String key, Object ... parameters) {
        return MessageHelper.createMessage(MessageType.WARNING, key, null, parameters);
    }

    @Deprecated
    public static Message createErrorMessage(String key, String details, Object ... parameters) {
        return MessageHelper.createMessage(MessageType.ERROR, key, details, parameters);
    }

    @Deprecated
    public static Message createErrorMessage(String key, Object ... parameters) {
        return MessageHelper.createMessage(MessageType.ERROR, key, null, parameters);
    }

    @Deprecated
    public static Message createExceptonMessage(String key, Throwable t, Object ... parameters) {
        return MessageHelper.createMessage(MessageType.ERROR, key, TextUtil.getExceptionStackTrace((Throwable)t), parameters);
    }

    @Deprecated
    public static boolean hasErrorMessages(Iterable<Message> messages) {
        return MessageHelper.getMessage(messages, MessageType.ERROR) != null;
    }

    public static boolean hasWarningMessages(Iterable<Message> messages) {
        return MessageHelper.getMessage(messages, MessageType.WARNING) != null;
    }

    public static Message getMessage(Iterable<Message> messages, MessageType type) {
        for (Message message : messages) {
            if (message.getType() != type) continue;
            return message;
        }
        return null;
    }

    public static boolean hasMessages(Collection<Message> messages, MessageType type) {
        return MessageHelper.hasMessages(messages, Arrays.asList(type));
    }

    public static boolean hasMessages(Collection<Message> messages, Collection<MessageType> types) {
        for (Message message : messages) {
            if (!types.contains(message.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTheseAndOnlyThese(Collection<Message> messages, Class<? extends Message> ... types) {
        Message message;
        boolean result = false;
        HashSet<String> set = new HashSet<String>(types.length);
        for (Class<? extends Message> c : types) {
            set.add(c.getName());
        }
        Iterator<Message> iterator = messages.iterator();
        while (iterator.hasNext() && (result = set.contains((message = (Message)iterator.next()).getClass().getName()))) {
        }
        return result;
    }

    @Deprecated
    public static Message createMessage(MessageType type, String key, String details, Object ... parameters) {
        Message message = new Message();
        message.setType(type);
        message.setMessage(L10nResourcesManager.createL10nMessage((String)key, (Object[])parameters));
        message.setDetails(details);
        return message;
    }

    @Deprecated
    public static ValidationMessage createValidationMessage(ValidationMessageCategory category, String key, String details, Object ... parameters) {
        return MessageHelper.createValidationMessage(category, MessageType.MESSAGE, key, details, parameters);
    }

    @Deprecated
    public static ValidationMessage createValidationMessage(ValidationMessageCategory category, String key, Object ... parameters) {
        return MessageHelper.createValidationMessage(category, MessageType.MESSAGE, key, null, parameters);
    }

    @Deprecated
    public static ValidationMessage createValidationWarningMessage(ValidationMessageCategory category, String key, String details, Object ... parameters) {
        return MessageHelper.createValidationMessage(category, MessageType.WARNING, key, details, parameters);
    }

    @Deprecated
    public static ValidationMessage createValidationWarningMessage(ValidationMessageCategory category, String key, Object ... parameters) {
        return MessageHelper.createValidationMessage(category, MessageType.WARNING, key, null, parameters);
    }

    @Deprecated
    public static ValidationMessage createValidationErrorMessage(ValidationMessageCategory category, String key, String details, Object ... parameters) {
        return MessageHelper.createValidationMessage(category, MessageType.ERROR, key, details, parameters);
    }

    @Deprecated
    public static ValidationMessage createValidationErrorMessage(ValidationMessageCategory category, String key, Object ... parameters) {
        return MessageHelper.createValidationMessage(category, MessageType.ERROR, key, null, parameters);
    }

    @Deprecated
    public static ValidationMessage createValidationMessage(ValidationMessageCategory category, MessageType type, String key, String details, Object ... parameters) {
        ValidationMessage validationMessage = new ValidationMessage();
        ValidationMessageSeverity severity = null;
        switch (type) {
            case MESSAGE: {
                severity = ValidationMessageSeverity.MESSAGE;
                break;
            }
            case WARNING: {
                severity = ValidationMessageSeverity.WARNING;
                break;
            }
            case ERROR: {
                severity = ValidationMessageSeverity.ERROR;
            }
        }
        validationMessage.setSeverity(severity);
        validationMessage.setCategory(category);
        validationMessage.setMessage(L10nResourcesManager.createL10nMessage((String)key, (Object[])parameters));
        validationMessage.setDetails(details);
        return validationMessage;
    }

    @Deprecated
    public static ValidationMessage createValidationMessage(ValidationMessageCategory category, Message message) {
        if (message == null) {
            return null;
        }
        ValidationMessage validationMessage = new ValidationMessage();
        ValidationMessageSeverity severity = null;
        switch (message.getType()) {
            case MESSAGE: {
                severity = ValidationMessageSeverity.MESSAGE;
                break;
            }
            case WARNING: {
                severity = ValidationMessageSeverity.WARNING;
                break;
            }
            case ERROR: {
                severity = ValidationMessageSeverity.ERROR;
            }
        }
        validationMessage.setSeverity(severity);
        validationMessage.setCategory(category);
        validationMessage.setMessage(message.getMessage());
        validationMessage.setDetails(message.getDetails());
        return validationMessage;
    }

    public static List<Message> filterMessages(Collection<Message> messages, MessageType messageType) {
        ArrayList<Message> result = new ArrayList<Message>();
        if (messageType == null) {
            return result;
        }
        for (Message mes : messages) {
            if (mes.getType() != messageType) continue;
            result.add(mes);
        }
        return result;
    }

    public static <M extends Message> List<M> filterMessages(Collection<Message> messages, Class<M> messageClass) {
        ArrayList<M> result = new ArrayList<M>();
        if (messageClass == null) {
            return result;
        }
        for (Message mes : messages) {
            if (!messageClass.isAssignableFrom(mes.getClass())) continue;
            result.add(messageClass.cast(mes));
        }
        return result;
    }

    public static String toHtmlString(Collection<Message> messages) {
        return MessageHelper.toHtmlString(messages.toArray(new Message[messages.size()]));
    }

    public static String toHtmlString(Message ... messages) {
        return messages != null && messages.length > 0 ? "<html>" + MessageHelper.toString(messages) : null;
    }

    public static String toString(Collection<? extends Message> messages) {
        return MessageHelper.toString(messages.toArray(new Message[messages.size()]));
    }

    public static String toString(Message ... messages) {
        L10nResourcesManager l10nResourcesManager = LocaleManager.get().getL10nResourceManager();
        StringBuilder stringBuilder = new StringBuilder();
        for (Message message : messages) {
            if (message == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("<br>");
            }
            stringBuilder.append("<b>");
            stringBuilder.append(message.getType());
            stringBuilder.append(":</b>&nbsp;");
            stringBuilder.append(l10nResourcesManager.getMessage(message.getMessage()));
            stringBuilder.append("<br>");
            if (TextUtil.isBlank((String)message.getDetails())) continue;
            stringBuilder.append("<b>\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f:</b>&nbsp;");
            stringBuilder.append(message.getDetails());
            stringBuilder.append("<br>");
        }
        return stringBuilder.toString();
    }

    public static String toSimpleString(Collection<? extends Message> messages) {
        if (CollectionUtil.isEmpty(messages)) {
            return null;
        }
        return messages.stream().map(MessageHelper::toSimpleString).collect(Collectors.joining("\n"));
    }

    public static <M extends Message> String toSimpleString(M mes) {
        StringBuilder sb = new StringBuilder();
        sb.append(mes.getType().toString());
        sb.append(": ");
        sb.append(mes.getMessage().toString());
        if (TextUtil.nonBlank((String)mes.getDetails())) {
            sb.append(". \u0414\u0435\u0442\u0430\u043b\u0438:\n----------\n").append(mes.getDetails()).append("\n----------");
        }
        return sb.toString();
    }

    public static boolean hasErrorValidationMessages(Collection<ValidationMessage> messages) {
        for (ValidationMessage vmes : messages) {
            if (vmes.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            return true;
        }
        return false;
    }

    public static Collection<ValidationMessage> getValidMessagesBySeverity(Collection<ValidationMessage> messages, ValidationMessageSeverity severity) {
        return MessageHelper.filterValidMessages(messages, severity, null);
    }

    public static Collection<ValidationMessage> getValidMessagesByCategory(Collection<ValidationMessage> messages, ValidationMessageCategory category) {
        return MessageHelper.filterValidMessages(messages, null, category);
    }

    public static Collection<ValidationMessage> filterValidMessages(Collection<ValidationMessage> messages, ValidationMessageSeverity severity, ValidationMessageCategory category) {
        if (severity == null && category == null) {
            return messages;
        }
        ArrayList<ValidationMessage> result = new ArrayList<ValidationMessage>();
        for (ValidationMessage mes : messages) {
            boolean add = true;
            if (severity != null && mes.getSeverity() != severity) {
                add = false;
            }
            if (category != null && mes.getCategory() != category) {
                add = false;
            }
            if (!add) continue;
            result.add(mes);
        }
        return result;
    }

    public static void removeMessages(Collection<ValidationMessage> messages, ValidationMessageSeverity severity) {
        MessageHelper.removeMessages(messages, severity, null);
    }

    public static void removeMessages(Collection<ValidationMessage> messages, ValidationMessageCategory category) {
        MessageHelper.removeMessages(messages, null, category);
    }

    public static void removeMessages(Collection<ValidationMessage> messages, ValidationMessageSeverity severity, ValidationMessageCategory category) {
        Iterator<ValidationMessage> iterator = messages.iterator();
        while (iterator.hasNext()) {
            ValidationMessage message = iterator.next();
            if ((severity == null || severity != message.getSeverity()) && (category == null || category != message.getCategory())) continue;
            iterator.remove();
        }
    }

    public static ValidationMessage createValidationMessage(ValidationMessageType messageType, Throwable ex, Object ... parameters) {
        return ((ValidationMessagesResourcesEnvironment)Environment.getPublished(ValidationMessagesResourcesEnvironment.class)).createValidationMessage(TextUtil.getExceptionStackTrace((Throwable)ex), messageType, parameters);
    }

    public static class MessageGroup<M extends Message> {
        private Collection<M> messages;

        public MessageGroup(Collection<M> messages) {
            this.messages = messages;
        }

        public <MM extends M> MessageGroup<MM> filter(Predicates.NarrowingPredicate<M, MM> pred) {
            return new MessageGroup<M>(Streams.filter(this.messages.stream(), pred).collect(Collectors.toList()));
        }

        public <MM extends M> MessageGroup<MM> filterAndRemove(Predicates.NarrowingPredicate<M, MM> pred) {
            ArrayList<Message> satisfying = new ArrayList<Message>();
            ArrayList<M> others = new ArrayList<M>();
            for (Message m : this.messages) {
                if (pred.test((Object)m)) {
                    satisfying.add(m);
                    continue;
                }
                others.add(m);
            }
            this.messages = others;
            return new MessageGroup(satisfying);
        }

        public List<M> get() {
            return CollectionUtil.list(this.messages);
        }
    }
}

