/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import org.slf4j.LoggerFactory;

public abstract class OnCreateFopListener {
    private static final OnCreateFopListener INSTANCE;

    public abstract void onCreateFop(BaseProduct var1, Fop var2, ContractType var3);

    public abstract PaymentType getDefaultFopPaymentType(BaseProduct var1, ContractType var2);

    public static void fire(BaseProduct product, Fop fop, ContractType contractType) {
        OnCreateFopListener instance = INSTANCE;
        if (null == instance) {
            return;
        }
        instance.onCreateFop(product, fop, contractType);
    }

    public static PaymentType getDefaultPaymentType(BaseProduct product, ContractType contractType) {
        OnCreateFopListener instance = INSTANCE;
        if (null == instance) {
            return null;
        }
        return instance.getDefaultFopPaymentType(product, contractType);
    }

    static {
        OnCreateFopListener instance;
        String className = System.getProperty(OnCreateFopListener.class.getName());
        try {
            instance = className != null ? (OnCreateFopListener)OnCreateFopListener.class.getClassLoader().loadClass(className).newInstance() : null;
        }
        catch (Exception e) {
            instance = null;
            LoggerFactory.getLogger(OnCreateFopListener.class).error("error while create OnCreateFopListener", (Throwable)e);
        }
        INSTANCE = instance;
    }
}

