/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;

public class PaymentCardHelper {
    public static boolean isPaymentCardMasked(Product product) {
        return PaymentCardHelper.isPaymentCardMasked(AirProductHelper.getVendorContractRelation(product).getFops());
    }

    public static boolean isPaymentCardMasked(ProductFop pf) {
        boolean result = false;
        String MaskedPaymentCardNumberRegEx = "^([0-9]{6})(0{4,6})([0-9]{4})";
        if (pf != null && PaymentCardHelper.isCCPaymentType(pf.getType()) && (pf.getCard() == null || pf.getCard().getNumber() == null || pf.getCard().getNumber().matches(MaskedPaymentCardNumberRegEx))) {
            result = true;
        }
        return result;
    }

    public static boolean isValidPC(ProductFop model) {
        String number;
        String string = number = model.getCard() != null ? model.getCard().getNumber() : "";
        if (TextUtil.isBlank((String)number) || number.length() != 16) {
            return false;
        }
        int oddSum = 0;
        int evenSum = 0;
        for (int i = 0; i < 15; ++i) {
            int digit;
            try {
                digit = Integer.valueOf(number.substring(i, i + 1));
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (i % 2 == 0) {
                int sum = 2 * digit;
                if (sum > 9 && (sum %= 9) == 0) {
                    sum = 9;
                }
                evenSum += sum;
                continue;
            }
            oddSum += digit;
        }
        int totalSum = evenSum + oddSum + Integer.valueOf(number.substring(15));
        return totalSum % 10 == 0;
    }

    public static boolean isPaymentCardMasked(Collection<ProductFop> productFops) {
        boolean result = false;
        String MaskedPaymentCardNumberRegEx = "^([0-9]{6})(0{4,6})([0-9]{4})";
        for (ProductFop pf : productFops) {
            if (pf == null || !PaymentCardHelper.isCCPaymentType(pf.getType()) || pf.getCard() != null && pf.getCard().getNumber() != null && !pf.getCard().getNumber().matches(MaskedPaymentCardNumberRegEx)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isCCPaymentType(PaymentType type) {
        return type != null && type.name().contains("CREDIT_CARD");
    }
}

