/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.profile.Person;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PersonHelper {
    private static List<List<String>> collectRefinedPersonNames(Person person) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        person.getPassports().forEach(passport -> result.add(PersonHelper.refineNames(passport.getFirstName(), passport.getLastName())));
        Stream.concat(person.getFirstName().getValues().keySet().stream(), person.getLastName().getValues().keySet().stream()).distinct().forEach(locale -> result.add(PersonHelper.refineNames((String)person.getFirstName().getValues().get(locale), (String)person.getLastName().getValues().get(locale))));
        result.removeIf(List::isEmpty);
        return result;
    }

    public static boolean hasPermutableNames(Person person, List<String> refinedNames) {
        boolean result = false;
        for (List<String> refinedPersonNames : PersonHelper.collectRefinedPersonNames(person)) {
            if (!PersonHelper.isPermutableMatch(refinedNames, refinedPersonNames)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isPermutableMatch(List<String> refinedTargetNames, List<String> refinedAgainstNames) {
        boolean result = !refinedTargetNames.isEmpty();
        ArrayList<String> depletableNames = new ArrayList<String>(refinedAgainstNames);
        for (String name : refinedTargetNames) {
            if (depletableNames.remove(name)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static String refineName(String name) {
        String result = name;
        if (result != null && (result = result.toLowerCase().replaceAll("-", " ").trim()).isEmpty()) {
            result = null;
        }
        return result;
    }

    public static List<String> refineNames(List<String> names) {
        return PersonHelper.refineNames(names.stream());
    }

    public static List<String> refineNames(Stream<String> names) {
        return names.map(PersonHelper::refineName).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<String> refineNames(String ... names) {
        return PersonHelper.refineNames(Stream.of(names));
    }
}

