/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractRelationType;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescription;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class ProductVoidingHelper {
    private ProductVoidingHelper() {
    }

    public static ProductStatus getRelatedProductStatus(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (bp, handler) -> handler.getStatus(bp));
    }

    public static EntityReference<Organization> getAgency(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (bp, handler) -> GeneralProductHelper.getContractor(handler.getSalesChain(bp), PredefinedContractorType.AGENCY));
    }

    public static EntityReference<Organization> getSubagency(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (bp, handler) -> GeneralProductHelper.getContractor(handler.getSalesChain(bp), PredefinedContractorType.SUBAGENCY));
    }

    public static EntityReference<Organization> getSupplier(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (bp, handler) -> GeneralProductHelper.getContractor(handler.getSalesChain(bp), PredefinedContractorType.SUPPLIER));
    }

    public static EntityReference<SalesPoint> getSalesPoint(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (bp, handler) -> handler.findSalesPoint(bp));
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissions(ProductVoiding product, ContractType vendor) {
        GeneralProductContractRelationData relation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation(product.getContractRelations(), vendor);
        return relation == null ? Collections.emptyList() : relation.getCommissions();
    }

    public static List<GeneralProductContractRelationData> updateAndGetContractRelations(ProductVoiding prod) {
        List originalRelations = prod.getContractRelations();
        SalesChain salesChain = ProductVoidingHelper.getRelatedProductValue(prod, (bp, handler) -> handler.getSalesChain(bp));
        if (salesChain.getDescription() == null) {
            return originalRelations;
        }
        ArrayList<GeneralProductContractRelationData> subresult = new ArrayList<GeneralProductContractRelationData>();
        ArrayList toDelete = new ArrayList(originalRelations);
        boolean modified = false;
        for (EntityReference item : ((SalesChainDescription)EntityStorage.get().resolve(salesChain.getDescription()).getEntity()).getContractRelations()) {
            GeneralProductContractRelationData relation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation(originalRelations, (EntityReference<ContractRelationDescription>)item);
            if (relation != null) {
                subresult.add(relation);
                toDelete.remove(relation);
                continue;
            }
            PredefinedContractRelationType predefinedType = ((ContractRelationDescription)EntityStorage.get().resolve(item).getEntity()).getPredefinedType();
            if ((predefinedType == PredefinedContractRelationType.AGENCY_TO_CLIENT || predefinedType == PredefinedContractRelationType.SUBAGENCY_TO_CLIENT) && (relation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation(originalRelations, ContractType.CLIENT)) != null) {
                relation.setDescription(item);
                subresult.add(relation);
                toDelete.remove(relation);
                continue;
            }
            relation = new GeneralProductContractRelationData();
            relation.setDescription(item);
            subresult.add(relation);
            modified = true;
        }
        if (modified || !toDelete.isEmpty()) {
            originalRelations.clear();
            originalRelations.addAll(subresult);
        }
        return originalRelations;
    }

    public static GeneralProductContractRelationData getClientContractRelation(ProductVoiding prod) {
        return (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation(prod.getContractRelations(), ContractType.CLIENT);
    }

    public static GeneralProductContractRelationData getSubagentContractRelation(ProductVoiding prod) {
        return (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation(prod.getContractRelations(), ContractType.SUBAGENCY);
    }

    public static GeneralProductContractRelationData getVendorContractRelation(ProductVoiding prod) {
        return (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation(prod.getContractRelations(), ContractType.VENDOR);
    }

    public static List<GeneralProductFop> getClientFops(ProductVoiding miscProduct) {
        GeneralProductContractRelationData relation = ProductVoidingHelper.getClientContractRelation(miscProduct);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<GeneralProductFop> getVendorFops(ProductVoiding miscProduct) {
        GeneralProductContractRelationData relation = ProductVoidingHelper.getVendorContractRelation(miscProduct);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<GeneralProductFop> getSubagentFops(ProductVoiding product, boolean autoCreateRelation) {
        GeneralProductContractRelationData relation = ProductVoidingHelper.updateAndGetSubagentContractRelation(product, autoCreateRelation);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<ProductVoiding> getRelatedVoidings(BaseProduct product) {
        return product.getReservation().getProducts().stream().filter(bp -> bp instanceof ProductVoiding).map(bp -> (ProductVoiding)bp).filter(pv -> pv.getRelatedProduct() == product).collect(Collectors.toList());
    }

    public static <T> T getRelatedProductValue(ProductVoiding prod, RelatedProductCallback<T> callback) {
        BaseProduct rp = prod.getRelatedProduct();
        if (rp == null) {
            return null;
        }
        ProductHandler<BaseProduct> handler = HandlersRegistry.get().findProductHandler(rp.getClass());
        return callback.calculate(rp, handler);
    }

    public static GeneralProductContractRelationData updateAndGetSubagentContractRelation(ProductVoiding prod, boolean autoUpdateSalesChain) {
        for (GeneralProductContractRelationData relation : prod.getContractRelations()) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != ContractType.SUBAGENCY) continue;
            return relation;
        }
        SalesChain salesChain = ProductVoidingHelper.getRelatedProductValue(prod, (rp, handler) -> handler.getSalesChain(rp));
        if (GeneralProductHelper.isOwnPredefinedSalesChainType(((SalesChainDescription)EntityStorage.get().resolve(salesChain.getDescription()).getEntity()).getPredefinedType())) {
            if (!autoUpdateSalesChain) {
                return null;
            }
            salesChain.setDescription(GeneralProductHelper.getPredefinedDescription(PredefinedSalesChainType.SUBAGENT, (EntityReference<SalesChainDescription>)salesChain.getDescription()));
            Contractor contractor = new Contractor();
            contractor.setDescription(GeneralProductHelper.findPredefinedContractorDescription(PredefinedContractorType.SUBAGENCY));
            contractor.setContractor(GeneralProductHelper.getContractor(salesChain, PredefinedContractorType.AGENCY));
            List lst = salesChain.getContractors();
            lst.add(lst.size() - 1, contractor);
            for (GeneralProductContractRelationData relation : prod.getContractRelations()) {
                if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != ContractType.SUBAGENCY) continue;
                return relation;
            }
        }
        throw new IllegalStateException("subagent contract relation is absent in product");
    }

    public static boolean removeProduct(ProductVoiding product) {
        product.getReservation().getProducts().remove(product);
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(ProductVoiding product, BaseProduct relatedProduct) {
        if (MiscUtil.equals((Object)product.getRelatedProduct(), (Object)relatedProduct)) {
            product.setRelatedProduct(null);
        }
        return true;
    }

    public static interface RelatedProductCallback<T> {
        public T calculate(BaseProduct var1, ProductHandler<BaseProduct> var2);
    }
}

