/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class RouteHelper {
    private static final String defaultPlaceholder = "?";

    public static String getRoute(List<AddressData> routeDatas) {
        return RouteHelper.getRoute(routeDatas, Arrays.asList(AddressElementType.STREET, AddressElementType.CITY, AddressElementType.COUNTRY), Collections.emptyList(), defaultPlaceholder);
    }

    public static String getRoute(List<AddressData> routeDatas, Collection<AddressElementType> mandatoryElementTypes) {
        return RouteHelper.getRoute(routeDatas, Arrays.asList(AddressElementType.STREET, AddressElementType.CITY, AddressElementType.COUNTRY), mandatoryElementTypes, defaultPlaceholder);
    }

    public static String getRoute(List<AddressData> routeDatas, List<AddressElementType> patternElementTypes, Collection<AddressElementType> mandatoryElementTypes, String placeholder) {
        if (patternElementTypes.size() == 0) {
            return null;
        }
        StringBuilder route = new StringBuilder();
        AddressElementType addressElementType = patternElementTypes.get(patternElementTypes.size() - 1);
        Set addressElements = routeDatas.stream().filter(item -> mandatoryElementTypes.contains((Object)addressElementType) ? true : item.getElements().get((Object)addressElementType) != null).map(item -> item.getElements().get((Object)addressElementType)).collect(Collectors.toSet());
        if (addressElements.size() == 0) {
            String subroute = RouteHelper.getRoute(routeDatas, patternElementTypes.subList(0, patternElementTypes.size() - 1), mandatoryElementTypes, placeholder);
            if (subroute != null) {
                route.append(subroute);
            }
        } else if (addressElements.size() == 1 && addressElements.iterator().next() != null) {
            String subroute = RouteHelper.getRoute(routeDatas, patternElementTypes.subList(0, patternElementTypes.size() - 1), mandatoryElementTypes, placeholder);
            if (subroute != null) {
                route.append(subroute);
            }
            if (route.length() > 0) {
                route.append(", ");
            }
            route.append((String)addressElements.iterator().next());
        } else {
            String subroute = RouteHelper.getSubroute(routeDatas, patternElementTypes, mandatoryElementTypes, placeholder);
            if (subroute != null) {
                route.append(subroute);
            }
        }
        return route.length() > 0 ? route.toString() : null;
    }

    private static String getSubroute(List<AddressData> routeDatas, List<AddressElementType> routeElementTypes, Collection<AddressElementType> mandatoryElementTypes, String placeholder) {
        StringBuilder subroute = new StringBuilder();
        for (AddressData routeData : routeDatas) {
            String address = RouteHelper.getAddress(routeData, routeElementTypes, mandatoryElementTypes, placeholder);
            if (address == null) continue;
            if (subroute.length() > 0) {
                subroute.append(" - ");
            }
            subroute.append(address);
        }
        return subroute.length() > 0 ? subroute.toString() : null;
    }

    private static String getAddress(AddressData routeData, List<AddressElementType> routeElementTypes, Collection<AddressElementType> mandatoryElementTypes, String placeholder) {
        StringBuilder address = new StringBuilder();
        for (AddressElementType routeElementType : routeElementTypes) {
            String addressElement = Optional.ofNullable(routeData.getElements().get((Object)routeElementType)).orElse(mandatoryElementTypes.contains((Object)routeElementType) ? placeholder : null);
            if (TextUtil.isBlank((String)addressElement)) continue;
            if (address.length() > 0) {
                address.append(", ");
            }
            address.append(addressElement);
        }
        return address.length() > 0 ? address.toString() : null;
    }

    public static enum AddressElementType {
        COUNTRY,
        CITY,
        STREET;

    }

    public static class AddressDataBuilder {
        private final Map<AddressElementType, String> elements = new HashMap<AddressElementType, String>();

        public static AddressDataBuilder get() {
            return new AddressDataBuilder();
        }

        private AddressDataBuilder() {
        }

        public AddressDataBuilder country(String country) {
            this.elements.put(AddressElementType.COUNTRY, country);
            return this;
        }

        public AddressDataBuilder city(String city) {
            this.elements.put(AddressElementType.CITY, city);
            return this;
        }

        public AddressDataBuilder street(String street) {
            this.elements.put(AddressElementType.STREET, street);
            return this;
        }

        public AddressData build() {
            return new AddressData(this);
        }
    }

    public static class AddressData {
        private final Map<AddressElementType, String> elements = new HashMap<AddressElementType, String>();

        private AddressData(AddressDataBuilder builder) {
            this.elements.clear();
            this.elements.putAll(builder.elements);
        }

        public Map<AddressElementType, String> getElements() {
            return this.elements;
        }
    }
}

