/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.helpers.RouteHelper;
import com.gridnine.xtrip.common.test.TestBase;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class RouteHelperTest
extends TestBase {
    @Test
    public void getRouteTest01() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertNull((Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"? - ? - ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"?, ? - ?, ? - ?, ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"?, ?, ? - ?, ?, ? - ?, ?, ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest02() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().country(null).build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().country(null).build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().country(null).build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertNull((Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"? - ? - ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"?, ? - ?, ? - ?, ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"?, ?, ? - ?, ?, ? - ?, ?, ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest03() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().country(null).city(null).build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().country(null).city(null).build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().country(null).city(null).build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertNull((Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"? - ? - ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"?, ? - ?, ? - ?, ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"?, ?, ? - ?, ?, ? - ?, ?, ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest04() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().country(null).city(null).street(null).build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().country(null).city(null).street(null).build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().country(null).city(null).street(null).build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertNull((Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"? - ? - ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"?, ? - ?, ? - ?, ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"?, ?, ? - ?, ?, ? - ?, ?, ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest05() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().country("Russia").build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().country("Italia").build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().country(null).build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertEquals((Object)"Russia - Italia", (Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"Russia - Italia - ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"?, Russia - ?, Italia - ?, ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"?, ?, Russia - ?, ?, Italia - ?, ?, ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest06() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().country("Russia").build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().country(null).build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().country("Japan").build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertEquals((Object)"Russia - Japan", (Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"Russia - ? - Japan", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"?, Russia - ?, ? - ?, Japan", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"?, ?, Russia - ?, ?, ? - ?, ?, Japan", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest07() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().country("Russia").build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().country(null).build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().country("Russia").build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertEquals((Object)"Russia", (Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"Russia - ? - Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"?, Russia - ?, ? - ?, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"?, ?, Russia - ?, ?, ? - ?, ?, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest08() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().country("Russia").build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().country("Russia").build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().country("Russia").build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertEquals((Object)"Russia", (Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"? - ? - ?, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"?, ? - ?, ? - ?, ?, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest09() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().city("Moscow").build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().city("Moscow").build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().city("Moscow").build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertEquals((Object)"Moscow", (Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"Moscow, ? - Moscow, ? - Moscow, ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"Moscow, ? - Moscow, ? - Moscow, ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"?, Moscow, ? - ?, Moscow, ? - ?, Moscow, ?", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest10() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Moscow").street("First str, 10").build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Moscow").street("First str, 10").build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Moscow").street("First str, 10").build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertEquals((Object)"First str, 10, Moscow, Russia", (Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"First str, 10, Moscow, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"First str, 10, Moscow, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"First str, 10, Moscow, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest11() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Moscow").street("First str, 10").build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Moscow").street("Second str, 20").build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Moscow").street("Third str, 30").build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertEquals((Object)"First str, 10 - Second str, 20 - Third str, 30, Moscow, Russia", (Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"First str, 10 - Second str, 20 - Third str, 30, Moscow, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"First str, 10 - Second str, 20 - Third str, 30, Moscow, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"First str, 10 - Second str, 20 - Third str, 30, Moscow, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest12() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Moscow").street("First str, 10").build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Saransk").street("Second str, 20").build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Khabarovsk").street("Third str, 30").build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertEquals((Object)"First str, 10, Moscow - Second str, 20, Saransk - Third str, 30, Khabarovsk, Russia", (Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"First str, 10, Moscow - Second str, 20, Saransk - Third str, 30, Khabarovsk, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"First str, 10, Moscow - Second str, 20, Saransk - Third str, 30, Khabarovsk, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"First str, 10, Moscow - Second str, 20, Saransk - Third str, 30, Khabarovsk, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest13() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Moscow").street("First str, 10").build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Saransk").street("Second str, 20").build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Moscow").street("First str, 10").build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertEquals((Object)"First str, 10, Moscow - Second str, 20, Saransk - First str, 10, Moscow, Russia", (Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"First str, 10, Moscow - Second str, 20, Saransk - First str, 10, Moscow, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"First str, 10, Moscow - Second str, 20, Saransk - First str, 10, Moscow, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"First str, 10, Moscow - Second str, 20, Saransk - First str, 10, Moscow, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest14() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Moscow").street("First str, 10").build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Moscow").street("First str, 10").build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Saransk").street("Second str, 20").build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertEquals((Object)"First str, 10, Moscow - First str, 10, Moscow - Second str, 20, Saransk, Russia", (Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"First str, 10, Moscow - First str, 10, Moscow - Second str, 20, Saransk, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"First str, 10, Moscow - First str, 10, Moscow - Second str, 20, Saransk, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"First str, 10, Moscow - First str, 10, Moscow - Second str, 20, Saransk, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest15() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Moscow").street("First str, 10").build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().country("Russia").build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Saransk").street("Second str, 20").build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertEquals((Object)"First str, 10, Moscow - Second str, 20, Saransk, Russia", (Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"First str, 10, Moscow - Second str, 20, Saransk, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"First str, 10, Moscow - ? - Second str, 20, Saransk, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"First str, 10, Moscow - ?, ? - Second str, 20, Saransk, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest16() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Moscow").street("First str, 10").build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().country("Russia").build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Moscow").street("First str, 10").build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertEquals((Object)"First str, 10, Moscow, Russia", (Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"First str, 10, Moscow, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"First str, 10, Moscow - ? - First str, 10, Moscow, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"First str, 10, Moscow - ?, ? - First str, 10, Moscow, Russia", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest17() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Moscow").street("First str, 10").build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().country("Italia").city("Rome").street("Second str, 20").build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().country("Japan").city("Tokyo").street("Third str, 30").build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertEquals((Object)"First str, 10, Moscow, Russia - Second str, 20, Rome, Italia - Third str, 30, Tokyo, Japan", (Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"First str, 10, Moscow, Russia - Second str, 20, Rome, Italia - Third str, 30, Tokyo, Japan", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"First str, 10, Moscow, Russia - Second str, 20, Rome, Italia - Third str, 30, Tokyo, Japan", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"First str, 10, Moscow, Russia - Second str, 20, Rome, Italia - Third str, 30, Tokyo, Japan", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }

    @Test
    public void getRouteTest18() {
        RouteHelper.AddressData routeData1 = RouteHelper.AddressDataBuilder.get().country("Russia").city("Moscow").street("First str, 10").build();
        RouteHelper.AddressData routeData2 = RouteHelper.AddressDataBuilder.get().country("Italia").city("Rome").street("First str, 10").build();
        RouteHelper.AddressData routeData3 = RouteHelper.AddressDataBuilder.get().country("Japan").city("Tokyo").street("First str, 10").build();
        ArrayList<RouteHelper.AddressData> routeDatas = new ArrayList<RouteHelper.AddressData>();
        routeDatas.add(routeData1);
        routeDatas.add(routeData2);
        routeDatas.add(routeData3);
        Assert.assertEquals((Object)"First str, 10, Moscow, Russia - First str, 10, Rome, Italia - First str, 10, Tokyo, Japan", (Object)RouteHelper.getRoute(routeDatas));
        Assert.assertEquals((Object)"First str, 10, Moscow, Russia - First str, 10, Rome, Italia - First str, 10, Tokyo, Japan", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY)));
        Assert.assertEquals((Object)"First str, 10, Moscow, Russia - First str, 10, Rome, Italia - First str, 10, Tokyo, Japan", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY)));
        Assert.assertEquals((Object)"First str, 10, Moscow, Russia - First str, 10, Rome, Italia - First str, 10, Tokyo, Japan", (Object)RouteHelper.getRoute(routeDatas, Arrays.asList(RouteHelper.AddressElementType.COUNTRY, RouteHelper.AddressElementType.CITY, RouteHelper.AddressElementType.STREET)));
    }
}

