/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class StatisticsHelperTest {
    private static final HandlersRegistry handlersRegistry = (HandlersRegistry)Mockito.mock(HandlersRegistry.class);

    @Test
    public void WhenProductHaveCostCodeWithCorrectPropertyAndCategoryThenReturnThisProperty() throws Exception {
        Organization client = new Organization();
        BaseProduct baseProduct = (BaseProduct)Mockito.mock(BaseProduct.class);
        Traveller traveller = new Traveller();
        StatisticalData statisticalData = new StatisticalData();
        ProductHandler handler = (ProductHandler)Mockito.mock(ProductHandler.class);
        this.initialize(baseProduct, statisticalData, handler);
        DictionaryReference category = (DictionaryReference)Mockito.mock(DictionaryReference.class);
        CostCodeProperties costCodeProperties = new CostCodeProperties();
        costCodeProperties.setCategory(category);
        CostCode costCode = new CostCode();
        costCode.setCostCodeProperties(costCodeProperties);
        TravellerCostCodes tcc = new TravellerCostCodes();
        tcc.setTraveller(traveller);
        tcc.getCostCodes().add(costCode);
        statisticalData.getTravellerCostCodes().add(tcc);
        Assert.assertThat((Object)StatisticsHelper.getRelevantCostCodeProperties(client, baseProduct, traveller).size(), (Matcher)Is.is((Object)1));
        statisticalData.getTravellerCostCodes().clear();
        category = (DictionaryReference)Mockito.mock(DictionaryReference.class);
        costCodeProperties = new CostCodeProperties();
        costCodeProperties.setCategory(category);
        costCode = new CostCode();
        costCode.setCostCodeProperties(costCodeProperties);
        TravellerCostCodes travellerCostCodes = new TravellerCostCodes();
        travellerCostCodes.getCostCodes().add(costCode);
        statisticalData.getTravellerCostCodes().add(travellerCostCodes);
        Assert.assertThat((Object)StatisticsHelper.getRelevantCostCodeProperties(client, baseProduct, traveller).size(), (Matcher)Is.is((Object)0));
        travellerCostCodes.setTraveller(traveller);
        Assert.assertThat((Object)StatisticsHelper.getRelevantCostCodeProperties(client, baseProduct, traveller).size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void whenPropertyCategoryIsNullThenAvoidNullPointerException() {
        Organization client = new Organization();
        BaseProduct baseProduct = (BaseProduct)Mockito.mock(BaseProduct.class);
        Traveller traveller = new Traveller();
        StatisticalData statisticalData = new StatisticalData();
        ProductHandler handler = (ProductHandler)Mockito.mock(ProductHandler.class);
        this.initialize(baseProduct, statisticalData, handler);
        TravellerCostCodes tcc = new TravellerCostCodes();
        CostCodeProperties costCodeProperties = new CostCodeProperties();
        CostCode costCode = new CostCode();
        costCode.setCostCodeProperties(costCodeProperties);
        tcc.getCostCodes().add(costCode);
        tcc.setTraveller(traveller);
        statisticalData.getTravellerCostCodes().add(tcc);
        Assert.assertThat((Object)StatisticsHelper.getRelevantCostCodeProperties(client, baseProduct, traveller).size(), (Matcher)Is.is((Object)0));
    }

    private void initialize(BaseProduct baseProduct, StatisticalData statisticalData, ProductHandler handler) {
        Mockito.when(handlersRegistry.findProductHandler(baseProduct.getClass())).thenReturn((Object)handler);
        Mockito.when((Object)handler.getStatisticalData(baseProduct)).thenReturn((Object)statisticalData);
    }

    static {
        Environment.publish(HandlersRegistry.class, (Object)handlersRegistry);
    }
}

