/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidatorHelper {
    static final Logger log = LoggerFactory.getLogger(ValidatorHelper.class);

    public static Validator findValidator(EntityReference<SalesPoint> salesPointReference, EntityReference<Organization> blankOwnerReference, EntityReference<Organization> supplierReference, EntityReference<Organization> agencyReference, Date date) throws Exception {
        List<Validator> validators = ValidatorHelper.findValidators(salesPointReference, blankOwnerReference, supplierReference, agencyReference, date);
        return !validators.isEmpty() ? validators.get(0) : null;
    }

    public static List<Validator> findValidators(EntityReference<SalesPoint> salesPointReference, EntityReference<Organization> blankOwnerReference, EntityReference<Organization> supplierReference, EntityReference<Organization> agencyReference, Date date) throws Exception {
        if (salesPointReference == null) {
            return Collections.emptyList();
        }
        EntityContainer salesPointContainer = EntityStorage.get().resolve(salesPointReference);
        if (salesPointContainer == null) {
            return Collections.emptyList();
        }
        ArrayList<Validator> validators = new ArrayList<Validator>();
        for (Validator validator : ((SalesPoint)salesPointContainer.getEntity()).getValidators()) {
            if (blankOwnerReference != null && !blankOwnerReference.equals((Object)validator.getBlankOwner()) || supplierReference != null && !supplierReference.equals((Object)validator.getSupplier()) || agencyReference != null && !agencyReference.equals((Object)validator.getAgency()) || date != null && !MiscUtil.isBetween((Date)validator.getOpened(), (Date)validator.getClosed(), (Date)date)) continue;
            validators.add(validator);
        }
        return validators;
    }

    public static ValidatorIndex getValidatorIndex(String number, EntityReference<Organization> blankOwner, String pccCode, Date date) {
        List<ValidatorIndex> validatorIndexes = ValidatorHelper.getValidatorIndexes(number, blankOwner, pccCode, date);
        return validatorIndexes.isEmpty() ? null : validatorIndexes.get(0);
    }

    public static ValidatorIndex getValidatorIndexForAgency(String number, EntityReference<Organization> blankOwner, EntityReference<Organization> agency, String pccCode, Date date) {
        List<ValidatorIndex> validatorIndexes = ValidatorHelper.getValidatorIndexesForAgency(number, blankOwner, agency, pccCode, date);
        return validatorIndexes.isEmpty() ? null : validatorIndexes.get(0);
    }

    public static List<ValidatorIndex> getValidatorIndexes(String number, EntityReference<Organization> blankOwner, String pccCode, Date date) {
        log.debug(String.format("searching validator number = \"%s\", blankOwner = \"%s\" (%s), pccCode = \"%s\", date = \"%s\"", number, blankOwner, blankOwner != null ? blankOwner.getUid() : "?", pccCode, date));
        if (blankOwner == null) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        if (!TextUtil.isBlank((String)number)) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.number.name(), (Object)number));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.blankOwner.name(), blankOwner));
        ValidatorHelper.addToValidatorQuery(query, date);
        log.debug(String.format("query = %s", query));
        ArrayList<ValidatorIndex> validatorIndexes = new ArrayList<ValidatorIndex>(EntityStorage.get().search(ValidatorIndex.class, query).getData());
        log.debug(String.format("found validators %s", String.valueOf(validatorIndexes.size())));
        for (ValidatorIndex validatorIndex : validatorIndexes) {
            log.debug(String.format("validators %s", validatorIndex.getNavigationKey()));
        }
        if (validatorIndexes.size() > 1 && !TextUtil.isBlank((String)pccCode)) {
            Iterator iterator = validatorIndexes.iterator();
            while (iterator.hasNext()) {
                ValidatorIndex validatorIndex;
                validatorIndex = (ValidatorIndex)iterator.next();
                log.debug(String.format("checking validator %s", validatorIndex.getNavigationKey()));
                if (TextUtil.isBlank((String)validatorIndex.getPcc())) {
                    log.debug(String.format("validator has no pcc code", new Object[0]));
                    EntityContainer salesPointContainer = EntityStorage.get().resolve(validatorIndex.getSource());
                    if (salesPointContainer != null) {
                        log.debug(String.format("validator sales point %s (%s)", salesPointContainer.getEntity(), ((SalesPoint)salesPointContainer.getEntity()).getUid()));
                        SalesPoint salesPoint = (SalesPoint)salesPointContainer.getEntity();
                        boolean found = false;
                        for (Pcc pcc : salesPoint.getPccs()) {
                            log.debug(String.format("checking pcc %s (%s)", pcc.getNotes(), pcc.getUid()));
                            if (!TextUtil.isSame((String)pccCode, (String)pcc.getCode(), (boolean)true)) continue;
                            log.debug(String.format("found indicated pcc", new Object[0]));
                            found = true;
                            break;
                        }
                        if (found) continue;
                        log.debug(String.format("indicated pcc not found, remove validator", new Object[0]));
                        iterator.remove();
                        continue;
                    }
                    log.debug(String.format("sales point was not resolved, remove validator", new Object[0]));
                    iterator.remove();
                    continue;
                }
                log.debug(String.format("validator has pcc code", new Object[0]));
                if (TextUtil.isSame((String)pccCode, (String)validatorIndex.getPcc(), (boolean)true)) continue;
                log.debug(String.format("validator has not indicated pcc code", new Object[0]));
                iterator.remove();
            }
        }
        return validatorIndexes;
    }

    public static List<ValidatorIndex> getValidatorIndexesForAgency(String number, EntityReference<Organization> blankOwner, EntityReference<Organization> agency, String pccCode, Date date) {
        if (blankOwner == null) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        if (!TextUtil.isBlank((String)number)) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.number.name(), (Object)number));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.blankOwner.name(), blankOwner));
        if (agency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.agency.name(), agency));
        }
        ValidatorHelper.addToValidatorQuery(query, date);
        List validatorIndexes = EntityStorage.get().search(ValidatorIndex.class, query).getData();
        if (validatorIndexes.size() > 1 && !TextUtil.isBlank((String)pccCode)) {
            Iterator iterator = validatorIndexes.iterator();
            while (iterator.hasNext()) {
                ValidatorIndex validatorIndex = (ValidatorIndex)iterator.next();
                if (TextUtil.isSame((String)validatorIndex.getPcc(), (String)pccCode, (boolean)true)) continue;
                iterator.remove();
            }
        }
        return validatorIndexes;
    }

    public static ValidatorIndex findValidator(String validatorCode, Date date) throws Exception {
        if (TextUtil.isBlank((String)validatorCode)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.number.name(), (Object)validatorCode));
        ValidatorHelper.addToValidatorQuery(query, date);
        List data = EntityStorage.get().search(ValidatorIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData();
        return !data.isEmpty() ? (ValidatorIndex)data.get(0) : null;
    }

    public static List<ValidatorIndex> getValidators(String validatorCode, Date date) throws Exception {
        if (TextUtil.isBlank((String)validatorCode)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.number.name(), (Object)validatorCode));
        ValidatorHelper.addToValidatorQuery(query, date);
        List data = EntityStorage.get().search(ValidatorIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData();
        return data;
    }

    public static List<ValidatorIndex> getValidators(Product product) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.number.name(), (Object)product.getValidatorCode()));
        ValidatorHelper.addToValidatorQuery(query, product.getIssueDate());
        if (product.getSalesPoint() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)product.getSalesPoint().getUid()));
        }
        if (product.getBlankOwnerRef() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ValidatorIndex.Property.blankOwner.name(), null), SearchCriterion.eq((String)ValidatorIndex.Property.blankOwner.name(), (Object)product.getBlankOwnerRef())}));
        }
        return EntityStorage.get().search(ValidatorIndex.class, query).getData();
    }

    public static List<ValidatorIndex> getValidators(String validator, String pcc, Date operationDate) throws Exception {
        SearchQuery query = new SearchQuery();
        if (!TextUtil.isBlank((String)pcc)) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ValidatorIndex.Property.pcc.name(), null), SearchCriterion.ieq((String)ValidatorIndex.Property.pcc.name(), (String)pcc)}));
        }
        if (!TextUtil.isBlank((String)validator)) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.number.name(), (Object)validator));
        }
        ValidatorHelper.addToValidatorQuery(query, operationDate);
        List indices = EntityStorage.get().search(ValidatorIndex.class, query).getData();
        if (TextUtil.nonBlank((String)pcc) && indices.stream().anyMatch(index -> pcc.equalsIgnoreCase(index.getPcc()))) {
            indices.removeIf(index -> index.getPcc() == null);
        }
        return indices;
    }

    public static ValidatorIndex findValidator(String validatorCode, EntityReference<Organization> blankOwner, Date date) throws Exception {
        if (TextUtil.isBlank((String)validatorCode)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.number.name(), (Object)validatorCode));
        if (blankOwner != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.blankOwner.name(), blankOwner));
        }
        ValidatorHelper.addToValidatorQuery(query, date);
        List data = EntityStorage.get().search(ValidatorIndex.class, query).getData();
        return !data.isEmpty() ? (ValidatorIndex)data.get(0) : null;
    }

    private static void addToValidatorQuery(SearchQuery query, Date date) {
        if (date == null) {
            return;
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ValidatorIndex.Property.closed.name(), null), SearchCriterion.ge((String)ValidatorIndex.Property.closed.name(), (Object)date)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ValidatorIndex.Property.opened.name(), null), SearchCriterion.le((String)ValidatorIndex.Property.opened.name(), (Object)date)}));
    }

    private ValidatorHelper() {
    }
}

