/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.meta.BaseClassType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class XCompareHelper {
    public static Difference compare(Object oldValue, Object newValue, Collection<Class<?>> ignoredClasses, Collection<String> ignoredPaths) {
        return XCompareHelper.compare(oldValue, newValue, new HashMap<String, String>(), ignoredClasses, ignoredPaths, "");
    }

    private static Difference compare(Object oldValue, Object newValue, Map<String, String> uidContext, Collection<Class<?>> ignoredClasses, Collection<String> ignoredPaths, String path) {
        Object hv1;
        for (String string : ignoredPaths) {
            if (!string.equals(path) && !path.matches(string)) continue;
            return null;
        }
        if (newValue != null && ignoredClasses.contains(newValue.getClass())) {
            return null;
        }
        if (oldValue != null && ignoredClasses.contains(oldValue.getClass())) {
            return null;
        }
        if (ignoredPaths.contains(path)) {
            return null;
        }
        if (oldValue == null) {
            if (newValue == null) {
                return null;
            }
            return new Difference(path, "\u043d\u0435\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f", "\u0435\u0441\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
        }
        if (newValue == null) {
            return new Difference(path, "\u0435\u0441\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", "\u043d\u0435\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
        }
        if (oldValue instanceof Set && newValue instanceof Set) {
            Set set1 = (Set)oldValue;
            Set set = (Set)newValue;
            return XCompareHelper.compareCollections(set1, set, false, uidContext, ignoredClasses, ignoredPaths, path);
        }
        if (oldValue instanceof List && newValue instanceof List) {
            List list1 = (List)oldValue;
            List list = (List)newValue;
            return XCompareHelper.compareCollections(list1, list, true, uidContext, ignoredClasses, ignoredPaths, path);
        }
        if (oldValue instanceof Map.Entry && newValue instanceof Map.Entry) {
            Map.Entry entry1 = (Map.Entry)oldValue;
            Map.Entry entry = (Map.Entry)newValue;
            Difference diff = XCompareHelper.compare(entry1.getKey(), entry.getKey(), uidContext, ignoredClasses, ignoredPaths, path);
            if (diff != null) {
                return diff;
            }
            return XCompareHelper.compare(entry1.getValue(), entry.getValue(), uidContext, ignoredClasses, ignoredPaths, path);
        }
        if (oldValue instanceof Map && newValue instanceof Map) {
            Map map1 = (Map)oldValue;
            Map map = (Map)newValue;
            return XCompareHelper.compareCollections(map1.entrySet(), map.entrySet(), false, uidContext, ignoredClasses, ignoredPaths, path);
        }
        if (XCompareHelper.isObjectEqualsApplicable(oldValue) && XCompareHelper.isObjectEqualsApplicable(newValue)) {
            if (!MiscUtil.equals((Object)oldValue, (Object)newValue)) {
                return new Difference(path, oldValue.toString(), newValue.toString());
            }
            return null;
        }
        if (oldValue instanceof HistoricalValue && newValue instanceof HistoricalValue) {
            hv1 = (HistoricalValue)oldValue;
            HistoricalValue historicalValue = (HistoricalValue)newValue;
            if (!MiscUtil.equals((Object)hv1.getDate(), (Object)historicalValue.getDate())) {
                return new Difference(path + "/key", MiscUtil.toString((Object)hv1.getDate()), MiscUtil.toString((Object)historicalValue.getDate()));
            }
            return XCompareHelper.compare(hv1.getValue(), historicalValue.getValue(), uidContext, ignoredClasses, ignoredPaths, path + "/value");
        }
        if (oldValue instanceof Money && newValue instanceof Money) {
            hv1 = (Money)oldValue;
            Money money = (Money)newValue;
            if (!MiscUtil.equals((Object)hv1.getValue(), (Object)money.getValue()) || !MiscUtil.equals((Object)hv1.getCurrency(), (Object)money.getCurrency())) {
                return new Difference(path, String.format("%s %s", hv1.getValue(), hv1.getCurrency()), String.format("%s %s", money.getValue(), money.getCurrency()));
            }
        }
        if (oldValue instanceof BaseEntity && newValue instanceof BaseEntity && oldValue.getClass().getName().equals(newValue.getClass().getName())) {
            Difference res;
            EntityType entityType;
            if (!uidContext.isEmpty()) {
                for (Class clazz : ignoredClasses) {
                    if (!clazz.isAssignableFrom(oldValue.getClass())) continue;
                    return null;
                }
            }
            if ((entityType = MetaRegistryHelper.getEntityType((String)oldValue.getClass().getName())) == null) {
                if (!oldValue.equals(newValue)) {
                    return new Difference(path, oldValue.toString(), newValue.toString());
                }
                return null;
            }
            BaseEntity baseEntity = (BaseEntity)oldValue;
            BaseEntity be2 = (BaseEntity)newValue;
            if (uidContext.containsKey(baseEntity.getUid())) {
                if (!be2.getUid().equals(uidContext.get(baseEntity.getUid()))) {
                    return new Difference(path, oldValue.toString(), newValue.toString());
                }
                return null;
            }
            uidContext.put(baseEntity.getUid(), be2.getUid());
            for (Property property : MetaRegistryHelper.getAllProperties((EntityType)entityType).values()) {
                res = XCompareHelper.compare(baseEntity.getValue(property.getId()), be2.getValue(property.getId()), uidContext, ignoredClasses, ignoredPaths, path + "/" + property.getId());
                if (res == null) continue;
                return res;
            }
            for (EntityCollection collection : MetaRegistryHelper.getAllCollections((BaseClassType)entityType).values()) {
                res = XCompareHelper.compare(baseEntity.getValue(collection.getId()), be2.getValue(collection.getId()), uidContext, ignoredClasses, ignoredPaths, path + "/" + collection.getId());
                if (res == null) continue;
                return res;
            }
            return null;
        }
        if (oldValue instanceof byte[] && newValue instanceof byte[]) {
            byte[] ba1 = (byte[])oldValue;
            byte[] byArray = (byte[])newValue;
            if (!Arrays.equals(ba1, byArray)) {
                return new Difference(path, "\u043d\u0430\u0431\u043e\u0440 \u0431\u0430\u0439\u0442\u043e\u0432 1", "\u043d\u0430\u0431\u043e\u0440 \u0431\u0430\u0439\u0442\u043e\u0432 2");
            }
            return null;
        }
        return null;
    }

    private static boolean isObjectEqualsApplicable(Object obj) {
        if (obj instanceof MiscUtil.Pair) {
            MiscUtil.Pair pair = (MiscUtil.Pair)obj;
            return !(pair.getFirst() != null && !XCompareHelper.isObjectEqualsApplicable(pair.getFirst()) || pair.getSecond() != null && !XCompareHelper.isObjectEqualsApplicable(pair.getSecond()));
        }
        return obj instanceof Enum || obj instanceof DictionaryReference || obj instanceof String || obj instanceof java.time.LocalDateTime || obj instanceof LocalDate || obj instanceof Byte || obj instanceof Date || obj instanceof Locale || obj instanceof Long || obj instanceof Boolean || obj instanceof Double || obj instanceof LocalDateTime || obj instanceof DateTime || obj instanceof BigDecimal || obj instanceof java.time.LocalTime || obj instanceof org.joda.time.LocalDate || obj instanceof Integer || obj instanceof URL || obj instanceof Float || obj instanceof LocalTime || obj instanceof EntityReference || obj instanceof VatAmount || obj instanceof L10nMessage || obj instanceof L10nString || obj instanceof SearchCriterion;
    }

    private static <T1> Difference compareCollections(Collection<T1> col1, Collection<T1> col2, boolean strict, Map<String, String> uidContext, Collection<Class<?>> ignoredClasses, Collection<String> ignoredPaths, String path) {
        if (col1.size() != col2.size()) {
            return new Difference(path, String.format("%s \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432", col1.size()), String.format("%s \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432", col2.size()));
        }
        if (strict) {
            Iterator<T1> col1Iterator = col1.iterator();
            Iterator<T1> col2Iterator = col2.iterator();
            int idx = 0;
            while (col1Iterator.hasNext()) {
                Difference res = XCompareHelper.compare(col1Iterator.next(), col2Iterator.next(), uidContext, ignoredClasses, ignoredPaths, path + "/" + idx);
                if (res != null) {
                    return res;
                }
                ++idx;
            }
            return null;
        }
        block1: for (T1 next : col1) {
            for (T1 item : col2) {
                Difference res = XCompareHelper.compare(next, item, uidContext, ignoredClasses, ignoredPaths, path);
                if (res != null) continue;
                continue block1;
            }
            return new Difference(path, "\u043e\u0434\u0438\u043d \u0438\u0437 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432", "\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442");
        }
        return null;
    }

    public static class Difference {
        public final String path;
        public final String oldValue;
        public final String newValue;

        Difference(String path, String oldValue, String newValue) {
            this.path = path;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }
    }
}

