/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLFinanceDocumentsExportHelper {
    private static final Logger log = LoggerFactory.getLogger(XMLFinanceDocumentsExportHelper.class);
    public static final String BOOKINGS_PUBLIC_ID = "-//xTrip//Bookings 1.0";
    public static final String FINANCE_DOCUMENTS_SYSTEM_ID = "http://xtrip.gridnine.com/bookings_1_0.dtd";
    public static final String FINANCE_DOCUMENTS_DTD_FILE_NAME = "bookings_1_0.dtd";
    public static final String FINANCE_DOCUMENTS_ENCODING = "UTF-8";
    private static final String BOOKINGS_ELEMENT_NAME = "bookings";
    private static final String BOOKING_ELEMENT_NAME = "booking";
    private static final String RESERVATIONS_ELEMENT_NAME = "reservations";
    private static final String RESERVATION_ELEMENT_NAME = "reservation";
    private static final String PRODUCTS_ELEMENT_NAME = "products";
    private static final String PRODUCT_ELEMENT_NAME = "product";
    private static final String PAYMENTS_ELEMENT_NAME = "payments";
    private static final String PAYMENT_ELEMENT_NAME = "payment";
    private static final String FINANCE_DOCUMENTS_ELEMENT_NAME = "financeDocuments";
    private static final String FINANCE_DOCUMENT_CONSIGNMENT_NOTE_ELEMENT_NAME = "financeDocumentConsignmentNote";
    private static final String FINANCE_DOCUMENT_STATEMENT_ON_SERVICES_ELEMENT_NAME = "financeDocumentStatementOnServices";
    private static final String FINANCE_DOCUMENT_BILL_ELEMENT_NAME = "financeDocumentBill";
    private static final String FINANCE_DOCUMENT_INVOICE_ELEMENT_NAME = "financeDocumentInvoice";
    private static final String FINANCE_DOCUMENT_CONSUMABLE_CASH_ORDER_ELEMENT_NAME = "financeDocumentConsumableCashOrder";
    private static final String FINANCE_DOCUMENT_AGENT_ELEMENT_NAME = "financeDocumentAgent";
    private static final String FINANCE_DOCUMENT_VENDOR_ELEMENT_NAME = "financeDocumentVendor";
    private static final String FINANCE_DOCUMENT_CLIENT_ELEMENT_NAME = "financeDocumentClient";
    private static final String FINANCE_DOCUMENT_NUMBER_ELEMENT_NAME = "financeDocumentNumber";
    private static final String FINANCE_DOCUMENT_DATE_ELEMENT_NAME = "financeDocumentDate";
    private static final String FINANCE_DOCUMENT_ITEMS_ELEMENT_NAME = "financeDocumentItems";
    private static final String FINANCE_DOCUMENT_CASH_ORDER_RECIPIENT_ELEMENT_NAME = "financeDocumentCashOrderRecipient";
    private static final String FINANCE_DOCUMENT_CASH_ORDER_TOTAL_ELEMENT_NAME = "financeDocumentCashOrderTotal";
    private static final String FINANCE_DOCUMENT_CASH_ORDER_SUBJECT_ELEMENT_NAME = "financeDocumentCashOrderSubject";
    private static final String FINANCE_DOCUMENT_ITEM_ELEMENT_NAME = "financeDocumentItem";
    private static final String FINANCE_DOCUMENT_ITEM_NAME_ELEMENT_NAME = "financeDocumentItemName";
    private static final String FINANCE_DOCUMENT_ITEM_COUNT_ELEMENT_NAME = "financeDocumentItemCount";
    private static final String FINANCE_DOCUMENT_ITEM_TOTAL_ELEMENT_NAME = "financeDocumentItemTotal";
    private static final String FINANCE_DOCUMENT_ITEM_VAT_ELEMENT_NAME = "financeDocumentItemVAT";
    private static final String FINANCE_DOCUMENT_ITEM_VAT_PERCENT_ELEMENT_NAME = "financeDocumentItemVATPercent";
    private static final String FINANCE_DOCUMENT_ITEM_IS_SERVICE_ELEMENT_NAME = "financeDocumentItemIsService";
    private static final String ORGANIZATION_ELEMENT_NAME = "organization";
    private static final String ORGANIZATION_CODE_ELEMENT_NAME = "organizationCode";
    private static final String ORGANIZATION_SHORT_NAME_ELEMENT_NAME = "organizationShortName";
    private static final String ORGANIZATION_FULL_NAME_ELEMENT_NAME = "organizationFullName";
    private static final String ORGANIZATION_LEGAL_FORM_ELEMENT_NAME = "organizationLegalForm";
    private static final String ORGANIZATION_INN_ELEMENT_NAME = "organizationINN";
    private static final String ORGANIZATION_KPP_ELEMENT_NAME = "organizationKPP";
    private static final String ORGANIZATION_OKPO_ELEMENT_NAME = "organizationOKPO";
    private static final String ORGANIZATION_MANAGERS_ELEMENT_NAME = "organizationManagers";
    private static final String ORGANIZATION_ADDRESSES_ELEMENT_NAME = "organizationAddresses";
    private static final String ORGANIZATION_BANK_ACCOUNTS_ELEMENT_NAME = "organizationBankAccounts";
    private static final String ORGANIZATION_COMMENTS_ELEMENT_NAME = "organizationComments";
    private static final String PERSON_ELEMENT_NAME = "person";
    private static final String PERSON_LAST_NAME_ELEMENT_NAME = "personLastName";
    private static final String PERSON_FIRST_NAME_ELEMENT_NAME = "personFirstName";
    private static final String PERSON_MIDDLE_NAME_ELEMENT_NAME = "personMiddleName";
    private static final String CUSTOMER_ELEMENT_NAME = "customer";
    private static final String CUSTOMER_NAME_ELEMENT_NAME = "customerName";
    private static final String CUSTOMER_CUSTOMER_ELEMENT_NAME = "customerCompany";
    private static final String CUSTOMER_ADDRESSES_ELEMENT_NAME = "customerAddresses";
    private static final String CUSTOMER_PASSPORT_ELEMENT_NAME = "customerPassport";
    private static final String MANAGER_ELEMENT_NAME = "manager";
    private static final String MANAGER_TYPE_ELEMENT_NAME = "managerType";
    private static final String MANAGER_NAME_ELEMENT_NAME = "managerName";
    private static final String MANAGER_COMMENTS_ELEMENT_NAME = "managerComments";
    private static final String ADDRESS_ELEMENT_NAME = "address";
    private static final String ADDRESS_TYPE_ELEMENT_NAME = "addressType";
    private static final String ADDRESS_ZIP_ELEMENT_NAME = "addressZIP";
    private static final String ADDRESS_COUNTRY_ELEMENT_NAME = "addressCountry";
    private static final String ADDRESS_REGION_ELEMENT_NAME = "addressRegion";
    private static final String ADDRESS_DISTRICT_ELEMENT_NAME = "addressDistrict";
    private static final String ADDRESS_CITY_ELEMENT_NAME = "addressCity";
    private static final String ADDRESS_TOWN_ELEMENT_NAME = "addressTown";
    private static final String ADDRESS_ADDRESS_ELEMENT_NAME = "addressAddress";
    private static final String ADDRESS_HOUSE_ELEMENT_NAME = "addressHouse";
    private static final String ADDRESS_HOUSING_ELEMENT_NAME = "addressHousing";
    private static final String ADDRESS_BUILDING_ELEMENT_NAME = "addressBuilding";
    private static final String ADDRESS_PAVILION_ELEMENT_NAME = "addressPavilion";
    private static final String ADDRESS_OFFICE_ELEMENT_NAME = "addressOffice";
    private static final String ADDRESS_FLAT_ELEMENT_NAME = "addressFlat";
    private static final String ADDRESS_POBOX_ELEMENT_NAME = "addressPoBox";
    private static final String ADDRESS_COMMENTS_ELEMENT_NAME = "addressComments";
    private static final String BANK_ACCOUNT_ELEMENT_NAME = "bankAccount";
    private static final String BANK_ACCOUNT_CURRENCY_ELEMENT_NAME = "bankAccountCurrency";
    private static final String BANK_ACCOUNT_SETTLEMENT_ACCOUNT_ELEMENT_NAME = "bankAccountSettlementAccount";
    private static final String BANK_ACCOUNT_BANK_ELEMENT_NAME = "bankAccountBank";
    private static final String BANK_ACCOUNT_CITY_ELEMENT_NAME = "bankAccountCity";
    private static final String BANK_ACCOUNT_CORRESPONDENT_ACCOUNT_ELEMENT_NAME = "bankAccountCorrespondentAccount";
    private static final String BANK_ACCOUNT_BIK_ELEMENT_NAME = "bankAccountBIK";
    private static final String BANK_ACCOUNT_COMMENTS_ELEMENT_NAME = "bankAccountComments";
    private static final String PASSPORT_ELEMENT_NAME = "passport";
    private static final String PASSPORT_LAST_NAME_ELEMENT_NAME = "passportLastName";
    private static final String PASSPORT_FIRST_NAME_ELEMENT_NAME = "passportFirstName";
    private static final String PASSPORT_MIDDLE_NAME_ELEMENT_NAME = "passportMiddleName";
    private static final String PASSPORT_GENDER_ELEMENT_NAME = "passportGender";
    private static final String PASSPORT_BIRTHDAY_ELEMENT_NAME = "passportBirthday";
    private static final String PASSPORT_CITIZENSHIP_ELEMENT_NAME = "passportCitizenship";
    private static final String PASSPORT_NUMBER_ELEMENT_NAME = "passportNumber";
    private static final String PASSPORT_TYPE_ELEMENT_NAME = "passportType";
    private static final String PASSPORT_ISSUE_DATE_ELEMENT_NAME = "passportIssueDate";
    private static final String PASSPORT_ISSUE_ORGANIZATION_ELEMENT_NAME = "passportIssueOrganization";
    private static final String PASSPORT_ISSUE_COUNTRY_ELEMENT_NAME = "passportIssueCountry";
    private static final String PASSPORT_ISSUE_CITY_ELEMENT_NAME = "passportIssueCity";
    private static final String PASSPORT_EXPIRED_ELEMENT_NAME = "passportExpired";
    private static final String AIRLINE_ELEMENT_NAME = "airline";
    private static final String AIRLINE_CODE_ELEMENT_NAME = "airlineCode";
    private static final String AIRLINE_CODE_VARIANTS_ELEMENT_NAME = "airlineCodeVariants";
    private static final String AIRLINE_CODE_VARIANT_ELEMENT_NAME = "airlineCodeVariant";
    private static final String AIRLINE_CODE_VARIANT_SYSTEM_ELEMENT_NAME = "airlineCodeVariantSystem";
    private static final String AIRLINE_CODE_VARIANT_VALUE_ELEMENT_NAME = "airlineCodeVariantValue";
    private static final String AIRLINE_NAME_ELEMENT_NAME = "airlineName";
    private static final String AIRLINE_NUMBER_ELEMENT_NAME = "airlineNumber";
    private static final String AIRLINE_COUNTRY_ELEMENT_NAME = "airlineCountry";
    private static final String AIRLINE_OPEN_DATE_ELEMENT_NAME = "airlineOpenDate";
    private static final String AIRLINE_CLOSE_DATE_ELEMENT_NAME = "airlineCloseDate";
    private static final String COUNTRY_ELEMENT_NAME = "country";
    private static final String COUNTRY_CODE_ELEMENT_NAME = "countryCode";
    private static final String COUNTRY_CODE_VARIANTS_ELEMENT_NAME = "countryCodeVariants";
    private static final String COUNTRY_CODE_VARIANT_ELEMENT_NAME = "countryCodeVariant";
    private static final String COUNTRY_CODE_VARIANT_SYSTEM_ELEMENT_NAME = "countryCodeVariantSystem";
    private static final String COUNTRY_CODE_VARIANT_VALUE_ELEMENT_NAME = "countryCodeVariantValue";
    private static final String BLANK_TYPE_ELEMENT_NAME = "blankType";
    private static final String BLANK_TYPE_CODE_ELEMENT_NAME = "blankTypeCode";
    private static final String BLANK_TYPE_NAME_ELEMENT_NAME = "blankTypeName";
    private static final String BLANK_TYPE_COUPONS_COUNT_ELEMENT_NAME = "blankTypeCouponsCount";
    private static final String BLANK_TYPE_VENDOR_ELEMENT_NAME = "blankTypeVendor";
    private static final String BLANK_TYPE_PRODUCT_CATEGORY_ELEMENT_NAME = "blankTypeProductCategory";
    private static final String BLANK_TYPE_BLANK_CATEGORY_ELEMENT_NAME = "blankTypeBlankCategory";

    public static EntityResolver createEntityResolver(final Set<Message> messages) {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (publicId != null && publicId.equals(XMLFinanceDocumentsExportHelper.BOOKINGS_PUBLIC_ID) || systemId != null && systemId.equals(XMLFinanceDocumentsExportHelper.FINANCE_DOCUMENTS_SYSTEM_ID)) {
                    URL url = XMLFinanceDocumentsExportHelper.class.getResource(XMLFinanceDocumentsExportHelper.FINANCE_DOCUMENTS_DTD_FILE_NAME);
                    try {
                        InputStreamReader reader = new InputStreamReader(IoUtil.getResourceInputStream((URL)url), XMLFinanceDocumentsExportHelper.FINANCE_DOCUMENTS_ENCODING);
                        return new InputSource(reader);
                    }
                    catch (IOException e) {
                        messages.add(XMLFinanceDocumentsExportHelper.createWarningMessage(String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0444\u0430\u0439\u043b %s \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0439 DTD \u0441\u0445\u0435\u043c\u0443", url), e.getMessage(), new Object[0]));
                    }
                }
                return null;
            }
        };
    }

    public static DOMErrorHandler createDOMErrorHandler(final Set<Message> messages) {
        return new DOMErrorHandler(){

            @Override
            public boolean handleError(DOMError error) {
                switch (error.getSeverity()) {
                    case 2: 
                    case 3: {
                        messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u0424\u0430\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438", error.getMessage(), new Object[0]));
                        break;
                    }
                    case 1: {
                        messages.add(XMLFinanceDocumentsExportHelper.createWarningMessage("\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438", error.getMessage(), new Object[0]));
                    }
                }
                return true;
            }
        };
    }

    public static ErrorHandler createErrorHandler(final Set<Message> messages) {
        return new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u0424\u0430\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438", exception.getMessage(), new Object[0]));
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438", exception.getMessage(), new Object[0]));
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                messages.add(XMLFinanceDocumentsExportHelper.createWarningMessage("\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438", exception.getMessage(), new Object[0]));
            }
        };
    }

    public static void validate(Document document, Set<Message> messages) {
        DOMConfiguration config = document.getDomConfig();
        config.setParameter("schema-type", "http://www.w3.org/TR/REC-xml");
        config.setParameter("validate", Boolean.TRUE);
        config.setParameter("well-formed", Boolean.TRUE);
        config.setParameter("error-handler", XMLFinanceDocumentsExportHelper.createDOMErrorHandler(messages));
        config.setParameter("schema-location", XMLFinanceDocumentsExportHelper.class.getResource(FINANCE_DOCUMENTS_DTD_FILE_NAME).toExternalForm());
        document.normalizeDocument();
    }

    public static Document exportBookings(List<EntityContainer<BookingFile>> bookingFileContainers, Set<Message> messages) throws Exception {
        Locale locale;
        Document document = DocumentBuilderHelper.newDocument();
        Element bookingsElement = XMLFinanceDocumentsExportHelper.createBookings(bookingFileContainers, document, locale = LocaleManager.get().getCurrentLocale(), messages);
        if (bookingsElement == null) {
            return null;
        }
        document.appendChild(bookingsElement);
        return document;
    }

    private static Element createBookings(List<EntityContainer<BookingFile>> bookingFileContainers, Document document, Locale locale, Set<Message> messages) throws Exception {
        Element bookingsElement = document.createElementNS(null, BOOKINGS_ELEMENT_NAME);
        for (EntityContainer<BookingFile> bookingFileContainer : bookingFileContainers) {
            Element bookingElement = XMLFinanceDocumentsExportHelper.createBookingElement(bookingFileContainer, document, locale, messages);
            if (bookingElement != null) {
                bookingsElement.appendChild(bookingElement);
                continue;
            }
            return null;
        }
        return bookingsElement;
    }

    private static Element createBookingElement(EntityContainer<BookingFile> bookingFileContainer, Document document, Locale locale, Set<Message> messages) throws Exception {
        Element bookingElement = document.createElementNS(null, BOOKING_ELEMENT_NAME);
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        Element reservationsElement = XMLFinanceDocumentsExportHelper.createReservationsElement(bookingFileContainer, bookingFile.getReservations(), document, locale, messages);
        if (reservationsElement == null) {
            return null;
        }
        bookingElement.appendChild(reservationsElement);
        Element paymentsDocumentsElement = XMLFinanceDocumentsExportHelper.createPaymentsElement(bookingFileContainer, bookingFile.getPayments(), document, locale, messages);
        if (paymentsDocumentsElement == null) {
            return null;
        }
        bookingElement.appendChild(paymentsDocumentsElement);
        return bookingElement;
    }

    private static Element createReservationsElement(EntityContainer<BookingFile> bookingFileContainer, List<Reservation> reservations, Document document, Locale locale, Set<Message> messages) throws Exception {
        Element reservationsElement = document.createElementNS(null, RESERVATIONS_ELEMENT_NAME);
        for (Reservation reservation : reservations) {
            Element reservationElement = XMLFinanceDocumentsExportHelper.createReservationElement(bookingFileContainer, reservation, document, locale, messages);
            if (reservationElement != null) {
                reservationsElement.appendChild(reservationElement);
                continue;
            }
            return null;
        }
        return reservationsElement;
    }

    private static Element createReservationElement(EntityContainer<BookingFile> bookingFileContainer, Reservation reservation, Document document, Locale locale, Set<Message> messages) throws Exception {
        Element reservationElement = document.createElementNS(null, RESERVATION_ELEMENT_NAME);
        Element productsElement = XMLFinanceDocumentsExportHelper.createProductsElement(bookingFileContainer, reservation.getProducts(), document, locale, messages);
        if (productsElement == null) {
            return null;
        }
        reservationElement.appendChild(productsElement);
        return reservationElement;
    }

    private static Element createProductsElement(EntityContainer<BookingFile> bookingFileContainer, List<BaseProduct> products, Document document, Locale locale, Set<Message> messages) throws Exception {
        Element productsElement = document.createElementNS(null, PRODUCTS_ELEMENT_NAME);
        for (BaseProduct product : products) {
            Element productElement = XMLFinanceDocumentsExportHelper.createProductElement(bookingFileContainer, product, document, locale, messages);
            if (productElement != null) {
                productsElement.appendChild(productElement);
                continue;
            }
            return null;
        }
        return productsElement;
    }

    private static Element createProductElement(EntityContainer<BookingFile> bookingFileContainer, BaseProduct product, Document document, Locale locale, Set<Message> messages) throws Exception {
        Element productElement = document.createElementNS(null, PRODUCT_ELEMENT_NAME);
        return productElement;
    }

    private static Element createPaymentsElement(EntityContainer<BookingFile> bookingFileContainer, List<Payment> payments, Document document, Locale locale, Set<Message> messages) throws Exception {
        Element paymentsElement = document.createElementNS(null, PAYMENTS_ELEMENT_NAME);
        for (Payment payment : payments) {
            Element paymentElement = XMLFinanceDocumentsExportHelper.createPaymentElement(bookingFileContainer, payment, document, locale, messages);
            if (paymentElement != null) {
                paymentsElement.appendChild(paymentElement);
                continue;
            }
            return null;
        }
        return paymentsElement;
    }

    private static Element createPaymentElement(EntityContainer<BookingFile> bookingFileContainer, Payment payment, Document document, Locale locale, Set<Message> messages) throws Exception {
        Element paymentElement = document.createElementNS(null, PAYMENT_ELEMENT_NAME);
        Element financeDocumentsElement = XMLFinanceDocumentsExportHelper.createFinanceDocumentsElement(bookingFileContainer, payment, payment.getFinanceDocuments(), document, locale, messages);
        if (financeDocumentsElement == null) {
            return null;
        }
        paymentElement.appendChild(financeDocumentsElement);
        return paymentElement;
    }

    private static Element createFinanceDocumentsElement(EntityContainer<BookingFile> bookingFileContainer, Payment payment, List<FinanceDocument> financeDocuments, Document document, Locale locale, Set<Message> messages) throws Exception {
        Element financeDocumentsElement = document.createElementNS(null, FINANCE_DOCUMENTS_ELEMENT_NAME);
        Collections.sort(financeDocuments, new Comparator<FinanceDocument>(){

            @Override
            public int compare(FinanceDocument o1, FinanceDocument o2) {
                return o1.getType().compareTo((Enum)o2.getType());
            }
        });
        for (FinanceDocument financeDocument : financeDocuments) {
            if (financeDocument.getType() == FinanceDocumentType.STANDARD_BILL) {
                Element financeDocumentConsignmentNoteElement = null;
                financeDocumentConsignmentNoteElement = XMLFinanceDocumentsExportHelper.createFinanceDocumentConsignmentNoteElement(bookingFileContainer, payment, financeDocument, document, messages);
                if (financeDocumentConsignmentNoteElement != null) {
                    financeDocumentsElement.appendChild(financeDocumentConsignmentNoteElement);
                    continue;
                }
                return null;
            }
            if (financeDocument.getType() == FinanceDocumentType.INVOICE) {
                Element financeDocumentBillElement = null;
                financeDocumentBillElement = XMLFinanceDocumentsExportHelper.createFinanceDocumentBillElement(bookingFileContainer, payment, financeDocument, document, messages);
                if (financeDocumentBillElement != null) {
                    financeDocumentsElement.appendChild(financeDocumentBillElement);
                    continue;
                }
                return null;
            }
            if (financeDocument.getType() == FinanceDocumentType.INVOICE_FACTURA) {
                Element financeDocumentInvoiceElement = null;
                financeDocumentInvoiceElement = XMLFinanceDocumentsExportHelper.createFinanceDocumentInvoiceElement(bookingFileContainer, payment, financeDocument, document, messages);
                if (financeDocumentInvoiceElement != null) {
                    financeDocumentsElement.appendChild(financeDocumentInvoiceElement);
                    continue;
                }
                return null;
            }
            if (financeDocument.getType() == FinanceDocumentType.CASH_ORDER) {
                Element financeDocumentConsumableCashOrderElement = null;
                financeDocumentConsumableCashOrderElement = XMLFinanceDocumentsExportHelper.createFinanceDocumentConsumableCashOrderElement(bookingFileContainer, payment, financeDocument, document, messages);
                if (financeDocumentConsumableCashOrderElement != null) {
                    financeDocumentsElement.appendChild(financeDocumentConsumableCashOrderElement);
                    continue;
                }
                return null;
            }
            if (financeDocument.getType() != FinanceDocumentType.ACCEPTANCE_CERTIFICATE) continue;
            Element financeDocumentStatementOnServicesElement = null;
            financeDocumentStatementOnServicesElement = XMLFinanceDocumentsExportHelper.createFinanceDocumentStatementOnServicesElement(bookingFileContainer, payment, financeDocument, document, messages);
            if (financeDocumentStatementOnServicesElement != null) {
                financeDocumentsElement.appendChild(financeDocumentStatementOnServicesElement);
                continue;
            }
            return null;
        }
        return financeDocumentsElement;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Element createFinanceDocumentConsignmentNoteElement(EntityContainer<BookingFile> bookingFileContainer, Payment payment, FinanceDocument financeDocument, Document document, Set<Message> messages) throws Exception {
        Element organizationElement;
        Element financeDocumentConsignmentNoteElement = document.createElementNS(null, FINANCE_DOCUMENT_CONSIGNMENT_NOTE_ELEMENT_NAME);
        if (payment.getAgent() != null) {
            Element financeDocumentAgentElement = document.createElementNS(null, FINANCE_DOCUMENT_AGENT_ELEMENT_NAME);
            Element personElement = XMLFinanceDocumentsExportHelper.createPersonElement((EntityReference<Person>)payment.getAgent(), document, messages);
            if (personElement == null) {
                messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0430\u0433\u0435\u043d\u0442\u0430, \u0432\u044b\u0441\u0442\u0430\u0432\u0438\u0432\u0448\u0435\u0433\u043e \u0441\u0447\u0435\u0442", new Object[0]));
                return null;
            }
            financeDocumentAgentElement.appendChild(personElement);
            financeDocumentConsignmentNoteElement.appendChild(financeDocumentAgentElement);
        }
        boolean refund = XMLFinanceDocumentsExportHelper.isRefund(payment);
        Element financeDocumentVendorElement = document.createElementNS(null, FINANCE_DOCUMENT_VENDOR_ELEMENT_NAME);
        if (refund) {
            organizationElement = XMLFinanceDocumentsExportHelper.createOrganizationElement((EntityReference<Organization>)((BookingFile)bookingFileContainer.getEntity()).getCustomerProfile(), document, messages);
            if (organizationElement == null) {
                messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f", new Object[0]));
                return null;
            }
            financeDocumentVendorElement.appendChild(organizationElement);
        } else {
            organizationElement = null;
            for (BillingItem billingItem : payment.getBillingItems()) {
                BaseProduct baseProduct = BookingHelper.findProduct((BookingFile)bookingFileContainer.getEntity(), !billingItem.getProductUids().isEmpty() ? (String)billingItem.getProductUids().iterator().next() : null);
                if (!(baseProduct instanceof BaseTicketProduct)) continue;
                ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
                EntityReference<Organization> agencyReference = GeneralProductHelper.getContractor(handler.getSalesChain(baseProduct), PredefinedContractorType.SUBAGENCY);
                organizationElement = XMLFinanceDocumentsExportHelper.createOrganizationElement(agencyReference, document, messages);
            }
            if (organizationElement == null) {
                messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430/\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430, \u043e\u0442 \u043b\u0438\u0446\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0447\u0435\u0442", new Object[0]));
                return null;
            }
            financeDocumentVendorElement.appendChild(organizationElement);
        }
        financeDocumentConsignmentNoteElement.appendChild(financeDocumentVendorElement);
        XHelper.writeString((Element)financeDocumentConsignmentNoteElement, (String)FINANCE_DOCUMENT_NUMBER_ELEMENT_NAME, (String)TextUtil.buildFullNumber((CompositeNumber)financeDocument));
        XHelper.writeDate((Element)financeDocumentConsignmentNoteElement, (String)FINANCE_DOCUMENT_DATE_ELEMENT_NAME, (Date)financeDocument.getDate());
        Element financeDocumentItemsElement = document.createElementNS(null, FINANCE_DOCUMENT_ITEMS_ELEMENT_NAME);
        Iterator iterator = payment.getBillingItems().iterator();
        while (true) {
            BillingItem billingItem;
            if (!iterator.hasNext()) {
                financeDocumentConsignmentNoteElement.appendChild(financeDocumentItemsElement);
                return financeDocumentConsignmentNoteElement;
            }
            billingItem = (BillingItem)iterator.next();
            if (!XMLFinanceDocumentsExportHelper.acceptable(financeDocument.getType(), billingItem, refund)) continue;
            Element financeDocumentItemElement = XMLFinanceDocumentsExportHelper.createFinanceDocumentItemElement(financeDocument, billingItem, refund, document, messages);
            if (financeDocumentItemElement == null) {
                return null;
            }
            financeDocumentItemsElement.appendChild(financeDocumentItemElement);
        }
    }

    private static Element createFinanceDocumentBillElement(EntityContainer<BookingFile> bookingFileContainer, Payment payment, FinanceDocument financeDocument, Document document, Set<Message> messages) throws Exception {
        Element financeDocumentBillElement = document.createElementNS(null, FINANCE_DOCUMENT_BILL_ELEMENT_NAME);
        if (payment.getAgent() != null) {
            Element financeDocumentAgentElement = document.createElementNS(null, FINANCE_DOCUMENT_AGENT_ELEMENT_NAME);
            Element personElement = XMLFinanceDocumentsExportHelper.createPersonElement((EntityReference<Person>)payment.getAgent(), document, messages);
            if (personElement == null) {
                messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0430\u0433\u0435\u043d\u0442\u0430, \u0432\u044b\u0441\u0442\u0430\u0432\u0438\u0432\u0448\u0435\u0433\u043e \u0441\u0447\u0435\u0442", new Object[0]));
                return null;
            }
            financeDocumentAgentElement.appendChild(personElement);
            financeDocumentBillElement.appendChild(financeDocumentAgentElement);
        }
        boolean refund = XMLFinanceDocumentsExportHelper.isRefund(payment);
        Element financeDocumentVendorElement = document.createElementNS(null, FINANCE_DOCUMENT_VENDOR_ELEMENT_NAME);
        Element organizationElement = null;
        for (BillingItem billingItem : payment.getBillingItems()) {
            BaseProduct baseProduct = BookingHelper.findProduct((BookingFile)bookingFileContainer.getEntity(), !billingItem.getProductUids().isEmpty() ? (String)billingItem.getProductUids().iterator().next() : null);
            if (!(baseProduct instanceof BaseTicketProduct)) continue;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            EntityReference<Organization> agencyReference = GeneralProductHelper.getContractor(handler.getSalesChain(baseProduct), PredefinedContractorType.SUBAGENCY);
            organizationElement = XMLFinanceDocumentsExportHelper.createOrganizationElement(agencyReference, document, messages);
        }
        if (organizationElement == null) {
            messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430/\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430, \u043e\u0442 \u043b\u0438\u0446\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0447\u0435\u0442", new Object[0]));
            return null;
        }
        financeDocumentVendorElement.appendChild(organizationElement);
        financeDocumentBillElement.appendChild(financeDocumentVendorElement);
        Element financeDocumentClientElement = document.createElementNS(null, FINANCE_DOCUMENT_CLIENT_ELEMENT_NAME);
        organizationElement = XMLFinanceDocumentsExportHelper.createOrganizationElement((EntityReference<Organization>)((BookingFile)bookingFileContainer.getEntity()).getCustomerProfile(), document, messages);
        if (organizationElement == null) {
            messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f", new Object[0]));
            return null;
        }
        financeDocumentClientElement.appendChild(organizationElement);
        financeDocumentBillElement.appendChild(financeDocumentClientElement);
        XHelper.writeString((Element)financeDocumentBillElement, (String)FINANCE_DOCUMENT_NUMBER_ELEMENT_NAME, (String)TextUtil.buildFullNumber((CompositeNumber)financeDocument));
        XHelper.writeDate((Element)financeDocumentBillElement, (String)FINANCE_DOCUMENT_DATE_ELEMENT_NAME, (Date)financeDocument.getDate());
        Element financeDocumentItemsElement = document.createElementNS(null, FINANCE_DOCUMENT_ITEMS_ELEMENT_NAME);
        for (BillingItem billingItem : payment.getBillingItems()) {
            if (!XMLFinanceDocumentsExportHelper.acceptable(financeDocument.getType(), billingItem, refund)) continue;
            Element financeDocumentItemElement = XMLFinanceDocumentsExportHelper.createFinanceDocumentItemElement(financeDocument, billingItem, refund, document, messages);
            if (financeDocumentItemElement != null) {
                financeDocumentItemsElement.appendChild(financeDocumentItemElement);
                continue;
            }
            return null;
        }
        financeDocumentBillElement.appendChild(financeDocumentItemsElement);
        return financeDocumentBillElement;
    }

    private static Element createFinanceDocumentInvoiceElement(EntityContainer<BookingFile> bookingFileContainer, Payment payment, FinanceDocument financeDocument, Document document, Set<Message> messages) throws Exception {
        Element financeDocumentInvoiceElement = document.createElementNS(null, FINANCE_DOCUMENT_INVOICE_ELEMENT_NAME);
        if (payment.getAgent() != null) {
            Element financeDocumentAgentElement = document.createElementNS(null, FINANCE_DOCUMENT_AGENT_ELEMENT_NAME);
            Element personElement = XMLFinanceDocumentsExportHelper.createPersonElement((EntityReference<Person>)payment.getAgent(), document, messages);
            if (personElement == null) {
                messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0430\u0433\u0435\u043d\u0442\u0430, \u0432\u044b\u0441\u0442\u0430\u0432\u0438\u0432\u0448\u0435\u0433\u043e \u0441\u0447\u0435\u0442", new Object[0]));
                return null;
            }
            financeDocumentAgentElement.appendChild(personElement);
            financeDocumentInvoiceElement.appendChild(financeDocumentAgentElement);
        }
        boolean refund = XMLFinanceDocumentsExportHelper.isRefund(payment);
        Element financeDocumentVendorElement = document.createElementNS(null, FINANCE_DOCUMENT_VENDOR_ELEMENT_NAME);
        Element organizationElement = null;
        for (BillingItem billingItem : payment.getBillingItems()) {
            BaseProduct baseProduct = BookingHelper.findProduct((BookingFile)bookingFileContainer.getEntity(), !billingItem.getProductUids().isEmpty() ? (String)billingItem.getProductUids().iterator().next() : null);
            if (!(baseProduct instanceof BaseTicketProduct)) continue;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            EntityReference<Organization> agencyReference = GeneralProductHelper.getContractor(handler.getSalesChain(baseProduct), PredefinedContractorType.SUBAGENCY);
            organizationElement = XMLFinanceDocumentsExportHelper.createOrganizationElement(agencyReference, document, messages);
        }
        if (organizationElement == null) {
            messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430/\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430, \u043e\u0442 \u043b\u0438\u0446\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0447\u0435\u0442", new Object[0]));
            return null;
        }
        financeDocumentVendorElement.appendChild(organizationElement);
        financeDocumentInvoiceElement.appendChild(financeDocumentVendorElement);
        Element financeDocumentClientElement = document.createElementNS(null, FINANCE_DOCUMENT_CLIENT_ELEMENT_NAME);
        organizationElement = XMLFinanceDocumentsExportHelper.createOrganizationElement((EntityReference<Organization>)((BookingFile)bookingFileContainer.getEntity()).getCustomerProfile(), document, messages);
        if (organizationElement == null) {
            messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f", new Object[0]));
            return null;
        }
        financeDocumentClientElement.appendChild(organizationElement);
        financeDocumentInvoiceElement.appendChild(financeDocumentClientElement);
        XHelper.writeString((Element)financeDocumentInvoiceElement, (String)FINANCE_DOCUMENT_NUMBER_ELEMENT_NAME, (String)TextUtil.buildFullNumber((CompositeNumber)financeDocument));
        XHelper.writeDate((Element)financeDocumentInvoiceElement, (String)FINANCE_DOCUMENT_DATE_ELEMENT_NAME, (Date)financeDocument.getDate());
        Element financeDocumentItemsElement = document.createElementNS(null, FINANCE_DOCUMENT_ITEMS_ELEMENT_NAME);
        for (BillingItem billingItem : payment.getBillingItems()) {
            if (!XMLFinanceDocumentsExportHelper.acceptable(financeDocument.getType(), billingItem, refund)) continue;
            Element financeDocumentItemElement = XMLFinanceDocumentsExportHelper.createFinanceDocumentItemElement(financeDocument, billingItem, refund, document, messages);
            if (financeDocumentItemElement != null) {
                financeDocumentItemsElement.appendChild(financeDocumentItemElement);
                continue;
            }
            return null;
        }
        financeDocumentInvoiceElement.appendChild(financeDocumentItemsElement);
        return financeDocumentInvoiceElement;
    }

    private static Element createFinanceDocumentConsumableCashOrderElement(EntityContainer<BookingFile> bookingFileContainer, Payment payment, FinanceDocument financeDocument, Document document, Set<Message> messages) throws Exception {
        Element financeDocumentConsumableCashOrderElement = document.createElementNS(null, FINANCE_DOCUMENT_CONSUMABLE_CASH_ORDER_ELEMENT_NAME);
        if (payment.getAgent() != null) {
            Element financeDocumentAgentElement = document.createElementNS(null, FINANCE_DOCUMENT_AGENT_ELEMENT_NAME);
            Element personElement = XMLFinanceDocumentsExportHelper.createPersonElement((EntityReference<Person>)payment.getAgent(), document, messages);
            if (personElement == null) {
                messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0430\u0433\u0435\u043d\u0442\u0430, \u0432\u044b\u0441\u0442\u0430\u0432\u0438\u0432\u0448\u0435\u0433\u043e \u0441\u0447\u0435\u0442", new Object[0]));
                return null;
            }
            financeDocumentAgentElement.appendChild(personElement);
            financeDocumentConsumableCashOrderElement.appendChild(financeDocumentAgentElement);
        }
        boolean refund = XMLFinanceDocumentsExportHelper.isRefund(payment);
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        Element financeDocumentVendorElement = document.createElementNS(null, FINANCE_DOCUMENT_VENDOR_ELEMENT_NAME);
        Element organizationElement = null;
        for (BillingItem billingItem : payment.getBillingItems()) {
            BaseProduct baseProduct = BookingHelper.findProduct((BookingFile)bookingFileContainer.getEntity(), !billingItem.getProductUids().isEmpty() ? (String)billingItem.getProductUids().iterator().next() : null);
            if (!(baseProduct instanceof BaseTicketProduct)) continue;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            EntityReference<Organization> agencyReference = GeneralProductHelper.getContractor(handler.getSalesChain(baseProduct), PredefinedContractorType.SUBAGENCY);
            organizationElement = XMLFinanceDocumentsExportHelper.createOrganizationElement(agencyReference, document, messages);
        }
        if (organizationElement == null) {
            messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430/\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430, \u043e\u0442 \u043b\u0438\u0446\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0447\u0435\u0442", new Object[0]));
            return null;
        }
        financeDocumentVendorElement.appendChild(organizationElement);
        financeDocumentConsumableCashOrderElement.appendChild(financeDocumentVendorElement);
        XHelper.writeString((Element)financeDocumentConsumableCashOrderElement, (String)FINANCE_DOCUMENT_NUMBER_ELEMENT_NAME, (String)TextUtil.buildFullNumber((CompositeNumber)financeDocument));
        XHelper.writeDate((Element)financeDocumentConsumableCashOrderElement, (String)FINANCE_DOCUMENT_DATE_ELEMENT_NAME, (Date)financeDocument.getDate());
        Element financeDocumentCustomerElement = document.createElementNS(null, FINANCE_DOCUMENT_CASH_ORDER_RECIPIENT_ELEMENT_NAME);
        financeDocumentCustomerElement.appendChild(XMLFinanceDocumentsExportHelper.createCustomerElement(bookingFile.getCustomer(), document, messages));
        financeDocumentConsumableCashOrderElement.appendChild(financeDocumentCustomerElement);
        BigDecimal cashOrderTotal = BigDecimal.ZERO;
        String cashOrderSubject = null;
        HashSet<String> returnedTicketNumbers = new HashSet<String>();
        HashSet<EntityReference> returnedBlankOwners = new HashSet<EntityReference>();
        for (BillingItem billingItem : payment.getBillingItems()) {
            if (billingItem.getAmount() == null || billingItem.getAmount().getTotal() == null || !XMLFinanceDocumentsExportHelper.acceptable(financeDocument.getType(), billingItem, refund) || financeDocument.getType() != FinanceDocumentType.CASH_ORDER) continue;
            if (billingItem.getServiceType() == ServiceType.TICKET) {
                for (String uid : billingItem.getProductUids()) {
                    Product product;
                    BaseProduct baseProduct = BookingHelper.findProduct(payment.getBookingFile(), uid);
                    if (!(baseProduct instanceof Product) || (product = (Product)baseProduct).getStatus() != ProductStatus.REFUND) continue;
                    if (product.getBlankOwnerRef() != null) {
                        returnedBlankOwners.add(product.getBlankOwnerRef());
                    }
                    if (TextUtil.isBlank((String)product.getSystemNumber())) continue;
                    returnedTicketNumbers.add(product.getSystemNumber());
                }
            }
            cashOrderTotal = cashOrderTotal.subtract(billingItem.getAmount().getTotal());
        }
        if (financeDocument.getType() == FinanceDocumentType.CASH_ORDER) {
            StringBuilder stringBuilder = new StringBuilder("\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u0430\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442\u043e\u0432");
            boolean first = true;
            for (EntityReference blankOwner : returnedBlankOwners) {
                stringBuilder.append(first ? " " : ", ");
                stringBuilder.append(blankOwner.toString());
                first = false;
            }
            first = true;
            for (String tn : returnedTicketNumbers) {
                stringBuilder.append(first ? " " : ", ");
                stringBuilder.append(tn);
                first = false;
            }
            cashOrderSubject = stringBuilder.toString();
        }
        XHelper.writeBigDecimal((Element)financeDocumentConsumableCashOrderElement, (String)FINANCE_DOCUMENT_CASH_ORDER_TOTAL_ELEMENT_NAME, (BigDecimal)cashOrderTotal);
        XHelper.writeString((Element)financeDocumentConsumableCashOrderElement, (String)FINANCE_DOCUMENT_CASH_ORDER_SUBJECT_ELEMENT_NAME, cashOrderSubject);
        return financeDocumentConsumableCashOrderElement;
    }

    private static Element createFinanceDocumentStatementOnServicesElement(EntityContainer<BookingFile> bookingFileContainer, Payment payment, FinanceDocument financeDocument, Document document, Set<Message> messages) throws Exception {
        Element financeDocumentStatementOnServicesElement = document.createElementNS(null, FINANCE_DOCUMENT_STATEMENT_ON_SERVICES_ELEMENT_NAME);
        if (payment.getAgent() != null) {
            Element financeDocumentAgentElement = document.createElementNS(null, FINANCE_DOCUMENT_AGENT_ELEMENT_NAME);
            Element personElement = XMLFinanceDocumentsExportHelper.createPersonElement((EntityReference<Person>)payment.getAgent(), document, messages);
            if (personElement == null) {
                messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0430\u0433\u0435\u043d\u0442\u0430, \u0432\u044b\u0441\u0442\u0430\u0432\u0438\u0432\u0448\u0435\u0433\u043e \u0441\u0447\u0435\u0442", new Object[0]));
                return null;
            }
            financeDocumentAgentElement.appendChild(personElement);
            financeDocumentStatementOnServicesElement.appendChild(financeDocumentAgentElement);
        }
        boolean refund = XMLFinanceDocumentsExportHelper.isRefund(payment);
        Element financeDocumentVendorElement = document.createElementNS(null, FINANCE_DOCUMENT_VENDOR_ELEMENT_NAME);
        Element organizationElement = null;
        for (BillingItem billingItem : payment.getBillingItems()) {
            BaseProduct baseProduct = BookingHelper.findProduct((BookingFile)bookingFileContainer.getEntity(), !billingItem.getProductUids().isEmpty() ? (String)billingItem.getProductUids().iterator().next() : null);
            if (!(baseProduct instanceof BaseTicketProduct)) continue;
            EntityReference<Organization> agencyReference = null;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            agencyReference = GeneralProductHelper.getContractor(handler.getSalesChain(baseProduct), PredefinedContractorType.SUBAGENCY);
            organizationElement = XMLFinanceDocumentsExportHelper.createOrganizationElement(agencyReference, document, messages);
        }
        if (organizationElement == null) {
            messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430/\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430, \u043e\u0442 \u043b\u0438\u0446\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0447\u0435\u0442", new Object[0]));
            return null;
        }
        financeDocumentVendorElement.appendChild(organizationElement);
        financeDocumentStatementOnServicesElement.appendChild(financeDocumentVendorElement);
        Element financeDocumentClientElement = document.createElementNS(null, FINANCE_DOCUMENT_CLIENT_ELEMENT_NAME);
        organizationElement = XMLFinanceDocumentsExportHelper.createOrganizationElement((EntityReference<Organization>)((BookingFile)bookingFileContainer.getEntity()).getCustomerProfile(), document, messages);
        if (organizationElement == null) {
            messages.add(XMLFinanceDocumentsExportHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f", new Object[0]));
            return null;
        }
        financeDocumentClientElement.appendChild(organizationElement);
        financeDocumentStatementOnServicesElement.appendChild(financeDocumentClientElement);
        XHelper.writeString((Element)financeDocumentStatementOnServicesElement, (String)FINANCE_DOCUMENT_NUMBER_ELEMENT_NAME, (String)TextUtil.buildFullNumber((CompositeNumber)financeDocument));
        XHelper.writeDate((Element)financeDocumentStatementOnServicesElement, (String)FINANCE_DOCUMENT_DATE_ELEMENT_NAME, (Date)financeDocument.getDate());
        Element financeDocumentItemsElement = document.createElementNS(null, FINANCE_DOCUMENT_ITEMS_ELEMENT_NAME);
        for (BillingItem billingItem : payment.getBillingItems()) {
            if (!XMLFinanceDocumentsExportHelper.acceptable(financeDocument.getType(), billingItem, refund)) continue;
            Element financeDocumentItemElement = XMLFinanceDocumentsExportHelper.createFinanceDocumentItemElement(financeDocument, billingItem, refund, document, messages);
            if (financeDocumentItemElement != null) {
                financeDocumentItemsElement.appendChild(financeDocumentItemElement);
                continue;
            }
            return null;
        }
        financeDocumentStatementOnServicesElement.appendChild(financeDocumentItemsElement);
        return financeDocumentStatementOnServicesElement;
    }

    private static Element createFinanceDocumentItemElement(FinanceDocument financeDocument, BillingItem billingItem, boolean refund, Document document, Set<Message> messages) throws Exception {
        int size;
        Element financeDocumentItemElement = document.createElementNS(null, FINANCE_DOCUMENT_ITEM_ELEMENT_NAME);
        BigDecimal coeff = BigDecimal.ONE;
        if (refund && financeDocument.getType() == FinanceDocumentType.STANDARD_BILL) {
            coeff = coeff.negate();
        }
        if ((size = billingItem.getProductUids().size()) == 0) {
            messages.add(XMLFinanceDocumentsExportHelper.createWarningMessage(String.format("\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0447\u0438\u0441\u043b\u043e \u043f\u043e\u0437\u0438\u0446\u0438\u0439 \u0434\u043b\u044f \u0443\u0441\u043b\u0443\u0433\u0438 \"%s\"", billingItem.getName()), new Object[0]));
        }
        XHelper.writeString((Element)financeDocumentItemElement, (String)FINANCE_DOCUMENT_ITEM_NAME_ELEMENT_NAME, (String)billingItem.getName());
        XHelper.writeString((Element)financeDocumentItemElement, (String)FINANCE_DOCUMENT_ITEM_COUNT_ELEMENT_NAME, (String)Integer.toString(size));
        BigDecimal total = null;
        BigDecimal vat = null;
        Double vatPercent = null;
        if (billingItem.getAmount() != null) {
            VatAmount vatAmount = billingItem.getAmount();
            if (vatAmount.getTotal() != null) {
                total = vatAmount.getTotal().divide(BigDecimal.valueOf(size), 2, RoundingMode.HALF_UP).multiply(coeff);
            }
            if (vatAmount.getVatAmount() != null) {
                vat = vatAmount.getVatAmount().divide(BigDecimal.valueOf(size), 2, RoundingMode.HALF_UP).multiply(coeff);
            }
            if ((vatPercent = billingItem.getAmount().getVat()) != null) {
                vatPercent = BigDecimal.valueOf(vatPercent).divide(BigDecimal.ONE, 1, RoundingMode.HALF_UP).doubleValue();
            }
        }
        XHelper.writeBigDecimal((Element)financeDocumentItemElement, (String)FINANCE_DOCUMENT_ITEM_TOTAL_ELEMENT_NAME, total);
        XHelper.writeBigDecimal((Element)financeDocumentItemElement, (String)FINANCE_DOCUMENT_ITEM_VAT_ELEMENT_NAME, vat);
        XHelper.writeDouble((Element)financeDocumentItemElement, (String)FINANCE_DOCUMENT_ITEM_VAT_PERCENT_ELEMENT_NAME, (Double)vatPercent);
        XHelper.writeBoolean((Element)financeDocumentItemElement, (String)FINANCE_DOCUMENT_ITEM_IS_SERVICE_ELEMENT_NAME, (Boolean)(billingItem.getServiceType() != ServiceType.TICKET ? 1 : 0));
        return financeDocumentItemElement;
    }

    private static Element createOrganizationElement(EntityReference<Organization> organizationReference, Document document, Set<Message> messages) throws Exception {
        if (organizationReference == null) {
            return null;
        }
        EntityContainer organizationContainer = EntityStorage.get().resolve(organizationReference);
        if (organizationContainer == null) {
            return null;
        }
        Organization organization = (Organization)organizationContainer.getEntity();
        Element organizationElement = document.createElementNS(null, ORGANIZATION_ELEMENT_NAME);
        Locale locale = LocaleManager.get().getCurrentLocale();
        String codeString = SystemHelper.findMetadataAsString(organization.getMetadata(), MetadataKey.KEY_ACCOUNTING_SYSTEM_CODE);
        XHelper.writeString((Element)organizationElement, (String)ORGANIZATION_CODE_ELEMENT_NAME, (String)codeString);
        XHelper.writeLocalizationString((Element)organizationElement, (String)ORGANIZATION_SHORT_NAME_ELEMENT_NAME, (L10nString)organization.getShortName());
        XHelper.writeLocalizationString((Element)organizationElement, (String)ORGANIZATION_FULL_NAME_ELEMENT_NAME, (L10nString)organization.getFullName());
        DictionaryReference legalformReference = organization.getLegalForm();
        String legalFormString = null;
        LegalForm legalForm = (LegalForm)DictionaryCache.get().resolveReference(legalformReference);
        if (legalForm != null && !legalForm.getTranslations().isEmpty()) {
            legalFormString = legalForm.getTranslations().containsKey(locale) ? (String)legalForm.getTranslations().get(locale) : (String)legalForm.getTranslations().values().iterator().next();
        }
        XHelper.writeString((Element)organizationElement, (String)ORGANIZATION_LEGAL_FORM_ELEMENT_NAME, legalFormString);
        XHelper.writeString((Element)organizationElement, (String)ORGANIZATION_INN_ELEMENT_NAME, (String)organization.getRegistrationId());
        XHelper.writeString((Element)organizationElement, (String)ORGANIZATION_KPP_ELEMENT_NAME, (String)organization.getKpp());
        XHelper.writeString((Element)organizationElement, (String)ORGANIZATION_OKPO_ELEMENT_NAME, (String)organization.getOkpoCode());
        Element managersElement = document.createElementNS(null, ORGANIZATION_MANAGERS_ELEMENT_NAME);
        List<Person> employees = ProfileDao.getEmployees(organizationReference, new ManagerType[0], null);
        for (Person person : employees) {
            String employeeName = ProfileHelper.getFullName(person, LocaleHelper.getCurrentLocale(), false);
            for (PersonEmployment employment : person.getEmployments()) {
                Element managerElement;
                ManagerType employeePosition;
                if (employment.getOrganization() == null || !employment.getOrganization().equals(organizationReference) || employment.getPosition() == null || (employeePosition = DictHelper.getDictionaryStandardValueType(employment.getPosition(), ManagerType.class)) == null || (managerElement = XMLFinanceDocumentsExportHelper.createManagerElement(employeePosition, employeeName, document, messages)) == null) continue;
                managersElement.appendChild(managerElement);
            }
        }
        organizationElement.appendChild(managersElement);
        Element addressesElement = document.createElementNS(null, ORGANIZATION_ADDRESSES_ELEMENT_NAME);
        for (Address address : organization.getAddresses()) {
            Element addressElement = XMLFinanceDocumentsExportHelper.createAddressElement(address, locale, document, messages);
            if (addressElement == null) continue;
            addressesElement.appendChild(addressElement);
        }
        organizationElement.appendChild(addressesElement);
        Element element = document.createElementNS(null, ORGANIZATION_BANK_ACCOUNTS_ELEMENT_NAME);
        for (BankAccount bankAccount : organization.getBankAccounts()) {
            Element bankAccountElement = XMLFinanceDocumentsExportHelper.createBankAccountElement(bankAccount, locale, document, messages);
            if (bankAccountElement == null) continue;
            element.appendChild(bankAccountElement);
        }
        organizationElement.appendChild(element);
        XHelper.writeString((Element)organizationElement, (String)ORGANIZATION_COMMENTS_ELEMENT_NAME, (String)organization.getNotes());
        return organizationElement;
    }

    private static Element createPersonElement(EntityReference<Person> personReference, Document document, Set<Message> messages) throws Exception {
        if (personReference == null) {
            return null;
        }
        EntityContainer personContainer = EntityStorage.get().resolve(personReference);
        if (personContainer == null) {
            return null;
        }
        Person person = (Person)personContainer.getEntity();
        Element personElement = document.createElementNS(null, PERSON_ELEMENT_NAME);
        XHelper.writeLocalizationString((Element)personElement, (String)PERSON_LAST_NAME_ELEMENT_NAME, (L10nString)person.getLastName());
        XHelper.writeLocalizationString((Element)personElement, (String)PERSON_FIRST_NAME_ELEMENT_NAME, (L10nString)person.getFirstName());
        XHelper.writeLocalizationString((Element)personElement, (String)PERSON_MIDDLE_NAME_ELEMENT_NAME, (L10nString)person.getMiddleName());
        return personElement;
    }

    private static Element createCustomerElement(Customer customer, Document document, Set<Message> messages) {
        Locale locale = LocaleManager.get().getCurrentLocale();
        Element customerElement = document.createElementNS(null, CUSTOMER_ELEMENT_NAME);
        XHelper.writeString((Element)customerElement, (String)CUSTOMER_NAME_ELEMENT_NAME, (String)customer.getName());
        XHelper.writeString((Element)customerElement, (String)CUSTOMER_CUSTOMER_ELEMENT_NAME, (String)customer.getCompanyName());
        Element customerAddressesElement = document.createElementNS(null, CUSTOMER_ADDRESSES_ELEMENT_NAME);
        for (Address address : customer.getAddresses()) {
            Element addressElement = XMLFinanceDocumentsExportHelper.createAddressElement(address, locale, document, messages);
            if (addressElement == null) continue;
            customerAddressesElement.appendChild(addressElement);
        }
        customerElement.appendChild(customerAddressesElement);
        Element customerPassportElement = document.createElementNS(null, CUSTOMER_PASSPORT_ELEMENT_NAME);
        Element passportElement = XMLFinanceDocumentsExportHelper.createPassportElement(customer.getPassport(), locale, document, messages);
        if (passportElement != null) {
            customerPassportElement.appendChild(passportElement);
        }
        customerElement.appendChild(customerPassportElement);
        return customerElement;
    }

    private static Element createManagerElement(ManagerType managerPosition, String managerName, Document document, Set<Message> messages) {
        Element managerElement = document.createElementNS(null, MANAGER_ELEMENT_NAME);
        XHelper.writeEnum((Element)managerElement, (String)MANAGER_TYPE_ELEMENT_NAME, (Enum)managerPosition);
        XHelper.writeString((Element)managerElement, (String)MANAGER_NAME_ELEMENT_NAME, (String)managerName);
        XHelper.writeString((Element)managerElement, (String)MANAGER_COMMENTS_ELEMENT_NAME, null);
        return managerElement;
    }

    private static Element createAddressElement(Address address, Locale locale, Document document, Set<Message> messages) {
        if (address == null) {
            return null;
        }
        Element addressElement = document.createElementNS(null, ADDRESS_ELEMENT_NAME);
        XHelper.writeEnum((Element)addressElement, (String)ADDRESS_TYPE_ELEMENT_NAME, (Enum)address.getAddressType());
        XHelper.writeString((Element)addressElement, (String)ADDRESS_ZIP_ELEMENT_NAME, (String)address.getZip());
        String countryString = null;
        DictionaryReference countryReference = address.getCountry();
        Country country = (Country)DictionaryCache.get().resolveReference(countryReference);
        if (country != null && !country.getTranslations().isEmpty()) {
            countryString = country.getTranslations().containsKey(locale) ? (String)country.getTranslations().get(locale) : (String)country.getTranslations().values().iterator().next();
        }
        XHelper.writeString((Element)addressElement, (String)ADDRESS_COUNTRY_ELEMENT_NAME, countryString);
        XHelper.writeString((Element)addressElement, (String)ADDRESS_REGION_ELEMENT_NAME, address.getRegion() != null ? address.getRegion().toString() : null);
        XHelper.writeLocalizationString((Element)addressElement, (String)ADDRESS_DISTRICT_ELEMENT_NAME, (L10nString)address.getDistrict());
        XHelper.writeString((Element)addressElement, (String)ADDRESS_CITY_ELEMENT_NAME, address.getCity() != null ? address.getCity().toString() : null);
        XHelper.writeLocalizationString((Element)addressElement, (String)ADDRESS_TOWN_ELEMENT_NAME, (L10nString)address.getTown());
        XHelper.writeLocalizationString((Element)addressElement, (String)ADDRESS_ADDRESS_ELEMENT_NAME, (L10nString)address.getAddress());
        XHelper.writeLocalizationString((Element)addressElement, (String)ADDRESS_HOUSE_ELEMENT_NAME, (L10nString)address.getHouse());
        XHelper.writeLocalizationString((Element)addressElement, (String)ADDRESS_HOUSING_ELEMENT_NAME, (L10nString)address.getHousing());
        XHelper.writeLocalizationString((Element)addressElement, (String)ADDRESS_BUILDING_ELEMENT_NAME, (L10nString)address.getBuilding());
        XHelper.writeLocalizationString((Element)addressElement, (String)ADDRESS_PAVILION_ELEMENT_NAME, (L10nString)address.getPavilion());
        XHelper.writeLocalizationString((Element)addressElement, (String)ADDRESS_FLAT_ELEMENT_NAME, (L10nString)address.getFlat());
        XHelper.writeLocalizationString((Element)addressElement, (String)ADDRESS_OFFICE_ELEMENT_NAME, (L10nString)address.getOffice());
        XHelper.writeString((Element)addressElement, (String)ADDRESS_POBOX_ELEMENT_NAME, (String)address.getPoBox());
        XHelper.writeString((Element)addressElement, (String)ADDRESS_COMMENTS_ELEMENT_NAME, (String)address.getNotes());
        return addressElement;
    }

    private static Element createBankAccountElement(BankAccount bankAccount, Locale locale, Document document, Set<Message> messages) {
        CurrencyInfo currencyInfo;
        Element bankAccountElement = document.createElementNS(null, BANK_ACCOUNT_ELEMENT_NAME);
        String currencyString = null;
        String currency = bankAccount.getCurrency();
        if (currency != null && (currencyInfo = DictHelper.getCurrencyInfoByAnyCode(currency)) != null) {
            currencyString = currencyInfo.getCode();
        }
        XHelper.writeString((Element)bankAccountElement, (String)BANK_ACCOUNT_CURRENCY_ELEMENT_NAME, currencyString);
        XHelper.writeString((Element)bankAccountElement, (String)BANK_ACCOUNT_SETTLEMENT_ACCOUNT_ELEMENT_NAME, (String)bankAccount.getSettlementAccount());
        XHelper.writeString((Element)bankAccountElement, (String)BANK_ACCOUNT_BANK_ELEMENT_NAME, (String)bankAccount.getBankName());
        String cityString = null;
        DictionaryReference cityReference = bankAccount.getCity();
        GeoLocation city = (GeoLocation)DictionaryCache.get().resolveReference(cityReference);
        if (city != null && !city.getTranslations().isEmpty()) {
            cityString = city.getTranslations().containsKey(locale) ? (String)city.getTranslations().get(locale) : (String)city.getTranslations().values().iterator().next();
        }
        XHelper.writeString((Element)bankAccountElement, (String)BANK_ACCOUNT_CITY_ELEMENT_NAME, cityString);
        XHelper.writeString((Element)bankAccountElement, (String)BANK_ACCOUNT_CORRESPONDENT_ACCOUNT_ELEMENT_NAME, (String)bankAccount.getCorrespondentAccount());
        XHelper.writeString((Element)bankAccountElement, (String)BANK_ACCOUNT_BIK_ELEMENT_NAME, (String)bankAccount.getBik());
        XHelper.writeString((Element)bankAccountElement, (String)BANK_ACCOUNT_COMMENTS_ELEMENT_NAME, (String)bankAccount.getRemarks());
        return bankAccountElement;
    }

    private static Element createPassportElement(Passport passport, Locale locale, Document document, Set<Message> messages) {
        if (passport == null) {
            return null;
        }
        Element passportElement = document.createElementNS(null, PASSPORT_ELEMENT_NAME);
        XHelper.writeString((Element)passportElement, (String)PASSPORT_LAST_NAME_ELEMENT_NAME, (String)passport.getLastName());
        XHelper.writeString((Element)passportElement, (String)PASSPORT_FIRST_NAME_ELEMENT_NAME, (String)passport.getFirstName());
        XHelper.writeString((Element)passportElement, (String)PASSPORT_MIDDLE_NAME_ELEMENT_NAME, (String)passport.getMiddleName());
        XHelper.writeEnum((Element)passportElement, (String)PASSPORT_GENDER_ELEMENT_NAME, (Enum)passport.getGender());
        XHelper.writeDate((Element)passportElement, (String)PASSPORT_BIRTHDAY_ELEMENT_NAME, (Date)passport.getBirthday());
        String countryString = null;
        DictionaryReference countryReference = passport.getCitizenship();
        Country country = (Country)DictionaryCache.get().resolveReference(countryReference);
        if (country != null && !country.getTranslations().isEmpty()) {
            countryString = country.getTranslations().containsKey(locale) ? (String)country.getTranslations().get(locale) : (String)country.getTranslations().values().iterator().next();
        }
        XHelper.writeString((Element)passportElement, (String)PASSPORT_CITIZENSHIP_ELEMENT_NAME, countryString);
        XHelper.writeString((Element)passportElement, (String)PASSPORT_NUMBER_ELEMENT_NAME, (String)passport.getNumber());
        XHelper.writeEnum((Element)passportElement, (String)PASSPORT_TYPE_ELEMENT_NAME, (Enum)passport.getType());
        XHelper.writeDate((Element)passportElement, (String)PASSPORT_ISSUE_DATE_ELEMENT_NAME, (Date)passport.getIssued());
        XHelper.writeString((Element)passportElement, (String)PASSPORT_ISSUE_ORGANIZATION_ELEMENT_NAME, (String)passport.getIssueOrganization());
        countryString = null;
        countryReference = passport.getOriginCountry();
        country = (Country)DictionaryCache.get().resolveReference(countryReference);
        if (country != null && !country.getTranslations().isEmpty()) {
            countryString = country.getTranslations().containsKey(locale) ? (String)country.getTranslations().get(locale) : (String)country.getTranslations().values().iterator().next();
        }
        XHelper.writeString((Element)passportElement, (String)PASSPORT_ISSUE_COUNTRY_ELEMENT_NAME, (String)countryString);
        XHelper.writeString((Element)passportElement, (String)PASSPORT_ISSUE_CITY_ELEMENT_NAME, (String)passport.getIssueCity());
        XHelper.writeDate((Element)passportElement, (String)PASSPORT_EXPIRED_ELEMENT_NAME, (Date)passport.getExpired());
        return passportElement;
    }

    private static boolean isRefund(Payment payment) {
        for (BillingItem billingItem : payment.getBillingItems()) {
            for (String uid : billingItem.getProductUids()) {
                BaseProduct baseProduct = BookingHelper.findProduct(payment.getBookingFile(), uid);
                if (!(baseProduct instanceof BaseTicketProduct) || ((BaseTicketProduct)baseProduct).getStatus() != ProductStatus.REFUND) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean acceptable(FinanceDocumentType type, BillingItem item, boolean refund) throws Exception {
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE && item.getServiceType() != ServiceType.FEE) {
            return false;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE && item.getServiceType() == ServiceType.FEE) {
            return refund && BookingHelper.isFeeForRefund((EntityReference<? extends BaseCommissionProperties>)item.getCommissionType()) || !refund && !BookingHelper.isFeeForRefund((EntityReference<? extends BaseCommissionProperties>)item.getCommissionType());
        }
        if (refund && type == FinanceDocumentType.STANDARD_BILL && item.getServiceType() == ServiceType.FEE) {
            return refund && !BookingHelper.isFeeForRefund((EntityReference<? extends BaseCommissionProperties>)item.getCommissionType()) || !refund && BookingHelper.isFeeForRefund((EntityReference<? extends BaseCommissionProperties>)item.getCommissionType());
        }
        if (type == FinanceDocumentType.CASH_ORDER) {
            if (!refund) {
                return false;
            }
            if (item.getServiceType() == ServiceType.DISCOUNT) {
                return false;
            }
            if (item.getServiceType() == ServiceType.FEE) {
                EntityContainer ctr = EntityStorage.get().resolve(item.getCommissionType());
                if (ctr == null || !FeeProperties.class.getName().equals(ctr.getEntityType().getName())) {
                    return false;
                }
                Operation operation = ((FeeProperties)ctr.getEntity()).getOperation();
                return operation != Operation.REFUND && operation != Operation.EXCHANGE;
            }
            return true;
        }
        return true;
    }

    public static Message createMessage(String key, String details, Object ... parameters) {
        return XMLFinanceDocumentsExportHelper.createMessage(MessageType.MESSAGE, key, details, parameters);
    }

    public static Message createMessage(String key, Object ... parameters) {
        return XMLFinanceDocumentsExportHelper.createMessage(MessageType.MESSAGE, key, null, parameters);
    }

    public static Message createWarningMessage(String key, String details, Object ... parameters) {
        return XMLFinanceDocumentsExportHelper.createMessage(MessageType.WARNING, key, details, parameters);
    }

    public static Message createWarningMessage(String key, Object ... parameters) {
        return XMLFinanceDocumentsExportHelper.createMessage(MessageType.WARNING, key, null, parameters);
    }

    public static Message createErrorMessage(String key, String details, Object ... parameters) {
        return XMLFinanceDocumentsExportHelper.createMessage(MessageType.ERROR, key, details, parameters);
    }

    public static Message createErrorMessage(String key, Object ... parameters) {
        return XMLFinanceDocumentsExportHelper.createMessage(MessageType.ERROR, key, null, parameters);
    }

    public static Message createMessage(MessageType type, String key, String details, Object ... parameters) {
        Message message = new Message();
        message.setType(type);
        message.setMessage(L10nResourcesManager.createL10nMessage((String)key, (Object[])parameters));
        message.setDetails(details);
        return message;
    }

    public static Element createAirlineDictionaryElement(DictionaryReference<Airline> airlineReference, Locale locale, Document document, Set<Message> messages) {
        Airline airline = (Airline)DictionaryCache.get().resolveReference(airlineReference);
        if (airline == null) {
            messages.add(MessageHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438", new Object[0]));
            return null;
        }
        Element airlineElement = document.createElementNS(null, AIRLINE_ELEMENT_NAME);
        String airlineCode = airline.getCode();
        if (!TextUtil.isBlank((String)airlineCode)) {
            XHelper.writeString((Element)airlineElement, (String)AIRLINE_CODE_ELEMENT_NAME, (String)airlineCode);
        } else {
            messages.add(MessageHelper.createWarningMessage("\u0423 \u0430\u0432\u0438\u0430\u043b\u0438\u043d\u0438\u0438 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", new Object[0]));
        }
        Element airlineCodeVariantsElement = document.createElementNS(null, AIRLINE_CODE_VARIANTS_ELEMENT_NAME);
        for (Map.Entry entry : airline.getCodeVariants().entrySet()) {
            Element airlineCodeVariantElement = document.createElementNS(null, AIRLINE_CODE_VARIANT_ELEMENT_NAME);
            String codeVariantSystem = (String)entry.getKey();
            if (!TextUtil.isBlank((String)codeVariantSystem)) {
                XHelper.writeString((Element)airlineCodeVariantElement, (String)AIRLINE_CODE_VARIANT_SYSTEM_ELEMENT_NAME, (String)codeVariantSystem);
            } else {
                messages.add(MessageHelper.createWarningMessage("\u0423 \u0430\u0432\u0438\u0430\u043b\u0438\u043d\u0438\u0438 \u0434\u043b\u044f \u0432\u0430\u0440\u0438\u043d\u0442\u0430 \u043a\u043e\u0434\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043a\u043e\u0434\u043e\u0432", new Object[0]));
            }
            String codeVariantValue = (String)entry.getValue();
            if (!TextUtil.isBlank((String)codeVariantValue)) {
                XHelper.writeString((Element)airlineCodeVariantElement, (String)AIRLINE_CODE_VARIANT_VALUE_ELEMENT_NAME, (String)codeVariantValue);
            } else {
                messages.add(MessageHelper.createWarningMessage("\u0423 \u0430\u0432\u0438\u0430\u043b\u0438\u043d\u0438\u0438 \u0434\u043b\u044f \u0432\u0430\u0440\u0438\u043d\u0442\u0430 \u043a\u043e\u0434\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u043a\u043e\u0434", new Object[0]));
            }
            airlineCodeVariantsElement.appendChild(airlineCodeVariantElement);
        }
        airlineElement.appendChild(airlineCodeVariantsElement);
        String translation = (String)MiscUtil.findByLocale((Map)airline.getTranslations(), (Locale)locale);
        if (!TextUtil.isBlank((String)translation)) {
            XHelper.writeString((Element)airlineElement, (String)AIRLINE_NAME_ELEMENT_NAME, (String)translation);
        } else {
            messages.add(MessageHelper.createWarningMessage("\u0423 \u0430\u0432\u0438\u0430\u043b\u0438\u043d\u0438\u0438 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", new Object[0]));
        }
        String airlineNumber = airline.getAirlineNumber();
        if (!TextUtil.isBlank((String)airlineNumber)) {
            XHelper.writeString((Element)airlineElement, (String)AIRLINE_NUMBER_ELEMENT_NAME, (String)airlineNumber);
        } else {
            messages.add(MessageHelper.createWarningMessage("\u0423 \u0430\u0432\u0438\u0430\u043b\u0438\u043d\u0438\u0438 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u043d\u043e\u043c\u0435\u0440", new Object[0]));
        }
        Element airlineCountryElement = document.createElementNS(null, AIRLINE_COUNTRY_ELEMENT_NAME);
        DictionaryReference countryReference = airline.getCountry();
        if (countryReference != null) {
            Element countryElement = XMLFinanceDocumentsExportHelper.createCountryDictionaryElement((DictionaryReference<Country>)countryReference, locale, document, messages);
            if (countryElement != null) {
                airlineCountryElement.appendChild(countryElement);
            } else {
                messages.add(MessageHelper.createWarningMessage("\u0423 \u0430\u0432\u0438\u0430\u043b\u0438\u043d\u0438\u0438 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0430", new Object[0]));
            }
        } else {
            messages.add(MessageHelper.createWarningMessage("\u0423 \u0430\u0432\u0438\u0430\u043b\u0438\u043d\u0438\u0438 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0430", new Object[0]));
        }
        airlineElement.appendChild(airlineCountryElement);
        Date openDate = airline.getOpenDate();
        if (openDate != null) {
            XHelper.writeDate((Element)airlineElement, (String)AIRLINE_OPEN_DATE_ELEMENT_NAME, (Date)openDate);
        } else {
            messages.add(MessageHelper.createWarningMessage("\u0423 \u0430\u0432\u0438\u0430\u043b\u0438\u043d\u0438\u0438 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0434\u0430\u0442\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f", new Object[0]));
        }
        Date closeDate = airline.getCloseDate();
        if (closeDate != null) {
            XHelper.writeDate((Element)airlineElement, (String)AIRLINE_CLOSE_DATE_ELEMENT_NAME, (Date)closeDate);
        } else {
            messages.add(MessageHelper.createWarningMessage("\u0423 \u0430\u0432\u0438\u0430\u043b\u0438\u043d\u0438\u0438 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0434\u0430\u0442\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f", new Object[0]));
        }
        return airlineElement;
    }

    public static Element createCountryDictionaryElement(DictionaryReference<Country> countryReference, Locale locale, Document document, Set<Message> messages) {
        Country country = (Country)DictionaryCache.get().resolveReference(countryReference);
        if (country == null) {
            messages.add(MessageHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \u0441\u0442\u0440\u0430\u043d\u044b", new Object[0]));
            return null;
        }
        Element countryElement = document.createElementNS(null, COUNTRY_ELEMENT_NAME);
        String countryCode = country.getCode();
        if (!TextUtil.isBlank((String)countryCode)) {
            XHelper.writeString((Element)countryElement, (String)COUNTRY_CODE_ELEMENT_NAME, (String)countryCode);
        } else {
            messages.add(MessageHelper.createWarningMessage("\u0423 \u0441\u0442\u0440\u0430\u043d\u044b \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", new Object[0]));
        }
        Element countryCodeVariantsElement = document.createElementNS(null, COUNTRY_CODE_VARIANTS_ELEMENT_NAME);
        for (Map.Entry entry : country.getCodeVariants().entrySet()) {
            Element countryCodeVariantElement = document.createElementNS(null, COUNTRY_CODE_VARIANT_ELEMENT_NAME);
            String codeVariantSystem = (String)entry.getKey();
            if (!TextUtil.isBlank((String)codeVariantSystem)) {
                XHelper.writeString((Element)countryCodeVariantElement, (String)COUNTRY_CODE_VARIANT_SYSTEM_ELEMENT_NAME, (String)codeVariantSystem);
            } else {
                messages.add(MessageHelper.createWarningMessage("\u0423 \u0441\u0442\u0440\u0430\u043d\u044b \u0434\u043b\u044f \u0432\u0430\u0440\u0438\u043d\u0442\u0430 \u043a\u043e\u0434\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043a\u043e\u0434\u043e\u0432", new Object[0]));
            }
            String codeVariantValue = (String)entry.getValue();
            if (!TextUtil.isBlank((String)codeVariantValue)) {
                XHelper.writeString((Element)countryCodeVariantElement, (String)COUNTRY_CODE_VARIANT_VALUE_ELEMENT_NAME, (String)codeVariantValue);
            } else {
                messages.add(MessageHelper.createWarningMessage("\u0423 \u0441\u0442\u0440\u0430\u043d\u044b \u0434\u043b\u044f \u0432\u0430\u0440\u0438\u043d\u0442\u0430 \u043a\u043e\u0434\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u043a\u043e\u0434", new Object[0]));
            }
            countryCodeVariantsElement.appendChild(countryCodeVariantElement);
        }
        countryElement.appendChild(countryCodeVariantsElement);
        return countryElement;
    }

    public static Element createBlankTypeDictionaryElement(DictionaryReference<BlankType> blankTypeReference, Locale locale, Document document, Set<Message> messages) {
        BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blankTypeReference);
        if (blankType == null) {
            messages.add(MessageHelper.createErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \u0442\u0438\u043f\u044b \u0431\u043b\u0430\u043d\u043a\u043e\u0432", new Object[0]));
            return null;
        }
        Element blankTypeElement = document.createElementNS(null, BLANK_TYPE_ELEMENT_NAME);
        String blankTypeCode = blankType.getCode();
        if (!TextUtil.isBlank((String)blankTypeCode)) {
            XHelper.writeString((Element)blankTypeElement, (String)BLANK_TYPE_CODE_ELEMENT_NAME, (String)blankTypeCode);
        } else {
            messages.add(MessageHelper.createWarningMessage("\u0423 \u0442\u0438\u043f\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", new Object[0]));
        }
        String blankTypeName = blankType.getName();
        if (!TextUtil.isBlank((String)blankTypeName)) {
            XHelper.writeString((Element)blankTypeElement, (String)BLANK_TYPE_NAME_ELEMENT_NAME, (String)blankTypeName);
        } else {
            messages.add(MessageHelper.createWarningMessage("\u0423 \u0442\u0438\u043f\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u043d\u043e\u043c\u0435\u0440", new Object[0]));
        }
        int blankTypeCouponsCount = blankType.getCouponsCount();
        XHelper.writeInt((Element)blankTypeElement, (String)BLANK_TYPE_COUPONS_COUNT_ELEMENT_NAME, (int)blankTypeCouponsCount);
        Element blankTypeVendorElement = document.createElementNS(null, BLANK_TYPE_VENDOR_ELEMENT_NAME);
        DictionaryReference airlineReference = blankType.getVendor();
        if (airlineReference != null) {
            Element airLineElement = XMLFinanceDocumentsExportHelper.createAirlineDictionaryElement((DictionaryReference<Airline>)airlineReference, locale, document, messages);
            if (airLineElement != null) {
                blankTypeVendorElement.appendChild(airLineElement);
            } else {
                messages.add(MessageHelper.createWarningMessage("\u0423 \u0442\u0438\u043f\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0431\u043b\u0430\u043d\u043a\u0430", new Object[0]));
            }
        } else {
            messages.add(MessageHelper.createWarningMessage("\u0423 \u0442\u0438\u043f\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0431\u043b\u0430\u043d\u043a\u0430", new Object[0]));
        }
        blankTypeElement.appendChild(blankTypeVendorElement);
        ProductCategory blankTypeProductCategory = blankType.getProductCategory();
        if (blankTypeProductCategory != null) {
            XHelper.writeEnum((Element)blankTypeElement, (String)BLANK_TYPE_PRODUCT_CATEGORY_ELEMENT_NAME, (Enum)blankTypeProductCategory);
        } else {
            messages.add(MessageHelper.createWarningMessage("\u0423 \u0442\u0438\u043f\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0432\u0438\u0434 \u0431\u043b\u0430\u043d\u043a\u0430", new Object[0]));
        }
        BlankCategory blankTypeBlankCategory = blankType.getBlankCategory();
        if (blankTypeBlankCategory != null) {
            XHelper.writeEnum((Element)blankTypeElement, (String)BLANK_TYPE_BLANK_CATEGORY_ELEMENT_NAME, (Enum)blankTypeBlankCategory);
        } else {
            messages.add(MessageHelper.createWarningMessage("\u0423 \u0442\u0438\u043f\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0442\u0438\u043f \u0431\u043b\u0430\u043d\u043a\u0430", new Object[0]));
        }
        return blankTypeElement;
    }
}

