/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceDataDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructure;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescription;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class XtripPriceStructureHelper {
    private static <C extends BaseCommission> ServiceFees getServiceFees(List<C> commissions, List<C> prevCommissions, boolean hidden) {
        Collection<C> agencyFees = GeneralProductHelper.filterCommissions(commissions, GeneralProductHelper.serviceFeePropertyTypes, null, null);
        List parentServiceFees = prevCommissions == null ? Collections.emptyList() : GeneralProductHelper.filterCommissions(prevCommissions, GeneralProductHelper.serviceFeePropertyTypes, null, null);
        List techFees = agencyFees.stream().filter(fee -> GeneralProductHelper.isTechFee((EntityReference<? extends BaseCommissionProperties>)fee.getCommissionProperties())).collect(Collectors.toList());
        agencyFees.removeAll(techFees);
        List supplierFees = agencyFees.stream().filter(fee -> parentServiceFees.stream().anyMatch(pf -> MiscUtil.equals((Object)fee.getCommissionProperties(), (Object)pf.getCommissionProperties()))).collect(Collectors.toList());
        agencyFees.removeAll(supplierFees);
        if (hidden) {
            agencyFees.removeIf(f -> GeneralProductHelper.isHiddenFee((EntityReference<? extends BaseCommissionProperties>)f.getCommissionProperties()));
            techFees.removeIf(f -> GeneralProductHelper.isHiddenFee((EntityReference<? extends BaseCommissionProperties>)f.getCommissionProperties()));
            supplierFees.removeIf(f -> GeneralProductHelper.isHiddenFee((EntityReference<? extends BaseCommissionProperties>)f.getCommissionProperties()));
        }
        ServiceFees result = new ServiceFees();
        result.agencyFeesValue = GeneralProductHelper.calculateCommissionsEquivalentValue(agencyFees);
        result.techFeesValue = GeneralProductHelper.calculateCommissionsEquivalentValue(techFees);
        result.supplierFeesValue = GeneralProductHelper.calculateCommissionsEquivalentValue(supplierFees);
        return result;
    }

    public static <C extends BaseCommission> void updateFees(XtripPriceStructure result, List<C> commissions, List<C> prevCommissions, boolean hidden) {
        Collection<C> paymentFees = GeneralProductHelper.filterCommissions(commissions, GeneralProductHelper.paymentFeePropertyTypes, null, null);
        Collection<C> discountCommissions = GeneralProductHelper.filterCommissions(commissions, GeneralProductHelper.discountPropertyTypes, null, null);
        ServiceFees serviceFees = XtripPriceStructureHelper.getServiceFees(commissions, prevCommissions, hidden);
        result.setAgencyFees(serviceFees.agencyFeesValue);
        result.setTechFees(serviceFees.techFeesValue);
        result.setSupplierFees(serviceFees.supplierFeesValue);
        result.setPaymentFees(GeneralProductHelper.calculateCommissionsEquivalentValue(paymentFees));
        result.setDiscount(GeneralProductHelper.calculateCommissionsEquivalentValue(discountCommissions));
    }

    public static <P extends BaseProduct> XtripPriceStructure calculatePriceStructure(P product, boolean hidden) {
        SalesChain salesChain = GeneralProductHelper.getHandler(product).getSalesChain(product);
        EntityContainer ctr = EntityStorage.get().resolve(salesChain.getDescription());
        PredefinedSalesChainType salesChainType = ctr != null ? ((SalesChainDescription)ctr.getEntity()).getPredefinedType() : null;
        return XtripPriceStructureHelper.calculatePriceStructure(GeneralProductHelper.getHandler(product).getUnmodifiableContractRelations(product), hidden, salesChainType);
    }

    public static <P extends BaseProduct> XtripPriceStructure calculatePriceStructure(List<GeneralProductContractRelationData> contractRelations, boolean hidden, PredefinedSalesChainType salesChainType) {
        ContractType contractType;
        XtripPriceStructure result = new XtripPriceStructure();
        GeneralProductContractRelationData prevRelation = null;
        GeneralProductContractRelationData clientRelation = null;
        GeneralProductContractRelationData subagentRelation = null;
        if (PredefinedSalesChainType.SUBAGENT == salesChainType || PredefinedSalesChainType.SUBAGENT_TECHNICAL_PROVIDER == salesChainType) {
            for (GeneralProductContractRelationData relation : contractRelations) {
                contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription());
                if (contractType == ContractType.SUBAGENCY) {
                    subagentRelation = relation;
                    break;
                }
                if (contractType == ContractType.TECHNICAL_PROVIDER) continue;
                prevRelation = relation;
            }
            if (subagentRelation != null) {
                XtripPriceStructureHelper.updateIncomeFees(result, subagentRelation.getCommissions(), prevRelation == null ? null : prevRelation.getCommissions(), hidden);
            }
        }
        for (GeneralProductContractRelationData relation : contractRelations) {
            contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription());
            if (contractType == ContractType.CLIENT) {
                clientRelation = relation;
                break;
            }
            if (contractType == ContractType.TECHNICAL_PROVIDER) continue;
            prevRelation = relation;
        }
        if (clientRelation == null) {
            return result;
        }
        result.setProductPrice(MiscUtil.guarded((BigDecimal)clientRelation.getServiceData().getTotalPrice()));
        XtripPriceStructureHelper.updateFees(result, clientRelation.getCommissions(), prevRelation == null ? null : prevRelation.getCommissions(), hidden);
        if (GeneralProductHelper.isOwnPredefinedSalesChainType(salesChainType)) {
            XtripPriceStructureHelper.updateIncomeFees(result, clientRelation.getCommissions(), prevRelation == null ? null : prevRelation.getCommissions(), hidden);
        }
        ContractRelationServiceDataDetalization detalization = clientRelation.getServiceData().getDetalization();
        result.getPriceDetalization().setFare(MiscUtil.guarded((BigDecimal)MiscUtil.sub((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{detalization.getFare(), detalization.getAdditionalFee()}), (BigDecimal[])new BigDecimal[]{detalization.getDeduction()})));
        if (hidden) {
            result.getPriceDetalization().setFare(result.getPriceDetalization().getFare().add(clientRelation.getCommissions().stream().filter(f -> GeneralProductHelper.isHiddenFee((EntityReference<? extends BaseCommissionProperties>)f.getCommissionProperties())).map(BaseCommission::getEquivalentAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)));
        }
        BigDecimal taxes = detalization.getTaxes().stream().map(SimpleTax::getAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        result.getPriceDetalization().setTaxes(taxes);
        return result;
    }

    private static <C extends BaseCommission> void updateIncomeFees(XtripPriceStructure result, List<C> commissions, List<C> prevCommissions, boolean hidden) {
        ServiceFees serviceFees = XtripPriceStructureHelper.getServiceFees(commissions, prevCommissions, hidden);
        result.setAgencyFeesIncome(serviceFees.agencyFeesValue);
    }

    private static class ServiceFees {
        BigDecimal agencyFeesValue;
        BigDecimal techFeesValue;
        BigDecimal supplierFeesValue;

        private ServiceFees() {
        }
    }
}

