/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers.util;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class CachingShaper<K, V> {
    private final int capacity;
    private final long ttl;
    protected final Map<K, E> map;

    public CachingShaper(int capacity, long ttl) {
        this.capacity = capacity;
        this.ttl = ttl;
        this.map = new HashMap<K, E>(capacity);
    }

    public V get(K key, long timeout) {
        try {
            V result = null;
            E entry = this.map.get(key);
            if (entry == null) {
                if (!this.init(key)) {
                    result = this.waitFor(key, timeout);
                }
            } else {
                switch (entry.getState()) {
                    case ACTUAL: {
                        entry.incrementScore();
                        result = entry.value;
                        break;
                    }
                    case EXPIRED: {
                        if (this.init(key)) break;
                        result = this.waitFor(key, timeout);
                        break;
                    }
                    case IN_PROGRESS: {
                        result = this.waitFor(key, timeout);
                        break;
                    }
                }
            }
            return result;
        }
        catch (Exception e) {
            IncidentsLog.reportException((String)("failed to get cached value for key: " + key), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean init(K key) {
        boolean result = false;
        Map<K, E> map = this.map;
        synchronized (map) {
            E entry = this.map.get(key);
            if (entry == null) {
                this.freeSpace();
                this.map.put(key, new E());
                result = true;
            } else {
                switch (entry.getState()) {
                    case EXPIRED: {
                        entry.reset();
                        entry.incrementScore();
                        result = true;
                        break;
                    }
                    default: {
                        entry.incrementScore();
                    }
                }
            }
        }
        return result;
    }

    protected V waitFor(K key, long timeout) {
        long deadline = System.currentTimeMillis() + timeout;
        E entry = this.map.get(key);
        if (entry == null) {
            IncidentsLog.reportStackTrace((String)"entry to wait for is absent");
            return null;
        }
        entry.incrementScore();
        while (entry.getState() == S.IN_PROGRESS && System.currentTimeMillis() < deadline) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        V result = null;
        switch (entry.getState()) {
            case ACTUAL: {
                result = entry.value;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        try {
            Map<K, E> map = this.map;
            synchronized (map) {
                E entry = this.map.get(key);
                if (entry == null) {
                    this.freeSpace();
                    this.map.put(key, new E(value));
                } else {
                    entry.setValue(value);
                }
            }
        }
        catch (Exception e) {
            IncidentsLog.reportException((String)("failed to put value to cache for key: " + key), (Throwable)e);
        }
    }

    protected void freeSpace() {
        int n = this.map.size() - this.capacity + 1;
        if (n <= 0) {
            return;
        }
        ArrayList<Map.Entry<K, E>> rating = new ArrayList<Map.Entry<K, E>>(n);
        ArrayList<K> toRemove = new ArrayList<K>(n);
        for (Map.Entry<K, E> x : this.map.entrySet()) {
            E entry = x.getValue();
            switch (entry.getState()) {
                case EXPIRED: {
                    toRemove.add(x.getKey());
                    break;
                }
                case ACTUAL: {
                    rating.add(x);
                    break;
                }
            }
        }
        if (toRemove.size() > 0) {
            toRemove.forEach(key -> this.map.remove(key));
            n -= toRemove.size();
            toRemove.clear();
        }
        if (n <= 0) {
            return;
        }
        rating.sort(new Comparator<Map.Entry<K, E>>(){

            @Override
            public int compare(Map.Entry<K, E> o1, Map.Entry<K, E> o2) {
                int score1 = o1.getValue().getScore();
                int score2 = o2.getValue().getScore();
                return score1 - score2;
            }
        });
        for (Map.Entry<K, E> x : rating) {
            this.map.remove(x.getKey());
            if (--n != 0) continue;
            break;
        }
        if (n <= 0) {
            return;
        }
        for (Map.Entry<K, E> x : this.map.entrySet()) {
            this.map.remove(x.getKey());
            if (--n != 0) continue;
            break;
        }
    }

    protected E newEntry() {
        return new E();
    }

    protected static enum S {
        ACTUAL,
        IN_PROGRESS,
        EXPIRED;

    }

    protected class E {
        S state;
        V value;
        long expiration = 0L;
        AtomicInteger score = new AtomicInteger(1);

        E(V value) {
            this.setValue(value);
        }

        E() {
            this.state = S.IN_PROGRESS;
        }

        void setValue(V value) {
            this.value = value;
            this.expiration = CachingShaper.this.ttl > 0L ? System.currentTimeMillis() + CachingShaper.this.ttl : 0L;
            this.state = S.ACTUAL;
        }

        S getState() {
            if (this.state == S.ACTUAL && this.expiration > 0L && this.expiration <= System.currentTimeMillis()) {
                this.state = S.EXPIRED;
            }
            return this.state;
        }

        void reset() {
            this.value = null;
            this.expiration = 0L;
            this.state = S.IN_PROGRESS;
        }

        int getScore() {
            return this.score.get();
        }

        int incrementScore() {
            return this.score.incrementAndGet();
        }
    }
}

