/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers.util;

import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.util.TextUtil;

public class CardVendorUtils {
    private CardVendorUtils() {
        throw new RuntimeException("don't do this");
    }

    public static CardVendor determineCardIssuer(String cardNumber) {
        if (TextUtil.isBlank((String)cardNumber) || cardNumber.length() < 4) {
            return null;
        }
        String IIN = cardNumber.substring(0, 4);
        String MII = IIN.substring(0, 1);
        int digitsIIN = Integer.parseInt(IIN);
        switch (MII) {
            case "1": {
                if (!CardVendorUtils.isAirTravelCard(digitsIIN)) break;
                return CardVendor.AIR_TRAVEL_CARD;
            }
            case "2": {
                if (CardVendorUtils.isMastercard(digitsIIN)) {
                    return CardVendor.MASTERCARD;
                }
                if (CardVendorUtils.isDinersClub(digitsIIN)) {
                    return CardVendor.DINERS_CLUB;
                }
                if (!CardVendorUtils.isMir(digitsIIN)) break;
                return CardVendor.MIR;
            }
            case "3": {
                if (CardVendorUtils.isAmex(digitsIIN)) {
                    return CardVendor.AMEX;
                }
                if (CardVendorUtils.isJcb(digitsIIN)) {
                    return CardVendor.JCB;
                }
                if (!CardVendorUtils.isDinersClub(digitsIIN)) break;
                return CardVendor.DINERS_CLUB;
            }
            case "4": {
                if (!CardVendorUtils.isVisa(digitsIIN)) break;
                return CardVendor.VISA;
            }
            case "5": {
                if (!CardVendorUtils.isMastercard(digitsIIN)) break;
                return CardVendor.MASTERCARD;
            }
            case "6": {
                return CardVendor.MASTERCARD;
            }
        }
        return null;
    }

    public static boolean isAirTravelCard(int digitsIIN) {
        return true;
    }

    public static boolean isVisa(int digitsIIN) {
        int cuttedIIN = digitsIIN / 1000;
        return cuttedIIN == 4;
    }

    public static boolean isMastercard(int digitsIIN) {
        return digitsIIN >= 2221 && digitsIIN <= 2720 || digitsIIN / 100 >= 51 && digitsIIN / 100 <= 55 || digitsIIN / 100 == 50 || digitsIIN / 100 >= 56 && digitsIIN / 100 <= 58 || digitsIIN / 10 == 639 || digitsIIN / 100 == 67;
    }

    public static boolean isAmex(int digitsIIN) {
        int cuttedIIN = digitsIIN / 100;
        return cuttedIIN == 34 || cuttedIIN == 37;
    }

    public static boolean isJcb(int digitsIIN) {
        return digitsIIN >= 3528 && digitsIIN <= 3589;
    }

    public static boolean isDinersClub(int digitsIIN) {
        return digitsIIN >= 2014 && digitsIIN <= 2149 || digitsIIN / 100 == 36 || digitsIIN / 10 >= 300 && digitsIIN / 10 <= 305 || digitsIIN == 3095 || digitsIIN / 100 >= 38 && digitsIIN / 100 <= 39;
    }

    public static boolean isMir(int digitsIIN) {
        return digitsIIN >= 2200 && digitsIIN <= 2204;
    }
}

