/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers.util;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.json.JSONMarshaller;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpUtil {
    private static final String INVALID = "invalid-data";
    private static final Logger log = LoggerFactory.getLogger(DumpUtil.class);

    public static void main(String[] args) {
    }

    public static void dumpInvalidData(String prefix, Collection<Object> objects) {
        DumpUtil.dump(INVALID, prefix, objects);
    }

    public static void dumpInvalidData(String prefix, Object ... objects) {
        DumpUtil.dump(INVALID, prefix, objects);
    }

    public static void dump(String dirName, String prefix, Collection<Object> objects) {
        DumpUtil.dump(DumpUtil.outputFile(dirName, prefix), objects);
    }

    public static void dump(String dirName, String prefix, Object ... objects) {
        DumpUtil.dump(DumpUtil.outputFile(dirName, prefix), objects);
    }

    public static void dump(File outFile, Collection<Object> objects) {
        DumpUtil.dump(outFile, objects.toArray(new Object[objects.size()]));
    }

    public static void dump(File outFile, Object ... objects) {
        try {
            for (Object obj : objects) {
                Throwable throwable;
                Closeable out;
                if (obj instanceof XSSerializable) {
                    XSSerializable x = (XSSerializable)obj;
                    byte[] bytes = XSUtil.toByteArray((XSSerializable)x);
                    int len = bytes.length;
                    bytes = Arrays.copyOf(bytes, len + 2);
                    bytes[len] = 10;
                    bytes[len + 1] = 10;
                    Files.write(outFile.toPath(), bytes, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                    continue;
                }
                if (obj instanceof XSerializable) {
                    out = new BufferedOutputStream(new FileOutputStream(outFile, true));
                    throwable = null;
                    try {
                        XSerializable x = (XSerializable)obj;
                        XUtil.serialize((XSerializable)x, (OutputStream)out);
                        ((OutputStream)out).write(10);
                        ((OutputStream)out).flush();
                        continue;
                    }
                    catch (Throwable x) {
                        throwable = x;
                        throw x;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    ((OutputStream)out).close();
                                }
                                catch (Throwable x) {
                                    throwable.addSuppressed(x);
                                }
                            } else {
                                ((OutputStream)out).close();
                            }
                        }
                    }
                }
                if (obj instanceof Introspectable) {
                    out = new PrintWriter(new FileOutputStream(outFile, true));
                    throwable = null;
                    try {
                        JSONObject json = (JSONObject)JSONMarshaller.marshal((Object)obj);
                        json = json == null ? new JSONObject(obj) : json;
                        json.write((Writer)out);
                        ((Writer)out).flush();
                        continue;
                    }
                    catch (Throwable json) {
                        throwable = json;
                        throw json;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    ((Writer)out).close();
                                }
                                catch (Throwable json) {
                                    throwable.addSuppressed(json);
                                }
                            } else {
                                ((Writer)out).close();
                            }
                        }
                    }
                }
                if (obj instanceof Exception) {
                    out = new PrintWriter(new FileOutputStream(outFile, true));
                    throwable = null;
                    try {
                        Exception x = (Exception)obj;
                        x.printStackTrace((PrintWriter)out);
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).flush();
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    ((PrintWriter)out).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((PrintWriter)out).close();
                            }
                        }
                    }
                }
                if (obj instanceof String) {
                    out = new PrintWriter(new FileOutputStream(outFile, true));
                    throwable = null;
                    try {
                        ((Writer)out).write((String)obj);
                        ((Writer)out).write("\n\n");
                        ((Writer)out).flush();
                        continue;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    ((Writer)out).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                ((Writer)out).close();
                            }
                        }
                    }
                }
                if (obj == null) {
                    out = new PrintWriter(new FileOutputStream(outFile, true));
                    throwable = null;
                    try {
                        ((Writer)out).write("(null)\n\n");
                        ((Writer)out).flush();
                        continue;
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    ((Writer)out).close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                ((Writer)out).close();
                            }
                        }
                    }
                }
                out = new PrintWriter(new FileOutputStream(outFile, true));
                throwable = null;
                try {
                    ((Writer)out).write("(something unserializable)\n\n");
                    ((Writer)out).flush();
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                ((Writer)out).close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                        } else {
                            ((Writer)out).close();
                        }
                    }
                }
            }
        }
        catch (Exception t) {
            log.error("dump failed", (Throwable)t);
        }
    }

    public static String toString(Object obj) {
        String result;
        if (obj == null) {
            result = "null";
        } else if (obj instanceof String) {
            result = "\"" + obj.toString() + "\"";
        } else if (obj instanceof Boolean || obj instanceof Number) {
            result = obj.toString();
        } else if (obj instanceof Enum) {
            result = "\"" + ((Enum)obj).name() + "\"";
        } else {
            StringBuilder sb = new StringBuilder("{");
            boolean notFirst = false;
            for (Method m : obj.getClass().getMethods()) {
                String val;
                String methodName = m.getName();
                if (!methodName.startsWith("get") || methodName.equals("getClass")) continue;
                String attr = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                try {
                    Object value = m.invoke(obj, new Object[0]);
                    val = DumpUtil.toString(value);
                }
                catch (Exception e) {
                    val = "\"(unserializable)\"";
                }
                if (notFirst) {
                    sb.append(", ");
                } else {
                    notFirst = true;
                }
                sb.append("\"").append(attr).append("\": ").append(val);
            }
            sb.append("}");
            result = sb.toString();
        }
        return result;
    }

    private static File outputFile(String dirName, String prefix) {
        File dir = new File(Environment.getTempFolder(), dirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, String.format("%s-%s.log", prefix, MiscUtil.getTimestamp()));
        return file;
    }
}

