/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.meta;

import com.gridnine.xtrip.common.meta.PropertiesRenamer;
import com.gridnine.xtrip.common.model.booking.commission.CalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import org.w3c.dom.Element;

public class CommissionPropertiesRenamer
implements PropertiesRenamer {
    private static final String basisElmName = "calculationBasis";
    private static final String calculationTypeElmName = "calculationType";
    private static final String segmentCalculationElm = "segmentCalculation";
    private static final String rateElmName = "rate";
    private static final String operationElmName = "operation";

    public void renameProperties(Element elm) {
        this.correctOperation(elm);
        this.correctBasis(elm);
        this.correctType(elm);
    }

    private void correctType(Element elm) {
        Element calculationTypeElm = XmlUtil.getElement((Element)elm, (String)calculationTypeElmName);
        if (calculationTypeElm != null) {
            return;
        }
        CalculationType calculationType = CalculationType.TICKET;
        if (XHelper.readBoolean((Element)elm, (String)segmentCalculationElm, (boolean)false)) {
            calculationType = CalculationType.SEGMENT;
        }
        XHelper.writeEnum((Element)elm, (String)calculationTypeElmName, (Enum)calculationType);
    }

    private void correctBasis(Element elm) {
        Element basisElm = XmlUtil.getElement((Element)elm, (String)basisElmName);
        if (!XHelper.readBoolean((Element)elm, (String)rateElmName, (boolean)false)) {
            if (basisElm == null) {
                return;
            }
            XmlUtil.setValue((Element)basisElm, null);
            return;
        }
        if (basisElm == null) {
            XHelper.writeEnum((Element)elm, (String)basisElmName, (Enum)CalculationBasis.FARE);
            return;
        }
    }

    private void correctOperation(Element elm) {
        Element operationElm = XmlUtil.getElement((Element)elm, (String)operationElmName);
        if (operationElm == null) {
            XHelper.writeEnum((Element)elm, (String)operationElmName, (Enum)Operation.SELL);
            return;
        }
        String val = XmlUtil.getValue((Element)operationElm);
        if (!TextUtil.isBlank((String)val)) {
            return;
        }
        XmlUtil.setValue((Element)operationElm, (String)Operation.SELL.name());
    }
}

