/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.profile;

import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.PassportCorrelationQualifier;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class PersonPassportWrapper {
    private String uidLatin;
    private String uidCyrillic;
    private String lastNameLatin;
    private String firstNameLatin;
    private String secondNameLatin;
    private String middleNameLatin;
    private boolean withoutMiddleNameLatin;
    private String lastNameCyrillic;
    private String firstNameCyrillic;
    private String secondNameCyrillic;
    private String middleNameCyrillic;
    private boolean withoutMiddleNameCyrillic;
    private Gender gender;
    private Date birthday;
    private String birthPlace;
    private PassportType type;
    private String number;
    private Date expired;
    private DictionaryReference<Country> citizenship;
    private DictionaryReference<Country> originCountry;
    private Date issued;
    private String issueOrganization;
    private String issueCity;
    private String remarks;
    private String correlationId;

    public static List<PersonPassportWrapper> wrap(List<Passport> passports) {
        Map<String, List<Passport>> groupedPassports = passports.stream().filter(p -> p.getCorrelationId() != null).collect(Collectors.groupingBy(Passport::getCorrelationId));
        ArrayList<PersonPassportWrapper> result = new ArrayList<PersonPassportWrapper>();
        for (Passport passport : passports) {
            if (passport.getCorrelationId() == null) {
                result.add(new PersonPassportWrapper(passport));
                continue;
            }
            List<Passport> group = groupedPassports.remove(passport.getCorrelationId());
            if (group == null) continue;
            result.add(new PersonPassportWrapper(group));
        }
        return result;
    }

    public PersonPassportWrapper() {
    }

    public PersonPassportWrapper(Passport passport) {
        boolean hasLatin = false;
        boolean hasCyrillic = false;
        if (passport.getCorrelationQualifier() != null) {
            switch (passport.getCorrelationQualifier()) {
                case LATIN: {
                    this.lastNameLatin = passport.getLastName();
                    this.firstNameLatin = passport.getFirstName();
                    this.secondNameLatin = passport.getSecondName();
                    this.middleNameLatin = passport.getMiddleName();
                    this.withoutMiddleNameLatin = passport.isWithoutMiddleName();
                    hasLatin = true;
                    break;
                }
                case CYRILLIC: {
                    this.lastNameCyrillic = passport.getLastName();
                    this.firstNameCyrillic = passport.getFirstName();
                    this.secondNameCyrillic = passport.getSecondName();
                    this.middleNameCyrillic = passport.getMiddleName();
                    this.withoutMiddleNameCyrillic = passport.isWithoutMiddleName();
                    hasCyrillic = true;
                }
            }
        } else {
            String middleName;
            String secondName;
            String firstName;
            String lastName = passport.getLastName();
            if (PersonPassportWrapper.hasLatin(lastName)) {
                this.lastNameLatin = lastName;
                hasLatin = true;
            }
            if (PersonPassportWrapper.hasCyrillic(lastName)) {
                this.lastNameCyrillic = lastName;
                hasCyrillic = true;
            }
            if (PersonPassportWrapper.hasLatin(firstName = passport.getFirstName())) {
                this.firstNameLatin = firstName;
                hasLatin = true;
            }
            if (PersonPassportWrapper.hasCyrillic(firstName)) {
                this.firstNameCyrillic = firstName;
                hasCyrillic = true;
            }
            if (PersonPassportWrapper.hasLatin(secondName = passport.getSecondName())) {
                this.secondNameLatin = secondName;
                hasLatin = true;
            }
            if (PersonPassportWrapper.hasCyrillic(secondName)) {
                this.secondNameCyrillic = secondName;
                hasCyrillic = true;
            }
            if (PersonPassportWrapper.hasLatin(middleName = passport.getMiddleName())) {
                this.middleNameLatin = middleName;
                hasLatin = true;
            }
            if (PersonPassportWrapper.hasCyrillic(middleName)) {
                this.middleNameCyrillic = middleName;
                hasCyrillic = true;
            }
            this.withoutMiddleNameCyrillic = passport.isWithoutMiddleName();
            this.withoutMiddleNameLatin = passport.isWithoutMiddleName();
        }
        if (hasLatin && hasCyrillic) {
            this.uidLatin = UUIDUtil.toString((UUID)UUID.randomUUID());
            this.uidCyrillic = UUIDUtil.toString((UUID)UUID.randomUUID());
            this.correlationId = UUIDUtil.toString((UUID)UUID.randomUUID());
        } else if (hasCyrillic) {
            this.uidCyrillic = passport.getUid();
        } else {
            this.uidLatin = passport.getUid();
        }
        this.gender = passport.getGender();
        this.birthday = passport.getBirthday();
        this.birthPlace = passport.getBirthPlace();
        this.type = passport.getType();
        this.number = passport.getNumber();
        this.expired = passport.getExpired();
        this.citizenship = passport.getCitizenship();
        this.originCountry = passport.getOriginCountry();
        this.issued = passport.getIssued();
        this.issueOrganization = passport.getIssueOrganization();
        this.issueCity = passport.getIssueCity();
        this.remarks = passport.getRemarks();
    }

    public PersonPassportWrapper(Collection<Passport> passportsGroup) {
        Passport latinPassport = (Passport)Streams.singleOrNull(passportsGroup.stream().filter(p -> p.getCorrelationQualifier() == PassportCorrelationQualifier.LATIN));
        Passport cyrillicPassport = (Passport)Streams.singleOrNull(passportsGroup.stream().filter(p -> p.getCorrelationQualifier() == PassportCorrelationQualifier.CYRILLIC));
        this.uidLatin = latinPassport != null ? latinPassport.getUid() : null;
        this.uidCyrillic = cyrillicPassport != null ? cyrillicPassport.getUid() : null;
        this.lastNameLatin = latinPassport != null ? latinPassport.getLastName() : null;
        this.lastNameCyrillic = cyrillicPassport != null ? cyrillicPassport.getLastName() : null;
        this.firstNameLatin = latinPassport != null ? latinPassport.getFirstName() : null;
        this.firstNameCyrillic = cyrillicPassport != null ? cyrillicPassport.getFirstName() : null;
        this.secondNameLatin = latinPassport != null ? latinPassport.getSecondName() : null;
        this.secondNameCyrillic = cyrillicPassport != null ? cyrillicPassport.getSecondName() : null;
        this.middleNameLatin = latinPassport != null ? latinPassport.getMiddleName() : null;
        this.withoutMiddleNameLatin = latinPassport != null && latinPassport.isWithoutMiddleName();
        this.middleNameCyrillic = cyrillicPassport != null ? cyrillicPassport.getMiddleName() : null;
        this.withoutMiddleNameCyrillic = cyrillicPassport != null && cyrillicPassport.isWithoutMiddleName();
        Passport passport = latinPassport != null ? latinPassport : cyrillicPassport;
        this.gender = passport.getGender();
        this.birthday = passport.getBirthday();
        this.birthPlace = passport.getBirthPlace();
        this.type = passport.getType();
        this.number = passport.getNumber();
        this.expired = passport.getExpired();
        this.citizenship = passport.getCitizenship();
        this.originCountry = passport.getOriginCountry();
        this.issued = passport.getIssued();
        this.issueOrganization = passport.getIssueOrganization();
        this.issueCity = passport.getIssueCity();
        this.remarks = passport.getRemarks();
        this.correlationId = passport.getCorrelationId();
    }

    public String getUidLatin() {
        return this.uidLatin;
    }

    public void setUidLatin(String uidLatin) {
        this.uidLatin = uidLatin;
    }

    public String getUidCyrillic() {
        return this.uidCyrillic;
    }

    public void setUidCyrillic(String uidCyrillic) {
        this.uidCyrillic = uidCyrillic;
    }

    public String getLastNameLatin() {
        return this.lastNameLatin;
    }

    public void setLastNameLatin(String lastNameLatin) {
        this.lastNameLatin = lastNameLatin;
    }

    public String getFirstNameLatin() {
        return this.firstNameLatin;
    }

    public void setFirstNameLatin(String firstNameLatin) {
        this.firstNameLatin = firstNameLatin;
    }

    public String getSecondNameLatin() {
        return this.secondNameLatin;
    }

    public void setSecondNameLatin(String secondNameLatin) {
        this.secondNameLatin = secondNameLatin;
    }

    public String getMiddleNameLatin() {
        return this.middleNameLatin;
    }

    public void setMiddleNameLatin(String middleNameLatin) {
        this.middleNameLatin = middleNameLatin;
    }

    public boolean isWithoutMiddleNameLatin() {
        return this.withoutMiddleNameLatin;
    }

    public void setWithoutMiddleNameLatin(boolean withoutMiddleNameLatin) {
        this.withoutMiddleNameLatin = withoutMiddleNameLatin;
    }

    public String getLastNameCyrillic() {
        return this.lastNameCyrillic;
    }

    public void setLastNameCyrillic(String lastNameCyrillic) {
        this.lastNameCyrillic = lastNameCyrillic;
    }

    public String getFirstNameCyrillic() {
        return this.firstNameCyrillic;
    }

    public void setFirstNameCyrillic(String firstNameCyrillic) {
        this.firstNameCyrillic = firstNameCyrillic;
    }

    public String getSecondNameCyrillic() {
        return this.secondNameCyrillic;
    }

    public void setSecondNameCyrillic(String secondNameCyrillic) {
        this.secondNameCyrillic = secondNameCyrillic;
    }

    public String getMiddleNameCyrillic() {
        return this.middleNameCyrillic;
    }

    public void setMiddleNameCyrillic(String middleNameCyrillic) {
        this.middleNameCyrillic = middleNameCyrillic;
    }

    public boolean isWithoutMiddleNameCyrillic() {
        return this.withoutMiddleNameCyrillic;
    }

    public void setWithoutMiddleNameCyrillic(boolean withoutMiddleNameCyrillic) {
        this.withoutMiddleNameCyrillic = withoutMiddleNameCyrillic;
    }

    private static String getFallback(String latin, String cyrillic) {
        if (latin == null) {
            return cyrillic;
        }
        if (cyrillic == null) {
            return latin;
        }
        if (latin.equals(cyrillic)) {
            return latin;
        }
        return null;
    }

    public String getLastNameFallback() {
        return PersonPassportWrapper.getFallback(this.lastNameLatin, this.lastNameCyrillic);
    }

    public String getFirstNameFallback() {
        return PersonPassportWrapper.getFallback(this.firstNameLatin, this.firstNameCyrillic);
    }

    public String getSecondNameFallback() {
        return PersonPassportWrapper.getFallback(this.secondNameLatin, this.secondNameCyrillic);
    }

    public String getMiddleNameFallback() {
        return PersonPassportWrapper.getFallback(this.middleNameLatin, this.middleNameCyrillic);
    }

    public boolean getWithoutMiddleNameFallback() {
        return this.middleNameLatin == null && this.middleNameCyrillic == null && (this.withoutMiddleNameLatin || this.withoutMiddleNameCyrillic);
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public String getBirthPlace() {
        return this.birthPlace;
    }

    public void setBirthPlace(String birthPlace) {
        this.birthPlace = birthPlace;
    }

    public PassportType getType() {
        return this.type;
    }

    public void setType(PassportType type) {
        this.type = type;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Date getExpired() {
        return this.expired;
    }

    public void setExpired(Date expired) {
        this.expired = expired;
    }

    public DictionaryReference<Country> getCitizenship() {
        return this.citizenship;
    }

    public void setCitizenship(DictionaryReference<Country> citizenship) {
        this.citizenship = citizenship;
    }

    public DictionaryReference<Country> getOriginCountry() {
        return this.originCountry;
    }

    public void setOriginCountry(DictionaryReference<Country> originCountry) {
        this.originCountry = originCountry;
    }

    public Date getIssued() {
        return this.issued;
    }

    public void setIssued(Date issued) {
        this.issued = issued;
    }

    public String getIssueOrganization() {
        return this.issueOrganization;
    }

    public void setIssueOrganization(String issueOrganization) {
        this.issueOrganization = issueOrganization;
    }

    public String getIssueCity() {
        return this.issueCity;
    }

    public void setIssueCity(String issueCity) {
        this.issueCity = issueCity;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void unwrap(Collection<Passport> destination) {
        if (this.uidLatin == null && (StringUtils.isNotBlank((String)this.lastNameLatin) || StringUtils.isNotBlank((String)this.firstNameLatin) || StringUtils.isNotBlank((String)this.secondNameLatin) || StringUtils.isNotBlank((String)this.middleNameLatin) || this.withoutMiddleNameLatin)) {
            this.uidLatin = UUIDUtil.toString((UUID)UUID.randomUUID());
        }
        if (this.uidCyrillic == null && (StringUtils.isNotBlank((String)this.lastNameCyrillic) || StringUtils.isNotBlank((String)this.firstNameCyrillic) || StringUtils.isNotBlank((String)this.secondNameCyrillic) || StringUtils.isNotBlank((String)this.middleNameCyrillic) || this.withoutMiddleNameCyrillic)) {
            this.uidCyrillic = UUIDUtil.toString((UUID)UUID.randomUUID());
        }
        if (this.uidLatin != null && this.uidCyrillic != null && this.correlationId == null) {
            this.correlationId = UUIDUtil.toString((UUID)UUID.randomUUID());
        }
        if (this.uidLatin != null) {
            destination.add(this.buildPassport(true));
        }
        if (this.uidCyrillic != null) {
            destination.add(this.buildPassport(false));
        }
    }

    protected Passport buildPassport(boolean latin) {
        Passport passport = new Passport(latin ? this.uidLatin : this.uidCyrillic);
        passport.setLastName(latin ? this.lastNameLatin : this.lastNameCyrillic);
        passport.setFirstName(latin ? this.firstNameLatin : this.firstNameCyrillic);
        passport.setSecondName(latin ? this.secondNameLatin : this.secondNameCyrillic);
        passport.setMiddleName(latin ? this.middleNameLatin : this.middleNameCyrillic);
        passport.setWithoutMiddleName(latin ? this.withoutMiddleNameLatin : this.withoutMiddleNameCyrillic);
        passport.setGender(this.gender);
        passport.setBirthday(this.birthday);
        passport.setBirthPlace(this.birthPlace);
        passport.setType(this.type);
        passport.setNumber(this.number);
        passport.setExpired(this.expired);
        passport.setCitizenship(this.citizenship);
        passport.setOriginCountry(this.originCountry);
        passport.setIssued(this.issued);
        passport.setIssueOrganization(this.issueOrganization);
        passport.setIssueCity(this.issueCity);
        passport.setRemarks(this.remarks);
        passport.setCorrelationId(this.correlationId);
        passport.setCorrelationQualifier(latin ? PassportCorrelationQualifier.LATIN : PassportCorrelationQualifier.CYRILLIC);
        return passport;
    }

    private static boolean hasLatin(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if ((c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCyrillic(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!(c >= '\u0410' && c <= '\u042f' || c >= '\u0430' && c <= '\u044f' || c == '\u0401') && c != '\u0451') continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonPassportWrapper that = (PersonPassportWrapper)o;
        return this.withoutMiddleNameLatin == that.withoutMiddleNameLatin && this.withoutMiddleNameCyrillic == that.withoutMiddleNameCyrillic && Objects.equals(this.uidLatin, that.uidLatin) && Objects.equals(this.uidCyrillic, that.uidCyrillic) && Objects.equals(this.lastNameLatin, that.lastNameLatin) && Objects.equals(this.firstNameLatin, that.firstNameLatin) && Objects.equals(this.secondNameLatin, that.secondNameLatin) && Objects.equals(this.middleNameLatin, that.middleNameLatin) && Objects.equals(this.lastNameCyrillic, that.lastNameCyrillic) && Objects.equals(this.firstNameCyrillic, that.firstNameCyrillic) && Objects.equals(this.secondNameCyrillic, that.secondNameCyrillic) && Objects.equals(this.middleNameCyrillic, that.middleNameCyrillic) && this.gender == that.gender && Objects.equals(this.birthday, that.birthday) && Objects.equals(this.birthPlace, that.birthPlace) && this.type == that.type && Objects.equals(this.number, that.number) && Objects.equals(this.expired, that.expired) && Objects.equals(this.citizenship, that.citizenship) && Objects.equals(this.originCountry, that.originCountry) && Objects.equals(this.issued, that.issued) && Objects.equals(this.issueOrganization, that.issueOrganization) && Objects.equals(this.issueCity, that.issueCity) && Objects.equals(this.remarks, that.remarks) && Objects.equals(this.correlationId, that.correlationId);
    }

    public int hashCode() {
        return Objects.hash(this.uidLatin, this.uidCyrillic, this.lastNameLatin, this.firstNameLatin, this.secondNameLatin, this.middleNameLatin, this.withoutMiddleNameLatin, this.lastNameCyrillic, this.firstNameCyrillic, this.secondNameCyrillic, this.middleNameCyrillic, this.withoutMiddleNameCyrillic, this.gender, this.birthday, this.birthPlace, this.type, this.number, this.expired, this.citizenship, this.originCountry, this.issued, this.issueOrganization, this.issueCity, this.remarks, this.correlationId);
    }
}

