/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.redapp.sws;

import java.util.Arrays;

public enum RemarkType {
    AlphaCoded("Alpha-Coded", "CODED"),
    ClientAddress("Client Address", "CLIADR"),
    Corporate("Corporate", "CORPORATE"),
    DeliveryAddress("Delivery Address", "DELADR"),
    General("General", "REG"),
    GroupName("Group Name", null),
    Hidden("Hidden", "HD"),
    Historical("Historical", "HS"),
    Invoice("Invoice", "INVOICE"),
    InvoiceSegAssoc(null, "ITINSEGASSOC"),
    Itinerary("Itinerary", "ITINERARY"),
    ItinerarySegAssoc(null, "ITINSEGASSOC"),
    QueuePlace(null, "QQ"),
    Interface(null, "INTERFACE"),
    Filler(null, "FILLER"),
    PrintOnTicket(null, "PRTONTKT"),
    Fop(null, "FOP");

    private final String code;
    private final String pnrbCode;

    private RemarkType(String code, String pnrbCode) {
        this.code = code;
        this.pnrbCode = pnrbCode;
    }

    public String toString() {
        return this.code;
    }

    public String getPnrbCode() {
        return this.pnrbCode;
    }

    public static RemarkType ofCode(String code) {
        return Arrays.stream(RemarkType.values()).filter(rt -> rt.code != null && rt.code.equals(code)).findFirst().orElse(null);
    }
}

