/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.redapp.vat.command;

import com.gridnine.xtrip.common.model.redapp.sws.AppliedDiscount;
import com.gridnine.xtrip.common.model.redapp.vat.command.TourCodeQualifier;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PqCommand {
    private String passengerNumber;
    private String passengerType;
    private List<String> endorsements;
    private final List<String> otherParameters;
    private boolean endorsementOverrided;
    private boolean pqShouldBeSaved;
    private TourCodeQualifier tourCode;
    private String accountCode;
    private AppliedDiscount appliedDiscount;
    private Set<String> accountCodesFromCommand;
    private static final String DELIMITER = String.valueOf('\u00a5');
    private static final String N = "N";
    private static final String P = "P";
    private static final String ED = "ED";
    private static final String EO = "EO";
    private static final String RQ = "RQ";
    private static final String WP = "WP";
    private static final String TOURCODE_QUALIFIER = "U";
    private static final String ACCOUNTCODE_QUALIFIER = "AC*";
    private static final String CORPORATEID_QUALIFIER = "I";

    private PqCommand(String passengerNumber, String passengerType, List<String> endorsement, List<String> otherParameters, boolean endorsementOverrided, boolean pqRetained, TourCodeQualifier tourCode, Set<String> accountCodesFromCommand) {
        this.pqShouldBeSaved = pqRetained;
        this.passengerNumber = passengerNumber;
        this.passengerType = passengerType;
        this.endorsements = endorsement;
        this.endorsementOverrided = endorsementOverrided;
        this.otherParameters = Collections.unmodifiableList(otherParameters);
        this.tourCode = tourCode;
        this.accountCodesFromCommand = accountCodesFromCommand;
    }

    public String getPassengerType() {
        return this.passengerType;
    }

    public PqCommand setPassengerType(String passengerTypes) {
        this.passengerType = passengerTypes;
        return this;
    }

    public static PqCommand of(String sabreCommand) {
        boolean pqShouldBeSaved;
        String passType;
        String passNumber;
        if (!sabreCommand.startsWith(WP)) {
            throw new IllegalArgumentException(String.format("This is not a PQ command: %s", sabreCommand));
        }
        Stream<String> sabreCommandStream = sabreCommand.startsWith("WPNCB") ? Stream.of(sabreCommand.substring(5).split(DELIMITER)) : Stream.of(sabreCommand.substring(2).split(DELIMITER));
        List<String> tokens = sabreCommandStream.filter(TextUtil::nonBlank).collect(Collectors.toList());
        ArrayList<String> endorsements = new ArrayList<String>();
        boolean endorsementOverrided = false;
        List edTokens = tokens.stream().filter(s -> s.startsWith(ED)).collect(Collectors.toList());
        if (!edTokens.isEmpty() && edTokens.stream().anyMatch(s -> s.length() > 2)) {
            for (String endorsement : edTokens) {
                if (endorsement == null) continue;
                tokens.remove(endorsement);
                if (endorsement.length() <= 2) continue;
                endorsements.add(endorsement.substring(2));
            }
        } else {
            edTokens.stream().forEach(s -> tokens.remove(s));
            List endTokens = tokens.stream().filter(s -> s.startsWith(EO)).collect(Collectors.toList());
            if (!endTokens.isEmpty()) {
                tokens.removeAll(endTokens);
                endTokens.stream().map(s -> s.replaceFirst("EO[0-9]{0,2}\\/", "")).filter(TextUtil::nonBlank).collect(Collectors.toCollection(() -> endorsements));
                endorsementOverrided = true;
            }
        }
        if ((passNumber = (String)tokens.stream().filter(s -> s.startsWith(N)).findFirst().orElse(null)) != null) {
            tokens.remove(passNumber);
            passNumber = passNumber.substring(1);
        }
        if ((passType = (String)tokens.stream().filter(s -> s.startsWith(P)).findFirst().orElse(null)) != null) {
            tokens.remove(passType);
            passType = passType.substring(1);
        }
        if (pqShouldBeSaved = tokens.stream().anyMatch(RQ::equals)) {
            tokens.remove(RQ);
        }
        String tourCodeToken = tokens.stream().filter(s -> s.startsWith(TOURCODE_QUALIFIER)).findFirst().orElse(null);
        TourCodeQualifier tourCode = null;
        if (TextUtil.nonBlank((String)tourCodeToken)) {
            tourCode = new TourCodeQualifier();
            Pattern pattern = Pattern.compile("U(([BINX]\\*)|(IT))?(?<tourCode>[A-Z0-9]+)");
            Matcher matcher = pattern.matcher(tourCodeToken);
            if (matcher.matches()) {
                tourCode.setValue(matcher.group("tourCode"));
                TourCodeQualifier.TourCodeQualifierPrefix prefix = TourCodeQualifier.TourCodeQualifierPrefix.of(tourCodeToken.replace(matcher.group("tourCode"), ""));
                if (prefix != null) {
                    tourCode.setPrefix(prefix);
                    tokens.remove(tourCodeToken);
                }
            }
        }
        Iterator tokensIterator = tokens.iterator();
        HashSet<String> accountCodesFromCommand = new HashSet<String>();
        while (tokensIterator.hasNext()) {
            String token = (String)tokensIterator.next();
            if (token.startsWith(ACCOUNTCODE_QUALIFIER)) {
                accountCodesFromCommand.add(token.substring(ACCOUNTCODE_QUALIFIER.length()));
                tokensIterator.remove();
                continue;
            }
            if (!token.startsWith(CORPORATEID_QUALIFIER)) continue;
            tokensIterator.remove();
        }
        return new PqCommand(passNumber, passType, endorsements, tokens, endorsementOverrided, pqShouldBeSaved, tourCode, accountCodesFromCommand);
    }

    public String toSabreCommand() {
        StringBuilder builder = new StringBuilder(WP);
        if (TextUtil.nonBlank((String)this.passengerType)) {
            builder.append(DELIMITER).append(P).append(this.passengerType);
        }
        if (TextUtil.nonBlank((String)this.passengerNumber)) {
            builder.append(DELIMITER).append(N).append(this.passengerNumber);
        }
        if (!this.endorsements.isEmpty()) {
            if (this.endorsementOverrided) {
                for (int i = 0; i < this.endorsements.size(); ++i) {
                    builder.append(DELIMITER).append(EO).append(i + 1).append("/").append(this.endorsements.get(i));
                }
            } else {
                builder.append(DELIMITER).append(ED).append(this.endorsements.stream().collect(Collectors.joining("/")));
            }
        }
        if (!this.otherParameters.isEmpty()) {
            builder.append(DELIMITER).append(this.otherParameters.stream().collect(Collectors.joining(DELIMITER)));
        }
        if (this.appliedDiscount != null) {
            if (this.appliedDiscount.getQualifier() == AppliedDiscount.DiscountQualifier.I && this.accountCodesFromCommand.contains(this.appliedDiscount.getCode())) {
                this.appliedDiscount.setQualifier(AppliedDiscount.DiscountQualifier.AC);
            }
            builder.append(DELIMITER).append(this.appliedDiscount.getQualifier().getSabreCommandQualifier()).append(this.appliedDiscount.getCode());
        }
        if (this.tourCode != null) {
            builder.append(DELIMITER).append(this.tourCode.getPrefix().getValue()).append(this.tourCode.getValue());
        }
        if (this.pqShouldBeSaved) {
            builder.append(DELIMITER).append(RQ);
        }
        return builder.toString().replaceFirst(DELIMITER, "");
    }

    public String getPassengerNumber() {
        return this.passengerNumber;
    }

    public PqCommand setPassengerNumber(String passengerNumber) {
        this.passengerNumber = passengerNumber;
        return this;
    }

    public boolean isPqShouldBeSaved() {
        return this.pqShouldBeSaved;
    }

    public void setPqShouldBeSaved(boolean pqShouldBeSaved) {
        this.pqShouldBeSaved = pqShouldBeSaved;
    }

    public List<String> getEndorsements() {
        return this.endorsements;
    }

    public TourCodeQualifier getTourCode() {
        return this.tourCode;
    }

    public void setTourCode(TourCodeQualifier tourCode) {
        this.tourCode = tourCode;
    }

    public String getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public AppliedDiscount getAppliedDiscount() {
        return this.appliedDiscount;
    }

    public void setAppliedDiscount(AppliedDiscount appliedDiscount) {
        this.appliedDiscount = appliedDiscount;
    }
}

