/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.redapp.vat.handlers;

import com.gridnine.xtrip.common.model.redapp.sws.remark.RemarkParserRegistry;
import com.gridnine.xtrip.common.model.redapp.vat.parsers.remark.TchVatHistoricalRemarkParser;
import com.gridnine.xtrip.common.model.redapp.vat.parsers.remark.TchVatInvoiceRemarkParser;
import com.gridnine.xtrip.common.model.redapp.vat.parsers.remark.TchVatRateRemarkParser;
import com.gridnine.xtrip.common.model.redapp.vat.parsers.remark.VatHistoricalRemarkParser;
import com.gridnine.xtrip.common.model.redapp.vat.parsers.remark.VatInvoiceRemarkParser;
import com.gridnine.xtrip.common.model.redapp.vat.parsers.remark.VatRateRemarkParser;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VatAppEnvironment {
    private static volatile VatAppEnvironment instance;
    private static final transient Logger LOG;
    private static Lock lock;
    private final RemarkParserRegistry remarkParserRegistry = new RemarkParserRegistry();
    private String recordLocator;

    private VatAppEnvironment() {
        this.remarkParserRegistry.registerConsoleRemarkController(new TchVatHistoricalRemarkParser());
        this.remarkParserRegistry.registerConsoleRemarkController(new TchVatInvoiceRemarkParser());
        this.remarkParserRegistry.registerConsoleRemarkController(new TchVatRateRemarkParser());
        this.remarkParserRegistry.registerConsoleRemarkController(new VatHistoricalRemarkParser());
        this.remarkParserRegistry.registerConsoleRemarkController(new VatInvoiceRemarkParser());
        this.remarkParserRegistry.registerConsoleRemarkController(new VatRateRemarkParser());
    }

    public static VatAppEnvironment get() {
        if (instance == null) {
            lock.lock();
            try {
                if (instance == null) {
                    instance = new VatAppEnvironment();
                }
            }
            catch (Exception e) {
                LOG.error("Exception while initialize VatAppEnvironment instance", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        return instance;
    }

    public String getRecordLocator() {
        return this.recordLocator;
    }

    public void setRecordLocator(String recordLocator) {
        this.recordLocator = recordLocator;
    }

    public RemarkParserRegistry getRemarkParserRegistry() {
        return this.remarkParserRegistry;
    }

    static {
        LOG = LoggerFactory.getLogger(VatAppEnvironment.class);
        lock = new ReentrantLock();
    }
}

