/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.redapp.vat.parsers.remark;

import com.gridnine.xtrip.common.model.redapp.sws.Remark;
import com.gridnine.xtrip.common.model.redapp.sws.RemarkType;
import com.gridnine.xtrip.common.model.redapp.sws.remark.RemarkController;
import com.gridnine.xtrip.common.model.redapp.vat.parsers.remark.TchVatRateRemark;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TchVatRateRemarkParser
implements RemarkController<TchVatRateRemark> {
    private static final Pattern PATTERN = Pattern.compile("X\\*-NDSA\\/C(?<ticketVat>[0-9.-]*)\\/(?<ticketVatRate>[0-9.-]*)P\\/ NDSZZ (?<zzVat>[0-9.-]*)\\/(?<zzVatRate>[0-9.-]*)P\\/-(?<travelerNumber>[0-9]{1,2}\\.[0-9]{1,2})?");

    @Override
    public boolean match(Remark remark) {
        return remark.getType() == RemarkType.Invoice && PATTERN.matcher(remark.getText()).matches();
    }

    @Override
    public TchVatRateRemark parse(Remark remark) {
        Matcher matcher = PATTERN.matcher(remark.getText());
        if (matcher.matches()) {
            return new TchVatRateRemark(remark.getRph(), matcher.group("ticketVat"), matcher.group("ticketVatRate"), matcher.group("zzVat"), matcher.group("zzVatRate"), matcher.group("travelerNumber"));
        }
        throw new IllegalStateException(String.format("Cannot parse remark [ %s ]", remark.getText()));
    }

    @Override
    public Remark compose(TchVatRateRemark consoleRemark) {
        StringBuilder sb = new StringBuilder("X*-NDSA/C");
        if (consoleRemark.getTicketVatAmount() != null) {
            sb.append(consoleRemark.getTicketVatAmount());
        }
        sb.append("/");
        if (consoleRemark.getTicketVatRate() != null) {
            sb.append(consoleRemark.getTicketVatRate()).append("P");
        }
        sb.append("/ NDSZZ ");
        if (consoleRemark.getZzTaxVatAmount() != null) {
            sb.append(consoleRemark.getZzTaxVatAmount());
        }
        sb.append("/");
        if (consoleRemark.getZzTaxVatRate() != null) {
            sb.append(consoleRemark.getZzTaxVatRate()).append("P");
        }
        sb.append("/-");
        if (consoleRemark.getTravelerNameNumber() != null) {
            sb.append(consoleRemark.getTravelerNameNumber());
        }
        Remark result = new Remark();
        result.setType(RemarkType.Invoice);
        result.setText(sb.toString());
        return result;
    }

    @Override
    public Class<TchVatRateRemark> getRemarkClass() {
        return TchVatRateRemark.class;
    }
}

