/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.restriction.resource;

import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.restriction.resource.RestrictionMatchable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionQueryable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyCategory;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRestrictionEntityResourcePropertyProperty
implements RestrictionResourceProperty,
RestrictionMatchable,
RestrictionQueryable {
    private static final Logger log = LoggerFactory.getLogger(ModelRestrictionEntityResourcePropertyProperty.class);
    private final EntityType entity;
    protected final Property property;

    public ModelRestrictionEntityResourcePropertyProperty(EntityType entity, Property property) {
        this.entity = entity;
        this.property = property;
    }

    public String getId() {
        return String.format("%s.%s", this.entity.getId(), this.property.getId());
    }

    public String getName() {
        return this.property.getDisplayName();
    }

    public String getDescriprion() {
        return this.property.getDescription();
    }

    public Class<?> getType() {
        Class type = this.resolveStandardType();
        if (type == null) {
            try {
                type = this.property.getType().contains("||") ? XSHelper.getClass((String)this.property.getType().split("[|]{2}")[1]) : XSHelper.getClass((String)this.property.getType());
            }
            catch (ClassNotFoundException e) {
                log.error(String.format("failed loading property %s class of entity %s", this.property.getId(), this.entity.getId()), (Throwable)e);
                throw new Error(String.format("failed loading property %s class of entity %s", this.property.getId(), this.entity.getId()), e);
            }
        }
        return type;
    }

    public boolean isCollection() {
        return false;
    }

    public boolean isTimeIncluded() {
        return this.property.getFormat() != null && this.property.getFormat().equals("dd.MM.yyyy HH:mm");
    }

    public String getResourceId() {
        return this.entity.getId();
    }

    public String getCategoryId() {
        Class<?> type = this.getType();
        if (Boolean.class.isAssignableFrom(type)) {
            return StandardRestrictionResourcePropertyCategory.BOOLEAN.name();
        }
        if (String.class.isAssignableFrom(type)) {
            return StandardRestrictionResourcePropertyCategory.STRING.name();
        }
        if (Locale.class.isAssignableFrom(type)) {
            return StandardRestrictionResourcePropertyCategory.LOCALE.name();
        }
        if (BigDecimal.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Byte.class.isAssignableFrom(type)) {
            return StandardRestrictionResourcePropertyCategory.NUMBER.name();
        }
        if (type.isEnum()) {
            return StandardRestrictionResourcePropertyCategory.ENUM.name();
        }
        if (BaseDictionary.class.isAssignableFrom(type)) {
            return StandardRestrictionResourcePropertyCategory.DICTIONARY.name();
        }
        if (BaseEntity.class.isAssignableFrom(type)) {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }
        if (Date.class.isAssignableFrom(type)) {
            return StandardRestrictionResourcePropertyCategory.DATE.name();
        }
        return StandardRestrictionResourcePropertyCategory.NULL.name();
    }

    public void init(RestrictionResourceProxy proxy, Object object) {
        proxy.getProperties().put(this.getId(), ((EntityIndex)object).getValue(this.property.getId()));
    }

    public Object getValue(RestrictionResourceProxy proxy) {
        return proxy.getProperties().get(this.getId());
    }

    public String getColumn() {
        return this.property.getId();
    }

    private Class<?> resolveStandardType() {
        String type = this.property.getType();
        if ("byte[]".equals(type)) {
            return byte[].class;
        }
        if ("text".equals(type) || "String".equals(type)) {
            return String.class;
        }
        if ("boolean".equals(type) || "Boolean".equals(type)) {
            return Boolean.class;
        }
        if ("byte".equals(type) || "Byte".equals(type)) {
            return Byte.class;
        }
        if ("char".equals(type) || "Character".equals(type)) {
            return Character.class;
        }
        if ("short".equals(type) || "Short".equals(type)) {
            return Short.class;
        }
        if ("int".equals(type) || "Integer".equals(type)) {
            return Integer.class;
        }
        if ("long".equals(type) || "Long".equals(type)) {
            return Long.class;
        }
        if ("float".equals(type) || "Float".equals(type)) {
            return Float.class;
        }
        if ("double".equals(type) || "Double".equals(type)) {
            return Double.class;
        }
        return null;
    }
}

