/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.restriction.resource;

import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.dict.ProfileGroup;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.HoldingIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionIndexResourceOwnershipProperty;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionResourcePropertyCategory;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionResourcePropertyConditions;
import com.gridnine.xtrip.common.model.restriction.resource.helper.RestrictionModelRulesHelper;
import com.gridnine.xtrip.common.restriction.helper.RestrictionRulesHelper;
import com.gridnine.xtrip.common.restriction.resource.RestrictionMatchable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionQueryable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyCondition;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyValueHandler;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyCategory;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyConditions;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.value.renderer.StandardValueRendererCategory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public enum ModelRestrictionResourcePropertyValueHandlers implements RestrictionResourcePropertyValueHandler
{
    MY_CURRENT_WORKLOG_PERIOD{

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DATE.name();
        }

        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (!property.isCollection()) {
                return new HashSet<String>(Arrays.asList(ModelRestrictionResourcePropertyConditions.MY_CURRENT_WORKLOG_PERIOD.getId()));
            }
            return Collections.emptySet();
        }

        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return StandardValueRendererCategory.NULL.name();
        }

        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)property).getValue(proxy);
            if (propertyValue != null && !property.isCollection()) {
                if (ModelRestrictionResourcePropertyConditions.MY_CURRENT_WORKLOG_PERIOD.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyCurrentWorklogPeriod((Date)propertyValue, userId, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                return true;
            }
            return true;
        }

        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column = ((RestrictionQueryable)property).getColumn();
            if (column != null && !property.isCollection()) {
                if (ModelRestrictionResourcePropertyConditions.MY_CURRENT_WORKLOG_PERIOD.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMyCurrentWorklogPeriodCriterion(column, userId, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                return null;
            }
            return null;
        }
    }
    ,
    PROFILE_GROUP{

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DICTIONARY.name();
        }

        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (ProfileGroup.class.isAssignableFrom(property.getType())) {
                return new HashSet<String>(Arrays.asList(ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_PROFILE_GROUPS.getId(), ModelRestrictionResourcePropertyConditions.MY_PROFILE_GROUPS.getId()));
            }
            return Collections.emptySet();
        }

        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return StandardValueRendererCategory.NULL.name();
        }

        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue;
            if (ProfileGroup.class.isAssignableFrom(property.getType()) && (propertyValue = ((RestrictionMatchable)property).getValue(proxy)) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_PROFILE_GROUPS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizationsProfileGroups(propertyValue, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_PROFILE_GROUPS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyProfileGroups(propertyValue, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                return true;
            }
            return true;
        }

        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column;
            if (ProfileGroup.class.isAssignableFrom(property.getType()) && (column = ((RestrictionQueryable)property).getColumn()) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_PROFILE_GROUPS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMyOrganizationsProfileGroupsCriterion(column, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_PROFILE_GROUPS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMyProfileGroupsCriterion(column, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                return null;
            }
            return null;
        }
    }
    ,
    COTRACT{

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (Contract.class.isAssignableFrom(property.getType())) {
                return new HashSet<String>(Arrays.asList(ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CONTRACTS.getId()));
            }
            return Collections.emptySet();
        }

        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return StandardValueRendererCategory.NULL.name();
        }

        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue;
            if (Contract.class.isAssignableFrom(property.getType()) && (propertyValue = ((RestrictionMatchable)property).getValue(proxy)) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CONTRACTS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizationsContracts(propertyValue, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                return true;
            }
            return true;
        }

        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column;
            if (Contract.class.isAssignableFrom(property.getType()) && (column = ((RestrictionQueryable)property).getColumn()) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CONTRACTS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMyOrganizationsContractsCriterion(column, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                return null;
            }
            return null;
        }
    }
    ,
    HOLDING{

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (Holding.class.isAssignableFrom(property.getType())) {
                HashSet<String> conditionIds = new HashSet<String>(Arrays.asList(ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS.getId()));
                if (MetaRegistry.get().getIndexes().containsKey(property.getResourceId())) {
                    conditionIds.add(ModelRestrictionResourcePropertyConditions.MY_CHILDREN_ORGANIZATIONS_HOLDINGS.getId());
                }
                if (property instanceof ModelRestrictionIndexResourceOwnershipProperty) {
                    conditionIds.add(StandardRestrictionResourcePropertyConditions.NULL.getId());
                    conditionIds.add(StandardRestrictionResourcePropertyConditions.NOT_NULL.getId());
                }
                return conditionIds;
            }
            return Collections.emptySet();
        }

        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return StandardValueRendererCategory.NULL.name();
        }

        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue;
            if (Holding.class.isAssignableFrom(property.getType()) && (propertyValue = ((RestrictionMatchable)property).getValue(proxy)) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizationsHoldings(propertyValue, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                return true;
            }
            return true;
        }

        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column;
            if (Holding.class.isAssignableFrom(property.getType()) && (column = ((RestrictionQueryable)property).getColumn()) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMyOrganizationsHoldingsCriterion(column, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_CHILDREN_ORGANIZATIONS_HOLDINGS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMyChildrenOrganizationsHoldingsCriterion(column, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (property instanceof ModelRestrictionIndexResourceOwnershipProperty) {
                    if (StandardRestrictionResourcePropertyConditions.NULL == condition) {
                        return SearchCriterion.eq((String)HoldingIndex.Property.hasOrganizations.name(), (Object)Boolean.FALSE);
                    }
                    if (StandardRestrictionResourcePropertyConditions.NOT_NULL == condition) {
                        return SearchCriterion.eq((String)HoldingIndex.Property.hasOrganizations.name(), (Object)Boolean.TRUE);
                    }
                }
                return null;
            }
            return null;
        }
    }
    ,
    ORGANIZATION{

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return StandardValueRendererCategory.NULL.name();
        }

        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (Organization.class.isAssignableFrom(property.getType())) {
                ModelRestrictionIndexResourceOwnershipProperty prop;
                HashSet<String> conditionIds = new HashSet<String>(Arrays.asList(ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS.getId(), ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CUSTOMERS.getId(), ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS.getId()));
                if (property instanceof ModelRestrictionIndexResourceOwnershipProperty && (prop = (ModelRestrictionIndexResourceOwnershipProperty)property).getId().contains(OrganizationIndex.class.getName())) {
                    conditionIds.add(StandardRestrictionResourcePropertyConditions.NULL.getId());
                    conditionIds.add(StandardRestrictionResourcePropertyConditions.NOT_NULL.getId());
                }
                if (!MetaRegistry.get().getIndexes().containsKey(property.getResourceId()) || OrganizationIndex.class.getName().equals(property.getResourceId())) {
                    conditionIds.addAll(Arrays.asList(ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CHILDREN.getId()));
                }
                return conditionIds;
            }
            return Collections.emptySet();
        }

        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue;
            if (Organization.class.isAssignableFrom(property.getType()) && (propertyValue = ((RestrictionMatchable)property).getValue(proxy)) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizations(propertyValue, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CUSTOMERS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizationsCustomers(propertyValue, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizationsHoldingsOrganizations(propertyValue, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CHILDREN.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizationsChildren(propertyValue, userId);
                }
                return true;
            }
            return true;
        }

        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column;
            if (Organization.class.isAssignableFrom(property.getType()) && (column = ((RestrictionQueryable)property).getColumn()) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMyOrganizationsCriterion(column, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CUSTOMERS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMyOrganizationsCustomersCriterion(column, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMyOrganizationsHoldingsOrganizationsCriterion(column, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (property instanceof ModelRestrictionIndexResourceOwnershipProperty) {
                    if (StandardRestrictionResourcePropertyConditions.NULL == condition) {
                        return SearchCriterion.isEmpty((String)OrganizationIndex.Property.supplierUids.name());
                    }
                    if (StandardRestrictionResourcePropertyConditions.NOT_NULL == condition) {
                        return SearchCriterion.isNotEmpty((String)OrganizationIndex.Property.supplierUids.name());
                    }
                }
                if (OrganizationIndex.class.getName().equals(property.getResourceId()) && ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CHILDREN.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMyOrganizationsChildrenCriterion(OrganizationIndex.Property.parentUids.name(), userId);
                }
                return null;
            }
            return null;
        }
    }
    ,
    BRANCH{

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (Branch.class.isAssignableFrom(property.getType())) {
                return new HashSet<String>(Arrays.asList(ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_BRANCHES.getId(), ModelRestrictionResourcePropertyConditions.MY_SALES_POINTS_BRANCHES.getId()));
            }
            return Collections.emptySet();
        }

        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return StandardValueRendererCategory.NULL.name();
        }

        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue;
            if (Branch.class.isAssignableFrom(property.getType()) && (propertyValue = ((RestrictionMatchable)property).getValue(proxy)) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_BRANCHES.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizationsBranches(propertyValue, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_SALES_POINTS_BRANCHES.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMySalesPointsBranches(propertyValue, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                return true;
            }
            return true;
        }

        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column;
            if (Branch.class.isAssignableFrom(property.getType()) && (column = ((RestrictionQueryable)property).getColumn()) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_BRANCHES.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMyOrganizationsBranchesCriterion(column, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_SALES_POINTS_BRANCHES.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMySalesPointsBranchesCriterion(column, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                return null;
            }
            return null;
        }
    }
    ,
    SALES_POINT{

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (SalesPoint.class.isAssignableFrom(property.getType())) {
                return new HashSet<String>(Arrays.asList(ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_SALES_POINTS.getId(), ModelRestrictionResourcePropertyConditions.MY_SALES_POINTS.getId()));
            }
            return Collections.emptySet();
        }

        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return StandardValueRendererCategory.NULL.name();
        }

        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue;
            if (SalesPoint.class.isAssignableFrom(property.getType()) && (propertyValue = ((RestrictionMatchable)property).getValue(proxy)) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_SALES_POINTS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizationsSalesPoints(propertyValue, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_SALES_POINTS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMySalesPoints(propertyValue, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                return true;
            }
            return true;
        }

        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column;
            if (SalesPoint.class.isAssignableFrom(property.getType()) && (column = ((RestrictionQueryable)property).getColumn()) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_SALES_POINTS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMyOrganizationsSalesPointsCriterion(column, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_SALES_POINTS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMySalesPointsCriterion(column, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                return null;
            }
            return null;
        }
    }
    ,
    CASH_REGISTER{

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (CashRegister.class.isAssignableFrom(property.getType())) {
                return new HashSet<String>(Arrays.asList(ModelRestrictionResourcePropertyConditions.MY_SALES_POINTS_CASH_REGISTERS.getId()));
            }
            return Collections.emptySet();
        }

        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return StandardValueRendererCategory.NULL.name();
        }

        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue;
            if (CashRegister.class.isAssignableFrom(property.getType()) && (propertyValue = ((RestrictionMatchable)property).getValue(proxy)) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_SALES_POINTS_CASH_REGISTERS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMySalesPointsCashRegisters(propertyValue, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                return true;
            }
            return true;
        }

        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column;
            if (CashRegister.class.isAssignableFrom(property.getType()) && (column = ((RestrictionQueryable)property).getColumn()) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_SALES_POINTS_CASH_REGISTERS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMySalesPointsCashRegistersCriterion(column, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                return null;
            }
            return null;
        }
    }
    ,
    CASH_REGISTER_WORKPLACE{

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (CashRegisterWorkplace.class.isAssignableFrom(property.getType())) {
                return new HashSet<String>(Arrays.asList(ModelRestrictionResourcePropertyConditions.MY_SALES_POINTS_CASH_REGISTER_WORKPLACES.getId()));
            }
            return Collections.emptySet();
        }

        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return StandardValueRendererCategory.NULL.name();
        }

        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue;
            if (CashRegisterWorkplace.class.isAssignableFrom(property.getType()) && (propertyValue = ((RestrictionMatchable)property).getValue(proxy)) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_SALES_POINTS_CASH_REGISTER_WORKPLACES.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMySalesPointsCashRegisterWorkplaces(propertyValue, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                return true;
            }
            return true;
        }

        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column;
            if (CashRegisterWorkplace.class.isAssignableFrom(property.getType()) && (column = ((RestrictionQueryable)property).getColumn()) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_SALES_POINTS_CASH_REGISTER_WORKPLACES.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMySalesPointsCashRegisterWorkplacesCriterion(column, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                return null;
            }
            return null;
        }
    }
    ,
    PERSON{

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return StandardValueRendererCategory.NULL.name();
        }

        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (Person.class.isAssignableFrom(property.getType())) {
                HashSet<String> conditionIds = new HashSet<String>(Arrays.asList(ModelRestrictionResourcePropertyConditions.MY_PERSONS.getId(), ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CUSTOMERS_PERSONS.getId()));
                if (property instanceof RestrictionQueryable) {
                    String column = ((RestrictionQueryable)property).getColumn();
                    if (column != null) {
                        if (MetaRegistry.get().getIndexes().containsKey(property.getResourceId()) && ((IndexType)MetaRegistry.get().getIndexes().get(property.getResourceId())).getCollections().containsKey(String.format("%sEmploymentsUids", column))) {
                            conditionIds.addAll(Arrays.asList(ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_PERSONS.getId(), ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS_PERSONS.getId()));
                        }
                        if (PersonIndex.class.getName().equals(property.getResourceId())) {
                            conditionIds.addAll(Arrays.asList(ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_PERSONS.getId(), ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CHILDREN_PERSONS.getId()));
                            if (column.equals("containerUid")) {
                                conditionIds.addAll(Arrays.asList(ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS_PERSONS.getId()));
                            }
                        }
                    }
                } else {
                    conditionIds.addAll(Arrays.asList(ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_PERSONS.getId(), ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CHILDREN_PERSONS.getId(), ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS_PERSONS.getId()));
                }
                return conditionIds;
            }
            return Collections.emptySet();
        }

        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue;
            if (Person.class.isAssignableFrom(property.getType()) && (propertyValue = ((RestrictionMatchable)property).getValue(proxy)) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_PERSONS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyPersons(propertyValue, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CUSTOMERS_PERSONS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizationsCustomersPersons(propertyValue, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_PERSONS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizationsPersons(propertyValue, userId);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CHILDREN_PERSONS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizationsChildrenPersons(propertyValue, userId);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS_PERSONS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizationsHoldingsOrganizationsPersons(propertyValue, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                return true;
            }
            return true;
        }

        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column;
            if (Person.class.isAssignableFrom(property.getType()) && (column = ((RestrictionQueryable)property).getColumn()) != null) {
                if (ModelRestrictionResourcePropertyConditions.MY_PERSONS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMyPersonsCriterion(column, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CUSTOMERS_PERSONS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.createMyOrganizationsCustomersPersonsCriterion(column, userId, property.isCollection(), property.isCollection() ? RestrictionModelRulesHelper.EntityCondition.CONTAINS : RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (MetaRegistry.get().getIndexes().containsKey(property.getResourceId()) && ((IndexType)MetaRegistry.get().getIndexes().get(property.getResourceId())).getCollections().containsKey(String.format("%sEmploymentsUids", column))) {
                    if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_PERSONS.getId().equals(condition.getId())) {
                        return RestrictionModelRulesHelper.createMyOrganizationsCriterion(String.format("%sEmploymentsUids", column), userId, true, RestrictionModelRulesHelper.EntityCondition.CONTAINS);
                    }
                    if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS_PERSONS.getId().equals(condition.getId())) {
                        return RestrictionModelRulesHelper.createMyOrganizationsHoldingsOrganizationsCriterion(String.format("%sEmploymentsUids", column), userId, true, RestrictionModelRulesHelper.EntityCondition.CONTAINS);
                    }
                }
                if (PersonIndex.class.getName().equals(property.getResourceId())) {
                    if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_PERSONS.getId().equals(condition.getId())) {
                        if (column.equals(PersonIndex.Property.parent.name())) {
                            return RestrictionModelRulesHelper.createParentInMyOrganizationsCriterion(userId);
                        }
                        return RestrictionModelRulesHelper.createMyOrganizationsPersonsCriterion(PersonIndex.Property.employmentsUids.name(), userId);
                    }
                    if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CHILDREN_PERSONS.getId().equals(condition.getId())) {
                        return RestrictionModelRulesHelper.createMyOrganizationsChildrenPersonsCriterion(PersonIndex.Property.parentOrganizationUids.name(), userId);
                    }
                    if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS_PERSONS.getId().equals(condition.getId()) && column.equals("containerUid")) {
                        return RestrictionModelRulesHelper.createMyOrganizationsHoldingsOrganizationsCriterion(PersonIndex.Property.employmentsUids.name(), userId, true, RestrictionModelRulesHelper.EntityCondition.CONTAINS);
                    }
                }
                return null;
            }
            return null;
        }
    }
    ,
    CLIENT_SHIPMENT_CREATED{

        public String getCategoryId() {
            return ModelRestrictionResourcePropertyCategory.CLIENT_SHIPMENT_CREATED.name();
        }

        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (!property.isCollection()) {
                return Collections.singleton(ModelRestrictionResourcePropertyConditions.CLIENT_SHIPMENT_CREATED.getId());
            }
            return Collections.emptySet();
        }

        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return StandardValueRendererCategory.NULL.name();
        }

        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)property).getValue(proxy);
            if (propertyValue != null && !property.isCollection()) {
                if (ModelRestrictionResourcePropertyConditions.CLIENT_SHIPMENT_CREATED.getId().equals(condition.getId())) {
                    return (Boolean)propertyValue;
                }
                return true;
            }
            return true;
        }

        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            return null;
        }
    }
    ,
    SUBAGENT_SHIPMENT_CREATED{

        public String getCategoryId() {
            return ModelRestrictionResourcePropertyCategory.SUBAGENT_SHIPMENT_CREATED.name();
        }

        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (!property.isCollection()) {
                return Collections.singleton(ModelRestrictionResourcePropertyConditions.SUBAGENT_SHIPMENT_CREATED.getId());
            }
            return Collections.emptySet();
        }

        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return StandardValueRendererCategory.NULL.name();
        }

        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)property).getValue(proxy);
            if (propertyValue != null && !property.isCollection()) {
                if (ModelRestrictionResourcePropertyConditions.SUBAGENT_SHIPMENT_CREATED.getId().equals(condition.getId())) {
                    return (Boolean)propertyValue;
                }
                return true;
            }
            return true;
        }

        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            return null;
        }
    };


    public String getId() {
        return this.name();
    }

    public String getName() {
        return this.name();
    }

    public String getDescription() {
        return this.name();
    }

    public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
        return RestrictionRulesHelper.getInfo((String)property.getName(), (String)condition.getName(), (Object)value, (boolean)property.isTimeIncluded());
    }
}

