/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Nomenclature;
import com.gridnine.xtrip.common.model.dict.ShipmentCategory;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentHolder;
import com.gridnine.xtrip.common.model.profile.AgreementType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.finance.HasSupplierPropertySet;
import com.gridnine.xtrip.common.model.rules.finance.HasVendorAgreementTypePropertySet;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;

public class ShipmentPropertySet
implements HasSupplierPropertySet,
HasVendorAgreementTypePropertySet {
    private final RuleProxy<? extends ShipmentPropertySet, ?> proxy;
    private final List<DictionaryReference<ShipmentCategory>> categories = new ArrayList<DictionaryReference<ShipmentCategory>>();
    private DictionaryReference<Nomenclature> nomenclature;
    private EntityReference<Organization> supplier;
    private EntityReference<Organization> customer;
    private HotelProvider hotelProvider;
    private AgreementType vendorAgreementType;
    private Double hotelVatRate;
    private boolean correctionShipment;

    public ShipmentPropertySet(RuleProxy<? extends ShipmentPropertySet, ?> proxy) {
        this.proxy = proxy;
    }

    public void init(ShipmentHolder holder) {
        RuleLogTracer tracer = this.proxy.getTracer();
        tracer.traceEnteringMethod(ShipmentPropertySet.class, "init()", new String[0]);
        try {
            this.categories.clear();
            this.categories.addAll(holder.getCategories());
            this.nomenclature = holder.getNomenclature();
            this.supplier = holder.getVendor();
            this.customer = holder.getCustomer();
            this.hotelProvider = holder.getHotelProvider();
            this.vendorAgreementType = holder.getVendorAgreementType();
            this.hotelVatRate = holder.getHotelVatRate();
            this.correctionShipment = holder.getShipment() != null && ((Shipment)holder.getShipment().getEntity()).isCorrection();
        }
        finally {
            tracer.traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            tracer.traceExitingMethod(ShipmentPropertySet.class, "init()", new String[0]);
        }
    }

    public List<DictionaryReference<ShipmentCategory>> getCategories() {
        return this.categories;
    }

    public DictionaryReference<Nomenclature> getNomenclature() {
        return this.nomenclature;
    }

    @Override
    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public EntityReference<Organization> getCustomer() {
        return this.customer;
    }

    public HotelProvider getHotelProvider() {
        return this.hotelProvider;
    }

    @Override
    public AgreementType getVendorAgreementType() {
        return this.vendorAgreementType;
    }

    public boolean isCorrectionShipment() {
        return this.correctionShipment;
    }

    public Double getHotelVatRate() {
        return this.hotelVatRate;
    }
}

