/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.VendorFinanceDocumentData;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ShipmentsDatePropertySet {
    private final RuleProxy<? extends ShipmentsDatePropertySet, ?> proxy;
    private ExtendedProductType productType;
    private EntityReference<Organization> supplier;
    private Set<FinanceDocumentType> vendorFinanceDocumentTypes;
    private boolean includeVat;
    private Date issueDate;
    private Date startDate;
    private Date endDate;
    private Date bookingFileCreateDate;

    public ShipmentsDatePropertySet(RuleProxy<? extends ShipmentsDatePropertySet, ?> proxy) {
        this.proxy = proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(BaseProduct product, List<GeneralProductFop> fops) {
        RuleLogTracer tracer = this.proxy.getTracer();
        tracer.traceEnteringMethod(ShipmentsDatePropertySet.class, "init()", new String[0]);
        try {
            this.productType = new ExtendedProductType();
            this.productType.setProductType(ProductHandler.of(product).getProductType(product));
            this.productType.setProductDescription(ProductHandler.of(product).getUniversalProductDescription(product));
            this.supplier = GeneralProductHelper.getSupplier(product);
            this.vendorFinanceDocumentTypes = product.getVendorFinanceDocumentsData().stream().filter(item -> TextUtil.nonBlank((String)item.getVendorNumber()) && item.getVendorDate() != null && item.getType() != null).map(VendorFinanceDocumentData::getType).collect(Collectors.toSet());
            this.includeVat = fops.stream().map(fop -> (FopDetalization)product.getFopDetalizations().get(fop.getUid())).filter(Objects::nonNull).flatMap(fop -> fop.getComponents().stream()).filter(item -> !FopComponentType.OWN_FEES.equals((Object)item.getType())).anyMatch(item -> item.getVatRate() != null);
            this.issueDate = ProductHandler.of(product).findIssueDate(product);
            this.startDate = ProductHandler.of(product).getFirstStartDate(product);
            this.endDate = ProductHandler.of(product).getLastEndDate(product);
            this.bookingFileCreateDate = Optional.ofNullable(product.getReservation()).map(Reservation::getBookingFile).map(BookingFile::getCreateDate).orElse(null);
        }
        finally {
            tracer.traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            tracer.traceExitingMethod(ShipmentsDatePropertySet.class, "init()", new String[0]);
        }
    }

    public ExtendedProductType getProductType() {
        return this.productType;
    }

    public void setProductType(ExtendedProductType productType) {
        this.productType = productType;
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public void setSupplier(EntityReference<Organization> supplier) {
        this.supplier = supplier;
    }

    public Set<FinanceDocumentType> getVendorFinanceDocumentTypes() {
        return this.vendorFinanceDocumentTypes;
    }

    public void setVendorFinanceDocumentTypes(Set<FinanceDocumentType> vendorFinanceDocumentTypes) {
        this.vendorFinanceDocumentTypes = vendorFinanceDocumentTypes;
    }

    public boolean isIncludeVat() {
        return this.includeVat;
    }

    public void setIncludeVat(boolean includeVat) {
        this.includeVat = includeVat;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getBookingFileCreateDate() {
        return this.bookingFileCreateDate;
    }
}

