/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.fops;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.Date;

public class FopPropertySet {
    private final RuleProxy<? extends FopPropertySet, ?> proxy;
    private ProductStatus productStatus;
    private ReservationType reservationType;
    private Date productDate;
    private EntityReference<Person> productAgent;
    private PaymentType fopPaymentType;
    private BigDecimal fopAmount;
    private Date fopDate;
    private EntityReference<Person> fopAgent;

    public FopPropertySet(RuleProxy<? extends FopPropertySet, ?> proxy) {
        this.proxy = proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(BaseProduct product, GeneralProductFop fop) {
        RuleLogTracer tracer = this.proxy.getTracer();
        tracer.traceEnteringMethod(FopPropertySet.class, "init()", new String[0]);
        try {
            this.productStatus = ProductHandler.of(product).getStatus(product);
            this.productDate = ProductHandler.of(product).findIssueDate(product);
            this.productAgent = ProductHandler.of(product).findIssuingAgent(product);
            this.reservationType = product.getReservation() != null ? product.getReservation().getType() : null;
            this.fopPaymentType = fop.getType();
            this.fopAmount = fop.getEquivalentAmount();
            this.fopDate = fop.getOperationDate();
            this.fopAgent = fop.getAgent();
        }
        finally {
            tracer.traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            tracer.traceExitingMethod(FopPropertySet.class, "init()", new String[0]);
        }
    }

    public ProductStatus getProductStatus() {
        return this.productStatus;
    }

    public void setProductStatus(ProductStatus productStatus) {
        this.productStatus = productStatus;
    }

    public Date getProductDate() {
        return this.productDate;
    }

    public void setProductDate(Date productDate) {
        this.productDate = productDate;
    }

    public EntityReference<Person> getProductAgent() {
        return this.productAgent;
    }

    public void setProductAgent(EntityReference<Person> productAgent) {
        this.productAgent = productAgent;
    }

    public PaymentType getFopPaymentType() {
        return this.fopPaymentType;
    }

    public void setFopPaymentType(PaymentType fopPaymentType) {
        this.fopPaymentType = fopPaymentType;
    }

    public BigDecimal getFopAmount() {
        return this.fopAmount;
    }

    public void setFopAmount(BigDecimal fopAmount) {
        this.fopAmount = fopAmount;
    }

    public Date getFopDate() {
        return this.fopDate;
    }

    public void setFopDate(Date fopDate) {
        this.fopDate = fopDate;
    }

    public EntityReference<Person> getFopAgent() {
        return this.fopAgent;
    }

    public void setFopAgent(EntityReference<Person> fopAgent) {
        this.fopAgent = fopAgent;
    }

    public ReservationType getReservationType() {
        return this.reservationType;
    }

    public void setReservationType(ReservationType reservationType) {
        this.reservationType = reservationType;
    }
}

