/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.fops;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.rules.fops.FopPropertySet;
import com.gridnine.xtrip.common.model.rules.fops.Targets;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.List;

public enum Properties implements RuleProperty
{
    FOP_PRODUCT_STATUS{

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_fopProductStatus);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.FOPS.name()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.PRODUCT_STATUS.name();
        }

        public void buildInfo(StringBuilder info, RuleCondition condition, Object value) {
            info.append(L10nResourcesManager.getStr((String)Messages.Properties_fopProductStatusInfo, (Object[])new Object[]{condition.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            FopPropertySet fopPropertySet = (FopPropertySet)propertySet;
            List productStatuses = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return productStatuses.contains(fopPropertySet.getProductStatus());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !productStatuses.contains(fopPropertySet.getProductStatus());
            }
            return true;
        }
    }
    ,
    FOP_RESERVATION_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_fopReservationType);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.FOPS.name()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.RESERVATION_TYPE.name();
        }

        public void buildInfo(StringBuilder info, RuleCondition condition, Object value) {
            info.append(L10nResourcesManager.getStr((String)Messages.Properties_fopReservationTypeInfo, (Object[])new Object[]{condition.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            FopPropertySet fopPropertySet = (FopPropertySet)propertySet;
            List reservationTypes = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return reservationTypes.contains(fopPropertySet.getReservationType());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !reservationTypes.contains(fopPropertySet.getReservationType());
            }
            return true;
        }
    }
    ,
    PAYMENT_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_fopPaymentType);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.FOPS.name()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.PAYMENT_TYPE.name();
        }

        public void buildInfo(StringBuilder info, RuleCondition condition, Object value) {
            info.append(L10nResourcesManager.getStr((String)Messages.Properties_fopPaymentTypeInfo, (Object[])new Object[]{condition.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            FopPropertySet fopPropertySet = (FopPropertySet)propertySet;
            List paymentTypes = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return paymentTypes.contains(fopPropertySet.getFopPaymentType());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !paymentTypes.contains(fopPropertySet.getFopPaymentType());
            }
            return true;
        }
    }
    ,
    FOP_AMOUNT{

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_fopAmount);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.FOPS.name()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.PRICE.name();
        }

        public void buildInfo(StringBuilder info, RuleCondition condition, Object value) {
            info.append(L10nResourcesManager.getStr((String)Messages.Properties_fopAmountInfo, (Object[])new Object[]{condition.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            FopPropertySet fopPropertySet = (FopPropertySet)propertySet;
            BigDecimal amount = (BigDecimal)value;
            if (Conditions.EQUALS.equals(condition)) {
                return MiscUtil.equals((Object)amount, (Object)fopPropertySet.getFopAmount());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !MiscUtil.equals((Object)amount, (Object)fopPropertySet.getFopAmount());
            }
            return true;
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    abstract String[] getConditionIds();
}

