/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.model.rules.standard.AdditionalServiceProductProperties;
import com.gridnine.xtrip.common.model.rules.standard.CommonProductProperties;
import com.gridnine.xtrip.common.model.rules.standard.ContractsFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.GeneralProductActions;
import com.gridnine.xtrip.common.model.rules.standard.ProductTicketInfoProperties;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleEnvironmentHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;

public class AdditionalServiceProductRuleEnvironment
implements RulesEnvironment.Hook {
    public void environmentInitialized(RulesEnvironment env) {
        env.registerProperties((RuleProperty[])AdditionalServiceProductProperties.values());
        for (AdditionalServiceProductProperties property : AdditionalServiceProductProperties.values()) {
            for (String targetId : property.getTargetIds()) {
                env.registerTarget2propertyAssociation(targetId, property.getId());
            }
            RuleEnvironmentHelper.registerPropertiesToContracts(env, property);
        }
        String targetId = Targets.ADDITIONAL_SERVICE_PRODUCT.getId();
        for (Properties property : Arrays.asList(Properties.EMPLOYEE_CATEGORIES, Properties.CREATED_BY_CLIENT, Properties.CREDIT_CARD_TYPE)) {
            env.registerTarget2propertyAssociation(targetId, property.getId());
        }
        for (CommonProductProperties property : Collections.singletonList(CommonProductProperties.PRODUCT_STATUS)) {
            env.registerTarget2propertyAssociation(targetId, property.getId());
        }
        for (ProductTicketInfoProperties property : Arrays.asList(ProductTicketInfoProperties.TICKETING_AGENTS, ProductTicketInfoProperties.PRODUCT_SALES_POINTS)) {
            if (env.findProperty(property.getId()) == null) {
                env.registerProperties(new RuleProperty[]{property});
            }
            env.registerTarget2propertyAssociation(targetId, property.getId());
            RuleEnvironmentHelper.registerPropertiesToContracts(env, property);
        }
        for (Iterator<Enum> iterator : GeneralProductActions.values()) {
            env.registerTarget2actionAssociation(targetId, ((GeneralProductActions)((Object)iterator)).getId());
            for (ContractsFilteringCategories filteringCategory : ContractsFilteringCategories.values()) {
                env.registerFilteringCategory2actionAssociation(filteringCategory.getId(), ((GeneralProductActions)((Object)iterator)).getId());
            }
        }
        for (Iterator<Enum> iterator : ContractsFilteringCategories.values()) {
            env.registerFilteringCategory2targetAssociation(((ContractsFilteringCategories)((Object)iterator)).getId(), targetId);
        }
        RuleEnvironmentHelper.registerTargetToContracts(env, targetId);
    }
}

