/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.dict.CarClass;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.CarRentalProductPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ClientCreditCardVendorProvider;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyTargets;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.util.Collection;
import java.util.List;

public enum CarRentalProductProperties implements RuleProperty,
RulePropertyConditions
{
    CAR_RENTAL_CLASS{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CarRentalClass);
        }

        public String getRendererId() {
            return ValueTypes.CAR_RENTAL_CLASS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_CarRentalClass, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            CarRentalProductPropertiesProvider propertiesProvider = (CarRentalProductPropertiesProvider)propertySet;
            Collection carClasses = (Collection)value;
            DictionaryReference<CarClass> carClass = propertiesProvider.getCarClass();
            if (Conditions.INCLUDE.equals(condition)) {
                return carClass != null && RulesHelper.matchesDictRestriction(carClass.getCode(), carClasses, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return carClass != null && RulesHelper.matchesDictRestriction(carClass.getCode(), carClasses, false);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.CAR.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    WITH_DRIVER{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_withDriver);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_withDriver, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            CarRentalProductPropertiesProvider propertiesProvider = (CarRentalProductPropertiesProvider)propertySet;
            return Boolean.valueOf(propertiesProvider.withDriver()).equals(value);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.CAR.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }
    }
    ,
    CAR_RENTAL_CREDIT_CARD_TYPE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CreditCardType);
        }

        public String getRendererId() {
            return ValueTypes.CREDIT_CARD_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.CAR.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_CreditCardType_info), cond.getDisplayName(), RulesHelper.values2text((List)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            if (propertySet instanceof ClientCreditCardVendorProvider) {
                ClientCreditCardVendorProvider prov = (ClientCreditCardVendorProvider)propertySet;
                if (Conditions.EQUALS.equals(condition)) {
                    return RulesHelper.matchesEnumRestriction(prov.getClientCreditCardVendor(), (List)value, true);
                }
                return RulesHelper.matchesEnumRestriction(prov.getClientCreditCardVendor(), (List)value, false);
            }
            return false;
        }
    }
    ,
    CAR_RENTAL_PRICE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelPrice);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelPrice, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            CarRentalProductPropertiesProvider propertiesProvider = (CarRentalProductPropertiesProvider)propertySet;
            Double totalPrice = propertiesProvider.getTotalPrice();
            Double compareWithValue = totalPrice - (Double)value;
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(compareWithValue) < 0.01;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(compareWithValue) >= 0.01;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return compareWithValue >= 0.01;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(compareWithValue) < 0.01 || compareWithValue >= 0.01;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return (Double)value - totalPrice >= 0.01;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(compareWithValue) < 0.01 || (Double)value - totalPrice >= 0.01;
            }
            return false;
        }

        @Override
        public String[] getTargetIds() {
            return new String[]{Targets.CAR.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }
    }
    ,
    CAR_RENTAL_VENDOR{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CarRentalVendor);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)Messages.RuleProperty_CarRentalVendor, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            CarRentalProductPropertiesProvider ps = (CarRentalProductPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getCarVendorCode(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getCarVendorCode(), value, false);
            }
            return false;
        }

        @Override
        public String[] getTargetIds() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_CAR_RENTAL.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    CAR_RENT_DURATION{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CarRentDuration);
        }

        public String getRendererId() {
            return ValueTypes.INTEGER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)Messages.RuleProperty_CarRentDuration, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            CarRentalProductPropertiesProvider ps = (CarRentalProductPropertiesProvider)propertySet;
            if (value == null) {
                return true;
            }
            if (ps.getRentDuration() == null) {
                return false;
            }
            int iv = (Integer)value;
            int stayDuration = ps.getRentDuration();
            if (Conditions.EQUALS.equals(condition)) {
                return stayDuration == iv;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return stayDuration != iv;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return stayDuration > iv;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return stayDuration >= iv;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return stayDuration < iv;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return stayDuration <= iv;
            }
            return false;
        }

        @Override
        public String[] getTargetIds() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_CAR_RENTAL.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    @Override
    public abstract String[] getConditionIds();
}

