/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.ClientPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.ProductStatusPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TicketTypePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TranslateSupplierFeesPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.util.ArrayList;
import java.util.List;

public enum CommonProductProperties implements RuleProperty,
RulePropertyConditions
{
    IS_TRANSLATE_SUPPLIER_FEES{

        public String getDisplayName() {
            return L10n.get((String)Messages.CommonProductProperties_IsTranslateSupplierFees);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.CommonProductProperties_IsTranslateSupplierFees_info1) : L10n.get((String)Messages.CommonProductProperties_IsTranslateSupplierFees_info2));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            TranslateSupplierFeesPropertyProvider pp = (TranslateSupplierFeesPropertyProvider)propertySet;
            return Boolean.valueOf(pp.isTranslateSupplierFees()).equals(value);
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }
    }
    ,
    TICKET_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TicketType);
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.TICKET_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(this.getDisplayName() + " " + cond.getDisplayName() + " " + RulesHelper.values2text((List)value));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            TicketTypePropertiesProvider ps = (TicketTypePropertiesProvider)propertySet;
            TicketType ticketType = ps.getTicketType();
            if (Conditions.EQUALS.equals(condition)) {
                if (ticketType == null) {
                    return false;
                }
                return RulesHelper.matchesEnumRestriction(ticketType.name(), (List)value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                if (ticketType == null) {
                    return true;
                }
                return RulesHelper.matchesEnumRestriction(ticketType.name(), (List)value, false);
            }
            return true;
        }
    }
    ,
    PRODUCT_STATUS{

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_productStatus);
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.PRODUCT_STATUS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(this.getDisplayName() + " " + cond.getDisplayName() + " " + RulesHelper.values2text((List)value));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ArrayList<ProductStatus> values = new ArrayList<ProductStatus>((List)value);
            if (values.contains(ProductStatus.SELL) && !values.contains(ProductStatus.BOOKING)) {
                values.add(ProductStatus.BOOKING);
            }
            ProductStatusPropertiesProvider ps = (ProductStatusPropertiesProvider)propertySet;
            ProductStatus productStatus = ps.getProductStatus();
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(productStatus.name(), values, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(productStatus.name(), values, false);
            }
            return true;
        }
    }
    ,
    CORPORATE_CLIENT{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_Client);
        }

        public String getRendererId() {
            return ValueTypes.CLIENTS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_Client_Info, (Object[])new Object[]{cond.getDisplayName(), this.toString((List)value)}));
        }

        private String toString(List<EntityReference<Organization>> value) {
            if (value == null || value.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (EntityReference<Organization> organization : value) {
                String title = organization.toString();
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(title);
            }
            return sb.toString();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ClientPropertiesProvider ps = (ClientPropertiesProvider)propertySet;
            List organizations = (List)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return organizations.contains(ps.getClient());
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return !organizations.contains(ps.getClient());
            }
            return false;
        }
    };


    @Override
    public abstract String[] getConditionIds();

    public String getId() {
        return this.name();
    }
}

