/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.ClientCreditCardVendorProvider;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.InsuranceTouristicPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.DateInterval;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.LoggerFactory;

public enum InsuranceTouristicProperties implements RuleProperty,
RulePropertyConditions
{
    INSURANCE_TOURISTIC_SALES_POINT{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SalesPoint);
        }

        public String getRendererId() {
            return ValueTypes.SALES_POINTS.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.INSURANCE_TOURISTIC_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_SalesPoint_info), cond.getDisplayName(), this.toString((List)value)));
        }

        private String toString(List<String> value) {
            if (value == null || value.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (String uid : value) {
                String title = "???";
                try {
                    EntityContainer ctr = EntityStorage.get().resolve(new EntityReference(uid, SalesPoint.class, null));
                    if (ctr != null) {
                        title = ctr.toReference().toString();
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error("unable to resolve reference", (Throwable)e);
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(title);
            }
            return sb.toString();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            InsuranceTouristicPropertiesProvider ps = (InsuranceTouristicPropertiesProvider)propertySet;
            List uids = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getSalesPointUid(), (Object)uids, true);
            }
            return RulesHelper.matchesStringRestriction(ps.getSalesPointUid(), (Object)uids, false);
        }
    }
    ,
    INSURANCE_TOURISTIC_ISSUED{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_Issued);
        }

        public String getRendererId() {
            return ValueTypes.DATE_INTERVAL.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.INSURANCE_TOURISTIC_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return;
            }
            DateFormat dateFormat = RulesHelper.getDateFormat();
            if (Conditions.PERIOD_WITHIN.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ISSUED_info_before, (Object[])new Object[]{dateFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ISSUED_info_after, (Object[])new Object[]{dateFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ISSUED_info_within, (Object[])new Object[]{dateFormat.format(di.getBeginDate()), dateFormat.format(di.getEndDate())}));
                }
                return;
            }
            if (Conditions.PERIOD_BEYOND.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ISSUED_info_after, (Object[])new Object[]{dateFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ISSUED_info_before, (Object[])new Object[]{dateFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ISSUED_info_beyond, (Object[])new Object[]{dateFormat.format(di.getBeginDate()), dateFormat.format(di.getEndDate())}));
                }
                return;
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            InsuranceTouristicPropertiesProvider ps = (InsuranceTouristicPropertiesProvider)propertySet;
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return true;
            }
            Date issueDate = ps.getIssueDate();
            if (Conditions.PERIOD_WITHIN.equals(condition)) {
                if (di.getBeginDate() == null) {
                    return issueDate != null && issueDate.getTime() <= di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return issueDate != null && issueDate.getTime() >= di.getBeginDate().getTime();
                }
                return issueDate != null && issueDate.getTime() >= di.getBeginDate().getTime() && issueDate.getTime() <= di.getEndDate().getTime();
            }
            if (Conditions.PERIOD_BEYOND.equals(condition)) {
                if (di.getBeginDate() == null) {
                    return issueDate != null && issueDate.getTime() > di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return issueDate != null && issueDate.getTime() < di.getBeginDate().getTime();
                }
                return issueDate != null && (issueDate.getTime() < di.getBeginDate().getTime() || issueDate.getTime() > di.getEndDate().getTime());
            }
            return true;
        }
    }
    ,
    INSURANCE_TOURISTIC_PNR{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.BEGINS_WITH.getId(), Conditions.ENDS_WITH.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PNR);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.INSURANCE_TOURISTIC_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_PNR_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            InsuranceTouristicPropertiesProvider ps = (InsuranceTouristicPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getPnr(), value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.getPnr() != null && RulesHelper.matchesStringRestriction(ps.getPnr(), value, false);
            }
            if (Conditions.BEGINS_WITH.equals(condition)) {
                return ps.getPnr() != null && RulesHelper.matchesStringStartsWithRestriction(ps.getPnr(), value, true);
            }
            if (Conditions.ENDS_WITH.equals(condition)) {
                return ps.getPnr() != null && RulesHelper.matchesStringEndsWithRestriction(ps.getPnr(), value, true);
            }
            return true;
        }
    }
    ,
    INSURANCE_TOURISTIC_E_TICKET{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_E_TICKET);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.INSURANCE_TOURISTIC_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_E_TICKET_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            InsuranceTouristicPropertiesProvider ps = (InsuranceTouristicPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return ps.isEticket() == (value == null ? false : (Boolean)value);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.isEticket() != (value == null ? false : (Boolean)value);
            }
            return true;
        }
    }
    ,
    INSURANCE_TOURISTIC_PAYMENT_SUM{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_Premium);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.AEROEXPRESS_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_FARE_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            InsuranceTouristicPropertiesProvider ps = (InsuranceTouristicPropertiesProvider)propertySet;
            double dv = value == null ? 0.0 : (Double)value;
            double fare = ps.getPaymentSum();
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) >= 0.01;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return fare - dv >= 0.01;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || fare - dv >= 0.01;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return dv - fare >= 0.01;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || dv - fare >= 0.01;
            }
            return true;
        }
    }
    ,
    INSURANCE_TOURISTIC_VENDOR_PAYMENT_TYPES{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_vendorFop);
        }

        public String getRendererId() {
            return ValueTypes.PAYMENT_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.INSURANCE_TOURISTIC_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.Properties_vendorFop_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            InsuranceTouristicPropertiesProvider ps = (InsuranceTouristicPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getVendorPaymentTypes(), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getVendorPaymentTypes(), (List)value, false);
            }
            return true;
        }
    }
    ,
    INSURANCE_TOURISTIC_CREDIT_CARD_TYPE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CreditCardType);
        }

        public String getRendererId() {
            return ValueTypes.CREDIT_CARD_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.INSURANCE_TOURISTIC_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_CreditCardType_info), cond.getDisplayName(), RulesHelper.values2text((List)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            if (propertySet instanceof ClientCreditCardVendorProvider) {
                ClientCreditCardVendorProvider prov = (ClientCreditCardVendorProvider)propertySet;
                if (Conditions.EQUALS.equals(condition)) {
                    return RulesHelper.matchesEnumRestriction(prov.getClientCreditCardVendor(), (List)value, true);
                }
                return RulesHelper.matchesEnumRestriction(prov.getClientCreditCardVendor(), (List)value, false);
            }
            return false;
        }
    }
    ,
    INSURANCE_TOURISTIC_CLIENT_PAYMENT_TYPES{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_clientFop);
        }

        public String getRendererId() {
            return ValueTypes.PAYMENT_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.INSURANCE_TOURISTIC_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.Properties_clientFop_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            InsuranceTouristicPropertiesProvider ps = (InsuranceTouristicPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getClientPaymentTypes(), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getClientPaymentTypes(), (List)value, false);
            }
            return true;
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    @Override
    public abstract String[] getConditionIds();
}

