/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.ProductTicketInfoPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.SalesPointPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.SupplierPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum ProductTicketInfoProperties implements RuleProperty,
RulePropertyConditions
{
    PRODUCT_BLANK_OWNERS{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_BLANK_OWNERS);
        }

        public String getRendererId() {
            return ValueTypes.PRODUCT_BLANK_OWNERS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_BLANK_OWNERS_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ProductTicketInfoPropertiesProvider provider = (ProductTicketInfoPropertiesProvider)propertySet;
            List blankOwners = (List)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEntityRestriction(Collections.singletonList(provider.getBlankOwner()), blankOwners, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEntityRestriction(Collections.singletonList(provider.getBlankOwner()), blankOwners, false);
            }
            return false;
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    SUPPLIERS{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_Supplier);
        }

        public String getRendererId() {
            return ValueTypes.SUPPLIERS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_Supplier_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            SupplierPropertyProvider provider = (SupplierPropertyProvider)propertySet;
            ArrayList suppliers = (ArrayList)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEntityRestriction(Collections.singletonList(provider.getSupplier()), suppliers, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEntityRestriction(Collections.singletonList(provider.getSupplier()), suppliers, false);
            }
            return false;
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    TICKETING_AGENTS{

        public String getDisplayName() {
            return L10n.get((String)Messages.RULES_PROPERTIES_ISSUING_AGENT);
        }

        public String getRendererId() {
            return ValueTypes.PERSONS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RULES_PROPERTIES_ISSUING_AGENT_X, (Object[])new Object[]{cond.getDisplayName(), ((List)value).size() + L10n.get((String)Messages.Pieces)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ProductTicketInfoPropertiesProvider provider = (ProductTicketInfoPropertiesProvider)propertySet;
            ArrayList ticketingAgents = (ArrayList)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return provider.getTicketingAgent() != null && RulesHelper.matchesStringRestriction(Collections.singletonList(provider.getTicketingAgent().getUid()), (Object)ticketingAgents, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return provider.getTicketingAgent() != null && RulesHelper.matchesStringRestriction(Collections.singletonList(provider.getTicketingAgent().getUid()), (Object)ticketingAgents, false);
            }
            return false;
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    PRODUCT_SALES_POINTS{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SalesPoint);
        }

        public String getRendererId() {
            return ValueTypes.SALES_POINTS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_SalesPoint, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            SalesPointPropertyProvider provider = (SalesPointPropertyProvider)propertySet;
            ArrayList salesPoints = (ArrayList)value;
            EntityReference<SalesPoint> salesPoint = provider.getSalesPoint();
            if (Conditions.INCLUDE.equals(condition)) {
                return salesPoint != null && RulesHelper.matchesStringRestriction(Collections.singletonList(salesPoint.getUid()), (Object)salesPoints, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return salesPoint != null && RulesHelper.matchesStringRestriction(Collections.singletonList(salesPoint.getUid()), (Object)salesPoints, false);
            }
            return false;
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    };


    public String getId() {
        return this.name();
    }

    @Override
    public abstract String[] getConditionIds();
}

