/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategoryReference;
import com.gridnine.xtrip.common.model.booking.SalesOriginContent;
import com.gridnine.xtrip.common.model.booking.SalesOriginProvider;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.FlightDistance;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.AircraftReference;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.AirTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.BasicAirTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.BasicCommonTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.BookingClassPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.ClientCreditCardVendorProvider;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Constants;
import com.gridnine.xtrip.common.model.rules.standard.EmployeeCategoriesProvider;
import com.gridnine.xtrip.common.model.rules.standard.EticketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.GdsNamePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.IssueDatePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.LuggagePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.MarketingCarrierPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.OperatingCarrierPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.PnrPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ProductPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RemarksPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ReservationPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RouteSegmentsRestriction;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.SalesContextPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.SegmentRestrictions;
import com.gridnine.xtrip.common.model.rules.standard.SpecialFaresPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.TchRouteRestrictions;
import com.gridnine.xtrip.common.model.rules.standard.TechnicalFeePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TourCodesPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.TransatlanticPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.TravelSubjectPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TravelSubjectTotalPriceRestrictions;
import com.gridnine.xtrip.common.model.rules.standard.TravelSubjectsPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.ValidatingCarrierPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.rules.standard.formOfPayment.FOPTargets;
import com.gridnine.xtrip.common.model.rules.standard.qualityCheck.QualityCheckTargets;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyTargets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

public enum Properties implements RuleProperty,
RulePropertyConditions
{
    AGENCY_COUNTRY_CODES{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_AgencyCountryCodes);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_AgencyCountryCodes_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getAgencyCountryCodes(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getAgencyCountryCodes(), value, false);
            }
            return true;
        }
    }
    ,
    BLANK_OWNERS{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_BLANK_OWNERS);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_BLANK_OWNERS_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getBlankOwners(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getBlankOwners(), value, false);
            }
            return true;
        }
    }
    ,
    BLANK_TYPES{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_BLANK_TYPES);
        }

        public String getRendererId() {
            return ValueTypes.BLANK_TYPES.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_BLANK_TYPES_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesDictRestriction(ps.getBlankType(), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesDictRestriction(ps.getBlankType(), (List)value, false);
            }
            return true;
        }
    }
    ,
    TRANSFER_TARIFF{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TransferTariff);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.RuleProperty_TransferTariff_info1) : L10n.get((String)Messages.RuleProperty_TransferTariff_info2));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            return ps.isHasTransferTariffs() == (value != null && (Boolean)value != false);
        }
    }
    ,
    PRIMARY_CARRIER_COUNTRY{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PrimaryCarrierCountry);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_PrimaryCarrierCountry_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getPrimaryCarrierCountry(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getPrimaryCarrierCountry(), value, false);
            }
            return true;
        }
    }
    ,
    VALIDATING_CARRIER{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CARRIERS);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{FOPTargets.FOP_CHECK_RESERVATION.getId(), QualityCheckTargets.QUALITY_CHECK_RESERVATION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_CARRIERS_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ValidatingCarrierPropertiesProvider ps = (ValidatingCarrierPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getValidatingCarriers(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getValidatingCarriers(), value, false);
            }
            return true;
        }
    }
    ,
    CARRIERS{

        public double getRank() {
            return 0.1;
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.CONTAINS_ONLY.name()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CARRIERS);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_CARRIERS_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getCarriers(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getCarriers(), value, false);
            }
            if (Conditions.CONTAINS_ONLY.equals(condition)) {
                return RulesHelper.containsOnly(ps.getAllValidatingCarriersCodes(), RulesHelper.toStringCollection(value), true);
            }
            return true;
        }
    }
    ,
    MARKETING_CARRIER{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_AIRLINES);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{FOPTargets.FOP_CHECK_RESERVATION.getId(), QualityCheckTargets.QUALITY_CHECK_RESERVATION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_AIRLINES_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            MarketingCarrierPropertiesProvider ps = (MarketingCarrierPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getMarketingCarriers(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getMarketingCarriers(), value, false);
            }
            return true;
        }
    }
    ,
    AIRLINES{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.CONFINED_TO.getId(), Conditions.CONTAINS_ONLY.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_AIRLINES);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_AIRLINES_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getAirlines(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getAirlines(), value, false);
            }
            if (Conditions.CONFINED_TO.equals(condition)) {
                return RulesHelper.confinedTo(ps.getSegmentAirlines(), RulesHelper.toStringCollection(value));
            }
            if (Conditions.CONTAINS_ONLY.equals(condition)) {
                return RulesHelper.containsOnly(ps.getSegmentAirlines(), RulesHelper.toStringCollection(value));
            }
            return true;
        }
    }
    ,
    OPERATING_CARRIER{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_OperatingAirlines);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{FOPTargets.FOP_CHECK_RESERVATION.getId(), QualityCheckTargets.QUALITY_CHECK_RESERVATION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_OperatingAirlines_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            OperatingCarrierPropertiesProvider ps = (OperatingCarrierPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getOperatingCarriers(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getOperatingCarriers(), value, false);
            }
            return true;
        }
    }
    ,
    OPERATING_AIRLINES{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.CONFINED_TO.getId(), Conditions.CONTAINS_ONLY.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_OperatingAirlines);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_OperatingAirlines_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getOperatingAirlines(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getOperatingAirlines(), value, false);
            }
            if (Conditions.CONFINED_TO.equals(condition)) {
                List<String> airlineCodes = RulesHelper.toStringCollection(value);
                return RulesHelper.containsOnly(ps.getSegmentOperatingAirlines(), airlineCodes, false);
            }
            if (Conditions.CONTAINS_ONLY.equals(condition)) {
                List<String> airlineCodes = RulesHelper.toStringCollection(value);
                return RulesHelper.containsOnly(ps.getSegmentOperatingAirlines(), airlineCodes, true);
            }
            return true;
        }
    }
    ,
    SALES_POINT_COUNTRY_CODES{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SalesPointCountryCodes);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_SalesPointCountryCodes_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getSalesPointCountryCodes(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getSalesPointCountryCodes(), value, false);
            }
            return true;
        }
    }
    ,
    FIRST_SEGMENT_AIRLINE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_FirstSegmentAirline);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_FirstSegmentAirline_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getFirstSegmentAirline(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getFirstSegmentAirline(), value, false);
            }
            return true;
        }
    }
    ,
    TAX_CODES{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TaxCodes);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TaxCodes_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getTaxCodes(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getTaxCodes(), value, false);
            }
            return true;
        }
    }
    ,
    TRANSPORTATION_TYPE{
        private final List<String> cis = Collections.singletonList("CIS");
        private final List<String> notCis = Collections.singletonList("!CIS");

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.TRANSPORTATION_DOMESTIC.getId(), Conditions.TRANSPORTATION_INTRENATIONAL.getId(), Conditions.TRANSPORTATION_INSIDE_CIS.getId(), Conditions.TRANSPORTATION_OUTSIDE_CIS.getId(), Conditions.TRANSPORTATION_INSIDE_COUNTRY.getId(), Conditions.TRANSPORTATION_OUTSIDE_COUNTRY.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TRANSPORTATION_TYPE);
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            if (cond.hasRightSide()) {
                buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TRANSPORTATION_TYPE_info1, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
            } else {
                buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TRANSPORTATION_TYPE_info2, (Object[])new Object[]{cond.getDisplayName()}));
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BasicAirTicketPropertiesProvider ps = (BasicAirTicketPropertiesProvider)propertySet;
            if (Conditions.TRANSPORTATION_DOMESTIC.equals(condition)) {
                return Constants.TRANSPORTATION_DOMESTIC.name().equals(ps.getTransportationType());
            }
            if (Conditions.TRANSPORTATION_INTRENATIONAL.equals(condition)) {
                return Constants.TRANSPORTATION_INTRENATIONAL.name().equals(ps.getTransportationType());
            }
            if (Conditions.TRANSPORTATION_COMBINED.equals(condition)) {
                return Constants.TRANSPORTATION_INTRENATIONAL.name().equals(ps.getTransportationType());
            }
            if (Conditions.TRANSPORTATION_INSIDE_CIS.equals(condition)) {
                return RulesHelper.collectionContains(ps.getVisitedCities(), this.cis, true) && RulesHelper.collectionContains(ps.getVisitedCities(), this.notCis, false);
            }
            if (Conditions.TRANSPORTATION_OUTSIDE_CIS.equals(condition)) {
                return RulesHelper.collectionContains(ps.getVisitedCities(), this.notCis, true);
            }
            if (Conditions.TRANSPORTATION_INSIDE_COUNTRY.equals(condition)) {
                return RulesHelper.collectionContains(ps.getVisitedCities(), Collections.singletonList((String)value), true) && RulesHelper.collectionContains(ps.getVisitedCities(), Collections.singletonList("!" + value), false);
            }
            if (Conditions.TRANSPORTATION_OUTSIDE_COUNTRY.equals(condition)) {
                return RulesHelper.collectionContains(ps.getVisitedCities(), Collections.singletonList("!" + value), true);
            }
            return true;
        }
    }
    ,
    INTERLINE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INTERLINE.getId(), Conditions.NOT_INTERLINE.getId(), Conditions.INTERLINE_LESS_THAN_HALF.getId(), Conditions.INTERLINE_NOT_LESS_THAN_HALF.getId(), Conditions.INTERLINE_NOT_LESS_THAN_75.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_INTERLINE);
        }

        public String getRendererId() {
            return ValueTypes.NULL.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(cond.getDisplayName());
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INTERLINE.equals(condition)) {
                return ps.isInterline();
            }
            if (Conditions.NOT_INTERLINE.equals(condition)) {
                return !ps.isInterline();
            }
            if (Conditions.INTERLINE_LESS_THAN_HALF.equals(condition)) {
                return 2 * ps.getNumOfInterlineSegments() > ps.getNumOfSegments();
            }
            if (Conditions.INTERLINE_NOT_LESS_THAN_HALF.equals(condition)) {
                return ps.isInterline() && 2 * ps.getNumOfInterlineSegments() <= ps.getNumOfSegments();
            }
            if (Conditions.INTERLINE_NOT_LESS_THAN_75.equals(condition)) {
                return ps.isInterline() && 4 * ps.getNumOfInterlineSegments() <= ps.getNumOfSegments();
            }
            return true;
        }
    }
    ,
    RETURN_TYPE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.RETURN_TYPE_FORCED.getId(), Conditions.RETURN_TYPE_UNFORCED.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ReturnType);
        }

        public String getRendererId() {
            return ValueTypes.NULL.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId(), Targets.HOTELS_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            if (cond.hasRightSide()) {
                buf.append(cond.getDisplayName()).append(" \"").append(value).append('\"');
            } else {
                buf.append(cond.getDisplayName());
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ProductPropertiesProvider ps = (ProductPropertiesProvider)propertySet;
            boolean isForcedRefund = ps.isForcedRefund();
            return Conditions.RETURN_TYPE_FORCED.equals(condition) == isForcedRefund;
        }
    }
    ,
    TARIFF_TYPE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.TARIFF_TYPE_BLOCKCHARTER.getId(), Conditions.TARIFF_TYPE_CHARTER.getId(), Conditions.TARIFF_TYPE_REGULAR.getId(), Conditions.TARIFF_TYPE_GROUP.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TARIFF_TYPE);
        }

        public String getRendererId() {
            return ValueTypes.TARIFF_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TARIFF_TYPE_info, (Object[])new Object[]{cond.getDisplayName()}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.TARIFF_TYPE_BLOCKCHARTER.equals(condition)) {
                return TariffType.BLOCKCHARTER.name().equals(ps.getTariffType());
            }
            if (Conditions.TARIFF_TYPE_CHARTER.equals(condition)) {
                return TariffType.CHARTER.name().equals(ps.getTariffType());
            }
            if (Conditions.TARIFF_TYPE_REGULAR.equals(condition)) {
                return TariffType.REGULAR.name().equals(ps.getTariffType());
            }
            if (Conditions.TARIFF_TYPE_GROUP.equals(condition)) {
                return TariffType.GROUP.name().equals(ps.getTariffType());
            }
            return true;
        }
    }
    ,
    FLIGHT_DISTANCE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.FLIGHT_DISTANCE_SHORT.getId(), Conditions.FLIGHT_DISTANCE_MEDIUM.getId(), Conditions.FLIGHT_DISTANCE_LONG.getId(), Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_FLIGHT_DISTANCE);
        }

        public String getRendererId() {
            return ValueTypes.FLIGHT_DISTANCE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            if (cond == Conditions.EQUALS || cond == Conditions.NOT_EQUALS) {
                buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_FLIGHT_DISTANCE_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
                return;
            }
            buf.append(cond.getDisplayName());
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.FLIGHT_DISTANCE_SHORT.equals(condition)) {
                return ps.getFlightDistance() == FlightDistance.SHORT;
            }
            if (Conditions.FLIGHT_DISTANCE_MEDIUM.equals(condition)) {
                return ps.getFlightDistance() == FlightDistance.MEDIUM;
            }
            if (Conditions.FLIGHT_DISTANCE_LONG.equals(condition)) {
                return ps.getFlightDistance() == FlightDistance.LONG;
            }
            List values = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return values != null && RulesHelper.matchesEnumRestriction(ps.getFlightDistance(), values, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return values != null && RulesHelper.matchesEnumRestriction(ps.getFlightDistance(), values, false);
            }
            return true;
        }
    }
    ,
    PASSENGER_TYPE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PassengerType);
        }

        public String getRendererId() {
            return ValueTypes.PASSENGER_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_PassengerType_info), cond.getDisplayName(), RulesHelper.toString(value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesDictRestriction(ps.getPassengerType(), (List)value, true);
            }
            return RulesHelper.matchesDictRestriction(ps.getPassengerType(), (List)value, false);
        }
    }
    ,
    PASSENGER_TYPE_CATEGORY{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PassengerTypeCategory);
        }

        public String getRendererId() {
            return ValueTypes.PASSENGER_TYPE_CATEGORY.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            StringBuilder sb = new StringBuilder();
            for (PassengerTypeCategoryReference ref : (List)value) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (StringUtils.isBlank((String)ref.getCaption())) {
                    sb.append(ref.getCode());
                    continue;
                }
                sb.append(ref);
            }
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_PassengerTypeCategory_info), cond.getDisplayName(), sb));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesDictRestriction(ps.getPassengerTypeCategories(), (List)value, true);
            }
            return RulesHelper.matchesDictRestriction(ps.getPassengerTypeCategories(), (List)value, false);
        }
    }
    ,
    CREDIT_CARD_TYPE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CreditCardType);
        }

        public String getRendererId() {
            return ValueTypes.CREDIT_CARD_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_CreditCardType_info), cond.getDisplayName(), RulesHelper.values2text((List)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            if (propertySet instanceof ClientCreditCardVendorProvider) {
                ClientCreditCardVendorProvider prov = (ClientCreditCardVendorProvider)propertySet;
                if (Conditions.EQUALS.equals(condition)) {
                    return RulesHelper.matchesEnumRestriction(prov.getClientCreditCardVendor(), (List)value, true);
                }
                return RulesHelper.matchesEnumRestriction(prov.getClientCreditCardVendor(), (List)value, false);
            }
            return false;
        }
    }
    ,
    BRANCHES{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_Branches);
        }

        public String getRendererId() {
            return ValueTypes.BRANCHES.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_Branches_info), cond.getDisplayName(), this.toString((List)value)));
        }

        private String toString(List<String> value) {
            if (value == null || value.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (String uid : value) {
                String title = "???";
                try {
                    EntityContainer ctr = EntityStorage.get().resolve(new EntityReference(uid, Branch.class, null));
                    if (ctr != null) {
                        title = ctr.toReference().toString();
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error("unable to resolve reference", (Throwable)e);
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(title);
            }
            return sb.toString();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            List uids = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getBranchUid(), (Object)uids, true);
            }
            return RulesHelper.matchesStringRestriction(ps.getBranchUid(), (Object)uids, false);
        }
    }
    ,
    SALES_POINTS{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SalesPoint);
        }

        public String getRendererId() {
            return ValueTypes.SALES_POINTS.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_SalesPoint_info), cond.getDisplayName(), this.toString((List)value)));
        }

        private String toString(List<String> value) {
            if (value == null || value.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (String uid : value) {
                String title = "???";
                try {
                    EntityContainer ctr = EntityStorage.get().resolve(new EntityReference(uid, SalesPoint.class, null));
                    if (ctr != null) {
                        title = ctr.toReference().toString();
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error("unable to resolve reference", (Throwable)e);
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(title);
            }
            return sb.toString();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            List uids = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getSalesPointUid(), (Object)uids, true);
            }
            return RulesHelper.matchesStringRestriction(ps.getSalesPointUid(), (Object)uids, false);
        }
    }
    ,
    SPECIAL_TARIFF{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SpecialTariff);
        }

        public String getRendererId() {
            return ValueTypes.SPECIAL_TARIFF.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_SpecialTariff_info), cond.getDisplayName(), RulesHelper.toString(value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getSpecialTariffs(), (List)value, true);
            }
            return RulesHelper.matchesEnumRestriction(ps.getSpecialTariffs(), (List)value, false);
        }
    }
    ,
    SPECIAL_FARE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.IS_PUBLIC_FARE.getId(), Conditions.IS_PRIVATE_FARE.getId(), Conditions.IS_PRIVATE_FARE_WITH_ACCOUNT_CODE.getId(), Conditions.IS_PRIVATE_FARE_WITH_SPECIFIC_ACCOUNT_CODE.getId(), Conditions.IS_NOT_PRIVATE_FARE_WITH_SPECIFIC_ACCOUNT_CODE.getId(), Conditions.IS_PRIVATE_FARE_WITHOUT_ACCOUNT_CODE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SpecialFare);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{QualityCheckTargets.QUALITY_CHECK_RESERVATION.getId(), FOPTargets.FOP_CHECK_RESERVATION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            if (cond == Conditions.IS_PRIVATE_FARE_WITH_SPECIFIC_ACCOUNT_CODE || cond == Conditions.IS_NOT_PRIVATE_FARE_WITH_SPECIFIC_ACCOUNT_CODE) {
                buf.append(String.format(L10n.get((String)Messages.RuleProperty_SpecialFareWithAccountCode_info), cond.getDisplayName(), RulesHelper.toString(value)));
            } else {
                buf.append(String.format(L10n.get((String)Messages.RuleProperty_SpecialFare_info), cond.getDisplayName()));
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            SpecialFaresPropertiesProvider ps = (SpecialFaresPropertiesProvider)propertySet;
            if (condition == Conditions.IS_PUBLIC_FARE) {
                return ps.getSpecialFares().stream().anyMatch(p -> !BooleanUtil.nullAsFalse((Boolean)((Boolean)p.getFirst())));
            }
            if (condition == Conditions.IS_PRIVATE_FARE) {
                return ps.getSpecialFares().stream().anyMatch(p -> BooleanUtil.nullAsFalse((Boolean)((Boolean)p.getFirst())));
            }
            if (condition == Conditions.IS_PRIVATE_FARE_WITH_ACCOUNT_CODE) {
                return ps.getSpecialFares().stream().anyMatch(p -> BooleanUtil.nullAsFalse((Boolean)((Boolean)p.getFirst())) && !((Set)p.getSecond()).isEmpty());
            }
            if (condition == Conditions.IS_PRIVATE_FARE_WITHOUT_ACCOUNT_CODE) {
                return ps.getSpecialFares().stream().anyMatch(p -> BooleanUtil.nullAsFalse((Boolean)((Boolean)p.getFirst())) && ((Set)p.getSecond()).isEmpty());
            }
            if (condition == Conditions.IS_NOT_PRIVATE_FARE_WITH_SPECIFIC_ACCOUNT_CODE) {
                return ps.getSpecialFares().stream().anyMatch(p -> ((Set)p.getSecond()).stream().anyMatch(a -> !RulesHelper.toStringCollection(value).contains(a)));
            }
            if (condition == Conditions.IS_PRIVATE_FARE_WITH_SPECIFIC_ACCOUNT_CODE) {
                return ps.getSpecialFares().stream().anyMatch(p -> BooleanUtil.nullAsFalse((Boolean)((Boolean)p.getFirst())) && ((Set)p.getSecond()).stream().anyMatch(a -> RulesHelper.toStringCollection(value).contains(a)));
            }
            return true;
        }
    }
    ,
    PASSENGER_STATUS{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PassengerStatus);
        }

        public String getRendererId() {
            return ValueTypes.PASSENGER_STATUS.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_PassengerStatus_info), cond.getDisplayName(), RulesHelper.toString(value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getPassengerStatus(), (List)value, true);
            }
            return RulesHelper.matchesEnumRestriction(ps.getPassengerStatus(), (List)value, false);
        }
    }
    ,
    ROUTE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.BEGINS_WITH.getId(), Conditions.NOT_BEGINS_WITH.getId(), Conditions.ENDS_WITH.getId(), Conditions.NOT_ENDS_WITH.getId(), Conditions.CONTAINS_ONLY.getId(), Conditions.CONFINED_TO.getId(), Conditions.NOT_CONFINED_TO.getId(), Conditions.CONTAINS_SEGMENT.getId(), Conditions.EXCLUDES_SEGMENT.getId(), Conditions.TRANSATLANTIC_FLIGHT.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ROUTE);
        }

        public String getRendererId() {
            return ValueTypes.ROUTE_RESTRICTION.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            if (Conditions.TRANSATLANTIC_FLIGHT.equals(cond)) {
                buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.RuleProperty_TransatlanticFlight_info1) : L10n.get((String)Messages.RuleProperty_TransatlanticFlight_info2));
                return;
            }
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ROUTE_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BasicAirTicketPropertiesProvider ps = (BasicAirTicketPropertiesProvider)propertySet;
            if (Conditions.TRANSATLANTIC_FLIGHT.equals(condition)) {
                if (ps instanceof TransatlanticPropertyProvider) {
                    TransatlanticPropertyProvider aps = (TransatlanticPropertyProvider)((Object)ps);
                    return Boolean.valueOf(aps.isTransatlanticFlight()).equals(value);
                }
                return false;
            }
            List<String> values = RulesHelper.toStringCollection(value);
            if (Conditions.INCLUDE.equals(condition)) {
                List negValues = values.stream().filter(v -> v.matches("^!.*")).collect(Collectors.toList());
                List<String> posValues = values.stream().filter(v -> !v.matches("^!.*")).collect(Collectors.toList());
                Boolean result = null;
                if (!negValues.isEmpty()) {
                    result = ps.getVisitedGeolocations().stream().anyMatch(location -> RulesHelper.collectionIncludes(Arrays.asList(location), negValues));
                }
                if (!posValues.isEmpty()) {
                    result = result == null ? Boolean.valueOf(RulesHelper.collectionIncludes(ps.getAllLocations(), posValues)) : Boolean.valueOf(result != false && RulesHelper.collectionIncludes(ps.getAllLocations(), posValues));
                }
                return result != null ? result : false;
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return !RulesHelper.collectionIncludes(ps.getAllLocations(), values);
            }
            if (Conditions.BEGINS_WITH.equals(condition)) {
                return RulesHelper.collectionIncludes(ps.getDepartureLocations(), values);
            }
            if (Conditions.NOT_BEGINS_WITH.equals(condition)) {
                return !RulesHelper.collectionIncludes(ps.getDepartureLocations(), values);
            }
            if (Conditions.ENDS_WITH.equals(condition)) {
                return RulesHelper.collectionIncludes(ps.getArrivalLocations(), values);
            }
            if (Conditions.NOT_ENDS_WITH.equals(condition)) {
                return !RulesHelper.collectionIncludes(ps.getArrivalLocations(), values);
            }
            if (Conditions.CONTAINS_ONLY.equals(condition)) {
                return RulesHelper.containsOnly(ps.getVisitedGeolocations(), values);
            }
            if (Conditions.CONFINED_TO.equals(condition)) {
                return RulesHelper.confinedTo(ps.getVisitedGeolocations(), RulesHelper.getCorrectedValues(values));
            }
            if (Conditions.NOT_CONFINED_TO.equals(condition)) {
                return !RulesHelper.confinedTo(ps.getVisitedGeolocations(), RulesHelper.getCorrectedValues(values));
            }
            if (Conditions.CONTAINS_SEGMENT.equals(condition)) {
                return RulesHelper.containsSegment(ps.getFlightSegments(), values);
            }
            if (Conditions.EXCLUDES_SEGMENT.equals(condition)) {
                return !RulesHelper.containsSegment(ps.getFlightSegments(), values);
            }
            return true;
        }
    }
    ,
    LAST_ROUTE_POINT{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_LAST_ROUTE_POINT);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_LAST_ROUTE_POINT_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            List<String> values = RulesHelper.toStringCollection(value);
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.collectionIncludes(ps.getLastRoutePointCodes(), values);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return !RulesHelper.collectionIncludes(ps.getLastRoutePointCodes(), values);
            }
            return true;
        }
    }
    ,
    OPEN_JAW{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.BEGINS_WITH.getId(), Conditions.NOT_BEGINS_WITH.getId(), Conditions.ENDS_WITH.getId(), Conditions.NOT_ENDS_WITH.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_OPEN_JAW);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_OPEN_JAW_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (!ps.isHasOpenJaw()) {
                return false;
            }
            if (Conditions.BEGINS_WITH.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getOpenJawStart(), value, true);
            }
            if (Conditions.NOT_BEGINS_WITH.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getOpenJawStart(), value, false);
            }
            if (Conditions.ENDS_WITH.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getOpenJawEnd(), value, true);
            }
            if (Conditions.NOT_ENDS_WITH.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getOpenJawEnd(), value, false);
            }
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getOpenJawLoc(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getOpenJawLoc(), value, false);
            }
            return true;
        }
    }
    ,
    DEPARTURE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_DEPARTURE);
        }

        public String getRendererId() {
            return ValueTypes.DATE_INTERVAL.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return;
            }
            DateFormat dateFormat = 31.getDateFormat();
            if (Conditions.PERIOD_WITHIN.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10n.replace((String)Messages.RuleProperty_DEPARTURE_info_before, (Object[])new Object[]{dateFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DEPARTURE_info_after, (Object[])new Object[]{dateFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DEPARTURE_info_within, (Object[])new Object[]{dateFormat.format(di.getBeginDate()), dateFormat.format(di.getEndDate())}));
                }
                return;
            }
            if (Conditions.PERIOD_BEYOND.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DEPARTURE_info_after, (Object[])new Object[]{dateFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DEPARTURE_info_before, (Object[])new Object[]{dateFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DEPARTURE_info_beyond, (Object[])new Object[]{dateFormat.format(di.getBeginDate()), dateFormat.format(di.getEndDate())}));
                }
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BasicCommonTicketPropertiesProvider ps = (BasicCommonTicketPropertiesProvider)propertySet;
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return true;
            }
            if (Conditions.PERIOD_WITHIN.equals(condition)) {
                if (di.getBeginDate() == null) {
                    return ps.getDepartureDate() != null && ps.getDepartureDate().getTime() <= di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return ps.getDepartureDate() != null && ps.getDepartureDate().getTime() >= di.getBeginDate().getTime();
                }
                return ps.getDepartureDate() != null && ps.getDepartureDate().getTime() >= di.getBeginDate().getTime() && ps.getDepartureDate().getTime() <= di.getEndDate().getTime();
            }
            if (Conditions.PERIOD_BEYOND.equals(condition)) {
                if (di.getBeginDate() == null) {
                    return ps.getDepartureDate() != null && ps.getDepartureDate().getTime() > di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return ps.getDepartureDate() != null && ps.getDepartureDate().getTime() < di.getBeginDate().getTime();
                }
                return ps.getDepartureDate() != null && (ps.getDepartureDate().getTime() < di.getBeginDate().getTime() || ps.getDepartureDate().getTime() > di.getEndDate().getTime());
            }
            return true;
        }
    }
    ,
    DEPARURE_TIME{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_DepartureTime);
        }

        public String getRendererId() {
            return ValueTypes.TIME_INTERVAL.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return;
            }
            DateFormat timeFormat = RulesEnvironment.getTimeFormat();
            if (Conditions.PERIOD_WITHIN.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DepartureTime_info1, (Object[])new Object[]{timeFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DepartureTime_info2, (Object[])new Object[]{timeFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DepartureTime_info3, (Object[])new Object[]{timeFormat.format(di.getBeginDate()), timeFormat.format(di.getEndDate())}));
                }
                return;
            }
            if (Conditions.PERIOD_BEYOND.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DepartureTime_info2, (Object[])new Object[]{timeFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DepartureTime_info1, (Object[])new Object[]{timeFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DepartureTime_info4, (Object[])new Object[]{timeFormat.format(di.getBeginDate()), timeFormat.format(di.getEndDate())}));
                }
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BasicCommonTicketPropertiesProvider propertiesProvider = (BasicCommonTicketPropertiesProvider)propertySet;
            DateInterval dateInterval = (DateInterval)value;
            if (dateInterval == null || dateInterval.getBeginDate() == null && dateInterval.getEndDate() == null) {
                return true;
            }
            if (propertiesProvider.getDepartureDate() != null) {
                int departureTime = MiscUtil.getTime((Date)propertiesProvider.getDepartureDate());
                int beginTime = MiscUtil.getTime((Date)dateInterval.getBeginDate());
                int endTime = MiscUtil.getTime((Date)dateInterval.getEndDate());
                if (Conditions.PERIOD_WITHIN.equals(condition)) {
                    if (dateInterval.getBeginDate() == null) {
                        return departureTime <= endTime;
                    }
                    if (dateInterval.getEndDate() == null) {
                        return departureTime >= beginTime;
                    }
                    if (beginTime > endTime) {
                        return departureTime >= beginTime || departureTime <= endTime;
                    }
                    return departureTime >= beginTime && departureTime <= endTime;
                }
                if (Conditions.PERIOD_BEYOND.equals(condition)) {
                    if (dateInterval.getBeginDate() == null) {
                        return departureTime > endTime;
                    }
                    if (dateInterval.getEndDate() == null) {
                        return departureTime < beginTime;
                    }
                    if (beginTime > endTime) {
                        return departureTime < beginTime && departureTime > endTime;
                    }
                    return departureTime < beginTime || departureTime > endTime;
                }
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }
    }
    ,
    ARRIVAL{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ARRIVAL);
        }

        public String getRendererId() {
            return ValueTypes.DATE_INTERVAL.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return;
            }
            DateFormat dateFormat = 33.getDateFormat();
            if (Conditions.PERIOD_WITHIN.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ARRIVAL_info_before, (Object[])new Object[]{dateFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ARRIVAL_info_after, (Object[])new Object[]{dateFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ARRIVAL_info_within, (Object[])new Object[]{dateFormat.format(di.getBeginDate()), dateFormat.format(di.getEndDate())}));
                }
                return;
            }
            if (Conditions.PERIOD_BEYOND.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ARRIVAL_info_after, (Object[])new Object[]{dateFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ARRIVAL_info_before, (Object[])new Object[]{dateFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ARRIVAL_info_beyond, (Object[])new Object[]{dateFormat.format(di.getBeginDate()), dateFormat.format(di.getEndDate())}));
                }
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return true;
            }
            if (Conditions.PERIOD_WITHIN.equals(condition)) {
                if (di.getBeginDate() == null) {
                    return ps.getArrivalDate() != null && ps.getArrivalDate().getTime() <= di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return ps.getArrivalDate() != null && ps.getArrivalDate().getTime() >= di.getBeginDate().getTime();
                }
                return ps.getArrivalDate() != null && ps.getArrivalDate().getTime() >= di.getBeginDate().getTime() && ps.getArrivalDate().getTime() <= di.getEndDate().getTime();
            }
            if (Conditions.PERIOD_BEYOND.equals(condition)) {
                if (di.getBeginDate() == null) {
                    return ps.getArrivalDate() != null && ps.getArrivalDate().getTime() > di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return ps.getArrivalDate() != null && ps.getArrivalDate().getTime() < di.getBeginDate().getTime();
                }
                return ps.getArrivalDate() != null && (ps.getArrivalDate().getTime() < di.getBeginDate().getTime() || ps.getArrivalDate().getTime() > di.getEndDate().getTime());
            }
            return true;
        }
    }
    ,
    ARRIVAL_TIME{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ArrivalTime);
        }

        public String getRendererId() {
            return ValueTypes.TIME_INTERVAL.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return;
            }
            DateFormat timeFormat = RulesEnvironment.getTimeFormat();
            if (Conditions.PERIOD_WITHIN.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ArrivalTime_info1, (Object[])new Object[]{timeFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ArrivalTime_info2, (Object[])new Object[]{timeFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ArrivalTime_info3, (Object[])new Object[]{timeFormat.format(di.getBeginDate()), timeFormat.format(di.getEndDate())}));
                }
                return;
            }
            if (Conditions.PERIOD_BEYOND.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ArrivalTime_info2, (Object[])new Object[]{timeFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ArrivalTime_info1, (Object[])new Object[]{timeFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ArrivalTime_info4, (Object[])new Object[]{timeFormat.format(di.getBeginDate()), timeFormat.format(di.getEndDate())}));
                }
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider propertiesProvider = (AirTicketPropertiesProvider)propertySet;
            DateInterval dateInterval = (DateInterval)value;
            if (dateInterval == null || dateInterval.getBeginDate() == null && dateInterval.getEndDate() == null) {
                return true;
            }
            if (propertiesProvider.getArrivalDate() != null) {
                int arrivalTime = MiscUtil.getTime((Date)propertiesProvider.getArrivalDate());
                int beginTime = MiscUtil.getTime((Date)dateInterval.getBeginDate());
                int endTime = MiscUtil.getTime((Date)dateInterval.getEndDate());
                if (Conditions.PERIOD_WITHIN.equals(condition)) {
                    if (dateInterval.getBeginDate() == null) {
                        return arrivalTime <= endTime;
                    }
                    if (dateInterval.getEndDate() == null) {
                        return arrivalTime >= beginTime;
                    }
                    if (beginTime > endTime) {
                        return arrivalTime >= beginTime || arrivalTime <= endTime;
                    }
                    return arrivalTime >= beginTime && arrivalTime <= endTime;
                }
                if (Conditions.PERIOD_BEYOND.equals(condition)) {
                    if (dateInterval.getBeginDate() == null) {
                        return arrivalTime > endTime;
                    }
                    if (dateInterval.getEndDate() == null) {
                        return arrivalTime < beginTime;
                    }
                    if (beginTime > endTime) {
                        return arrivalTime < beginTime && arrivalTime > endTime;
                    }
                    return arrivalTime < beginTime || arrivalTime > endTime;
                }
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }
    }
    ,
    ISSUED{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ISSUED);
        }

        public String getRendererId() {
            return ValueTypes.DATE_INTERVAL.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return;
            }
            DateFormat dateFormat = 35.getDateFormat();
            if (Conditions.PERIOD_WITHIN.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ISSUED_info_before, (Object[])new Object[]{dateFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ISSUED_info_after, (Object[])new Object[]{dateFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ISSUED_info_within, (Object[])new Object[]{dateFormat.format(di.getBeginDate()), dateFormat.format(di.getEndDate())}));
                }
                return;
            }
            if (Conditions.PERIOD_BEYOND.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ISSUED_info_after, (Object[])new Object[]{dateFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ISSUED_info_before, (Object[])new Object[]{dateFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ISSUED_info_beyond, (Object[])new Object[]{dateFormat.format(di.getBeginDate()), dateFormat.format(di.getEndDate())}));
                }
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            IssueDatePropertiesProvider ps = (IssueDatePropertiesProvider)propertySet;
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return true;
            }
            if (Conditions.PERIOD_WITHIN.equals(condition)) {
                if (di.getBeginDate() == null) {
                    return ps.getIssueDate() != null && ps.getIssueDate().getTime() <= di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return ps.getIssueDate() != null && ps.getIssueDate().getTime() >= di.getBeginDate().getTime();
                }
                return ps.getIssueDate() != null && ps.getIssueDate().getTime() >= di.getBeginDate().getTime() && ps.getIssueDate().getTime() <= di.getEndDate().getTime();
            }
            if (Conditions.PERIOD_BEYOND.equals(condition)) {
                if (di.getBeginDate() == null) {
                    return ps.getIssueDate() != null && ps.getIssueDate().getTime() > di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return ps.getIssueDate() != null && ps.getIssueDate().getTime() < di.getBeginDate().getTime();
                }
                return ps.getIssueDate() != null && (ps.getIssueDate().getTime() < di.getBeginDate().getTime() || ps.getIssueDate().getTime() > di.getEndDate().getTime());
            }
            return true;
        }
    }
    ,
    FLIGHTS{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_FLIGHTS);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_FLIGHTS_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRangeRestriction(ps.getFlightNumbers(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRangeRestriction(ps.getFlightNumbers(), value, false);
            }
            return true;
        }
    }
    ,
    SERVICE_CLASSES{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.CONTAINS_ONLY.getId(), Conditions.CONFINED_TO.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SERVICE_CLASSES);
        }

        public String getRendererId() {
            return ValueTypes.CLASS_OF_SERVICE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_SERVICE_CLASSES_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getServiceClasses(), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getServiceClasses(), (List)value, false);
            }
            if (Conditions.CONTAINS_ONLY.equals(condition)) {
                List items = (List)value;
                StringBuilder buf = new StringBuilder();
                for (int n = 0; n < items.size(); ++n) {
                    if (n != 0) {
                        buf.append("-");
                    }
                    buf.append(((ClassOfService)items.get(n)).name());
                }
                return RulesHelper.includesOnly(ps.getServiceClasses(), Collections.singletonList(buf.toString()));
            }
            if (Conditions.CONFINED_TO.equals(condition)) {
                List items = (List)value;
                StringBuilder buf = new StringBuilder();
                for (int n = 0; n < items.size(); ++n) {
                    if (n != 0) {
                        buf.append("-");
                    }
                    buf.append(((ClassOfService)items.get(n)).name());
                }
                return RulesHelper.confinedTo(RulesHelper.to2DList(ps.getServiceClasses()), Collections.singletonList(buf.toString()));
            }
            return true;
        }
    }
    ,
    BOOKING_CLASSES{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.CONTAINS_ONLY.getId(), Conditions.CONFINED_TO.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_BOOKING_CLASSES);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_BOOKING_CLASSES_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BookingClassPropertyProvider ps = (BookingClassPropertyProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getBookingClasses(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getBookingClasses(), value, false);
            }
            if (Conditions.CONTAINS_ONLY.equals(condition)) {
                List<String> values = RulesHelper.toStringCollection(value);
                StringBuilder buf = new StringBuilder();
                for (int n = 0; n < values.size(); ++n) {
                    if (n != 0) {
                        buf.append("-");
                    }
                    buf.append(values.get(n));
                }
                return RulesHelper.includesOnly(ps.getBookingClasses(), Collections.singletonList(buf.toString()));
            }
            if (Conditions.CONFINED_TO.equals(condition)) {
                List<String> values = RulesHelper.toStringCollection(value);
                StringBuilder buf = new StringBuilder();
                for (int n = 0; n < values.size(); ++n) {
                    if (n != 0) {
                        buf.append("-");
                    }
                    buf.append(values.get(n));
                }
                return RulesHelper.confinedTo(RulesHelper.to2DList(ps.getBookingClasses()), Collections.singletonList(buf.toString()));
            }
            return true;
        }
    }
    ,
    FARE_BASIS{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.BEGINS_WITH.getId(), Conditions.ENDS_WITH.getId(), Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.FARE_BASIS_ALL_CODES_CONTAIN.getId(), Conditions.MATCHES_TEMPLATE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_FARE_BASIS);
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_FARE_BASIS_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (ps.getFareBasises().isEmpty()) {
                return false;
            }
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getFareBasises(), value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.getFareBasises() != null && RulesHelper.matchesStringRestriction(ps.getFareBasises(), value, false);
            }
            if (Conditions.BEGINS_WITH.equals(condition)) {
                return RulesHelper.matchesStringStartsWithRestriction(ps.getFareBasises(), value, true);
            }
            if (Conditions.ENDS_WITH.equals(condition)) {
                return RulesHelper.matchesStringEndsWithRestriction(ps.getFareBasises(), value, true);
            }
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringContainsRestriction(ps.getFareBasises(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringContainsRestriction(ps.getFareBasises(), value, false);
            }
            if (Conditions.FARE_BASIS_ALL_CODES_CONTAIN.equals(condition)) {
                List<String> values = RulesHelper.toStringCollection(value);
                for (String item : ps.getFareBasises()) {
                    if (TextUtil.isBlank((String)item)) continue;
                    boolean found = false;
                    for (String val : values) {
                        if (TextUtil.isBlank((String)val) || !item.contains(val)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                return true;
            }
            if (Conditions.MATCHES_TEMPLATE.equals(condition)) {
                List<String> values = RulesHelper.toStringCollection(value);
                Set fareBasises = ps.getFareBasises().stream().filter(TextUtil::nonBlank).collect(Collectors.toSet());
                if (fareBasises.isEmpty()) {
                    return false;
                }
                return fareBasises.stream().allMatch(str -> values.stream().filter(TextUtil::nonBlank).anyMatch(p -> RulesHelper.matchesPattern(str, p)));
            }
            return true;
        }
    }
    ,
    CARRIER_NUMBER{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.BEGINS_WITH.getId(), Conditions.ENDS_WITH.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CARRIER_NUMBER);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_CARRIER_NUMBER_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getCarrierNumber(), value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.getCarrierNumber() != null && RulesHelper.matchesStringRestriction(ps.getCarrierNumber(), value, false);
            }
            if (Conditions.BEGINS_WITH.equals(condition)) {
                return RulesHelper.matchesStringStartsWithRestriction(ps.getCarrierNumber(), value, true);
            }
            if (Conditions.ENDS_WITH.equals(condition)) {
                return RulesHelper.matchesStringEndsWithRestriction(ps.getCarrierNumber(), value, true);
            }
            return true;
        }
    }
    ,
    PCC{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PCC);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_PCC_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getPcc(), value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.getPcc() != null && RulesHelper.matchesStringRestriction(ps.getPcc(), value, false);
            }
            return true;
        }
    }
    ,
    PNR{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.BEGINS_WITH.getId(), Conditions.ENDS_WITH.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PNR);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_PNR_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            PnrPropertiesProvider ps = (PnrPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getPnr(), value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.getPnr() != null && RulesHelper.matchesStringRestriction(ps.getPnr(), value, false);
            }
            if (Conditions.BEGINS_WITH.equals(condition)) {
                return ps.getPnr() != null && RulesHelper.matchesStringStartsWithRestriction(ps.getPnr(), value, true);
            }
            if (Conditions.ENDS_WITH.equals(condition)) {
                return ps.getPnr() != null && RulesHelper.matchesStringEndsWithRestriction(ps.getPnr(), value, true);
            }
            return true;
        }
    }
    ,
    TOUR_CODE_TYPE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TourCodeType);
        }

        public String getRendererId() {
            return ValueTypes.TOUR_CODE_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{QualityCheckTargets.QUALITY_CHECK_RESERVATION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TourCodeType_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            TourCodesPropertyProvider ps = (TourCodesPropertyProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getTourCodeTypes(), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getTourCodeTypes(), (List)value, false);
            }
            return true;
        }
    }
    ,
    TOUR_CODES{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.NOT_SET.getId(), Conditions.NOT_EMPTY.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TourCodes);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{QualityCheckTargets.QUALITY_CHECK_RESERVATION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TourCodes_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            TourCodesPropertyProvider ps = (TourCodesPropertyProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getTourCodes(), value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getTourCodes(), value, false);
            }
            if (Conditions.NOT_SET.equals(condition)) {
                return ps.getTourCodes().isEmpty();
            }
            if (Conditions.NOT_EMPTY.equals(condition)) {
                return !ps.getTourCodes().isEmpty();
            }
            return true;
        }
    }
    ,
    TOUR_CODE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.BEGINS_WITH.getId(), Conditions.ENDS_WITH.getId(), Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.NOT_SET.getId(), Conditions.NOT_EMPTY.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TourCode);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TourCode_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getTourCode(), value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.getTourCode() != null && RulesHelper.matchesStringRestriction(ps.getTourCode(), value, false);
            }
            if (Conditions.BEGINS_WITH.equals(condition)) {
                return RulesHelper.matchesStringStartsWithRestriction(ps.getTourCode(), value, true);
            }
            if (Conditions.ENDS_WITH.equals(condition)) {
                return RulesHelper.matchesStringEndsWithRestriction(ps.getTourCode(), value, true);
            }
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringContainsRestriction(ps.getTourCode(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringContainsRestriction(ps.getTourCode(), value, false);
            }
            if (Conditions.NOT_SET.equals(condition)) {
                return TextUtil.isBlank((String)ps.getTourCode());
            }
            if (Conditions.NOT_EMPTY.equals(condition)) {
                return !TextUtil.isBlank((String)ps.getTourCode());
            }
            return true;
        }
    }
    ,
    ACCOUNT_CODE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.BEGINS_WITH.getId(), Conditions.ENDS_WITH.getId(), Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.NOT_SET.getId(), Conditions.NOT_EMPTY.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_AccountCode);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_AccountCode_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getAccountCode(), value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.getAccountCode() != null && RulesHelper.matchesStringRestriction(ps.getAccountCode(), value, false);
            }
            if (Conditions.BEGINS_WITH.equals(condition)) {
                return RulesHelper.matchesStringStartsWithRestriction(ps.getAccountCode(), value, true);
            }
            if (Conditions.ENDS_WITH.equals(condition)) {
                return RulesHelper.matchesStringEndsWithRestriction(ps.getAccountCode(), value, true);
            }
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringContainsRestriction(ps.getAccountCode(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringContainsRestriction(ps.getAccountCode(), value, false);
            }
            if (Conditions.NOT_SET.equals(condition)) {
                return TextUtil.isBlank((String)ps.getAccountCode());
            }
            if (Conditions.NOT_EMPTY.equals(condition)) {
                return !TextUtil.isBlank((String)ps.getAccountCode());
            }
            return true;
        }
    }
    ,
    CONTRACT_CODE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.BEGINS_WITH.getId(), Conditions.ENDS_WITH.getId(), Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.NOT_SET.getId(), Conditions.NOT_EMPTY.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ContractCode);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ContractCode_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            String contractCode = ps.getContractCode();
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(contractCode, value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return contractCode != null && RulesHelper.matchesStringRestriction(contractCode, value, false);
            }
            if (Conditions.BEGINS_WITH.equals(condition)) {
                return RulesHelper.matchesStringStartsWithRestriction(contractCode, value, true);
            }
            if (Conditions.ENDS_WITH.equals(condition)) {
                return RulesHelper.matchesStringEndsWithRestriction(contractCode, value, true);
            }
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringContainsRestriction(contractCode, value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringContainsRestriction(contractCode, value, false);
            }
            if (Conditions.NOT_SET.equals(condition)) {
                return TextUtil.isBlank((String)contractCode);
            }
            if (Conditions.NOT_EMPTY.equals(condition)) {
                return !TextUtil.isBlank((String)contractCode);
            }
            return true;
        }
    }
    ,
    AGENT_LOCATION{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.BEGINS_WITH.getId(), Conditions.ENDS_WITH.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_AGENT_LOCATION);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_AGENT_LOCATION_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getAgentLocation(), value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.getAgentLocation() != null && RulesHelper.matchesStringRestriction(ps.getAgentLocation(), value, false);
            }
            if (Conditions.BEGINS_WITH.equals(condition)) {
                return RulesHelper.matchesStringStartsWithRestriction(ps.getAgentLocation(), value, true);
            }
            if (Conditions.ENDS_WITH.equals(condition)) {
                return RulesHelper.matchesStringEndsWithRestriction(ps.getAgentLocation(), value, true);
            }
            return true;
        }
    }
    ,
    VALIDATOR{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_VALIDATOR);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_VALIDATOR_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getValidator(), value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.getValidator() != null && RulesHelper.matchesStringRestriction(ps.getValidator(), value, false);
            }
            return true;
        }
    }
    ,
    E_TICKET{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_E_TICKET);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_E_TICKET_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            EticketPropertiesProvider ps = (EticketPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return ps.isEticket() == (value != null && (Boolean)value != false);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.isEticket() != (value != null && (Boolean)value != false);
            }
            return true;
        }
    }
    ,
    HAS_CODE_SHARING{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HasCodeSharing);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.RuleProperty_HasCodeSharing_info1) : L10n.get((String)Messages.RuleProperty_HasCodeSharing_info2));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            return Boolean.valueOf(ps.isHasCodeSharing()).equals(value);
        }
    }
    ,
    IS_ISSUED_IN_EXCHANGE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_IsIssuedInExchange);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.RuleProperty_IsIssuedInExchange_info1) : L10n.get((String)Messages.RuleProperty_IsIssuedInExchange_info2));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            return Boolean.valueOf(ps.isIssuedInExchange()).equals(value);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }
    }
    ,
    CODE_SHARING{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.NOT_EMPTY.getId(), Conditions.NOT_SET.getId(), Conditions.INCLUDE.getId(), Conditions.NOT_SET_OR_INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.NOT_SET_OR_EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CodeSharing);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            if (cond == Conditions.NOT_EMPTY) {
                buf.append(L10n.get((String)Messages.RuleProperty_HasCodeSharing_info1));
            } else if (cond == Conditions.NOT_SET) {
                buf.append(L10n.get((String)Messages.RuleProperty_HasCodeSharing_info2));
            } else {
                buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_CodeSharing_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (condition == Conditions.NOT_EMPTY) {
                return ps.isHasCodeSharing();
            }
            if (condition == Conditions.NOT_SET) {
                return !ps.isHasCodeSharing();
            }
            if (condition == Conditions.NOT_SET_OR_INCLUDE) {
                return !ps.isHasCodeSharing() || RulesHelper.matchesStringRestriction(ps.getCodeShareAirlines(), value, true);
            }
            if (condition == Conditions.NOT_SET_OR_EXCLUDE) {
                return !ps.isHasCodeSharing() || RulesHelper.matchesStringRestriction(ps.getCodeShareAirlines(), value, false);
            }
            if (condition == Conditions.INCLUDE) {
                return ps.isHasCodeSharing() && RulesHelper.matchesStringRestriction(ps.getCodeShareAirlines(), value, true);
            }
            if (condition == Conditions.EXCLUDE) {
                return ps.isHasCodeSharing() && RulesHelper.matchesStringRestriction(ps.getCodeShareAirlines(), value, false);
            }
            return false;
        }
    }
    ,
    VAT{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.SIMPLE_TAXED.getId(), Conditions.NOT_SIMPLE_TAXED.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_VAT);
        }

        public String getRendererId() {
            return ValueTypes.NULL.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(cond == Conditions.SIMPLE_TAXED ? L10n.get((String)Messages.RuleProperty_VAT_info1) : L10n.get((String)Messages.RuleProperty_VAT_info2));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            return ps.isSimpleTaxed() == (condition == Conditions.SIMPLE_TAXED);
        }
    }
    ,
    GROUP_FARE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_GROUP_FARE);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_GROUP_FARE_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return ps.isGroupFare() == (value != null && (Boolean)value != false);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.isGroupFare() != (value != null && (Boolean)value != false);
            }
            return true;
        }
    }
    ,
    FARE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_FARE);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_FARE_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            double dv = value == null ? 0.0 : (Double)value;
            double fare = ps.getFare();
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) >= 0.01;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return fare - dv >= 0.01;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || fare - dv >= 0.01;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return dv - fare >= 0.01;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || dv - fare >= 0.01;
            }
            return true;
        }
    }
    ,
    FARE_DIFFERENCE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_FARE_DIFFERENCE);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_FARE_DIFFERENCE_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (!ps.isIssuedInExchange()) {
                return false;
            }
            double dv = value == null ? 0.0 : (Double)value;
            double fareDifference = ps.getFareDifference().doubleValue();
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(fareDifference - dv) < 0.01;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(fareDifference - dv) >= 0.01;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return fareDifference - dv >= 0.01;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fareDifference - dv) < 0.01 || fareDifference - dv >= 0.01;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return dv - fareDifference >= 0.01;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fareDifference - dv) < 0.01 || dv - fareDifference >= 0.01;
            }
            return true;
        }
    }
    ,
    TOTAL_DIFFERENCE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TOTAL_DIFFERENCE);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TOTAL_DIFFERENCE_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (!ps.isIssuedInExchange()) {
                return false;
            }
            double dv = value == null ? 0.0 : (Double)value;
            double totalDifference = ps.getTotalDifference().doubleValue();
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(totalDifference - dv) < 0.01;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(totalDifference - dv) >= 0.01;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return totalDifference - dv >= 0.01;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(totalDifference - dv) < 0.01 || totalDifference - dv >= 0.01;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return dv - totalDifference >= 0.01;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(totalDifference - dv) < 0.01 || dv - totalDifference >= 0.01;
            }
            return true;
        }
    }
    ,
    VENDOR_COMMISSION_RATE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_VendorCommissionRate);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(cond == Conditions.NOT_SET ? L10n.get((String)Messages.RuleProperty_VendorCommissionRate_info1) : String.format(L10n.get((String)Messages.RuleProperty_VendorCommissionRate_info2), cond.getDisplayName(), value));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            double percent;
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            double dv = value == null ? 0.0 : (Double)value;
            double d = percent = ps.getVendorCommissionRate() == null ? 0.0 : ps.getVendorCommissionRate();
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(percent - dv) < 0.001;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(percent - dv) >= 0.001;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return percent - dv >= 0.001;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(percent - dv) < 0.001 || percent - dv >= 0.001;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return dv - percent >= 0.001;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(percent - dv) < 0.001 || dv - percent >= 0.001;
            }
            return false;
        }
    }
    ,
    VENDOR_COMMISSION_VALUE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_VendorCommissionValue);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(cond == Conditions.NOT_SET ? L10n.get((String)Messages.RuleProperty_VendorCommissionValue_info1) : String.format(L10n.get((String)Messages.RuleProperty_VendorCommissionValue_info2), cond.getDisplayName(), value));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            double percent;
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            double dv = value == null ? 0.0 : (Double)value;
            double d = percent = ps.getVendorCommissionValue() == null ? 0.0 : ps.getVendorCommissionValue();
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(percent - dv) < 0.01;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(percent - dv) >= 0.01;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return percent - dv >= 0.01;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(percent - dv) < 0.01 || percent - dv >= 0.01;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return dv - percent >= 0.01;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(percent - dv) < 0.01 || dv - percent >= 0.01;
            }
            return false;
        }
    }
    ,
    BSP_COMMISSION_EQUIVALENT_VALUE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_BspCommissionEquivalentValue);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_BspCommissionEquivalentValue_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            double percent;
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            double dv = value == null ? 0.0 : (Double)value;
            double d = percent = ps.getBspCommissionEquivalentValue() == null ? 0.0 : ps.getBspCommissionEquivalentValue().doubleValue();
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(percent - dv) < 0.01;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(percent - dv) >= 0.01;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return percent - dv >= 0.01;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(percent - dv) < 0.01 || percent - dv >= 0.01;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return dv - percent >= 0.01;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(percent - dv) < 0.01 || dv - percent >= 0.01;
            }
            return false;
        }
    }
    ,
    SELL_TOTAL{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SellTotal);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_SellTotal_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            double dv = value == null ? 0.0 : (Double)value;
            double fare = ps.getSellTotal();
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) >= 0.01;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return fare - dv >= 0.01;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || fare - dv >= 0.01;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return dv - fare >= 0.01;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || dv - fare >= 0.01;
            }
            return true;
        }
    }
    ,
    ADD_COLLECT_TOTAL{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_AddCollectTotal);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_AddCollectTotal_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            double dv = value == null ? 0.0 : (Double)value;
            double fare = ps.getAddCollectTotal();
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) >= 0.01;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return fare - dv >= 0.01;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || fare - dv >= 0.01;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return dv - fare >= 0.01;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || dv - fare >= 0.01;
            }
            return true;
        }
    }
    ,
    PRICE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_Price);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_Price_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            double price;
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            double dv = value == null ? 0.0 : ((Number)value).doubleValue();
            BigDecimal value2 = ps.getPrice();
            double d = price = value2 != null ? value2.doubleValue() : 0.0;
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(price - dv) < 0.01;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(price - dv) >= 0.01;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return price - dv >= 0.01;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(price - dv) < 0.01 || price - dv >= 0.01;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return dv - price >= 0.01;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(price - dv) < 0.01 || dv - price >= 0.01;
            }
            return true;
        }
    }
    ,
    PRICE_IN_CURRENCY{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_Price_In_Currency);
        }

        public String getRendererId() {
            return ValueTypes.MONEY.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_Price_In_Currency_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            Money money = (Money)value;
            BigDecimal priceWithTaxes = ps.getPrice();
            BigDecimal rulePrice = money.getValue();
            if (ps.getPriceCurrency() == null) {
                return false;
            }
            ExchangeRateData rateData = MulticurrencyHelper.buildExchangeRateData(ps.getPriceCurrency(), money.getCurrency(), null, ps.getIssueDate(), ps.getSupplier(), true);
            BigDecimal convertedPrice = MulticurrencyHelper.convert(priceWithTaxes, rateData);
            if (Conditions.EQUALS.equals(condition)) {
                return convertedPrice.compareTo(rulePrice) == 0;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return convertedPrice.compareTo(rulePrice) != 0;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return convertedPrice.compareTo(rulePrice) > 0;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return convertedPrice.compareTo(rulePrice) >= 0;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return convertedPrice.compareTo(rulePrice) < 0;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return convertedPrice.compareTo(rulePrice) <= 0;
            }
            return true;
        }
    }
    ,
    TRAVEL_SUBJECT_LIST{
        private static final String DISPLAY_NAME = "\u0422\u0438\u043f \u0443\u0441\u043b\u0443\u0433\u0438";

        @Override
        public String[] getTargetIds() {
            return new String[0];
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public String getRendererId() {
            return ValueTypes.TRAVEL_SUBJECTS_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(DISPLAY_NAME).append(" ").append(cond.getDisplayName()).append(" \"").append(RulesHelper.toString(value)).append("\"");
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            TravelSubjectsPropertyProvider ps = (TravelSubjectsPropertyProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumsRestriction(ps.getTravelSubjects(), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumsRestriction(ps.getTravelSubjects(), (List)value, false);
            }
            return true;
        }
    }
    ,
    PRODUCT_CATEGORY{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_productCategory);
        }

        public String getRendererId() {
            return ValueTypes.PRODUCT_CATEGORY.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.Properties_productCategoryReplace, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (value == null) {
                return false;
            }
            String category = ps.getProductCategory();
            ProductCategory pc = (ProductCategory)value;
            if (Conditions.EQUALS.equals(condition)) {
                return pc.name().equals(category);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return category != null && !pc.name().equals(category);
            }
            return true;
        }
    }
    ,
    MCO_CATEGORY{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_mcoCategory);
        }

        public String getRendererId() {
            return ValueTypes.MCO_CATEGORY.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.Properties_mcoCategoryReplace, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            String category = ps.getMcoCategory();
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(category, (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(category, (List)value, false);
            }
            return true;
        }
    }
    ,
    GDS_NAME{

        public double getRank() {
            return 0.001;
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_GDS);
        }

        public String getRendererId() {
            return ValueTypes.GDS_NAME.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId(), Targets.TECHNICAL_FEE.getId(), Targets.TECHNICAL_FEE_SYSTEM.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_GDS_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            GdsNamePropertiesProvider ps = (GdsNamePropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getGdsName(), (List)value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getGdsName(), (List)value, false);
            }
            return true;
        }
    }
    ,
    RESERVATION_TYPE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ReservationType);
        }

        public String getRendererId() {
            return ValueTypes.RESERVATION_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId(), Targets.TECHNICAL_FEE.getId(), Targets.TECHNICAL_FEE_SYSTEM.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ReservationType_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getReservationType(), (List)value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getReservationType(), (List)value, false);
            }
            return true;
        }
    }
    ,
    PAYMENT_TYPES{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PAYMENT_TYPES);
        }

        public String getRendererId() {
            return ValueTypes.PAYMENT_TYPES_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_PAYMENT_TYPES_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getClientPaymentTypes(), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getClientPaymentTypes(), (List)value, false);
            }
            return true;
        }
    }
    ,
    SEGMENT{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            SegmentRestrictions.buildInfo(buf, cond, (SegmentRestrictions)value);
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_Segment);
        }

        public String getRendererId() {
            return ValueTypes.SEGMENT.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            Country country;
            String s;
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            boolean res = SegmentRestrictions.matchesSegmentRestrictions(ps.getVisitedCities(), ps.getSurfaceSegments(), ps.getConnectedFlights(), ps.getDomesticFlightsAC(), ps.getSegmentAirlines(), (SegmentRestrictions)value);
            if (res && (s = ((SegmentRestrictions)value).getRouteCodes()) != null && s.length() == 4 && s.startsWith("*-") && (country = (Country)DictionaryCache.get().findByCode(Country.class, s.substring(2))) != null) {
                ps.setCountryForVisaHolder((DictionaryReference<Country>)country.toReference());
            }
            return condition == Conditions.INCLUDE == res;
        }
    }
    ,
    ROUTE_SEGMENTS_RESTRICTION{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.CONTAINS_ONLY.getId()};
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            if (value instanceof RouteSegmentsRestriction) {
                ((RouteSegmentsRestriction)value).buildInfo(buf);
            }
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_RouteSegmentsRestriction);
        }

        public String getRendererId() {
            return ValueTypes.ROUTE_SEGMENTS_RESTRICTION.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (value instanceof RouteSegmentsRestriction) {
                RouteSegmentsRestriction restr = (RouteSegmentsRestriction)value;
                return restr.match(ps.getFlightSegments(), ps.getSurfaceSegments(), ps.getSegmentAirlines(), ps.getSegmentOperatingAirlines(), ps.getFlightNumbers());
            }
            return true;
        }
    }
    ,
    TCH_ROUTE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.TCH_ROUTE_ALL.getId(), Conditions.TCH_ROUTE_SEGMENT.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_tchRoute);
        }

        public String getRendererId() {
            return ValueTypes.TCH_ROUTE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            TchRouteRestrictions.TariffCodeRestriction tariffCode;
            TchRouteRestrictions.ClassOfBookingRestriction classOfBooking;
            TchRouteRestrictions.DepartureDaysRestriction departureDays;
            TchRouteRestrictions.DepartureDatesRestriction departureDates;
            TchRouteRestrictions.FlightNumbersRestriction flightNumbers;
            TchRouteRestrictions.RouteRestriction route;
            TchRouteRestrictions restr = (TchRouteRestrictions)value;
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
            buf.append(restr.isAppliedToSegment() ? L10n.get((String)Messages.Properties_appliedToSegment) : L10n.get((String)Messages.Properties_appliedToWholeTransportation));
            TchRouteRestrictions.InterlineRestriction interline = restr.getInterlineRestriction();
            if (interline != TchRouteRestrictions.InterlineRestriction.ALL) {
                buf.append("<br>");
                buf.append(L10nResourcesManager.getStr((String)Messages.Properties_interline, (Object[])new Object[]{interline}));
                if (interline != TchRouteRestrictions.InterlineRestriction.NONE) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_oneSpace, (Object[])new Object[]{TextUtil.isBlank((String)restr.getInterlineValue()) ? L10n.get((String)Messages.Properties_all) : restr.getInterlineValue()}));
                }
            }
            if ((route = restr.getRouteRestriction()) != TchRouteRestrictions.RouteRestriction.ALL) {
                buf.append("<br>");
                buf.append(L10nResourcesManager.getStr((String)Messages.Properties_route, (Object[])new Object[]{route}));
                buf.append(L10nResourcesManager.getStr((String)Messages.Properties_oneSpace, (Object[])new Object[]{restr.getRouteValue()}));
            }
            if ((flightNumbers = restr.getFlightNumbersRestriction()) != TchRouteRestrictions.FlightNumbersRestriction.ALL) {
                buf.append("<br>");
                buf.append(L10nResourcesManager.getStr((String)Messages.Properties_flightNumbers, (Object[])new Object[]{flightNumbers}));
                buf.append(L10nResourcesManager.getStr((String)Messages.Properties_oneSpace, (Object[])new Object[]{restr.getFlightNumbersValue()}));
            }
            if ((departureDates = restr.getDepartureDatesRestriction()) != TchRouteRestrictions.DepartureDatesRestriction.ALL) {
                buf.append("<br>");
                buf.append(L10nResourcesManager.getStr((String)Messages.Properties_departureDates, (Object[])new Object[]{departureDates}));
                Date fromValue = restr.getDepartureDatesFromValue();
                buf.append(L10nResourcesManager.getStr((String)Messages.Properties_from, (Object[])new Object[]{fromValue != null ? sdf.format(fromValue) : "-"}));
                Date toValue = restr.getDepartureDatesToValue();
                buf.append(L10nResourcesManager.getStr((String)Messages.Properties_to, (Object[])new Object[]{toValue != null ? sdf.format(toValue) : "-"}));
            }
            if ((departureDays = restr.getDepartureDaysRestriction()) != TchRouteRestrictions.DepartureDaysRestriction.ALL) {
                buf.append("<br>");
                buf.append(L10nResourcesManager.getStr((String)Messages.Properties_departureDays, (Object[])new Object[]{departureDays}));
                buf.append(L10nResourcesManager.getStr((String)Messages.Properties_oneSpace, (Object[])new Object[]{restr.getDepartureDaysValue()}));
            }
            if ((classOfBooking = restr.getClassOfBookingRestriction()) != TchRouteRestrictions.ClassOfBookingRestriction.ALL) {
                buf.append("<br>");
                buf.append(L10nResourcesManager.getStr((String)Messages.Properties_classOfBooking, (Object[])new Object[]{classOfBooking}));
                buf.append(L10nResourcesManager.getStr((String)Messages.Properties_oneSpace, (Object[])new Object[]{restr.getClassOfBookingValue()}));
            }
            if ((tariffCode = restr.getTariffCodeRestriction()) != TchRouteRestrictions.TariffCodeRestriction.ALL) {
                buf.append("<br>");
                buf.append(L10nResourcesManager.getStr((String)Messages.Properties_tariffCode, (Object[])new Object[]{tariffCode}));
                buf.append(L10nResourcesManager.getStr((String)Messages.Properties_oneSpace, (Object[])new Object[]{restr.getTariffCodeValue()}));
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            return TchRouteRestrictions.matchesTchRouteRules(ps.getInterlineCarriers(), ps.getVisitedCities(), ps.getSurfaceSegments(), ps.getFlightNumbers(), ps.getDepartureDates(), ps.getBookingClasses(), ps.getFareBasises(), (TchRouteRestrictions)value);
        }
    }
    ,
    TCH_AGENCY_CODE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_tchAgencyCode);
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.Properties_tchAgencyCodeReplace, (Object[])new Object[]{cond == Conditions.EQUALS ? L10n.get((String)Messages.Properties_is) : L10n.get((String)Messages.Properties_isNot), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getAgencyTchCode(), value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.getFareBasises() != null && RulesHelper.matchesStringRestriction(ps.getAgencyTchCode(), value, false);
            }
            return true;
        }
    }
    ,
    ONE_WAY{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_OneWay);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_OneWay_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return ps.isOneWayTicket() == (value != null && (Boolean)value != false);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.isOneWayTicket() != (value != null && (Boolean)value != false);
            }
            return true;
        }
    }
    ,
    SEGMENTS_COUNT{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SegmentsCount);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_SegmentsCount_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            int iv = value == null ? 0 : ((Number)value).intValue();
            int numOfSegments = ps.getNumOfSegments();
            if (Conditions.EQUALS.equals(condition)) {
                return numOfSegments == iv;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return numOfSegments != iv;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return numOfSegments > iv;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return numOfSegments >= iv;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return numOfSegments < iv;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return numOfSegments <= iv;
            }
            return true;
        }
    }
    ,
    SEGMENTS_TARIFF_COUNT{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SegmentsTariffCount);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_SegmentsTariffCount_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            int iv = value == null ? 0 : ((Number)value).intValue();
            int numOfSegmentsTariff = ps.getNumOfSegmentTariffs();
            if (Conditions.EQUALS.equals(condition)) {
                return numOfSegmentsTariff == iv;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return numOfSegmentsTariff != iv;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return numOfSegmentsTariff > iv;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return numOfSegmentsTariff >= iv;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return numOfSegmentsTariff < iv;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return numOfSegmentsTariff <= iv;
            }
            return true;
        }
    }
    ,
    OWN_SEGMENTS_COUNT{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_OwnSegmentsCount);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_OwnSegmentsCount_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            int iv = value == null ? 0 : ((Number)value).intValue();
            int numOfOwnSegments = ps.getNumOfSegments() - ps.getNumOfInterlineSegments();
            if (Conditions.EQUALS.equals(condition)) {
                return numOfOwnSegments == iv;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return numOfOwnSegments != iv;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return numOfOwnSegments > iv;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return numOfOwnSegments >= iv;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return numOfOwnSegments < iv;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return numOfOwnSegments <= iv;
            }
            return true;
        }
    }
    ,
    ISSUE_TIME{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_IssueTime);
        }

        public String getRendererId() {
            return ValueTypes.TIME_INTERVAL.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return;
            }
            DateFormat timeFormat = RulesEnvironment.getTimeFormat();
            if (Conditions.PERIOD_WITHIN.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_IssueTime_info1, (Object[])new Object[]{timeFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_IssueTime_info2, (Object[])new Object[]{timeFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_IssueTime_info3, (Object[])new Object[]{timeFormat.format(di.getBeginDate()), timeFormat.format(di.getEndDate())}));
                }
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider propertiesProvider = (AirTicketPropertiesProvider)propertySet;
            DateInterval dateInterval = (DateInterval)value;
            if (dateInterval == null || dateInterval.getBeginDate() == null && dateInterval.getEndDate() == null) {
                return true;
            }
            if (propertiesProvider.getIssueDate() != null) {
                if (Conditions.PERIOD_WITHIN.equals(condition)) {
                    int issueTime = MiscUtil.getTime((Date)propertiesProvider.getIssueDate());
                    int beginTime = MiscUtil.getTime((Date)dateInterval.getBeginDate());
                    int endTime = MiscUtil.getTime((Date)dateInterval.getEndDate());
                    if (dateInterval.getBeginDate() == null) {
                        return issueTime <= endTime;
                    }
                    if (dateInterval.getEndDate() == null) {
                        return issueTime >= beginTime;
                    }
                    if (beginTime > endTime) {
                        return issueTime >= beginTime || issueTime <= endTime;
                    }
                    return issueTime >= beginTime && issueTime <= endTime;
                }
                if (Conditions.PERIOD_BEYOND.equals(condition)) {
                    int issueTime = MiscUtil.getTime((Date)propertiesProvider.getIssueDate());
                    int beginTime = MiscUtil.getTime((Date)dateInterval.getBeginDate());
                    int endTime = MiscUtil.getTime((Date)dateInterval.getEndDate());
                    if (dateInterval.getBeginDate() == null) {
                        return issueTime > endTime;
                    }
                    if (dateInterval.getEndDate() == null) {
                        return issueTime < beginTime;
                    }
                    if (beginTime > endTime) {
                        return issueTime < beginTime && issueTime > endTime;
                    }
                    return issueTime < beginTime || issueTime > endTime;
                }
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }
    }
    ,
    ISSUE_WEEK_DAY{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_IssueWeekDay);
        }

        public String getRendererId() {
            return ValueTypes.WEEK_DAY.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_IssueWeekDay_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(DictHelper.getWeekDay(ps.getIssueDate().getDay()), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(DictHelper.getWeekDay(ps.getIssueDate().getDay()), (List)value, false);
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    TCH_SERVICE_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TCHServiceType);
        }

        public String getRendererId() {
            return ValueTypes.NULL.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TCHServiceType_info, (Object[])new Object[]{cond.getDisplayName()}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.TCH_SERVICE_TYPE_AIR_TICKETS.equals(condition) || Conditions.TCH_SERVICE_TYPE_AIR_AND_EXCESS_BAGGAGE.equals(condition)) {
                return ProductCategory.AIR.name().equals(ps.getProductCategory()) || ProductCategory.EXCESS_BAGAGE.name().equals(ps.getProductCategory()) || MCOCategory.EXCESS_LUGGAGE.name().equals(ps.getMcoCategory()) || TextUtil.isBlank((String)ps.getRfisc());
            }
            if (Conditions.TCH_SERVICE_TYPE_ADDITIONAL_SERVICES.equals(condition)) {
                return !TextUtil.isBlank((String)ps.getRfisc()) && !ProductCategory.AIR.name().equals(ps.getProductCategory()) && !ProductCategory.EXCESS_BAGAGE.name().equals(ps.getProductCategory()) && !MCOCategory.EXCESS_LUGGAGE.name().equals(ps.getMcoCategory());
            }
            if (Conditions.TCH_SERVICE_TYPE_ADDITIONAL_SERVICES_AND_LUGGAGE.equals(condition)) {
                return !TextUtil.isBlank((String)ps.getRfisc()) && !ProductCategory.AIR.name().equals(ps.getProductCategory()) && !ProductCategory.EXCESS_BAGAGE.name().equals(ps.getProductCategory());
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.TCH_SERVICE_TYPE_AIR_TICKETS.getId(), Conditions.TCH_SERVICE_TYPE_ADDITIONAL_SERVICES.getId(), Conditions.TCH_SERVICE_TYPE_ADDITIONAL_SERVICES_AND_LUGGAGE.getId()};
        }
    }
    ,
    TCH_ADDITIONAL_SERVICE_CODES{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TCHAdditionalServiceCodes);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TCHAdditionalServiceCodes_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getRfisc(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                RulesHelper.matchesStringRestriction(ps.getRfisc(), value, false);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    TCH_SERVICE_CODES{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TCHServiceCodes);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TCHServiceCodes_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getRfisc(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getRfisc(), value, false);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    TCH_ERSP_CODE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TCHErspCodes);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            if (cond == Conditions.NOT_SET) {
                buf.append(String.format("%s: %s", L10n.get((String)Messages.RuleProperty_TCHErspCodes), cond.getDisplayName()));
                return;
            }
            if (cond == Conditions.NOT_EMPTY) {
                buf.append(String.format("%s: %s", L10n.get((String)Messages.RuleProperty_TCHErspCodes), cond.getDisplayName()));
                return;
            }
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TCHErspCodes_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.NOT_SET.equals(condition)) {
                return TextUtil.isBlank((String)ps.getErsp());
            }
            if (Conditions.NOT_EMPTY.equals(condition)) {
                return !TextUtil.isBlank((String)ps.getErsp());
            }
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getErsp(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getErsp(), value, false);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    BOOKING_CONTENT{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_BookingContent);
        }

        public String getRendererId() {
            return ValueTypes.BOOKING_CONTENT.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_BookingContent_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getBookingContent(), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getBookingContent(), (List)value, false);
            }
            if (Conditions.CONTAINS_ONLY.equals(condition)) {
                List items = (List)value;
                StringBuilder buf = new StringBuilder();
                for (int n = 0; n < items.size(); ++n) {
                    if (n != 0) {
                        buf.append("-");
                    }
                    buf.append(((ProductType)items.get(n)).name());
                }
                return RulesHelper.includesOnly(ps.getBookingContent(), Collections.singletonList(buf.toString()));
            }
            if (Conditions.CONFINED_TO.equals(condition)) {
                List items = (List)value;
                StringBuilder buf = new StringBuilder();
                for (int n = 0; n < items.size(); ++n) {
                    if (n != 0) {
                        buf.append("-");
                    }
                    buf.append(((ProductType)items.get(n)).name());
                }
                return RulesHelper.confinedTo(RulesHelper.to2DList(ps.getBookingContent()), Collections.singletonList(buf.toString()));
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.CONTAINS_ONLY.getId(), Conditions.CONFINED_TO.getId()};
        }
    }
    ,
    SALES_DEPTH_DAYS{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SalesDepthDays);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_SalesDepthDays_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            int days = value == null ? 0 : ((Number)value).intValue();
            Date issueDate = ps.getIssueDate();
            Date departureDate = ps.getDepartureDate();
            if (issueDate == null || departureDate == null) {
                return false;
            }
            int salesDepthDays = (int)(MiscUtil.getDuration((Date)MiscUtil.clearTime((Date)issueDate), (Date)MiscUtil.clearTime((Date)departureDate)) / 86400000L);
            if (Conditions.EQUALS.equals(condition)) {
                return salesDepthDays == days;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return salesDepthDays != days;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return salesDepthDays > days;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return salesDepthDays >= days;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return salesDepthDays < days;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return salesDepthDays <= days;
            }
            return true;
        }
    }
    ,
    TRAVEL_DURATION{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TRAVEL_DURATION);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TRAVEL_DURATION_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            int val;
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            int travelDuration = ps.getTravelDuration();
            int n = val = value == null ? 0 : ((Number)value).intValue();
            if (Conditions.EQUALS.equals(condition)) {
                return travelDuration == val;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return travelDuration != val;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return travelDuration > val;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return travelDuration >= val;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return travelDuration < val;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return travelDuration <= val;
            }
            return true;
        }
    }
    ,
    BASE_FARE_CURRENCY{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_BaseFareCurrency);
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_BaseFareCurrency_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            Money baseFare = ps.getBaseFare();
            if (baseFare == null || baseFare.getCurrency() == null) {
                return false;
            }
            String code = baseFare.getCurrency();
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(code, value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(code, value, false);
            }
            throw Xeption.forDeveloper((String)"unexpected condition {0}", (Object[])new Object[]{condition});
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }
    }
    ,
    HAS_LUGGAGE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HasLuggage);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.RuleProperty_HasLuggage_info1) : L10n.get((String)Messages.RuleProperty_HasLuggage_info2));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            LuggagePropertiesProvider ps = (LuggagePropertiesProvider)propertySet;
            return ps.isHasLuggage() == (value != null && (Boolean)value != false);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }
    }
    ,
    GENERAL_ISSUE_AGENT{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RULES_PROPERTIES_ISSUING_AGENT);
        }

        public String getRendererId() {
            return ValueTypes.PERSONS.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.HOTELS_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RULES_PROPERTIES_ISSUING_AGENT_X, (Object[])new Object[]{cond.getDisplayName(), ((List)value).size() + L10n.get((String)Messages.Pieces)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            SalesContextPropertiesProvider ps = (SalesContextPropertiesProvider)propertySet;
            if (ps.getAgent() == null) {
                return false;
            }
            List uids = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getAgent().getUid(), (Object)uids, true);
            }
            return RulesHelper.matchesStringRestriction(ps.getAgent().getUid(), (Object)uids, false);
        }
    }
    ,
    GENERAL_ROUTE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ROUTE);
        }

        @Override
        public String[] getTargetIds() {
            return new String[0];
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.BEGINS_WITH.getId(), Conditions.NOT_BEGINS_WITH.getId(), Conditions.ENDS_WITH.getId(), Conditions.NOT_ENDS_WITH.getId(), Conditions.CONTAINS_ONLY.getId(), Conditions.CONFINED_TO.getId(), Conditions.NOT_CONFINED_TO.getId()};
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ROUTE_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BasicCommonTicketPropertiesProvider ps = (BasicCommonTicketPropertiesProvider)propertySet;
            List<String> values = RulesHelper.toStringCollection(value);
            HashSet<String> allLocations = new HashSet<String>(ps.getDepartureLocations());
            allLocations.addAll(ps.getArrivalLocations());
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.collectionIncludes(allLocations, values);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return !RulesHelper.collectionIncludes(allLocations, values);
            }
            if (Conditions.BEGINS_WITH.equals(condition)) {
                return RulesHelper.collectionIncludes(ps.getDepartureLocations(), values);
            }
            if (Conditions.NOT_BEGINS_WITH.equals(condition)) {
                return !RulesHelper.collectionIncludes(ps.getDepartureLocations(), values);
            }
            if (Conditions.ENDS_WITH.equals(condition)) {
                return RulesHelper.collectionIncludes(ps.getArrivalLocations(), values);
            }
            if (Conditions.NOT_ENDS_WITH.equals(condition)) {
                return !RulesHelper.collectionIncludes(ps.getArrivalLocations(), values);
            }
            if (Conditions.CONTAINS_ONLY.equals(condition)) {
                return RulesHelper.containsOnly(ps.getVisitedCities(), values);
            }
            if (Conditions.CONFINED_TO.equals(condition)) {
                return RulesHelper.confinedTo(ps.getVisitedCities(), RulesHelper.getCorrectedValues(values));
            }
            if (Conditions.NOT_CONFINED_TO.equals(condition)) {
                return !RulesHelper.confinedTo(ps.getVisitedCities(), RulesHelper.getCorrectedValues(values));
            }
            return true;
        }
    }
    ,
    EMPLOYEE_CATEGORIES{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_EMPLOYEE_CATEGORIES);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId(), Targets.AEROEXPRESS_COMMISSION.getId(), Targets.INSURANCE_ACCIDENT_COMMISSION.getId(), Targets.INSURANCE_TOURISTIC_COMMISSION.getId(), Targets.HOTELS_COMMISSION.getId(), Targets.DELIVERY.getId(), Targets.VISA_PRODUCT_COMMISSION.getId(), Targets.HOTELS_DOMESTIC.getId(), Targets.HOTELS_FOREIGN.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_EMPLOYEE_CATEGORIES_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            EmployeeCategoriesProvider ps = (EmployeeCategoriesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return value != null && RulesHelper.containsEmployeeCategory(ps.getEmployeeCategories(), (List)value);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return value != null && !RulesHelper.containsEmployeeCategory(ps.getEmployeeCategories(), (List)value);
            }
            return true;
        }
    }
    ,
    ISSUED_FOR_VOUCHER{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ISSUED_FOR_VOUCHER);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.RuleProperty_ISSUED_FOR_VOUCHER_info1) : L10n.get((String)Messages.RuleProperty_ISSUED_FOR_VOUCHER_info2));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            return Boolean.valueOf(ps.isIssuedForVoucher()).equals(value);
        }
    }
    ,
    CREATED_BY_CLIENT{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CREATED_BY_CLIENT);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId(), Targets.AEROEXPRESS_COMMISSION.getId(), Targets.INSURANCE_ACCIDENT_COMMISSION.getId(), Targets.INSURANCE_TOURISTIC_COMMISSION.getId(), Targets.HOTELS_COMMISSION.getId(), Targets.DELIVERY.getId(), Targets.VISA_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.RuleProperty_CREATED_BY_CLIENT_info1) : L10n.get((String)Messages.RuleProperty_CREATED_BY_CLIENT_info2));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ReservationPropertiesProvider ps = (ReservationPropertiesProvider)propertySet;
            return Boolean.valueOf(ps.isCreatedByClient()).equals(value);
        }
    }
    ,
    BRAND_NAME{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_BRAND_NAME);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            List<String> strings = this.parseValue(value);
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_BRAND_NAME_info, (Object[])new Object[]{cond.getDisplayName(), strings}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (ps.getBrandName() == null) {
                return false;
            }
            List<String> strings = this.parseValue(value);
            if (Conditions.EQUALS.equals(condition)) {
                return ps.getBrandName().getValues().values().stream().anyMatch(strings::contains);
            }
            return false;
        }

        private List<String> parseValue(Object value) {
            if (value == null) {
                return Collections.emptyList();
            }
            if (value instanceof L10nString) {
                return new ArrayList<String>(((L10nString)value).getValues().values());
            }
            return RulesHelper.toStringCollection(value);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }
    }
    ,
    M2_AGREEMENT{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.NO.getId(), Conditions.EXCLUDE.getId(), Conditions.EXCEPT.getId(), Conditions.INCLUDE.getId(), Conditions.ONLY.getId(), Conditions.ONLY_M2.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_M2_AGREEMENT_CODE);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            if (Conditions.EXCEPT == cond || Conditions.EXCLUDE == cond || Conditions.INCLUDE == cond || Conditions.ONLY == cond) {
                buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_M2_AGREEMENT_CODE_info1, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
            } else {
                buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_M2_AGREEMENT_CODE_info2, (Object[])new Object[]{cond.getDisplayName()}));
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition) || Conditions.ONLY.equals(condition)) {
                return ps.getM2AgreementCode() != null && RulesHelper.matchesStringRestriction(ps.getM2AgreementCode(), value, true);
            }
            if (Conditions.EXCEPT.equals(condition) || Conditions.EXCLUDE.equals(condition)) {
                return ps.getM2AgreementCode() != null && RulesHelper.matchesStringRestriction(ps.getM2AgreementCode(), value, false);
            }
            if (Conditions.NO.equals(condition)) {
                return ps.getM2AgreementCode() == null;
            }
            if (Conditions.ONLY_M2.equals(condition)) {
                return ps.getM2AgreementCode() != null;
            }
            return false;
        }
    }
    ,
    MAIN_DOCUMENT_TYPE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_mainDocumentType);
        }

        public String getRendererId() {
            return ValueTypes.TICKET_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.Properties_mainDocumentTypeInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (value == null) {
                return false;
            }
            TicketType ticketType = ps.getMainDocumentType();
            if (ticketType == null) {
                return false;
            }
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ticketType.name(), (List)value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ticketType.name(), (List)value, false);
            }
            return true;
        }
    }
    ,
    BOOKING_AGENT{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_Booking_Agent);
        }

        public String getRendererId() {
            return ValueTypes.ORGANIZATIONS_REFERENCES.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_Booking_Agent_info, (Object[])new Object[]{cond.getDisplayName(), this.toString((List)value)}));
        }

        private String toString(List<EntityReference<Organization>> value) {
            if (value == null || value.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (EntityReference<Organization> ref : value) {
                String title = "???";
                try {
                    if (ref != null) {
                        title = ref.toString();
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error("unable to resolve reference", (Throwable)e);
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(title);
            }
            return sb.toString();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ReservationPropertiesProvider ps = (ReservationPropertiesProvider)propertySet;
            List<EntityReference<Organization>> employers = ps.getEmployersOfBookingAgent();
            List organizations = (List)value;
            if (organizations == null || employers == null || organizations.isEmpty() || employers.isEmpty()) {
                return false;
            }
            if (Conditions.IS_EMPLOYEE.equals(condition)) {
                for (EntityReference<Organization> employer : employers) {
                    if (!organizations.contains(employer)) continue;
                    return true;
                }
                return false;
            }
            if (Conditions.IS_NOT_EMPLOYEE.equals(condition)) {
                for (EntityReference<Organization> employer : employers) {
                    if (!organizations.contains(employer)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.IS_EMPLOYEE.getId(), Conditions.IS_NOT_EMPLOYEE.getId()};
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.ADDITIONAL_SERVICE_PRODUCT.getId(), Targets.AEROEXPRESS_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId(), Targets.DELIVERY.getId(), Targets.CAR.getId(), Targets.HOTELS_COMMISSION.getId(), Targets.HOTELS_DOMESTIC.getId(), Targets.HOTELS_FOREIGN.getId(), Targets.INSURANCE_ACCIDENT_COMMISSION.getId(), Targets.INSURANCE_TOURISTIC_COMMISSION.getId(), Targets.PRODUCT_COMMISSION.getId(), Targets.TRANSFER.getId(), Targets.VISA_PRODUCT_COMMISSION.getId()};
        }
    }
    ,
    BOOKING_AGENT_PROFILE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_BookingAgentProfile);
        }

        public String getRendererId() {
            return ValueTypes.PERSONS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_BookingAgentProfile_info, (Object[])new Object[]{cond.getDisplayName(), ((List)value).size() + L10n.get((String)Messages.Pieces)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ReservationPropertiesProvider ps = (ReservationPropertiesProvider)propertySet;
            if (ps.getBookingAgent() == null) {
                return false;
            }
            List uids = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getBookingAgent().getUid(), (Object)uids, true);
            }
            return RulesHelper.matchesStringRestriction(ps.getBookingAgent().getUid(), (Object)uids, false);
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.ADDITIONAL_SERVICE_PRODUCT.getId(), Targets.AEROEXPRESS_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId(), Targets.DELIVERY.getId(), Targets.CAR.getId(), Targets.HOTELS_COMMISSION.getId(), Targets.HOTELS_DOMESTIC.getId(), Targets.HOTELS_FOREIGN.getId(), Targets.INSURANCE_ACCIDENT_COMMISSION.getId(), Targets.INSURANCE_TOURISTIC_COMMISSION.getId(), Targets.PRODUCT_COMMISSION.getId(), Targets.TRANSFER.getId(), Targets.VISA_PRODUCT_COMMISSION.getId()};
        }
    }
    ,
    AIRCRAFT{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_Aircraft);
        }

        public String getRendererId() {
            return ValueTypes.AIRCRAFT.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            StringBuilder sb = new StringBuilder();
            for (AircraftReference ref : (List)value) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (StringUtils.isBlank((String)ref.getCaption())) {
                    sb.append(ref.getCode());
                    continue;
                }
                sb.append(ref);
            }
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_Aircraft_info, (Object[])new Object[]{cond.getDisplayName(), sb.toString()}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesDictRestriction(ps.getAircraftsCodes(), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesDictRestriction(ps.getAircraftsCodes(), (List)value, false);
            }
            return true;
        }
    }
    ,
    SALES_ORIGIN_PROVIDER{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.TECHNICAL_FEE.getId(), Targets.TECHNICAL_FEE_SYSTEM.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SalesOriginProvider);
        }

        public String getRendererId() {
            return ValueTypes.SALES_ORIGIN_PROVIDER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_SalesOriginProvider_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            if (value == null) {
                return false;
            }
            TechnicalFeePropertiesProvider ps = (TechnicalFeePropertiesProvider)propertySet;
            String provider = ps.getSalesOriginProvider();
            SalesOriginProvider sop = (SalesOriginProvider)value;
            if (Conditions.EQUALS.equals(condition)) {
                return sop.name().equals(provider);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !sop.name().equals(provider);
            }
            return false;
        }
    }
    ,
    SALES_ORIGIN_CONTENT{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.TECHNICAL_FEE.getId(), Targets.TECHNICAL_FEE_SYSTEM.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SalesOriginContent);
        }

        public String getRendererId() {
            return ValueTypes.SALES_ORIGIN_CONTENT.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_SalesOriginContent_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            if (value == null) {
                return false;
            }
            TechnicalFeePropertiesProvider ps = (TechnicalFeePropertiesProvider)propertySet;
            String content = ps.getSalesOriginContent();
            SalesOriginContent soc = (SalesOriginContent)value;
            if (Conditions.EQUALS.equals(condition)) {
                return soc.name().equals(content);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !soc.name().equals(content);
            }
            return false;
        }
    }
    ,
    DEPARTURE_WEEK_DAYS{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_DepartureWeekDay);
        }

        public String getRendererId() {
            return ValueTypes.WEEK_DAY.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DepartureWeekDay_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return ps.getDepartureDates().stream().filter(Objects::nonNull).anyMatch(date -> RulesHelper.matchesEnumRestriction(DictHelper.getWeekDay(date.getDay()), (List)value, true));
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return ps.getDepartureDates().stream().filter(Objects::nonNull).anyMatch(date -> RulesHelper.matchesEnumRestriction(DictHelper.getWeekDay(date.getDay()), (List)value, false));
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    TRAVEL_SUBJECT_TOTAL_PRICE{

        @Override
        public String[] getConditionIds() {
            return new String[0];
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            if (value != null) {
                ((TravelSubjectTotalPriceRestrictions)value).buildInfo(buf);
            }
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TravelSubjectTotalPrice);
        }

        public String getRendererId() {
            return ValueTypes.TRAVEL_SUBJECT_TOTAL_PRICE.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            if (value == null) {
                return false;
            }
            TravelSubjectPropertiesProvider ps = (TravelSubjectPropertiesProvider)propertySet;
            TravelSubjectTotalPriceRestrictions rules = (TravelSubjectTotalPriceRestrictions)value;
            return rules.matches(ps.getTravelSubject(), ps.getPassengerTypeCategories(), ps.getTravelSubjectTotalPrice());
        }
    }
    ,
    NO_BYPASS_ACKNOWLEDGE_REMARK{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_NoBypassAcknowledgeRemark", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{FOPTargets.FOP_CHECK_RESERVATION.getId(), QualityCheckTargets.QUALITY_CHECK_RESERVATION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RuleProperty_NoBypassAcknowledgeRemarkInfo", (Object[])new Object[]{RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RemarksPropertiesProvider ps = (RemarksPropertiesProvider)propertySet;
            return !ps.getRemarks().contains((String)value);
        }
    }
    ,
    NO_AUTH_APPROVED_REMARK{

        @Override
        public String[] getConditionIds() {
            return new String[0];
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_NoAuthApprovedRemark", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append((Boolean)value != false ? L10nResourcesManager.getStr((String)"RuleProperty_NoAuthApprovedRemarkYes", (Object[])new Object[0]) : L10nResourcesManager.getStr((String)"RuleProperty_NoAuthApprovedRemarkNo", (Object[])new Object[0]));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RemarksPropertiesProvider ps = (RemarksPropertiesProvider)propertySet;
            return (Boolean)value ^ !ps.getRemarks().isEmpty();
        }
    };


    public String getId() {
        return this.name();
    }

    protected String buildRegularExpression(String prefix, String[] values, String suffix) {
        StringBuilder builder = new StringBuilder("^");
        for (int n = 0; n < values.length; ++n) {
            String value = values[n];
            if (n != 0) {
                builder.append("|");
            }
            if (!TextUtil.isBlank((String)prefix)) {
                builder.append(prefix);
            }
            builder.append(value);
            if (TextUtil.isBlank((String)suffix)) continue;
            builder.append(suffix);
        }
        builder.append("$");
        return builder.toString();
    }

    abstract String[] getTargetIds();

    @Override
    public abstract String[] getConditionIds();

    protected String[] getValues(Object value) {
        List<String> res = RulesHelper.toStringCollection(value);
        return res.toArray(new String[0]);
    }

    protected static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy.MM.dd");
    }
}

