/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class RouteSegmentsRestriction
implements Serializable,
XSerializable,
XSSerializable,
XCloneable {
    static final Logger log = LoggerFactory.getLogger(RouteSegmentsRestriction.class);
    private static final long serialVersionUID = -3397438787890386627L;
    private final List<ComplexSegmentRestriction> restrictions = new ArrayList<ComplexSegmentRestriction>();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RouteSegmentsRestriction)) {
            return false;
        }
        RouteSegmentsRestriction other = (RouteSegmentsRestriction)obj;
        return CollectionUtil.equals(this.restrictions, other.restrictions, (boolean)true);
    }

    public void fromXML(Element elm) throws Exception {
        this.restrictions.clear();
        for (Element element : XmlUtil.getElements((Element)elm, (String)"restrictions/item")) {
            this.restrictions.add((ComplexSegmentRestriction)((Object)XHelper.readObject((Element)element, (String)".")));
        }
    }

    private boolean matchGeoPointRestriction(GeoLocationPattern loc, String[] cityCodes) {
        boolean hasMatch = false;
        boolean hasMismatch = false;
        for (GeoLocationCode code : loc.getCodes()) {
            boolean match = this.match(code.getCode(), cityCodes);
            boolean match2 = match && !code.isHasNegativePrefix() || !match && code.isHasNegativePrefix();
            hasMatch = hasMatch || match2;
            boolean bl = hasMismatch = hasMismatch || !match2;
            if (!hasMatch || loc.getConjunctionType() != GeoLocationConjunctionType.OR) continue;
            return true;
        }
        if (!hasMatch) {
            return false;
        }
        return !hasMismatch || loc.getConjunctionType() != GeoLocationConjunctionType.AND;
    }

    public List<ComplexSegmentRestriction> getRestrictions() {
        return this.restrictions;
    }

    public int hashCode() {
        return MiscUtil.hash((Object[])new Object[]{this.restrictions});
    }

    public void toXML(Element elm) throws Exception {
        for (ComplexSegmentRestriction item : this.restrictions) {
            XHelper.writeObject((Element)elm, (String)"restrictions/item", (Object)((Object)item));
        }
    }

    public void toXML(XMLStreamWriter writer) throws Exception {
        if (!this.restrictions.isEmpty()) {
            writer.writeStartElement("restrictions");
            for (ComplexSegmentRestriction item : this.restrictions) {
                XSHelper.writeObject((XMLStreamWriter)writer, (String)"item", (Object)((Object)item));
            }
            writer.writeEndElement();
        }
    }

    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        RouteSegmentsRestriction clone = new RouteSegmentsRestriction();
        clone.restrictions.addAll(XCloneHelper.cloneCollection(this.restrictions, (boolean)newUids, uids));
        return clone;
    }

    public void fromXML(XMLStreamReader reader) throws Exception {
        this.restrictions.clear();
        block12: while (reader.nextTag() != 2) {
            String tag;
            switch (tag = reader.getName().getLocalPart()) {
                case "restrictions": {
                    block13: while (reader.nextTag() != 2) {
                        switch (tag = reader.getName().getLocalPart()) {
                            case "item": {
                                this.restrictions.add((ComplexSegmentRestriction)((Object)XSHelper.readObject((XMLStreamReader)reader)));
                                continue block13;
                            }
                        }
                        XSHelper.skipElement((XMLStreamReader)reader);
                    }
                    continue block12;
                }
            }
            XSHelper.skipElement((XMLStreamReader)reader);
        }
    }

    public boolean match(List<List<String[]>> cities, List<Boolean> surface, List<String[]> marketingCarriers, List<String[]> operatingCarriers, List<String> flightNumbers) {
        ArrayList<String> correctedFlightNumbers = new ArrayList<String>(flightNumbers);
        for (int n = 0; n < surface.size(); ++n) {
            if (!Boolean.TRUE.equals(surface.get(n))) continue;
            correctedFlightNumbers.remove(n);
        }
        int[] parsedFlightNumbers = new int[correctedFlightNumbers.size()];
        for (int n = 0; n < correctedFlightNumbers.size(); ++n) {
            try {
                parsedFlightNumbers[n] = TextUtil.isBlank((String)((String)correctedFlightNumbers.get(n))) ? -1 : Integer.parseInt((String)correctedFlightNumbers.get(n));
                continue;
            }
            catch (NumberFormatException e) {
                parsedFlightNumbers[n] = -1;
            }
        }
        int conditionIndex = 0;
        int dataIndex = 0;
        return this.matchInternal(cities, marketingCarriers, operatingCarriers, parsedFlightNumbers, conditionIndex, dataIndex);
    }

    private boolean matchInternal(List<List<String[]>> cities, List<String[]> marketingCarriers, List<String[]> operatingCarriers, int[] flightNumbers, int conditionIndex, int dataIndex) {
        int n;
        int dataSize = marketingCarriers.size();
        if (this.restrictions.size() <= conditionIndex) {
            return dataSize - dataIndex == 0;
        }
        ComplexSegmentRestriction restriction = this.restrictions.get(conditionIndex);
        int maxSegmentsCount = 0;
        int minSegmentsCount = 0;
        if (restriction.getSegmentsCountRestriction() != null) {
            if (restriction.getSegmentsCountRestriction().getMinCount() >= 0) {
                minSegmentsCount = restriction.getSegmentsCountRestriction().getMinCount();
            }
            if (restriction.getSegmentsCountRestriction().getMaxCount() >= minSegmentsCount) {
                maxSegmentsCount = restriction.getSegmentsCountRestriction().getMaxCount();
            }
            if (minSegmentsCount > dataSize - dataIndex) {
                return false;
            }
            if (maxSegmentsCount > dataSize - dataIndex) {
                maxSegmentsCount = dataSize - dataIndex;
            }
        } else {
            maxSegmentsCount = dataSize - dataIndex;
            for (n = dataIndex + 1; n < this.restrictions.size(); ++n) {
                SegmentsCountRestriction restr2 = this.restrictions.get(n).getSegmentsCountRestriction();
                if (restr2 == null || restr2.getMinCount() <= 0) continue;
                maxSegmentsCount -= restr2.getMinCount();
            }
        }
        if (minSegmentsCount == 0 && maxSegmentsCount == 0) {
            return this.matchForZeroCount(conditionIndex, cities, marketingCarriers, operatingCarriers, flightNumbers, dataIndex);
        }
        for (n = minSegmentsCount; n <= maxSegmentsCount; ++n) {
            if (n == 0) {
                if (dataSize - dataIndex <= 0) {
                    return true;
                }
                if (!this.matchForZeroCount(conditionIndex, cities, marketingCarriers, operatingCarriers, flightNumbers, dataIndex)) continue;
                return true;
            }
            boolean unmatched = false;
            for (int m = 1; m <= n; ++m) {
                boolean bl = unmatched = !this.matchSegment(this.restrictions.get(conditionIndex), cities.get(dataIndex + m - 1).get(0), cities.get(dataIndex + m - 1).get(1), marketingCarriers.get(dataIndex + m - 1), operatingCarriers.get(dataIndex + m - 1), flightNumbers[dataIndex + m - 1]);
                if (unmatched) break;
            }
            if (unmatched || !this.matchInternal(cities, marketingCarriers, operatingCarriers, flightNumbers, conditionIndex + 1, dataIndex + n)) continue;
            return true;
        }
        return false;
    }

    private boolean matchForZeroCount(int conditionIndex, List<List<String[]>> cities, List<String[]> marketingCarriers, List<String[]> operatingCarriers, int[] flightNumbers, int dataIndex) {
        if (conditionIndex + 1 > this.restrictions.size() - 1) {
            return false;
        }
        return this.matchInternal(cities, marketingCarriers, operatingCarriers, flightNumbers, conditionIndex + 1, dataIndex);
    }

    private boolean matchSegment(ComplexSegmentRestriction restr, String[] startCityCodes, String[] finalCityCodes, String[] marketingCarriers, String[] opperatingCarriers, int flightNumber) {
        return this.matchRouteRestriction(restr.getRoutes(), startCityCodes, finalCityCodes) && this.matchCarrierRestriction(restr.getMarketingCarriers(), marketingCarriers) && this.matchCarrierRestriction(restr.getOperatingCarriers(), opperatingCarriers) && this.matchFlightNumberRestriction(restr.getFlightNumbers(), flightNumber);
    }

    private boolean matchFlightNumberRestriction(List<FlightNumbersRestriction> flightNumbers, int flightNumber) {
        if (flightNumbers.isEmpty()) {
            return true;
        }
        for (FlightNumbersRestriction restr : flightNumbers) {
            if (restr.getMinFlightNumber() > flightNumber || restr.getMaxFlightNumber() < flightNumber) continue;
            return true;
        }
        return false;
    }

    private boolean matchCarrierRestriction(List<String> ruleCarriersCodes, String[] carriersCodes) {
        if (ruleCarriersCodes.isEmpty()) {
            return true;
        }
        for (String ruleCode : ruleCarriersCodes) {
            if (!this.match(ruleCode, carriersCodes)) continue;
            return true;
        }
        return false;
    }

    private boolean matchRouteRestriction(List<GeoLocationPair> routes, String[] startCityCodes, String[] finalCityCodes) {
        if (routes.isEmpty()) {
            return true;
        }
        for (GeoLocationPair pair : routes) {
            if (!this.matchGeoPointRestriction(pair.getStartLocation(), startCityCodes) || !this.matchGeoPointRestriction(pair.getFinalLocation(), finalCityCodes)) continue;
            return true;
        }
        return false;
    }

    private boolean match(String ruleCode, String[] codes) {
        if (ruleCode.equals("*")) {
            return true;
        }
        for (String item : codes) {
            if (item == null || !item.equalsIgnoreCase(ruleCode)) continue;
            return true;
        }
        return false;
    }

    public void buildInfo(StringBuilder buf) {
        buf.append(L10n.get((String)Messages.Restriction_RouteSegments)).append(":\r\n");
        for (int n = 0; n < this.restrictions.size(); ++n) {
            ComplexSegmentRestriction seg = this.restrictions.get(n);
            if (n > 0) {
                buf.append("\r");
            }
            if (seg.getSegmentsCountRestriction() != null) {
                seg.appendSegmentsCountPattern(buf);
            } else {
                buf.append("*");
            }
            buf.append(":");
            if (!seg.getRoutes().isEmpty()) {
                buf.append(" ").append(L10n.get((String)Messages.ROUTE)).append("=");
                seg.appendRoutePattern(buf);
            }
            if (!seg.getMarketingCarriers().isEmpty()) {
                buf.append(" ").append(L10n.get((String)Messages.MARKETING_CARRIERS)).append("=");
                seg.appendMarketingCarriersPattern(buf);
            }
            if (!seg.getOperatingCarriers().isEmpty()) {
                buf.append(" ").append(L10n.get((String)Messages.OPERATING_CARRIERS)).append("=");
                seg.appendOperatingCarriersPattern(buf);
            }
            if (seg.getFlightNumbers().isEmpty()) continue;
            buf.append(" ").append(L10n.get((String)Messages.FLIGHT_NUMBERS)).append("=");
            seg.appendFlightNumbersPattern(buf);
        }
    }

    public static class ComplexSegmentRestriction
    extends BaseEntity {
        private static final long serialVersionUID = -1209535408824210845L;
        private final List<GeoLocationPair> routes = new ArrayList<GeoLocationPair>();
        private final List<String> marketingCarriers = new ArrayList<String>();
        private final List<String> operatingCarriers = new ArrayList<String>();
        private final List<FlightNumbersRestriction> flightNumbers = new ArrayList<FlightNumbersRestriction>();
        private SegmentsCountRestriction segmentsCountRestriction;

        public List<String> getMarketingCarriers() {
            return this.marketingCarriers;
        }

        public List<String> getOperatingCarriers() {
            return this.operatingCarriers;
        }

        public List<FlightNumbersRestriction> getFlightNumbers() {
            return this.flightNumbers;
        }

        public List<GeoLocationPair> getRoutes() {
            return this.routes;
        }

        public SegmentsCountRestriction getSegmentsCountRestriction() {
            return this.segmentsCountRestriction;
        }

        public void setSegmentsCountPattern(SegmentsCountRestriction value) {
            this.segmentsCountRestriction = value;
        }

        public ComplexSegmentRestriction() {
        }

        public int hashCode() {
            return MiscUtil.hash((Object[])new Object[]{this.routes, this.marketingCarriers, this.operatingCarriers, this.flightNumbers, this.segmentsCountRestriction});
        }

        public void toXML(Element elm) throws Exception {
            for (GeoLocationPair geoLocationPair : this.routes) {
                XHelper.writeObject((Element)elm, (String)"routePatterns/item", (Object)geoLocationPair);
            }
            for (String string : this.marketingCarriers) {
                XHelper.writeString((Element)elm, (String)"marketingCarriers/item", (String)string);
            }
            for (String string : this.operatingCarriers) {
                XHelper.writeString((Element)elm, (String)"operatingCarriers/item", (String)string);
            }
            for (FlightNumbersRestriction flightNumbersRestriction : this.flightNumbers) {
                XHelper.writeObject((Element)elm, (String)"flightNumbers/item", (Object)flightNumbersRestriction);
            }
            XHelper.writeObject((Element)elm, (String)"segmentsCountRestriction", (Object)this.segmentsCountRestriction);
        }

        protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
            if (!this.routes.isEmpty()) {
                writer.writeStartElement("routePatterns");
                for (GeoLocationPair geoLocationPair : this.routes) {
                    XSHelper.writeObject((XMLStreamWriter)writer, (String)"item", (Object)geoLocationPair);
                }
                writer.writeEndElement();
            }
            if (!this.marketingCarriers.isEmpty()) {
                writer.writeStartElement("marketingCarriers");
                for (String string : this.marketingCarriers) {
                    XSHelper.writeString((XMLStreamWriter)writer, (String)"item", (String)string);
                }
                writer.writeEndElement();
            }
            if (!this.operatingCarriers.isEmpty()) {
                writer.writeStartElement("operatingCarriers");
                for (String string : this.operatingCarriers) {
                    XSHelper.writeString((XMLStreamWriter)writer, (String)"item", (String)string);
                }
                writer.writeEndElement();
            }
            if (!this.flightNumbers.isEmpty()) {
                writer.writeStartElement("flightNumbers");
                for (FlightNumbersRestriction flightNumbersRestriction : this.flightNumbers) {
                    XSHelper.writeObject((XMLStreamWriter)writer, (String)"item", (Object)flightNumbersRestriction);
                }
                writer.writeEndElement();
            }
            XSHelper.writeObject((XMLStreamWriter)writer, (String)"segmentsCountRestriction", (Object)this.segmentsCountRestriction);
        }

        public void copyFrom(BaseEntity sourceEntity, boolean newUids, Map<String, String> uids) throws Exception {
            super.copyFrom(sourceEntity, newUids, uids);
            ComplexSegmentRestriction source = (ComplexSegmentRestriction)sourceEntity;
            this.routes.clear();
            for (GeoLocationPair geoLocationPair : source.routes) {
                this.routes.add((GeoLocationPair)geoLocationPair.clone(newUids, uids));
            }
            this.marketingCarriers.clear();
            for (String string : source.marketingCarriers) {
                this.marketingCarriers.add(string);
            }
            this.operatingCarriers.clear();
            for (String string : source.operatingCarriers) {
                this.operatingCarriers.add(string);
            }
            this.flightNumbers.clear();
            for (FlightNumbersRestriction flightNumbersRestriction : source.flightNumbers) {
                this.flightNumbers.add((FlightNumbersRestriction)flightNumbersRestriction.clone(newUids, uids));
            }
            this.segmentsCountRestriction = source.segmentsCountRestriction != null ? (SegmentsCountRestriction)source.segmentsCountRestriction.clone(newUids, uids) : null;
        }

        public ComplexSegmentRestriction(String uid) {
            super(uid);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ComplexSegmentRestriction)) {
                return false;
            }
            ComplexSegmentRestriction other = (ComplexSegmentRestriction)((Object)obj);
            if (!CollectionUtil.equals(this.routes, other.routes, (boolean)true)) {
                return false;
            }
            if (!CollectionUtil.equals(this.marketingCarriers, other.marketingCarriers, (boolean)true)) {
                return false;
            }
            if (!CollectionUtil.equals(this.operatingCarriers, other.operatingCarriers, (boolean)true)) {
                return false;
            }
            if (!CollectionUtil.equals(this.flightNumbers, other.flightNumbers, (boolean)true)) {
                return false;
            }
            return MiscUtil.equals((Object)this.segmentsCountRestriction, (Object)other.segmentsCountRestriction);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.segmentsCountRestriction != null) {
                this.appendSegmentsCountPattern(buf);
            } else {
                buf.append("*");
            }
            buf.append(":");
            if (!this.routes.isEmpty()) {
                buf.append(" R=");
                this.appendRoutePattern(buf);
            }
            if (!this.marketingCarriers.isEmpty()) {
                buf.append(" MC=");
                this.appendMarketingCarriersPattern(buf);
            }
            if (!this.operatingCarriers.isEmpty()) {
                buf.append(" OC=");
                this.appendOperatingCarriersPattern(buf);
            }
            if (!this.flightNumbers.isEmpty()) {
                buf.append(" \u2116 \u0440\u0435\u0439\u0441\u043e\u0432=");
                this.appendFlightNumbersPattern(buf);
            }
            return buf.toString();
        }

        public void fromPatterns(String routePattern, String marketingAirlinesPattern, String operatingAirlinesPattern, String flightNumbersPattern, String segmentsCountPattern) {
            this.routes.clear();
            this.routes.addAll(this.parseRoutePattern(routePattern));
            this.marketingCarriers.clear();
            this.marketingCarriers.addAll(this.parseStringListPattern(marketingAirlinesPattern));
            this.operatingCarriers.clear();
            this.operatingCarriers.addAll(this.parseStringListPattern(operatingAirlinesPattern));
            this.flightNumbers.clear();
            this.flightNumbers.addAll(this.parseFlightNumbersPattern(flightNumbersPattern));
            this.segmentsCountRestriction = this.parseSegmentCountPattern(segmentsCountPattern);
        }

        private SegmentsCountRestriction parseSegmentCountPattern(String segmentsCountPattern) {
            if (TextUtil.isBlank((String)segmentsCountPattern)) {
                return null;
            }
            String pattern = segmentsCountPattern.replace(" ", "");
            if (!pattern.contains("-")) {
                int count = Integer.parseInt(pattern);
                return new SegmentsCountRestriction(count, count);
            }
            String[] patterns = pattern.split("-");
            if (patterns.length != 2) {
                return null;
            }
            return new SegmentsCountRestriction(Integer.parseInt(patterns[0]), Integer.parseInt(patterns[1]));
        }

        private List<FlightNumbersRestriction> parseFlightNumbersPattern(String flightNumbersPattern) {
            if (TextUtil.isBlank((String)flightNumbersPattern)) {
                return Collections.emptyList();
            }
            ArrayList<FlightNumbersRestriction> result = new ArrayList<FlightNumbersRestriction>();
            for (String item : this.parseStringListPattern(flightNumbersPattern)) {
                if (TextUtil.isBlank((String)item)) continue;
                String[] patterns = item.split("-");
                if (patterns.length == 2) {
                    result.add(new FlightNumbersRestriction(Integer.parseInt(patterns[0]), Integer.parseInt(patterns[1])));
                    continue;
                }
                int count = Integer.parseInt(patterns[0]);
                result.add(new FlightNumbersRestriction(count, count));
            }
            return result;
        }

        private List<String> parseStringListPattern(String pattern) {
            if (TextUtil.isBlank((String)pattern)) {
                return Collections.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>();
            String correctedpattern = pattern.replace(" ", "").replace(";", ",");
            for (String item : correctedpattern.split(",")) {
                if (TextUtil.isBlank((String)item)) continue;
                result.add(item.trim().toUpperCase());
            }
            return result;
        }

        private List<GeoLocationPair> parseRoutePattern(String routePattern) {
            if (TextUtil.isBlank((String)routePattern)) {
                return Collections.emptyList();
            }
            ArrayList<GeoLocationPair> result = new ArrayList<GeoLocationPair>();
            for (String item : this.parseStringListPattern(routePattern)) {
                String[] items = item.split("-");
                if (items.length != 2 || TextUtil.isBlank((String)items[0]) || TextUtil.isBlank((String)items[1])) continue;
                result.add(new GeoLocationPair(this.parseRoutePointPattern(items[0]), this.parseRoutePointPattern(items[1])));
            }
            return result;
        }

        private GeoLocationPattern parseRoutePointPattern(String pattern) {
            GeoLocationPattern result = new GeoLocationPattern();
            result.setConjunctionType(pattern.contains("|") ? GeoLocationConjunctionType.OR : GeoLocationConjunctionType.AND);
            for (String item : pattern.split(result.getConjunctionType() == GeoLocationConjunctionType.AND ? "&" : "\\|")) {
                if (TextUtil.isBlank((String)item)) continue;
                boolean negative = (item = item.trim().toUpperCase()).startsWith("!");
                if (negative) {
                    item = item.substring(1);
                }
                result.getCodes().add(new GeoLocationCode(negative, item));
            }
            return result;
        }

        void appendRoutePattern(StringBuilder buf) {
            if (this.routes.isEmpty()) {
                return;
            }
            for (int n = 0; n < this.routes.size(); ++n) {
                GeoLocationPair pair = this.routes.get(n);
                if (n > 0) {
                    buf.append(", ");
                }
                this.appendLocationPattern(buf, pair.getStartLocation());
                buf.append("-");
                this.appendLocationPattern(buf, pair.getFinalLocation());
            }
        }

        public String getRouteRestriction() {
            if (this.routes.isEmpty()) {
                return null;
            }
            StringBuilder res = new StringBuilder();
            this.appendRoutePattern(res);
            return res.toString();
        }

        private void appendLocationPattern(StringBuilder buf, GeoLocationPattern loc) {
            if (loc == null || loc.getCodes().isEmpty()) {
                buf.append("*");
                return;
            }
            for (int n = 0; n < loc.getCodes().size(); ++n) {
                GeoLocationCode code = loc.getCodes().get(n);
                if (n > 0) {
                    buf.append(loc.getConjunctionType() == GeoLocationConjunctionType.AND ? "&" : "|");
                }
                if (code.isHasNegativePrefix()) {
                    buf.append("!");
                }
                buf.append(code.getCode());
            }
        }

        void appendMarketingCarriersPattern(StringBuilder buf) {
            if (this.marketingCarriers.isEmpty()) {
                return;
            }
            for (int n = 0; n < this.marketingCarriers.size(); ++n) {
                if (n > 0) {
                    buf.append(", ");
                }
                buf.append(this.marketingCarriers.get(n));
            }
        }

        public String getMarketingCarriersPattern() {
            if (this.marketingCarriers.isEmpty()) {
                return null;
            }
            StringBuilder res = new StringBuilder();
            this.appendMarketingCarriersPattern(res);
            return res.toString();
        }

        void appendOperatingCarriersPattern(StringBuilder buf) {
            if (this.operatingCarriers.isEmpty()) {
                return;
            }
            for (int n = 0; n < this.operatingCarriers.size(); ++n) {
                if (n > 0) {
                    buf.append(", ");
                }
                buf.append(this.operatingCarriers.get(n));
            }
        }

        public String getOperatingCarriersPattern() {
            if (this.operatingCarriers.isEmpty()) {
                return null;
            }
            StringBuilder res = new StringBuilder();
            this.appendOperatingCarriersPattern(res);
            return res.toString();
        }

        void appendFlightNumbersPattern(StringBuilder buf) {
            if (this.flightNumbers.isEmpty()) {
                return;
            }
            for (int n = 0; n < this.flightNumbers.size(); ++n) {
                FlightNumbersRestriction fnr;
                if (n > 0) {
                    buf.append(", ");
                }
                if ((fnr = this.flightNumbers.get(n)).getMinFlightNumber() == fnr.getMaxFlightNumber()) {
                    buf.append(Integer.toString(fnr.getMinFlightNumber()));
                    continue;
                }
                buf.append(String.format("%s-%s", Integer.toString(fnr.getMinFlightNumber()), Integer.toString(fnr.getMaxFlightNumber())));
            }
        }

        public String getFlightNumbersPattern() {
            if (this.flightNumbers.isEmpty()) {
                return null;
            }
            StringBuilder res = new StringBuilder();
            this.appendFlightNumbersPattern(res);
            return res.toString();
        }

        void appendSegmentsCountPattern(StringBuilder buf) {
            if (this.segmentsCountRestriction == null) {
                return;
            }
            if (this.segmentsCountRestriction.getMinCount() == this.segmentsCountRestriction.getMaxCount()) {
                buf.append(Integer.toString(this.segmentsCountRestriction.getMinCount()));
            } else {
                buf.append(String.format("%s-%s", Integer.toString(this.segmentsCountRestriction.getMinCount()), Integer.toString(this.segmentsCountRestriction.getMaxCount())));
            }
        }

        public String getSegmentsCountPattern() {
            if (this.segmentsCountRestriction == null) {
                return null;
            }
            StringBuilder res = new StringBuilder();
            this.appendSegmentsCountPattern(res);
            return res.toString();
        }

        public void fromXML(Element elm) throws Exception {
            for (Element routePatternElm : XmlUtil.getElements((Element)elm, (String)"routePatterns")) {
                Element[] items = XmlUtil.getElements((Element)routePatternElm, (String)"item");
                if (items == null || items.length <= 0 || !StringUtils.isBlank((String)items[0].getAttribute("class"))) continue;
                routePatternElm.getOwnerDocument().renameNode(routePatternElm, null, "marketingCarriers");
            }
            this.routes.clear();
            for (Element element : XmlUtil.getElements((Element)elm, (String)"routePatterns/item")) {
                GeoLocationPair pair = (GeoLocationPair)XHelper.readObject((Element)element, (String)".");
                this.routes.add(pair);
            }
            this.marketingCarriers.clear();
            for (Element element : XmlUtil.getElements((Element)elm, (String)"marketingCarriers/item")) {
                this.marketingCarriers.add(XHelper.readString((Element)element, (String)"."));
            }
            this.operatingCarriers.clear();
            for (Element element : XmlUtil.getElements((Element)elm, (String)"operatingCarriers/item")) {
                this.operatingCarriers.add(XHelper.readString((Element)element, (String)"."));
            }
            this.flightNumbers.clear();
            for (Element element : XmlUtil.getElements((Element)elm, (String)"flightNumbers/item")) {
                this.flightNumbers.add((FlightNumbersRestriction)XHelper.readObject((Element)element, (String)"."));
            }
            this.segmentsCountRestriction = (SegmentsCountRestriction)XHelper.readObject((Element)elm, (String)"segmentsCountRestriction");
        }

        protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
            String tagName = reader.getName().getLocalPart();
            if ("routePatterns".equals(tagName)) {
                while (reader.nextTag() != 2) {
                    if ("item".equals(reader.getName().getLocalPart())) {
                        this.routes.add((GeoLocationPair)XSHelper.readObject((XMLStreamReader)reader));
                        continue;
                    }
                    XSHelper.skipElement((XMLStreamReader)reader);
                }
                return true;
            }
            if ("marketingCarriers".equals(tagName)) {
                while (reader.nextTag() != 2) {
                    if ("item".equals(reader.getName().getLocalPart())) {
                        this.marketingCarriers.add(XSHelper.readString((XMLStreamReader)reader));
                        continue;
                    }
                    XSHelper.skipElement((XMLStreamReader)reader);
                }
                return true;
            }
            if ("operatingCarriers".equals(tagName)) {
                while (reader.nextTag() != 2) {
                    if ("item".equals(reader.getName().getLocalPart())) {
                        this.operatingCarriers.add(XSHelper.readString((XMLStreamReader)reader));
                        continue;
                    }
                    XSHelper.skipElement((XMLStreamReader)reader);
                }
                return true;
            }
            if ("flightNumbers".equals(tagName)) {
                while (reader.nextTag() != 2) {
                    if ("item".equals(reader.getName().getLocalPart())) {
                        this.flightNumbers.add((FlightNumbersRestriction)XSHelper.readObject((XMLStreamReader)reader));
                        continue;
                    }
                    XSHelper.skipElement((XMLStreamReader)reader);
                }
                return true;
            }
            if ("segmentsCountRestriction".equals(tagName)) {
                this.segmentsCountRestriction = (SegmentsCountRestriction)XSHelper.readObject((XMLStreamReader)reader);
                return true;
            }
            return false;
        }

        public BaseEntity newInstance(String uid) {
            return new ComplexSegmentRestriction(uid);
        }
    }

    public static class SegmentsCountRestriction
    implements Serializable,
    XSerializable,
    XSSerializable,
    XCloneable {
        private static final long serialVersionUID = 5005714914636329796L;
        private int minCount;
        private int maxCount;

        public SegmentsCountRestriction() {
        }

        public SegmentsCountRestriction(int min, int max) {
            this.minCount = min;
            this.maxCount = max;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SegmentsCountRestriction)) {
                return false;
            }
            SegmentsCountRestriction other = (SegmentsCountRestriction)obj;
            if (this.minCount != other.minCount) {
                return false;
            }
            return this.maxCount == other.maxCount;
        }

        public int hashCode() {
            return MiscUtil.hash((Object[])new Object[]{this.minCount, this.maxCount});
        }

        public void toXML(Element elm) throws Exception {
            XHelper.writeInt((Element)elm, (String)"minCount", (int)this.minCount);
            XHelper.writeInt((Element)elm, (String)"maxCount", (int)this.maxCount);
        }

        public void toXML(XMLStreamWriter writer) throws Exception {
            XSHelper.writeInt((XMLStreamWriter)writer, (String)"minCount", (int)this.minCount);
            XSHelper.writeInt((XMLStreamWriter)writer, (String)"maxCount", (int)this.maxCount);
        }

        public void fromXML(Element elm) throws Exception {
            this.minCount = XHelper.readInt((Element)elm, (String)"minCount", (int)0);
            this.maxCount = XHelper.readInt((Element)elm, (String)"maxCount", (int)0);
        }

        public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
            SegmentsCountRestriction clone = new SegmentsCountRestriction();
            clone.minCount = this.minCount;
            clone.maxCount = this.maxCount;
            return clone;
        }

        public void fromXML(XMLStreamReader reader) throws Exception {
            while (reader.nextTag() != 2) {
                String tag = reader.getName().getLocalPart();
                if ("minCount".equals(tag)) {
                    this.minCount = XSHelper.readInt((XMLStreamReader)reader, (int)0);
                    continue;
                }
                if ("maxCount".equals(tag)) {
                    this.maxCount = XSHelper.readInt((XMLStreamReader)reader, (int)0);
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
        }

        public String toString() {
            return this.minCount == this.maxCount ? Integer.toString(this.minCount) : String.format("%s-%s", Integer.toString(this.minCount), Integer.toString(this.maxCount));
        }
    }

    public static class GeoLocationPair
    implements Serializable,
    XSerializable,
    XSSerializable,
    XCloneable {
        private static final long serialVersionUID = 795035287789913621L;
        private GeoLocationPattern startLocation;
        private GeoLocationPattern finalLocation;

        public GeoLocationPair() {
        }

        public GeoLocationPair(GeoLocationPattern start, GeoLocationPattern end) {
            this.startLocation = start;
            this.finalLocation = end;
        }

        public GeoLocationPattern getStartLocation() {
            return this.startLocation;
        }

        public GeoLocationPattern getFinalLocation() {
            return this.finalLocation;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GeoLocationPair)) {
                return false;
            }
            GeoLocationPair other = (GeoLocationPair)obj;
            if (!MiscUtil.equals((Object)this.startLocation, (Object)other.startLocation)) {
                return false;
            }
            return MiscUtil.equals((Object)this.finalLocation, (Object)other.finalLocation);
        }

        public int hashCode() {
            return MiscUtil.hash((Object[])new Object[]{this.startLocation, this.finalLocation});
        }

        public void toXML(Element elm) throws Exception {
            XHelper.writeObject((Element)elm, (String)"startLocation", (Object)this.startLocation);
            XHelper.writeObject((Element)elm, (String)"finalLocation", (Object)this.finalLocation);
        }

        public void toXML(XMLStreamWriter writer) throws Exception {
            XSHelper.writeObject((XMLStreamWriter)writer, (String)"startLocation", (Object)this.startLocation);
            XSHelper.writeObject((XMLStreamWriter)writer, (String)"finalLocation", (Object)this.finalLocation);
        }

        public void fromXML(Element elm) throws Exception {
            this.startLocation = (GeoLocationPattern)XHelper.readObject((Element)elm, (String)"startLocation");
            this.finalLocation = (GeoLocationPattern)XHelper.readObject((Element)elm, (String)"finalLocation");
        }

        public void fromXML(XMLStreamReader reader) throws Exception {
            while (reader.nextTag() != 2) {
                String tag = reader.getName().getLocalPart();
                if ("startLocation".equals(tag)) {
                    this.startLocation = (GeoLocationPattern)XSHelper.readObject((XMLStreamReader)reader);
                    continue;
                }
                if ("finalLocation".equals(tag)) {
                    this.finalLocation = (GeoLocationPattern)XSHelper.readObject((XMLStreamReader)reader);
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
        }

        public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
            GeoLocationPair clone = new GeoLocationPair();
            clone.startLocation = this.startLocation != null ? (GeoLocationPattern)this.startLocation.clone(newUids, uids) : null;
            clone.finalLocation = this.finalLocation != null ? (GeoLocationPattern)this.finalLocation.clone(newUids, uids) : null;
            return clone;
        }

        public String toString() {
            return String.format("%s-%s", this.startLocation, this.finalLocation);
        }
    }

    public static class GeoLocationPattern
    implements Serializable,
    XSerializable,
    XSSerializable,
    XCloneable {
        private static final long serialVersionUID = 8163857825019820710L;
        private GeoLocationConjunctionType conjunctionType;
        private final List<GeoLocationCode> codes = new ArrayList<GeoLocationCode>();

        public GeoLocationConjunctionType getConjunctionType() {
            return this.conjunctionType;
        }

        public void setConjunctionType(GeoLocationConjunctionType value) {
            this.conjunctionType = value;
        }

        public List<GeoLocationCode> getCodes() {
            return this.codes;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GeoLocationPattern)) {
                return false;
            }
            GeoLocationPattern other = (GeoLocationPattern)obj;
            if (!MiscUtil.equals((Object)((Object)this.conjunctionType), (Object)((Object)other.conjunctionType))) {
                return false;
            }
            return CollectionUtil.equals(this.codes, other.codes, (boolean)true);
        }

        public int hashCode() {
            return MiscUtil.hash((Object[])new Object[]{this.conjunctionType, this.codes});
        }

        public void fromXML(Element elm) throws Exception {
            this.conjunctionType = (GeoLocationConjunctionType)XHelper.readEnum((Element)elm, (String)"conjunctionType", GeoLocationConjunctionType.class);
            this.codes.clear();
            for (Element element : XmlUtil.getElements((Element)elm, (String)"codes/item")) {
                this.codes.add((GeoLocationCode)XHelper.readObject((Element)element, (String)"."));
            }
        }

        public void fromXML(XMLStreamReader reader) throws Exception {
            while (reader.nextTag() != 2) {
                String tag = reader.getName().getLocalPart();
                if ("conjunctionType".equals(tag)) {
                    this.conjunctionType = (GeoLocationConjunctionType)XSHelper.readEnum((XMLStreamReader)reader, GeoLocationConjunctionType.class);
                    continue;
                }
                if ("codes".equals(tag)) {
                    while (reader.nextTag() != 2) {
                        if ("item".equals(reader.getName().getLocalPart())) {
                            this.codes.add((GeoLocationCode)XSHelper.readObject((XMLStreamReader)reader));
                            continue;
                        }
                        XSHelper.skipElement((XMLStreamReader)reader);
                    }
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
        }

        public void toXML(Element elm) throws Exception {
            XHelper.writeEnum((Element)elm, (String)"conjunctionType", (Enum)this.conjunctionType);
            for (GeoLocationCode item : this.codes) {
                XHelper.writeObject((Element)elm, (String)"codes/item", (Object)item);
            }
        }

        public void toXML(XMLStreamWriter writer) throws Exception {
            XSHelper.writeEnum((XMLStreamWriter)writer, (String)"conjunctionType", (Enum)this.conjunctionType);
            if (!this.codes.isEmpty()) {
                writer.writeStartElement("codes");
                for (GeoLocationCode item : this.codes) {
                    XSHelper.writeObject((XMLStreamWriter)writer, (String)"item", (Object)item);
                }
                writer.writeEndElement();
            }
        }

        public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
            GeoLocationPattern clone = new GeoLocationPattern();
            clone.conjunctionType = this.conjunctionType;
            for (GeoLocationCode item : this.codes) {
                clone.codes.add((GeoLocationCode)item.clone(newUids, uids));
            }
            return clone;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            for (GeoLocationCode code : this.codes) {
                if (buf.length() > 0) {
                    buf.append(this.conjunctionType == GeoLocationConjunctionType.AND ? "&" : "|");
                }
                buf.append(code);
            }
            return buf.toString();
        }
    }

    public static class GeoLocationCode
    implements Serializable,
    XSerializable,
    XSSerializable,
    XCloneable {
        private static final long serialVersionUID = 2641171540578186349L;
        private boolean hasNegativePrefix;
        private String code;

        public GeoLocationCode() {
        }

        public GeoLocationCode(boolean prefix, String aCode) {
            this.hasNegativePrefix = prefix;
            this.code = aCode;
        }

        public boolean isHasNegativePrefix() {
            return this.hasNegativePrefix;
        }

        public String getCode() {
            return this.code;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GeoLocationCode)) {
                return false;
            }
            GeoLocationCode other = (GeoLocationCode)obj;
            if (this.hasNegativePrefix != other.hasNegativePrefix) {
                return false;
            }
            return MiscUtil.equals((Object)this.code, (Object)other.code);
        }

        public int hashCode() {
            return MiscUtil.hash((Object[])new Object[]{this.hasNegativePrefix, this.code});
        }

        public void toXML(Element elm) throws Exception {
            XHelper.writeBoolean((Element)elm, (String)"hasNegativePrefix", (boolean)this.hasNegativePrefix);
            XHelper.writeString((Element)elm, (String)"code", (String)this.code);
        }

        public void toXML(XMLStreamWriter writer) throws Exception {
            XSHelper.writeBoolean((XMLStreamWriter)writer, (String)"hasNegativePrefix", (boolean)this.hasNegativePrefix);
            XSHelper.writeString((XMLStreamWriter)writer, (String)"code", (String)this.code);
        }

        public void fromXML(Element elm) throws Exception {
            this.hasNegativePrefix = XHelper.readBoolean((Element)elm, (String)"hasNegativePrefix", (boolean)false);
            this.code = XHelper.readString((Element)elm, (String)"code");
        }

        public void fromXML(XMLStreamReader reader) throws Exception {
            while (reader.nextTag() != 2) {
                String tag = reader.getName().getLocalPart();
                if ("hasNegativePrefix".equals(tag)) {
                    this.hasNegativePrefix = XSHelper.readBoolean((XMLStreamReader)reader, (boolean)false);
                    continue;
                }
                if ("code".equals(tag)) {
                    this.code = XSHelper.readString((XMLStreamReader)reader);
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
        }

        public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
            GeoLocationCode clone = new GeoLocationCode();
            clone.hasNegativePrefix = this.hasNegativePrefix;
            clone.code = this.code;
            return clone;
        }

        public String toString() {
            return this.hasNegativePrefix ? "!" : "" + this.code;
        }
    }

    public static class FlightNumbersRestriction
    implements Serializable,
    XSerializable,
    XSSerializable,
    XCloneable {
        private static final long serialVersionUID = -3342617344104856345L;
        private int minFlightNumber;
        private int maxFlightNumber;

        public FlightNumbersRestriction() {
        }

        public FlightNumbersRestriction(int min, int max) {
            this.minFlightNumber = min;
            this.maxFlightNumber = max;
        }

        public int getMaxFlightNumber() {
            return this.maxFlightNumber;
        }

        public int getMinFlightNumber() {
            return this.minFlightNumber;
        }

        public void fromXML(Element elm) throws Exception {
            this.minFlightNumber = XHelper.readInt((Element)elm, (String)"minFlightNumber", (int)0);
            this.maxFlightNumber = XHelper.readInt((Element)elm, (String)"maxFlightNumber", (int)0);
        }

        public void fromXML(XMLStreamReader reader) throws Exception {
            while (reader.nextTag() != 2) {
                String tag = reader.getName().getLocalPart();
                if ("minFlightNumber".equals(tag)) {
                    this.minFlightNumber = XSHelper.readInt((XMLStreamReader)reader, (int)0);
                    continue;
                }
                if ("maxFlightNumber".equals(tag)) {
                    this.maxFlightNumber = XSHelper.readInt((XMLStreamReader)reader, (int)0);
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
        }

        public void toXML(Element elm) throws Exception {
            XHelper.writeInt((Element)elm, (String)"minFlightNumber", (int)this.minFlightNumber);
            XHelper.writeInt((Element)elm, (String)"maxFlightNumber", (int)this.maxFlightNumber);
        }

        public void toXML(XMLStreamWriter writer) throws Exception {
            XSHelper.writeInt((XMLStreamWriter)writer, (String)"minFlightNumber", (int)this.minFlightNumber);
            XSHelper.writeInt((XMLStreamWriter)writer, (String)"maxFlightNumber", (int)this.maxFlightNumber);
        }

        public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
            FlightNumbersRestriction clone = new FlightNumbersRestriction();
            clone.minFlightNumber = this.minFlightNumber;
            clone.maxFlightNumber = this.maxFlightNumber;
            return clone;
        }

        public String toString() {
            return this.maxFlightNumber == this.minFlightNumber ? Integer.toString(this.maxFlightNumber) : String.format("%s-%s", Integer.toString(this.minFlightNumber), Integer.toString(this.maxFlightNumber));
        }
    }

    public static enum GeoLocationConjunctionType {
        OR,
        AND;

    }
}

