/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public final class SegmentRestrictions
implements Serializable,
XSerializable,
XSSerializable,
XCloneable {
    private static final long serialVersionUID = -5097172277953850104L;
    private String routeCodes;
    private String airlineCodes;
    private TariffType tariffType;
    private BranchPositionRestrictionType firstInBranch;
    private BranchPositionRestrictionType lastInBranch;

    private static boolean matchesBranchPositionRestrictions(int n, List<Boolean> connected, List<Boolean> surface, BranchPositionRestrictionType firstInBranch, BranchPositionRestrictionType lastInBranch) {
        if (connected == null || connected.size() == 0) {
            return false;
        }
        if (firstInBranch == BranchPositionRestrictionType.YES && Boolean.TRUE.equals(connected.get(n))) {
            return false;
        }
        if (firstInBranch == BranchPositionRestrictionType.NO && Boolean.FALSE.equals(connected.get(n))) {
            return false;
        }
        if (lastInBranch == BranchPositionRestrictionType.YES && n + 1 < connected.size() && !Boolean.FALSE.equals(connected.get(n + 1)) && !Boolean.TRUE.equals(surface.get(n + 1))) {
            return false;
        }
        return lastInBranch != BranchPositionRestrictionType.NO || n + 1 < connected.size() && !Boolean.FALSE.equals(connected.get(n + 1)) && !Boolean.TRUE.equals(surface.get(n + 1));
    }

    private static boolean matchesInternal(SegmentRestrictions restr, String[] departureCityCodes, String[] arrivalCityCodes, List<String> airlines, boolean domesticFlight) {
        StringTokenizer st;
        boolean found;
        if (restr.tariffType == TariffType.DOMESTIC && !domesticFlight) {
            return false;
        }
        if (restr.tariffType == TariffType.INTERNATIONAL && domesticFlight) {
            return false;
        }
        if (!TextUtil.isBlank((String)restr.airlineCodes)) {
            found = false;
            st = new StringTokenizer(restr.airlineCodes, ",;");
            while (st.hasMoreTokens()) {
                String airlineCode = st.nextToken();
                if (TextUtil.isBlank((String)airlineCode)) continue;
                boolean negative = false;
                if (airlineCode.startsWith("!")) {
                    negative = true;
                    airlineCode = airlineCode.substring(1);
                }
                if (!negative && airlines.contains(airlineCode)) {
                    found = true;
                    break;
                }
                if (!negative || airlines.contains(airlineCode)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        if (!TextUtil.isBlank((String)restr.routeCodes)) {
            found = false;
            st = new StringTokenizer(restr.routeCodes, ",;");
            while (st.hasMoreTokens()) {
                int idx;
                String pairs = st.nextToken();
                if (TextUtil.isBlank((String)pairs) || (idx = pairs.indexOf(45)) < 0 || idx == pairs.length() - 1) continue;
                String ruleCity1 = pairs.substring(0, idx);
                String ruleCity2 = pairs.substring(idx + 1);
                if (ruleCity2.indexOf(45) >= 0 || !SegmentRestrictions.matchesInternal(departureCityCodes, ruleCity1, arrivalCityCodes, ruleCity2)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }

    public static boolean matchesSegmentRestrictions(List<String[]> cities, List<Boolean> surface, List<Boolean> connected, List<Boolean> domesticFlightAC, List<String[]> airlines, SegmentRestrictions restr) {
        int index = 0;
        for (int n = 0; n < cities.size() - 1; ++n) {
            if (Boolean.TRUE.equals(surface.get(n)) || !SegmentRestrictions.matchesBranchPositionRestrictions(n, connected, surface, restr.firstInBranch, restr.lastInBranch)) continue;
            int max = n;
            if (Boolean.TRUE.equals(connected.get(n))) {
                int m;
                int n2 = m = n == 0 ? 1 : n;
                while (m < cities.size() - 1) {
                    if (Boolean.FALSE.equals(connected.get(m))) {
                        max = m;
                        break;
                    }
                    ++m;
                }
            }
            int min = n;
            for (int m = n - 1; m > 0 && !Boolean.FALSE.equals(connected.get(n)); --m) {
                if (!Boolean.TRUE.equals(connected.get(n))) continue;
                min = m;
            }
            boolean domAC = true;
            for (int m = min; m <= max; ++m) {
                domAC = domAC && Boolean.TRUE.equals(domesticFlightAC.get(m));
            }
            if (SegmentRestrictions.matchesInternal(restr, cities.get(n), cities.get(n + 1), Arrays.asList((Object[])airlines.get(index)), domAC)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private static boolean matchesInternal(String[] proxyCityCodes1, String ruleCity1, String[] proxyCityCodes2, String ruleCity2) {
        if (!SegmentRestrictions.matchesInternal(proxyCityCodes1, ruleCity1)) {
            return false;
        }
        return SegmentRestrictions.matchesInternal(proxyCityCodes2, ruleCity2);
    }

    public static void buildInfo(StringBuilder buf, RuleCondition cond, SegmentRestrictions value) {
        if (value == null) {
            return;
        }
        if (cond != null) {
            buf.append(cond.getDisplayName()).append(" ");
        }
        buf.append(L10n.get((String)Messages.SEGMENT));
        if (!TextUtil.isBlank((String)value.routeCodes)) {
            buf.append(" ").append(value.routeCodes);
        }
        if (value.tariffType == TariffType.DOMESTIC || value.tariffType == TariffType.INTERNATIONAL) {
            buf.append(" " + L10n.get((String)Messages.WHERE_TARIFF) + " ").append((Object)value.tariffType);
        }
        if (!TextUtil.isBlank((String)value.airlineCodes)) {
            buf.append(" " + L10n.get((String)Messages.WHERE_AK) + " ").append(value.airlineCodes);
        }
        if (value.firstInBranch == BranchPositionRestrictionType.YES) {
            buf.append(" " + L10n.get((String)Messages.FIRST_IN_BRANCH));
        } else if (value.firstInBranch == BranchPositionRestrictionType.NO) {
            buf.append(" " + L10n.get((String)Messages.NOT_FIRST_IN_BRANCH));
        }
        if (value.lastInBranch == BranchPositionRestrictionType.YES) {
            buf.append(" " + L10n.get((String)Messages.LAST_IN_BRANCH));
        } else if (value.lastInBranch == BranchPositionRestrictionType.NO) {
            buf.append(" " + L10n.get((String)Messages.NOT_LAST_IN_BRANCH));
        }
    }

    private static boolean matchesInternal(String[] proxyCityCodes, String ruleCity) {
        if ("*".equals(ruleCity)) {
            return true;
        }
        boolean negative = false;
        if (ruleCity.startsWith("!")) {
            negative = true;
            ruleCity = ruleCity.substring(1);
        }
        boolean contains = false;
        for (String proxyCityCode : proxyCityCodes) {
            if (!ruleCity.equals(proxyCityCode)) continue;
            contains = true;
            break;
        }
        if (!negative && !contains) {
            return false;
        }
        return !negative || !contains;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SegmentRestrictions)) {
            return false;
        }
        SegmentRestrictions other = (SegmentRestrictions)obj;
        if (!MiscUtil.equals((Object)this.airlineCodes, (Object)other.airlineCodes)) {
            return false;
        }
        if (!MiscUtil.equals((Object)this.routeCodes, (Object)other.routeCodes)) {
            return false;
        }
        if (!MiscUtil.equals((Object)((Object)this.tariffType), (Object)((Object)other.tariffType))) {
            return false;
        }
        if (!MiscUtil.equals((Object)((Object)this.firstInBranch), (Object)((Object)other.firstInBranch))) {
            return false;
        }
        return MiscUtil.equals((Object)((Object)this.lastInBranch), (Object)((Object)other.lastInBranch));
    }

    public void fromXML(Element elm) {
        this.airlineCodes = XHelper.readString((Element)elm, (String)"airlineCodes");
        this.routeCodes = XHelper.readString((Element)elm, (String)"routeCodes");
        this.tariffType = (TariffType)XHelper.readEnum((Element)elm, (String)"tariffType", TariffType.class);
        this.firstInBranch = (BranchPositionRestrictionType)XHelper.readEnum((Element)elm, (String)"firstInBranch", BranchPositionRestrictionType.class);
        this.lastInBranch = (BranchPositionRestrictionType)XHelper.readEnum((Element)elm, (String)"lastInBranch", BranchPositionRestrictionType.class);
    }

    public SegmentRestrictions(String airlines, String routes, String tarType, String frstInBranch, String lstInBranch) {
        this.airlineCodes = airlines;
        if ("null".equals(this.airlineCodes)) {
            this.airlineCodes = null;
        }
        this.routeCodes = routes;
        if ("null".equals(this.routeCodes)) {
            this.routeCodes = null;
        }
        this.tariffType = TextUtil.isBlank((String)tarType) || "null".equals(tarType) ? null : TariffType.valueOf(tarType);
        this.firstInBranch = TextUtil.isBlank((String)frstInBranch) || "null".equals(frstInBranch) ? null : BranchPositionRestrictionType.valueOf(frstInBranch);
        this.lastInBranch = TextUtil.isBlank((String)lstInBranch) || "null".equals(lstInBranch) ? null : BranchPositionRestrictionType.valueOf(lstInBranch);
    }

    public SegmentRestrictions() {
    }

    public void copyTo(SegmentRestrictions target) {
        if (target == null) {
            return;
        }
        target.airlineCodes = this.airlineCodes;
        target.routeCodes = this.routeCodes;
        target.tariffType = this.tariffType;
        target.firstInBranch = this.firstInBranch;
        target.lastInBranch = this.lastInBranch;
    }

    public String getRouteCodes() {
        return this.routeCodes;
    }

    public String getAirlineCodes() {
        return this.airlineCodes;
    }

    public TariffType getTariffType() {
        return this.tariffType;
    }

    public BranchPositionRestrictionType getFirstInBranch() {
        return this.firstInBranch;
    }

    public BranchPositionRestrictionType getLastInBranch() {
        return this.lastInBranch;
    }

    public void toXML(Element elm) {
        XHelper.writeString((Element)elm, (String)"airlineCodes", (String)this.airlineCodes, (boolean)true);
        XHelper.writeString((Element)elm, (String)"routeCodes", (String)this.routeCodes, (boolean)true);
        XHelper.writeEnum((Element)elm, (String)"tariffType", (Enum)this.tariffType);
        XHelper.writeEnum((Element)elm, (String)"firstInBranch", (Enum)this.firstInBranch);
        XHelper.writeEnum((Element)elm, (String)"lastInBranch", (Enum)this.lastInBranch);
    }

    public int hashCode() {
        return MiscUtil.hash((Object[])new Object[]{this.airlineCodes, this.routeCodes, this.tariffType, this.firstInBranch, this.lastInBranch});
    }

    public Object clone(boolean newUids, Map<String, String> uids) {
        SegmentRestrictions clone = new SegmentRestrictions();
        clone.airlineCodes = this.airlineCodes;
        clone.routeCodes = this.routeCodes;
        clone.tariffType = this.tariffType;
        clone.firstInBranch = this.firstInBranch;
        clone.lastInBranch = this.lastInBranch;
        return clone;
    }

    public void fromXML(XMLStreamReader reader) throws Exception {
        while (reader.nextTag() != 2) {
            String tag = reader.getName().getLocalPart();
            if ("airlineCodes".equals(tag)) {
                this.airlineCodes = XSHelper.readString((XMLStreamReader)reader);
                continue;
            }
            if ("routeCodes".equals(tag)) {
                this.routeCodes = XSHelper.readString((XMLStreamReader)reader);
                continue;
            }
            if ("tariffType".equals(tag)) {
                this.tariffType = (TariffType)XSHelper.readEnum((XMLStreamReader)reader, TariffType.class);
                continue;
            }
            if ("firstInBranch".equals(tag)) {
                this.firstInBranch = (BranchPositionRestrictionType)XSHelper.readEnum((XMLStreamReader)reader, BranchPositionRestrictionType.class);
                continue;
            }
            if ("lastInBranch".equals(tag)) {
                this.lastInBranch = (BranchPositionRestrictionType)XSHelper.readEnum((XMLStreamReader)reader, BranchPositionRestrictionType.class);
                continue;
            }
            XSHelper.skipElement((XMLStreamReader)reader);
        }
    }

    public void toXML(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString((XMLStreamWriter)writer, (String)"airlineCodes", (String)this.airlineCodes, (boolean)true);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"routeCodes", (String)this.routeCodes, (boolean)true);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"tariffType", (Enum)this.tariffType);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"firstInBranch", (Enum)this.firstInBranch);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"lastInBranch", (Enum)this.lastInBranch);
    }

    public static enum BranchPositionRestrictionType {
        NONE{

            public String toString() {
                return L10n.get((String)Messages.NONE);
            }
        }
        ,
        YES{

            public String toString() {
                return L10n.get((String)Messages.YES);
            }
        }
        ,
        NO{

            public String toString() {
                return L10n.get((String)Messages.NO);
            }
        };

    }

    public static enum TariffType {
        ALL{

            public String toString() {
                return L10n.get((String)Messages.ANY);
            }
        }
        ,
        INTERNATIONAL{

            public String toString() {
                return L10n.get((String)Messages.INTERNATIONAL_AK);
            }
        }
        ,
        DOMESTIC{

            public String toString() {
                return L10n.get((String)Messages.DOMESTIC_AK);
            }
        };

    }
}

