/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.BrandNameRuleRestrictionModifier;
import com.gridnine.xtrip.common.model.rules.standard.CommonProductProperties;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.ContractActions;
import com.gridnine.xtrip.common.model.rules.standard.ContractsFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.GeneralProductActions;
import com.gridnine.xtrip.common.model.rules.standard.ProductTicketInfoProperties;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleEnvironmentHelper;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.SabreSynchronizationActions;
import com.gridnine.xtrip.common.model.rules.standard.SabreSynchronizationAdditionalTargets;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleRestrictionModifier;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import java.util.Arrays;
import java.util.stream.Collectors;

public class StandardRuleEnvironment
implements RulesEnvironment.Hook {
    public void environmentInitialized(RulesEnvironment env) {
        env.registerTargets((RuleTarget[])Targets.values());
        env.registerProperties((RuleProperty[])Properties.values());
        env.registerConditions((RuleCondition[])Conditions.values());
        env.registerActions((RuleAction[])Actions.values());
        env.registerActions((RuleAction[])GeneralProductActions.values());
        env.registerFilteringCategories((RuleFilteringCategory[])ContractsFilteringCategories.values());
        for (Properties properties : Properties.values()) {
            for (String string : properties.getTargetIds()) {
                env.registerTarget2propertyAssociation(string, properties.getId());
            }
            for (String string : properties.getConditionIds()) {
                env.registerProperty2conditionAssociation(properties.getId(), string);
            }
            for (String string : ContractsFilteringCategories.values()) {
                env.registerFilteringCategory2propertyAssociation(((ContractsFilteringCategories)((Object)string)).getId(), properties.getId());
            }
        }
        for (Enum enum_ : Actions.values()) {
            for (String string : ((Actions)enum_).getTargetIds()) {
                env.registerTarget2actionAssociation(string, ((Actions)enum_).getId());
            }
            for (String string : ContractsFilteringCategories.values()) {
                env.registerFilteringCategory2actionAssociation(((ContractsFilteringCategories)((Object)string)).getId(), ((Actions)enum_).getId());
            }
        }
        for (Enum enum_ : GeneralProductActions.values()) {
            for (String string : ((GeneralProductActions)enum_).getTargetIds()) {
                env.registerTarget2actionAssociation(string, ((GeneralProductActions)enum_).getId());
            }
            for (String string : ContractsFilteringCategories.values()) {
                env.registerFilteringCategory2actionAssociation(((ContractsFilteringCategories)((Object)string)).getId(), ((GeneralProductActions)enum_).getId());
            }
        }
        for (Enum enum_ : ContractsFilteringCategories.values()) {
            for (String string : Targets.values()) {
                env.registerFilteringCategory2targetAssociation(((ContractsFilteringCategories)enum_).getId(), ((Targets)((Object)string)).getId());
            }
        }
        this.addSabreSynchronizationAdditionalTargets(env);
        for (Enum enum_ : new CommonProductProperties[]{CommonProductProperties.TICKET_TYPE, CommonProductProperties.PRODUCT_STATUS}) {
            RuleEnvironmentHelper.registerPropertiesToContracts(env, enum_);
            for (RuleTarget ruleTarget : Arrays.asList(Targets.PRODUCT_COMMISSION)) {
                env.registerTarget2propertyAssociation(ruleTarget.getId(), ((CommonProductProperties)enum_).getId());
            }
        }
        StandardRuleEnvironment.registerSupplierProperty(env, Targets.PRODUCT_COMMISSION);
        env.registerActions((RuleAction[])ContractActions.values());
        for (Enum enum_ : ContractActions.values()) {
            env.registerTarget2actionAssociation(Targets.PRODUCT_COMMISSION.getId(), ((ContractActions)enum_).getId());
            env.registerTarget2actionAssociation(Targets.HOTELS_COMMISSION.getId(), ((ContractActions)enum_).getId());
            env.registerTarget2actionAssociation(Targets.AEROEXPRESS_COMMISSION.getId(), ((ContractActions)enum_).getId());
            env.registerTarget2actionAssociation(Targets.CAR.getId(), ((ContractActions)enum_).getId());
            env.registerTarget2actionAssociation(Targets.DELIVERY.getId(), ((ContractActions)enum_).getId());
            env.registerTarget2actionAssociation(Targets.INSURANCE_ACCIDENT_COMMISSION.getId(), ((ContractActions)enum_).getId());
            env.registerTarget2actionAssociation(Targets.INSURANCE_TOURISTIC_COMMISSION.getId(), ((ContractActions)enum_).getId());
            env.registerTarget2actionAssociation(Targets.VISA_PRODUCT_COMMISSION.getId(), ((ContractActions)enum_).getId());
            for (ContractsFilteringCategories contractsFilteringCategories : ContractsFilteringCategories.values()) {
                env.registerFilteringCategory2actionAssociation(contractsFilteringCategories.getId(), ((ContractActions)enum_).getId());
            }
        }
        env.registerRestrictionModifier((RuleRestrictionModifier)new BrandNameRuleRestrictionModifier());
    }

    public static void registerSupplierProperty(RulesEnvironment env, RuleTarget target) {
        env.registerTarget2propertyAssociation(target.getId(), ProductTicketInfoProperties.SUPPLIERS.getId());
        for (String string : ProductTicketInfoProperties.SUPPLIERS.getConditionIds()) {
            env.registerProperty2conditionAssociation(ProductTicketInfoProperties.SUPPLIERS.getId(), string);
        }
        for (ContractsFilteringCategories contractsFilteringCategories : ContractsFilteringCategories.values()) {
            env.registerFilteringCategory2propertyAssociation(contractsFilteringCategories.getId(), ProductTicketInfoProperties.SUPPLIERS.getId());
        }
    }

    private void addSabreSynchronizationAdditionalTargets(RulesEnvironment env) {
        if (Environment.isPublished(DictionaryCache.class) && !DictHelper.getPreferenceValue(PreferenceKey.SHOW_SABRE_SYNCH_RULE_TARGETS, false)) {
            return;
        }
        env.registerTargets((RuleTarget[])SabreSynchronizationAdditionalTargets.values());
        for (SabreSynchronizationActions sabreSynchronizationActions : SabreSynchronizationActions.values()) {
            if (env.findAction(sabreSynchronizationActions.getId()) == null) {
                env.registerActions(new RuleAction[]{sabreSynchronizationActions});
            }
            env.registerTarget2actionAssociation(Targets.PRODUCT_COMMISSION.getId(), sabreSynchronizationActions.getId());
            env.registerTarget2actionAssociation(Targets.HOTELS_FOREIGN.getId(), sabreSynchronizationActions.getId());
            env.registerTarget2actionAssociation(Targets.HOTELS_DOMESTIC.getId(), sabreSynchronizationActions.getId());
            env.registerTarget2actionAssociation(Targets.DELIVERY.getId(), sabreSynchronizationActions.getId());
            env.registerTarget2actionAssociation(Targets.INSURANCE_ACCIDENT_COMMISSION.getId(), sabreSynchronizationActions.getId());
            env.registerTarget2actionAssociation(Targets.INSURANCE_TOURISTIC_COMMISSION.getId(), sabreSynchronizationActions.getId());
            env.registerTarget2actionAssociation(Targets.CAR.getId(), sabreSynchronizationActions.getId());
            env.registerTarget2actionAssociation(Targets.HOTELS_COMMISSION.getId(), sabreSynchronizationActions.getId());
            env.registerTarget2actionAssociation(Targets.VISA_PRODUCT_COMMISSION.getId(), sabreSynchronizationActions.getId());
            for (Enum enum_ : SabreSynchronizationAdditionalTargets.values()) {
                env.registerTarget2actionAssociation(enum_.getId(), sabreSynchronizationActions.getId());
            }
            for (Enum enum_ : ContractsFilteringCategories.values()) {
                env.registerFilteringCategory2actionAssociation(((ContractsFilteringCategories)enum_).getId(), sabreSynchronizationActions.getId());
            }
        }
        for (Enum enum_ : SabreSynchronizationAdditionalTargets.values()) {
            for (ContractsFilteringCategories contractsFilteringCategories : ContractsFilteringCategories.values()) {
                env.registerFilteringCategory2targetAssociation(contractsFilteringCategories.getId(), enum_.getId());
            }
        }
    }

    private <P extends RuleProperty & RulePropertyConditions> void registerDefaultProduct(RulesEnvironment environment, RuleTarget ruleTarget, P ... properties) {
        for (P property : properties) {
            for (String conditionId : ((RulePropertyConditions)property).getConditionIds()) {
                environment.registerProperty2conditionAssociation(property.getId(), conditionId);
            }
        }
        String[] propertiesIds = Arrays.stream(properties).map(RuleProperty::getId).collect(Collectors.toList()).toArray(new String[0]);
        for (ContractsFilteringCategories contractsFilteringCategories : ContractsFilteringCategories.values()) {
            environment.registerFilteringCategory2targetAssociation(contractsFilteringCategories.getId(), ruleTarget.getId());
            this.registerPropertyAssociation(environment, contractsFilteringCategories.getId(), ruleTarget.getId(), propertiesIds);
        }
        for (ContractsFilteringCategories contractsFilteringCategories : new RuleAction[]{Actions.SIMPLE_FEE, Actions.PAYMENT_FEE, GeneralProductActions.GENERAL_COMMISSION}) {
            environment.registerTarget2actionAssociation(ruleTarget.getId(), contractsFilteringCategories.getId());
        }
    }

    private void registerPropertyAssociation(RulesEnvironment env, String filteringCategoryId, String targetId, String[] properties) {
        for (String property : properties) {
            env.registerFilteringCategory2propertyAssociation(filteringCategoryId, property);
            env.registerTarget2propertyAssociation(targetId, property);
        }
    }
}

