/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransatlaticRouteHelper {
    private static final int minPacificDelta = 13;
    private static final int maxPacificDelta = 24;
    private static final int minAtlanticDelta = 4;
    private static final int maxAtlanticDelta = 12;
    private static final String[] EU_CODES = new String[]{"EURO", "CIS"};
    private static final String[] AM_CODES = new String[]{"NOAM", "SOAM"};
    private static final Logger log = LoggerFactory.getLogger(TransatlaticRouteHelper.class);

    private static DateFormat createDf() {
        return new SimpleDateFormat("yyy-MM-dd-HH-mm");
    }

    static boolean isTransatlanticFlight(Product prod) {
        if (prod == null) {
            return false;
        }
        if (prod.getProductCategory() != ProductCategory.AIR) {
            return false;
        }
        for (SegmentTariff st : prod.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (!TransatlaticRouteHelper.isTransatlanticSegment((DictionaryReference<GeoLocation>)seg.getDepartureLocation(), (DictionaryReference<GeoLocation>)seg.getArriveLocation(), seg.getStartDate(), seg.getEndDate(), seg.getFlightDuration())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTransatlanticSegment(String depLoc, String arrLoc, Date startDate, Date endDate, Integer durationOfFlightInMinutes) {
        return TransatlaticRouteHelper.isTransatlanticSegment(DictHelper.findAirport(depLoc), DictHelper.findAirport(arrLoc), startDate, endDate, durationOfFlightInMinutes);
    }

    public static boolean isTransatlanticSegment(DictionaryReference<GeoLocation> depLoc, DictionaryReference<GeoLocation> arrLoc, Date startDate, Date endDate, Integer durationOfFlightInMinutes) {
        return TransatlaticRouteHelper.isTransatlanticSegment((GeoLocation)DictionaryCache.get().resolveReference(depLoc), (GeoLocation)DictionaryCache.get().resolveReference(arrLoc), startDate, endDate, durationOfFlightInMinutes);
    }

    public static boolean isTransatlanticSegment(GeoLocation departure, GeoLocation arrival, Date startDate, Date endDate, Integer durationOfFlightInMinutes) {
        boolean arrToAmerica;
        if (departure == null || arrival == null) {
            return false;
        }
        boolean depFromAmerica = TransatlaticRouteHelper.isHasRegionCodes(AM_CODES, departure);
        if (depFromAmerica == (arrToAmerica = TransatlaticRouteHelper.isHasRegionCodes(AM_CODES, arrival))) {
            return false;
        }
        if (startDate == null || endDate == null || durationOfFlightInMinutes == null) {
            return TransatlaticRouteHelper.isHasRegionCodes(EU_CODES, departure, arrival);
        }
        int delta = (int)Math.round((double)(startDate.getTime() + (long)(durationOfFlightInMinutes * 60) * 1000L - endDate.getTime()) / 3600000.0);
        if (depFromAmerica) {
            boolean canBePacific = TransatlaticRouteHelper.fits(delta, -24, -13, 1);
            boolean canBePacific2 = TransatlaticRouteHelper.fits(delta, -24, -13, 2);
            if (canBePacific && canBePacific2) {
                TransatlaticRouteHelper.reportAlgorithmProblem(departure, arrival, startDate, endDate, durationOfFlightInMinutes);
                return TransatlaticRouteHelper.isHasRegionCodes(EU_CODES, departure, arrival);
            }
            boolean canBeAtlantic = TransatlaticRouteHelper.fits(delta, -12, -4, 0);
            boolean canBeAtlantic2 = TransatlaticRouteHelper.fits(delta, -12, -4, 1);
            if (canBeAtlantic && canBeAtlantic2) {
                return TransatlaticRouteHelper.isHasRegionCodes(EU_CODES, departure, arrival);
            }
            if (canBeAtlantic && canBePacific) {
                return TransatlaticRouteHelper.isHasRegionCodes(EU_CODES, departure, arrival);
            }
            return canBeAtlantic || canBeAtlantic2;
        }
        boolean canBePacific = TransatlaticRouteHelper.fits(delta, 13, 24, -1);
        boolean canBePacific2 = TransatlaticRouteHelper.fits(delta, 13, 24, 0);
        if (canBePacific && canBePacific2) {
            return TransatlaticRouteHelper.isHasRegionCodes(EU_CODES, departure, arrival);
        }
        boolean canBeAtlantic = TransatlaticRouteHelper.fits(delta, 4, 12, 0);
        boolean canBeAtlantic2 = TransatlaticRouteHelper.fits(delta, 4, 12, 1);
        if (canBeAtlantic && canBeAtlantic2) {
            return TransatlaticRouteHelper.isHasRegionCodes(EU_CODES, departure, arrival);
        }
        if (canBeAtlantic && canBePacific) {
            return TransatlaticRouteHelper.isHasRegionCodes(EU_CODES, departure, arrival);
        }
        return canBeAtlantic || canBeAtlantic2;
    }

    private static void reportAlgorithmProblem(GeoLocation depLoc, GeoLocation arrLoc, Date startDate, Date endDate, Integer durationOfFlightInMinutes) {
        DateFormat df = TransatlaticRouteHelper.createDf();
        log.warn(String.format("flight can be both pacific and atlantic: depLoc = %s, arrLoc = %s, start date = %s, endDate = %s, duration = %s min", depLoc.getCode(), arrLoc.getCode(), df.format(startDate), df.format(endDate), durationOfFlightInMinutes));
    }

    private static boolean fits(int delta, int minDelta, int maxDelta, int daysCoeff) {
        int delta2 = delta - daysCoeff * 24;
        return delta2 >= minDelta && delta2 <= maxDelta;
    }

    private static boolean isHasRegionCodes(String[] regionCodes, GeoLocation ... locations) {
        for (GeoLocation loc : locations) {
            Country country = (Country)DictionaryCache.get().resolveReference(loc.getCountry());
            if (country == null) continue;
            for (DictionaryReference region : country.getRegions()) {
                for (String code : regionCodes) {
                    if (region == null || !region.getCode().equals(code)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private TransatlaticRouteHelper() {
    }
}

