/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.ClientCreditCardVendorProvider;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TransferPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public enum TransferProperties implements RuleProperty,
RulePropertyConditions
{
    STANDARD_CAR_CLASS{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.STANDARD_CAR_CLASS_info);
        }

        public String getRendererId() {
            return "CAR_CLASS";
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.STANDARD_CAR_CLASS_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            TransferPropertiesProvider ps = (TransferPropertiesProvider)propertySet;
            if (ps.getCarClass() == null) {
                return false;
            }
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesDictRestriction(ps.getCarClass().getCode(), (List)value, true);
            }
            return RulesHelper.matchesDictRestriction(ps.getCarClass().getCode(), (List)value, false);
        }
    }
    ,
    TRANSFER_CREDIT_CARD_TYPE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CreditCardType);
        }

        public String getRendererId() {
            return ValueTypes.CREDIT_CARD_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_CreditCardType_info), cond.getDisplayName(), RulesHelper.values2text((List)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            if (propertySet instanceof ClientCreditCardVendorProvider) {
                ClientCreditCardVendorProvider prov = (ClientCreditCardVendorProvider)propertySet;
                if (Conditions.EQUALS.equals(condition)) {
                    return RulesHelper.matchesEnumRestriction(prov.getClientCreditCardVendor(), (List)value, true);
                }
                return RulesHelper.matchesEnumRestriction(prov.getClientCreditCardVendor(), (List)value, false);
            }
            return false;
        }
    }
    ,
    TRANSFER_TOTAL_SUM{

        public String getDisplayName() {
            return L10n.get((String)Messages.TRANSFER_TOTAL_SUM_displayName);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(this.getDisplayName() + " " + cond.getDisplayName() + " " + value);
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            double fare;
            TransferPropertiesProvider ps = (TransferPropertiesProvider)propertySet;
            BigDecimal total = ps.getEquivalentSum();
            double dv = value == null ? 0.0 : ((Number)value).doubleValue();
            double d = fare = total == null ? 0.0 : total.doubleValue();
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) >= 0.01;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return fare - dv >= 0.01;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || fare - dv >= 0.01;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return dv - fare >= 0.01;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || dv - fare >= 0.01;
            }
            return false;
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }
    }
    ,
    TRANSFER_DEPARTURE_WEEK_DAYS{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TransferDepartureWeekDay);
        }

        public String getRendererId() {
            return ValueTypes.WEEK_DAY.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TransferDepartureWeekDay_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            TransferPropertiesProvider ps = (TransferPropertiesProvider)propertySet;
            if (ps.getDepartureDate() == null) {
                return false;
            }
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(DictHelper.getWeekDay(ps.getDepartureDate().getDay()), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(DictHelper.getWeekDay(ps.getDepartureDate().getDay()), (List)value, false);
            }
            return true;
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    BOOKING_DEPTH{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_BookingDepthDays);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_BookingDepthDays_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            TransferPropertiesProvider ps = (TransferPropertiesProvider)propertySet;
            int days = value == null ? 0 : ((Number)value).intValue();
            Date bookingDate = ps.getIssueDate();
            Date departureDate = ps.getDepartureDate();
            if (bookingDate == null || departureDate == null) {
                return false;
            }
            int depthDays = (int)(MiscUtil.getDuration((Date)MiscUtil.clearTime((Date)bookingDate), (Date)MiscUtil.clearTime((Date)departureDate)) / 86400000L);
            if (Conditions.EQUALS.equals(condition)) {
                return depthDays == days;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return depthDays != days;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return depthDays > days;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return depthDays >= days;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return depthDays < days;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return depthDays <= days;
            }
            return true;
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }
    }
    ,
    TRANSFER_RESERVATION_TYPE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ReservationType);
        }

        public String getRendererId() {
            return ValueTypes.RESERVATION_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ReservationType_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            TransferPropertiesProvider ps = (TransferPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getReservationType(), (List)value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getReservationType(), (List)value, false);
            }
            return true;
        }
    };


    public String getId() {
        return this.name();
    }

    @Override
    public abstract String[] getConditionIds();
}

