/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.UserDataProvider;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.util.List;
import java.util.stream.Collectors;

public enum UserProperties implements RuleProperty,
RulePropertyConditions
{
    USER_PERSON_TYPE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_UserPersonType);
        }

        public String getRendererId() {
            return ValueTypes.USER_PERSON_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_UserPersonType_info), cond.getDisplayName(), RulesHelper.values2text((List)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            UserDataProvider prov = (UserDataProvider)propertySet;
            List<String> personTypeNames = prov.getUserPersonTypes().stream().map(Enum::name).collect(Collectors.toList());
            return RulesHelper.matchesEnumRestriction(personTypeNames, (List)value, Conditions.INCLUDE.equals(condition));
        }
    };


    public String getId() {
        return this.name();
    }

    @Override
    public abstract String[] getConditionIds();
}

