/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.visa.VisaType;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.ClientCreditCardVendorProvider;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.rules.standard.VisaProductPropertiesProvider;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public enum VisaProductProperties implements RuleProperty,
RulePropertyConditions
{
    VISA_COUNTRIES{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_Countries);
        }

        public String getRendererId() {
            return ValueTypes.COUNTRIES.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_Countries, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            VisaProductPropertiesProvider propertiesProvider = (VisaProductPropertiesProvider)propertySet;
            HashSet countries = (HashSet)value;
            DictionaryReference<Country> country = propertiesProvider.getCountry();
            if (Conditions.INCLUDE.equals(condition)) {
                return country != null && RulesHelper.matchesDictRestriction(country.getCode(), countries, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return country != null && RulesHelper.matchesDictRestriction(country.getCode(), countries, false);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.VISA_PRODUCT_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    VISA_REGIONS{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_VisaRegions);
        }

        public String getRendererId() {
            return ValueTypes.GEO_REGION.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            DictionaryReference region = (DictionaryReference)value;
            buf.append(this.getDisplayName()).append(" ").append(cond.getDisplayName()).append(" ").append(region != null ? region : "");
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            VisaProductPropertiesProvider propertiesProvider = (VisaProductPropertiesProvider)propertySet;
            DictionaryReference region = (DictionaryReference)value;
            Collection regions = propertiesProvider.getRegions();
            if (Conditions.INCLUDE.equals(condition)) {
                return region != null && RulesHelper.matchesDictRestriction(region.getCode(), regions, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return region != null && RulesHelper.matchesDictRestriction(region.getCode(), regions, false);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.VISA_PRODUCT_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    VISA_TYPES{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_VisaType);
        }

        public String getRendererId() {
            return ValueTypes.VISA_TYPES.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_VisaType, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            VisaProductPropertiesProvider propertiesProvider = (VisaProductPropertiesProvider)propertySet;
            HashSet visaType = (HashSet)value;
            DictionaryReference<VisaType> type = propertiesProvider.getType();
            if (Conditions.INCLUDE.equals(condition)) {
                return type != null && RulesHelper.matchesDictRestriction(type.getCode(), visaType, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return type != null && RulesHelper.matchesDictRestriction(type.getCode(), visaType, false);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.VISA_PRODUCT_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    VISA_CREDIT_CARD_TYPE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CreditCardType);
        }

        public String getRendererId() {
            return ValueTypes.CREDIT_CARD_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.VISA_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_CreditCardType_info), cond.getDisplayName(), RulesHelper.values2text((List)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            if (propertySet instanceof ClientCreditCardVendorProvider) {
                ClientCreditCardVendorProvider prov = (ClientCreditCardVendorProvider)propertySet;
                if (Conditions.EQUALS.equals(condition)) {
                    return RulesHelper.matchesEnumRestriction(prov.getClientCreditCardVendor(), (List)value, true);
                }
                return RulesHelper.matchesEnumRestriction(prov.getClientCreditCardVendor(), (List)value, false);
            }
            return false;
        }
    }
    ,
    VISA_ENTRY_TYPES{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_VisaEntryType);
        }

        public String getRendererId() {
            return ValueTypes.VISA_ENTRY_TYPES.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_VisaEntryType, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            VisaProductPropertiesProvider propertiesProvider = (VisaProductPropertiesProvider)propertySet;
            ArrayList visaEntryType = (ArrayList)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(propertiesProvider.getEntryTypeName(), visaEntryType, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(propertiesProvider.getEntryTypeName(), visaEntryType, false);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.VISA_PRODUCT_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    VISA_EXPRESS_SERVICE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_VisaExpressService);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_VisaExpressService, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            VisaProductPropertiesProvider propertiesProvider = (VisaProductPropertiesProvider)propertySet;
            return Boolean.valueOf(propertiesProvider.isExpressService()).equals(value);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.VISA_PRODUCT_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    @Override
    public abstract String[] getConditionIds();
}

