/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard.nomenclatures;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.booking.AddServiceTypeNomenclatureRuleResult;
import com.gridnine.xtrip.common.model.booking.CategoryFeeNomenclatureRuleResult;
import com.gridnine.xtrip.common.model.booking.TaxesNomenclatureRuleResult;
import com.gridnine.xtrip.common.model.booking.TaxesWithVatRateNomenclatureRuleResult;
import com.gridnine.xtrip.common.model.dict.CommissionCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Nomenclature;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.rules.standard.nomenclatures.NomenclatureActionSet;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;

public enum NomenclatureActions implements RuleAction
{
    PRODUCT_NOMENCLATURE{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_Nomenclature_Product");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_Product_info"), (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            NomenclatureActionSet as = (NomenclatureActionSet)proxy.getActionSet();
            if (value != null) {
                as.setProductNomenclature((DictionaryReference<Nomenclature>)((DictionaryReference)value));
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }
    }
    ,
    SERVICE_NOMENCLATURE{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_Nomenclature_Service");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_Service_info"), (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            NomenclatureActionSet as = (NomenclatureActionSet)proxy.getActionSet();
            if (value != null) {
                as.setServiceNomenclature((DictionaryReference<Nomenclature>)((DictionaryReference)value));
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }
    }
    ,
    FEE_NOMENCLATURE{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_Nomenclature_Fee");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_Fee_info"), (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            NomenclatureActionSet as = (NomenclatureActionSet)proxy.getActionSet();
            if (value != null) {
                as.setFeeNomenclature((DictionaryReference<Nomenclature>)((DictionaryReference)value));
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }
    }
    ,
    VENDOR_FEE_NOMENCLATURE{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_Nomenclature_Vendor_Fee");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_Vendor_Fee_info"), (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            NomenclatureActionSet as = (NomenclatureActionSet)proxy.getActionSet();
            if (value != null) {
                as.setVendorFeeNomenclature((DictionaryReference<Nomenclature>)((DictionaryReference)value));
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }
    }
    ,
    TECHNICAL_PROVIDER_FEE_NOMENCLATURE{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_Nomenclature_Technical_Provider_Fee");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_Technical_Provider_Fee_info"), (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            NomenclatureActionSet as = (NomenclatureActionSet)proxy.getActionSet();
            if (value != null) {
                as.setTechnicalProviderFeeNomenclature((DictionaryReference<Nomenclature>)((DictionaryReference)value));
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }
    }
    ,
    HIDDEN_FEE_NOMENCLATURE{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_Nomenclature_Hidden_Fee");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_Hidden_Fee_info"), (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            NomenclatureActionSet as = (NomenclatureActionSet)proxy.getActionSet();
            if (value != null) {
                as.setHiddenFeeNomenclature((DictionaryReference<Nomenclature>)((DictionaryReference)value));
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }
    }
    ,
    PENALTY_NOMENCLATURE{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_Nomenclature_Penalty");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_Penalty_info"), (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            NomenclatureActionSet as = (NomenclatureActionSet)proxy.getActionSet();
            if (value != null) {
                as.setPenaltyNomenclature((DictionaryReference<Nomenclature>)((DictionaryReference)value));
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }
    }
    ,
    ALL_TAXES_NOMENCLATURE{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_Nomenclature_Taxes");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_Taxes_info"), (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            NomenclatureActionSet as = (NomenclatureActionSet)proxy.getActionSet();
            if (value != null) {
                as.setTaxesNomenclature((DictionaryReference<Nomenclature>)((DictionaryReference)value));
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }
    }
    ,
    DEDUCTION_NOMENCLATURE{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_Nomenclature_Deduction");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_Deduction_info"), (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            NomenclatureActionSet as = (NomenclatureActionSet)proxy.getActionSet();
            if (value != null) {
                as.setDeductionNomenclature((DictionaryReference<Nomenclature>)((DictionaryReference)value));
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }
    }
    ,
    TAXES_NOMENCLATURE{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_Nomenclature_Special_Taxes");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            TaxesNomenclatureRuleResult rr = (TaxesNomenclatureRuleResult)value;
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_Special_Taxes_info"), (Object[])new Object[]{rr.getTaxes(), rr.getNomenclature()}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            NomenclatureActionSet as = (NomenclatureActionSet)proxy.getActionSet();
            if (value != null) {
                TaxesNomenclatureRuleResult rr = (TaxesNomenclatureRuleResult)value;
                as.putSpecialTaxNomenclature(rr.getTaxes(), (DictionaryReference<Nomenclature>)rr.getNomenclature());
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }

        @Override
        public String getRendererId() {
            return ValueTypes.TAXES_NOMENCLATURE.name();
        }

        @Override
        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            TaxesNomenclatureRuleResult rr = (TaxesNomenclatureRuleResult)value;
            return this.name() + "-" + rr.getTaxes();
        }
    }
    ,
    TAXES_WITH_VAT_RATE_NOMENCLATURE{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_Nomenclature_Taxes_With_Vat_Rate");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            TaxesWithVatRateNomenclatureRuleResult result = (TaxesWithVatRateNomenclatureRuleResult)value;
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_Taxes_With_Vat_Rate_info"), (Object[])new Object[]{this.vatRateToString(result.getVatRate()), result.getNomenclature()}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            NomenclatureActionSet as = (NomenclatureActionSet)proxy.getActionSet();
            if (value != null) {
                TaxesWithVatRateNomenclatureRuleResult result = (TaxesWithVatRateNomenclatureRuleResult)value;
                as.putTaxWithVatRateNomenclature(result.getVatRate(), (DictionaryReference<Nomenclature>)result.getNomenclature());
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }

        @Override
        public String getRendererId() {
            return ValueTypes.TAXES_WITH_VAT_RATE_NOMENCLATURE.name();
        }

        @Override
        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            TaxesWithVatRateNomenclatureRuleResult result = (TaxesWithVatRateNomenclatureRuleResult)value;
            return this.name() + "-" + result.getVatRate();
        }

        private String vatRateToString(Double vatRate) {
            if (vatRate == null || vatRate == -1.0) {
                return L10n.get((String)"RuleAction_Nomenclature_Without_VAT");
            }
            return L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_With_VAT_Rate"), (Object[])new Object[]{vatRate});
        }
    }
    ,
    ADD_SERVICE_TYPE_NOMENCLATURE{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_Nomenclature_AddServiceType");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            AddServiceTypeNomenclatureRuleResult rr = (AddServiceTypeNomenclatureRuleResult)value;
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_AddServiceType_info"), (Object[])new Object[]{rr.getServiceType(), rr.getNomenclature()}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            NomenclatureActionSet as = (NomenclatureActionSet)proxy.getActionSet();
            if (value != null) {
                AddServiceTypeNomenclatureRuleResult rr = (AddServiceTypeNomenclatureRuleResult)value;
                as.putAddServiceTypeNomenclature(rr.getServiceType(), (DictionaryReference<Nomenclature>)rr.getNomenclature());
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }

        @Override
        public String getRendererId() {
            return ValueTypes.ADD_SERVICE_TYPE_NOMENCLATURE.name();
        }

        @Override
        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            AddServiceTypeNomenclatureRuleResult rr = (AddServiceTypeNomenclatureRuleResult)value;
            return this.name() + "-" + rr.getServiceType().name();
        }
    }
    ,
    DISABLE_CREATE_COMPONENTS_FOR_ZERO_FOP{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_Nomenclature_DisableCreateComponentsForZeroFop");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (Boolean.TRUE.equals(value)) {
                buf.append(L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_DisableCreateComponentsForZeroFop"), (Object[])new Object[0]));
            } else {
                buf.append(L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_DisableCreateComponentsForZeroFopFalse"), (Object[])new Object[0]));
            }
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            NomenclatureActionSet as = (NomenclatureActionSet)proxy.getActionSet();
            as.setDisableCreateComponentsForZeroFop(Boolean.TRUE.equals(value));
        }

        @Override
        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }
    }
    ,
    CATEGORY_VENDOR_FEE_NOMENCLATURE{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_Nomenclature_CategoryVendorFees");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            CategoryFeeNomenclatureRuleResult rr = (CategoryFeeNomenclatureRuleResult)value;
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_CategoryVendorFees_info"), (Object[])new Object[]{rr.getCategory(), rr.getNomenclature()}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CategoryFeeNomenclatureRuleResult rr;
            NomenclatureActionSet as = (NomenclatureActionSet)proxy.getActionSet();
            if (value != null && (rr = (CategoryFeeNomenclatureRuleResult)value).getCategory() != null) {
                as.putVendorFeeNomenclature((DictionaryReference<CommissionCategory>)rr.getCategory(), (DictionaryReference<Nomenclature>)rr.getNomenclature());
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }

        @Override
        public String getRendererId() {
            return ValueTypes.CATEGORY_FEE_NOMENCLATURE.name();
        }

        @Override
        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            CategoryFeeNomenclatureRuleResult rr = (CategoryFeeNomenclatureRuleResult)value;
            return this.name() + "-" + rr.getCategory().getCode();
        }
    }
    ,
    CATEGORY_OWN_FEE_NOMENCLATURE{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_Nomenclature_CategoryOwnFees");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            CategoryFeeNomenclatureRuleResult rr = (CategoryFeeNomenclatureRuleResult)value;
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_Nomenclature_CategoryOwnFees_info"), (Object[])new Object[]{rr.getCategory(), rr.getNomenclature()}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CategoryFeeNomenclatureRuleResult rr;
            NomenclatureActionSet as = (NomenclatureActionSet)proxy.getActionSet();
            if (value != null && (rr = (CategoryFeeNomenclatureRuleResult)value).getCategory() != null) {
                as.putOwnFeeNomenclature((DictionaryReference<CommissionCategory>)rr.getCategory(), (DictionaryReference<Nomenclature>)rr.getNomenclature());
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }

        @Override
        public String getRendererId() {
            return ValueTypes.CATEGORY_FEE_NOMENCLATURE.name();
        }

        @Override
        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            CategoryFeeNomenclatureRuleResult rr = (CategoryFeeNomenclatureRuleResult)value;
            return this.name() + "-" + rr.getCategory().getCode();
        }
    };


    public String getId() {
        return this.name();
    }

    public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
        return this.getId();
    }

    public String getRendererId() {
        return ValueTypes.NOMENCLATURE.name();
    }

    public boolean hasValue() {
        return true;
    }
}

