/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard.tchexport;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleAttributes;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.TchXmlCommissionsImportHelper;
import com.gridnine.xtrip.common.model.rules.standard.tchexport.TchCondition;
import com.gridnine.xtrip.common.model.rules.standard.tchexport.TchConditionParam;
import com.gridnine.xtrip.common.model.rules.standard.tchexport.TchConditionType;
import com.gridnine.xtrip.common.model.rules.standard.tchexport.TchConditionValue;
import com.gridnine.xtrip.common.model.rules.standard.tchexport.TchCurrCode;
import com.gridnine.xtrip.common.model.rules.standard.tchexport.TchFile;
import com.gridnine.xtrip.common.model.rules.standard.tchexport.TchOrgType;
import com.gridnine.xtrip.common.model.rules.standard.tchexport.TchSubType;
import com.gridnine.xtrip.common.model.rules.standard.tchexport.TchType;
import com.gridnine.xtrip.common.parsers.model.TchXmlCommissionsImportSettings;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TchCommissionsExportHelper {
    private static final Logger log = LoggerFactory.getLogger(TchCommissionsExportHelper.class);

    public static TchFile convertTchRules(RuleSet ruleSet) throws Exception {
        TchFile res = new TchFile();
        int conditionId = 200000;
        int priority = 1;
        for (RuleSettings ruleSettings : ruleSet.getRules()) {
            if (!Targets.PRODUCT_COMMISSION.equals(ruleSettings.getTarget())) continue;
            TchCondition tchCond = new TchCondition();
            if (TchCommissionsExportHelper.isPTAComission(ruleSettings)) continue;
            TchCommissionsExportHelper.convertValues(ruleSettings, tchCond);
            if (tchCond.getValues().size() <= 0) continue;
            TchCommissionsExportHelper.convertRuleSettings(ruleSettings, tchCond, conditionId, priority);
            --conditionId;
            ++priority;
            res.getConditions().add(tchCond);
        }
        for (TchType tchType : TchType.values()) {
            res.getTypes().add(tchType);
        }
        for (Enum enum_ : TchSubType.values()) {
            res.getSubTypes().add((TchSubType)enum_);
        }
        return res;
    }

    private static boolean isPTAComission(RuleSettings rs) {
        RuleRestriction restr = TchCommissionsExportHelper.findRestriction(rs, Properties.MCO_CATEGORY, Conditions.INCLUDE);
        if (restr != null && restr.getValue() instanceof List) {
            List catList = (List)restr.getValue();
            return catList.contains(MCOCategory.PTA);
        }
        return false;
    }

    public static List<TchConditionValue> convertValues(RuleSettings rs) {
        return TchCommissionsExportHelper.convertValues(rs, new TchCondition());
    }

    public static List<TchConditionValue> convertValues(RuleSettings rs, TchCondition tchCond) {
        for (RuleResult result : rs.getResults()) {
            RuleResultValue resValue;
            if (!Actions.FOP_COMMISSION.equals(result.getAction()) || !(result.getValue() instanceof RuleResultValue) || !TchCommissionsExportHelper.checkCommissionProperties((resValue = (RuleResultValue)result.getValue()).getTarget())) continue;
            Object[] fopValues = resValue.getFopValues();
            Double[][] amounts = (Double[][])fopValues[0];
            String[][] curCodes = (String[][])fopValues[1];
            tchCond.setUseTp(false);
            tchCond.setUseCn(false);
            tchCond.setUseTb(false);
            for (int q = 0; q < 12; ++q) {
                TchOrgType orgType = TchCommissionsExportHelper.convertTchOrgType(q);
                if (orgType == null && q != 11) continue;
                TchConditionValue tchValue = new TchConditionValue();
                boolean hasValues = false;
                for (int i = 0; i < 3; ++i) {
                    if (amounts[q][i] == null) continue;
                    hasValues = true;
                    TchCurrCode curCode = TchCommissionsExportHelper.convertTchCurCode(curCodes[q][i]);
                    Double amount = amounts[q][i];
                    if (curCode.equals((Object)TchCurrCode.PERCENT)) {
                        amount = BigDecimal.valueOf(amount / 100.0).divide(BigDecimal.ONE, 4, RoundingMode.HALF_UP).doubleValue();
                    }
                    if (i == 0) {
                        tchCond.setUseTp(true);
                        tchValue.setCurrCodeTp(curCode);
                        tchValue.setSumTp(amount);
                        continue;
                    }
                    if (i == 1) {
                        tchCond.setUseCn(true);
                        tchValue.setCurrCodeCn(curCode);
                        tchValue.setSumCn(amount);
                        continue;
                    }
                    if (i != 2) continue;
                    tchCond.setUseTb(true);
                    tchValue.setCurrCodeTb(curCode);
                    tchValue.setSumTb(amount);
                }
                if (!hasValues) continue;
                if (q != 11) {
                    tchValue.setOrgType(orgType);
                    tchCond.getValues().add(tchValue);
                    continue;
                }
                for (TchOrgType tchOrgType : TchOrgType.values()) {
                    boolean found = false;
                    for (TchConditionValue value : tchCond.getValues()) {
                        if (!value.getOrgType().equals((Object)tchOrgType)) continue;
                        TchCommissionsExportHelper.fillDefaultValues(tchValue, value);
                        found = true;
                    }
                    if (found) continue;
                    TchConditionValue value = new TchConditionValue();
                    value.setOrgType(tchOrgType);
                    value.setCurrCodeTp(tchValue.getCurrCodeTp());
                    value.setSumTp(tchValue.getSumTp());
                    value.setCurrCodeCn(tchValue.getCurrCodeCn());
                    value.setSumCn(tchValue.getSumCn());
                    value.setCurrCodeTb(tchValue.getCurrCodeTb());
                    value.setSumTb(tchValue.getSumTb());
                    tchCond.getValues().add(value);
                }
            }
        }
        return tchCond.getValues();
    }

    private static void fillDefaultValues(TchConditionValue from, TchConditionValue to) {
        if (to.getSumCn() == null) {
            to.setSumCn(from.getSumCn());
        }
        if (to.getSumTb() == null) {
            to.setSumTb(from.getSumTb());
        }
        if (to.getSumTp() == null) {
            to.setSumTp(from.getSumTp());
        }
        if (to.getCurrCodeCn() == null) {
            to.setCurrCodeCn(from.getCurrCodeCn());
        }
        if (to.getCurrCodeTb() == null) {
            to.setCurrCodeTb(from.getCurrCodeTb());
        }
        if (to.getCurrCodeTp() == null) {
            to.setCurrCodeTp(from.getCurrCodeTp());
        }
    }

    private static TchOrgType convertTchOrgType(int ptIndex) {
        if (ptIndex == 0) {
            return TchOrgType.CASH;
        }
        if (ptIndex == 1) {
            return TchOrgType.CREDITCARD;
        }
        if (ptIndex == 2) {
            return TchOrgType.CASH_CREDITCARD;
        }
        if (ptIndex == 4) {
            return TchOrgType.INTERLINE;
        }
        if (ptIndex == 5) {
            return TchOrgType.INTERLINE_CASH;
        }
        if (ptIndex == 8) {
            return TchOrgType.MTD;
        }
        if (ptIndex == 9) {
            return TchOrgType.MTD_CASH;
        }
        if (ptIndex == 6) {
            return TchOrgType.CREDIT;
        }
        if (ptIndex == 7) {
            return TchOrgType.CREDIT_CASH;
        }
        if (ptIndex == 10) {
            return TchOrgType.PTA;
        }
        return null;
    }

    private static TchCurrCode convertTchCurCode(String value) {
        if (value == null) {
            return null;
        }
        for (TchCurrCode curCode : TchCurrCode.values()) {
            if (!value.equals(curCode.getCaption())) continue;
            return curCode;
        }
        return null;
    }

    public static TchCondition convertRuleSettings(RuleSettings rs, int id) throws Exception {
        return TchCommissionsExportHelper.convertRuleSettings(rs, new TchCondition(), id);
    }

    public static TchCondition convertRuleSettings(RuleSettings rs, TchCondition cond, int id) throws Exception {
        return TchCommissionsExportHelper.convertRuleSettings(rs, cond, id, 1);
    }

    public static TchCondition convertRuleSettings(RuleSettings rs, TchCondition cond, int id, int priority) throws Exception {
        Date startDate = rs.getPeriodBegin();
        if (startDate == null) {
            startDate = MiscUtil.addYearsToDate((Date)new Date(), (int)-1);
            startDate = MiscUtil.clearTime((Date)startDate);
        }
        cond.setDateStart(startDate);
        cond.setDateEnd(rs.getPeriodEnd());
        cond.setDateAct(startDate);
        if (rs.getRevisionDate() != null) {
            cond.setDateCondition(rs.getRevisionDate());
        } else {
            Date dt = MiscUtil.addYearsToDate((Date)new Date(), (int)-1);
            cond.setDateCondition(MiscUtil.clearTime((Date)dt));
        }
        cond.setId(id);
        cond.setPriority(priority);
        try {
            int num = Integer.parseInt(rs.getName().substring(rs.getName().lastIndexOf(" ") + 1));
            cond.setNum(num);
        }
        catch (NumberFormatException ex) {
            cond.setNum(id);
        }
        RuleRestriction restr = TchCommissionsExportHelper.findRestriction(rs, Properties.TOUR_CODE, Conditions.EQUALS);
        if (restr == null) {
            restr = TchCommissionsExportHelper.findRestriction(rs, Properties.CARRIER_NUMBER, Conditions.EQUALS);
        }
        if (restr != null) {
            cond.setTreatyCode(TchCommissionsExportHelper.getValue(restr.getValue()));
        } else {
            restr = TchCommissionsExportHelper.findRestriction(rs, Properties.CARRIERS, Conditions.CONTAINS_ONLY);
            if (restr != null) {
                cond.setCarrierCode(TchCommissionsExportHelper.getValue(restr.getValue()));
            }
        }
        cond.setOutNumAvs(TchCommissionsExportHelper.formOutNumAvs(rs));
        for (RuleRestriction rr : rs.getRestrictions()) {
            for (TchType type : TchType.values()) {
                try {
                    type.formTchCondition(rr, cond);
                }
                catch (Exception e) {
                    log.error("Export tch condition failed: " + e.getMessage() + ". RuleSettings: " + rs.getName());
                }
            }
        }
        TchCommissionsExportHelper.correctConditionParams(cond);
        cond.setType(TchConditionType.ALL_ROUTE);
        for (RuleRestriction rr : rs.getRestrictions()) {
            if (!Properties.TCH_ROUTE.equals(rr.getProperty()) || !Conditions.TCH_ROUTE_SEGMENT.equals(rr.getCondition())) continue;
            cond.setType(TchConditionType.SEGMENTS);
        }
        return cond;
    }

    private static void correctConditionParams(TchCondition condition) {
        ArrayList<TchType> correctedTypes = new ArrayList<TchType>();
        correctedTypes.add(TchType.AIRLINES);
        ArrayList<TchConditionParam> forRemoving = new ArrayList<TchConditionParam>();
        for (TchConditionParam param : condition.getParams()) {
            if (forRemoving.contains(param) || !correctedTypes.contains((Object)param.getType())) continue;
            for (TchConditionParam sameParam : condition.getParams()) {
                if (param.equals(sameParam) || !param.getType().equals((Object)sameParam.getType()) || !param.getSubType().equals((Object)sameParam.getSubType())) continue;
                param.setCodeValue(param.getCodeValue() + "," + sameParam.getCodeValue());
                forRemoving.add(sameParam);
            }
        }
        for (TchConditionParam param : forRemoving) {
            condition.getParams().remove(param);
        }
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.TRANSPORTATION_TYPE, TchSubType.TRANSPORTATION_ALL);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.VALIDATORS, TchSubType.VALIDATORS_ALL);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.VAT, TchSubType.VAT_ALL);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.SALES_POINT_COUNTRIES, TchSubType.SALES_POINT_COUNTRIES_ALL);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.AGENCY_COUNTRIES, TchSubType.AGENCY_COUNTRIES_ALL);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.DIRECTION, TchSubType.DIRECTION_ALL);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.INTERLINE, TchSubType.INTERLINE_NONE);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.ROUTES, TchSubType.ROUTES_ALL);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.FLIGHTS, TchSubType.FLIGHTS_ALL);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.DEPARTURE_DATE, TchSubType.DEPARTURE_DATE_ALL);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.BOOKING_CLASSES, TchSubType.BOOKING_CLASSES_ALL);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.TARIFF_CODE, TchSubType.TARIFF_CODE_ALL);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.DEPARTURE_DAY, TchSubType.DEPARTURE_DAY_ALL);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.AIRLINES, TchSubType.AIRLINES_ALL);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.RESERVATION_TYPE, TchSubType.RESERVATION_TYPE_ALL);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.ORGANIZATION, TchSubType.ORGANIZATION_STANDARD);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.AIRLINE_PARTICIPATION, TchSubType.AIRLINE_PARTICIPATION_ALL);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.GDS_CODE, TchSubType.GDS_CODE_ALL);
        TchCommissionsExportHelper.addDefaultConditionParam(condition, TchType.ADDITIONAL_SERVICE_CODE, TchSubType.ADDITIONAL_SERVICE_CODE_ALL);
        TchCommissionsExportHelper.removeDuplicateTypeParams(condition);
    }

    private static void removeDuplicateTypeParams(TchCondition cond) {
        ArrayList<TchConditionParam> forRemoving = new ArrayList<TchConditionParam>();
        for (int q = 0; q < cond.getParams().size(); ++q) {
            for (int i = q + 1; i < cond.getParams().size(); ++i) {
                TchType type2;
                TchType type1 = cond.getParams().get(q).getType();
                if (type1 != (type2 = cond.getParams().get(i).getType())) continue;
                forRemoving.add(cond.getParams().get(i));
            }
        }
        for (TchConditionParam param : forRemoving) {
            cond.getParams().remove(param);
        }
    }

    private static void addDefaultConditionParam(TchCondition condition, TchType type, TchSubType subtype) {
        for (TchConditionParam param : condition.getParams()) {
            if (!type.equals((Object)param.getType())) continue;
            return;
        }
        TchConditionParam param = new TchConditionParam();
        param.setType(type);
        param.setSubType(subtype);
        condition.getParams().add(param);
    }

    private static String getValue(Object obj) {
        List list;
        if (obj instanceof List && (list = (List)obj).size() > 0) {
            return list.get(0).toString();
        }
        return obj.toString();
    }

    private static String formOutNumAvs(RuleSettings rs) {
        String telexNo = (String)rs.getAttributes().get(RuleAttributes.TCH_TELEX_NO.name());
        String telexDate = (String)rs.getAttributes().get(RuleAttributes.TCH_TELEX_DATE.name());
        if (TextUtil.isBlank((String)telexNo)) {
            return null;
        }
        if (TextUtil.isBlank((String)telexDate)) {
            return telexNo;
        }
        return telexNo + " \u043e\u0442 " + telexDate;
    }

    private static boolean checkCommissionProperties(EntityReference<? extends BaseCommissionProperties> targetRef) {
        EntityContainer baseProps = EntityStorage.get().resolve(targetRef);
        if (baseProps == null || !baseProps.getEntityType().equals(CommissionProperties.class)) {
            return false;
        }
        CommissionProperties props = (CommissionProperties)baseProps.getEntity();
        EntityReference<CommissionProperties> tchCommRef = TchCommissionsExportHelper.findTchCommissionRef();
        return tchCommRef != null && baseProps.getUid().equals(tchCommRef.getUid()) || props.isRate() && !props.isBonus();
    }

    private static EntityReference<CommissionProperties> findTchCommissionRef() {
        EntityContainer settingsCtr = EntityStorage.get().resolve(TchXmlCommissionsImportHelper.settingsRef);
        if (settingsCtr != null && ((TchXmlCommissionsImportSettings)settingsCtr.getEntity()).getCommission() != null) {
            return ((TchXmlCommissionsImportSettings)settingsCtr.getEntity()).getCommission();
        }
        return null;
    }

    static RuleRestriction findRestriction(RuleSettings rs, Properties prop, RuleCondition cond) {
        for (RuleRestriction rr : rs.getRestrictions()) {
            if (rr.getProperty() != prop || cond != null && !cond.equals(rr.getCondition())) continue;
            return rr;
        }
        return null;
    }
}

