/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.travelPolicy;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.profile.ExchangeRateCondition;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.AirTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.HotelPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.LocationCodesPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyTargets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.travelPolicy.BaseTravelPolicyMinimalPriceProperties;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMatchType;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMinimalPriceRuleValue;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyRuleRouteLimitParameters;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public enum TravelPolicyProperties implements RuleProperty,
RulePropertyConditions
{
    TRAVEL_POLICY_PERSONS{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyProperties_PERSONS);
        }

        public String getRendererId() {
            return ValueTypes.TRAVEL_POLICY_ORGANIZATION_PERSONS.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId(), TravelPolicyTargets.TRAVEL_POLICY_RAILWAY.getId(), TravelPolicyTargets.TRAVEL_POLICY_HOTELS.getId(), TravelPolicyTargets.TRAVEL_POLICY_AUTHORIZATION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.TravelPolicyProperties_PERSONS_X, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            TravelPolicyPropertiesProvider ps = (TravelPolicyPropertiesProvider)propertySet;
            Collection<EntityReference<Person>> psValues = ps.getPersons();
            Collection values = (Collection)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEntityRestriction(psValues, values, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEntityRestriction(psValues, values, false);
            }
            return false;
        }
    }
    ,
    TRAVEL_POLICY_CLIENT_TOTAL{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyProperties_CLIENT_TOTAL);
        }

        public String getRendererId() {
            return ValueTypes.PRICE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId(), TravelPolicyTargets.TRAVEL_POLICY_RAILWAY.getId(), TravelPolicyTargets.TRAVEL_POLICY_HOTELS.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.TravelPolicyProperties_CLIENT_TOTAL_X, (Object[])new Object[]{cond.getDisplayName(), String.valueOf(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            TravelPolicyPropertiesProvider ps = (TravelPolicyPropertiesProvider)propertySet;
            int compared = MiscUtil.guarded((BigDecimal)ps.getClientTotal()).compareTo(MiscUtil.guarded((BigDecimal)((BigDecimal)value)));
            if (Conditions.EQUALS.equals(condition)) {
                return 0 == compared;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return compared != 0;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return compared > 0;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return compared >= 0;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return compared < 0;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return compared <= 0;
            }
            return false;
        }
    }
    ,
    TRAVEL_POLICY_CLIENT_TOTAL_DIFF_WITH_MINIMAL{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyProperties_CLIENT_TOTAL_DIFF_WITH_MINIMAL);
        }

        public String getRendererId() {
            return ValueTypes.DIFF_WITH_MINIMAL_AIR.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            TravelPolicyMinimalPriceRuleValue data = (TravelPolicyMinimalPriceRuleValue)value;
            String propsInfo = String.valueOf(Optional.ofNullable(data).map(TravelPolicyMinimalPriceRuleValue::getProperties).map(EntityReference::getCaption).orElse(null));
            String valueInfo = String.valueOf(Optional.ofNullable(data).map(TravelPolicyMinimalPriceRuleValue::getPercent).orElse(null));
            buf.append(L10nResourcesManager.getStr((String)Messages.TravelPolicyProperties_CLIENT_TOTAL_DIFF_WITH_MINIMAL_X, (Object[])new Object[]{propsInfo, cond.getDisplayName(), valueInfo}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BigDecimal minimal;
            TravelPolicyPropertiesProvider ps = (TravelPolicyPropertiesProvider)propertySet;
            TravelPolicyMinimalPriceRuleValue data = (TravelPolicyMinimalPriceRuleValue)value;
            if (data == null || data.getProperties() == null || (minimal = ps.getMinimal((EntityReference<BaseTravelPolicyMinimalPriceProperties>)data.getProperties())) == null) {
                return false;
            }
            BigDecimal percent = BigDecimal.ONE.add(MiscUtil.guarded((BigDecimal)data.getPercent()).divide(BigDecimal.valueOf(100L)));
            BigDecimal minimalWithPercent = minimal.multiply(percent);
            int compared = MiscUtil.guarded((BigDecimal)ps.getClientTotal()).compareTo(minimalWithPercent);
            if (Conditions.EQUALS.equals(condition)) {
                return 0 == compared;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return compared != 0;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return compared > 0;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return compared >= 0;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return compared < 0;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return compared <= 0;
            }
            return false;
        }
    }
    ,
    TRAVEL_POLICY_HOTEL_DAILY_RATE{

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyProperties_RATE_PER_NIGHT);
        }

        public String getRendererId() {
            return ValueTypes.PRICE_WITH_CURRENCY.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.TravelPolicyProperties_RATE_PER_NIGHT_X, (Object[])new Object[]{cond.getDisplayName(), String.valueOf(value)}));
        }

        private Money getValue(Object value) {
            if (value instanceof BigDecimal) {
                return MoneyHelper.buildMoney((BigDecimal)value, DictHelper.getLocalCurrency());
            }
            return (Money)value;
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            int nights = ps.getStayDuration();
            if (nights < 1) {
                return false;
            }
            String localCurrency = DictHelper.getLocalCurrency();
            BigDecimal farePerNight = BigDecimal.valueOf(ps.getFare() / (double)nights);
            String gdsCurrency = (String)MiscUtil.guarded((Object)ps.getProduct().getGdsCurrency(), (Object)localCurrency);
            Money money = this.getValue(value);
            BigDecimal amount = money.getValue();
            String currency = (String)MiscUtil.guarded((Object)money.getCurrency(), (Object)localCurrency);
            if (!Objects.equals(gdsCurrency, currency)) {
                Date operationDate;
                HotelProduct product = ps.getProduct();
                ProductStatus status = product.getStatus();
                if ((ProductStatus.REFUND == status || ProductStatus.EXCHANGE == status) && product.getPreviousProduct() != null) {
                    product = product.getPreviousProduct();
                }
                if (null == (operationDate = product.getIssueDate()) && product.getReservation() != null) {
                    operationDate = product.getReservation().getResDate();
                }
                if (null == operationDate) {
                    operationDate = new Date();
                }
                ExchangeRateCondition defaultExchangeRateCondition = new ExchangeRateCondition();
                defaultExchangeRateCondition.setCoefficient(1.0);
                if (!Objects.equals(gdsCurrency, localCurrency)) {
                    Double rate = product.getGdsCurrencyRate();
                    if (null == rate) {
                        ExchangeRateData rateData = MulticurrencyHelper.buildExchangeRateData(gdsCurrency, localCurrency, defaultExchangeRateCondition, operationDate, GeneralProductHelper.getSupplier((BaseProduct)product), false);
                        rate = rateData.getRateWithCoefficient();
                    }
                    farePerNight = farePerNight.multiply(new BigDecimal(rate)).setScale(2, 4);
                }
                if (!Objects.equals(currency, localCurrency)) {
                    ExchangeRateData rateData = MulticurrencyHelper.buildExchangeRateData(currency, localCurrency, defaultExchangeRateCondition, operationDate, GeneralProductHelper.getSupplier((BaseProduct)product), false);
                    double rate = rateData.getRateWithCoefficient();
                    amount = amount.multiply(new BigDecimal(rate)).setScale(2, 4);
                }
            }
            int compared = MiscUtil.guarded((BigDecimal)farePerNight).compareTo(MiscUtil.guarded((BigDecimal)amount));
            if (Conditions.EQUALS.equals(condition)) {
                return 0 == compared;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return compared != 0;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return compared > 0;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return compared >= 0;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return compared < 0;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return compared <= 0;
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_HOTELS.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }
    }
    ,
    TRAVEL_POLICY_HOTEL_DAILY_RATE_PER_PERSON{

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyProperties_RATE_PER_NIGHT_PER_PERSON);
        }

        public String getRendererId() {
            return ValueTypes.PRICE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.TravelPolicyProperties_RATE_PER_NIGHT_PER_PERSON_INFO, (Object[])new Object[]{cond.getDisplayName(), String.valueOf(value)}));
        }

        private Money getValue(Object value) {
            if (value instanceof BigDecimal) {
                return MoneyHelper.buildMoney((BigDecimal)value, DictHelper.getLocalCurrency());
            }
            return (Money)value;
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            BigDecimal totalPrice = BookingHelper.getTotalPrice((BaseProduct)ps.getProduct(), ContractType.CLIENT);
            BigDecimal nights = BigDecimal.valueOf(ps.getStayDuration());
            BigDecimal persons = BigDecimal.valueOf(ps.getPersonsCount());
            if (nights.intValue() < 1) {
                return false;
            }
            if (persons.intValue() < 1) {
                return false;
            }
            String localCurrency = DictHelper.getLocalCurrency();
            BigDecimal costPerNightPerPerson = totalPrice.divide(nights, RoundingMode.HALF_UP).divide(persons, RoundingMode.HALF_UP);
            int compared = MiscUtil.guarded((BigDecimal)costPerNightPerPerson).compareTo(MiscUtil.guarded((BigDecimal)((BigDecimal)value)));
            if (Conditions.EQUALS.equals(condition)) {
                return 0 == compared;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return compared != 0;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return compared > 0;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return compared >= 0;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return compared < 0;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return compared <= 0;
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_HOTELS.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }
    }
    ,
    TRAVEL_POLICY_AVIA_ROUTE_LIMITS{

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyProperties_AVIA_ROUTE_LIMITS);
        }

        public String getRendererId() {
            return ValueTypes.TRAVEL_POLICY_ROUTE_LIMIT_PARAMETERS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            StringBuilder sb = new StringBuilder();
            if (null == value) {
                sb.append(" \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e");
            } else {
                TravelPolicyRuleRouteLimitParameters params = (TravelPolicyRuleRouteLimitParameters)value;
                sb.append(' ');
                sb.append(TextUtil.isBlank((String)params.getDepartureLocation()) ? "?" : params.getDepartureLocation()).append(" - ").append(TextUtil.isBlank((String)params.getArriveLocation()) ? "?" : params.getArriveLocation());
                sb.append(", OW ").append(cond.getDisplayName()).append(' ').append(MiscUtil.guarded((BigDecimal)params.getOneWayAmount()));
                sb.append(", RT ").append(cond.getDisplayName()).append(' ').append(MiscUtil.guarded((BigDecimal)params.getRoundTripAmount()));
            }
            buf.append(L10n.get((String)Messages.TravelPolicyProperties_AVIA_ROUTE_LIMITS)).append((CharSequence)sb);
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            boolean found;
            BigDecimal amount;
            String[] arriveLocations;
            String[] departureLocations;
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            TravelPolicyPropertiesProvider tpps = (TravelPolicyPropertiesProvider)propertySet;
            TravelPolicyRuleRouteLimitParameters params = (TravelPolicyRuleRouteLimitParameters)value;
            if (null == params) {
                return false;
            }
            List<List<String[]>> segments = ps.getFlightSegments();
            if (segments.isEmpty()) {
                return false;
            }
            List<String> departureValues = RulesHelper.toStringCollection(params.getDepartureLocation());
            List<String> arriveValues = RulesHelper.toStringCollection(params.getArriveLocation());
            List<String[]> firstSegment = segments.get(0);
            List<String[]> lastSegment = segments.get(segments.size() - 1);
            String[] stringArray = departureLocations = !firstSegment.isEmpty() ? firstSegment.get(0) : null;
            if (null == departureLocations) {
                return false;
            }
            String[] stringArray2 = arriveLocations = lastSegment.size() > 1 ? lastSegment.get(1) : null;
            if (null == arriveLocations) {
                return false;
            }
            if (departureValues.stream().filter(Objects::nonNull).anyMatch(v -> Arrays.stream(departureLocations).anyMatch(v::equalsIgnoreCase)) && arriveValues.stream().filter(Objects::nonNull).anyMatch(v -> Arrays.stream(arriveLocations).anyMatch(v::equalsIgnoreCase)) || departureValues.stream().filter(Objects::nonNull).anyMatch(v -> Arrays.stream(arriveLocations).anyMatch(v::equalsIgnoreCase)) && arriveValues.stream().filter(Objects::nonNull).anyMatch(v -> Arrays.stream(departureLocations).anyMatch(v::equalsIgnoreCase))) {
                amount = params.getOneWayAmount();
            } else if (departureValues.stream().filter(Objects::nonNull).anyMatch(v -> {
                if (!Arrays.stream(departureLocations).anyMatch(v::equalsIgnoreCase)) return false;
                if (!Arrays.stream(arriveLocations).anyMatch(v::equalsIgnoreCase)) return false;
                return true;
            })) {
                found = false;
                for (int i = 0; i < segments.size() - 1; ++i) {
                    List<String[]> segment = segments.get(i);
                    if (segment.size() < 2) continue;
                    String[] location = segment.get(1);
                    if (!arriveValues.stream().filter(Objects::nonNull).anyMatch(v -> Arrays.stream(location).anyMatch(v::equalsIgnoreCase))) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
                amount = params.getRoundTripAmount();
            } else if (arriveValues.stream().filter(Objects::nonNull).anyMatch(v -> Arrays.stream(departureLocations).anyMatch(v::equalsIgnoreCase)) && arriveValues.stream().filter(Objects::nonNull).anyMatch(v -> Arrays.stream(arriveLocations).anyMatch(v::equalsIgnoreCase))) {
                found = false;
                for (int i = 0; i < segments.size() - 1; ++i) {
                    List<String[]> segment = segments.get(i);
                    if (segment.size() < 2) continue;
                    String[] location = segment.get(1);
                    if (!departureValues.stream().filter(Objects::nonNull).anyMatch(v -> Arrays.stream(location).anyMatch(v::equalsIgnoreCase))) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
                amount = params.getRoundTripAmount();
            } else {
                return false;
            }
            int compared = MiscUtil.guarded((BigDecimal)tpps.getClientTotal()).compareTo(MiscUtil.guarded((BigDecimal)amount));
            if (Conditions.EQUALS.equals(condition)) {
                return 0 == compared;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return compared != 0;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return compared > 0;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return compared >= 0;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return compared < 0;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return compared <= 0;
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }
    }
    ,
    TRAVEL_POLICY_HOTEL_COUNTRY{

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyProperties_HOTEL_COUNTRY);
        }

        public String getRendererId() {
            return ValueTypes.COUNTRIES.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)L10n.get((String)Messages.TravelPolicyProperties_HOTEL_COUNTRY_X), (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            LocationCodesPropertiesProvider ps = (LocationCodesPropertiesProvider)propertySet;
            String country = ps.getCountryCode();
            if (null == country) {
                return false;
            }
            Collection countries = (Collection)value;
            if (null == countries) {
                return false;
            }
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesDictRestriction(country, countries, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesDictRestriction(country, countries, false);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_HOTELS.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    TRAVEL_POLICY_HOTEL_CITY{

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyProperties_HOTEL_CITY);
        }

        public String getRendererId() {
            return ValueTypes.CITIES.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.TravelPolicyProperties_HOTEL_CITY_X, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            LocationCodesPropertiesProvider ps = (LocationCodesPropertiesProvider)propertySet;
            String city = ps.getCityCode();
            if (null == city) {
                return false;
            }
            Collection cities = (Collection)value;
            if (null == cities) {
                return false;
            }
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesDictRestriction(city, cities, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesDictRestriction(city, cities, false);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_HOTELS.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    TRAVEL_POLICY_AUTHORIZATION_VIOLATION{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyProperties_AUTHORIZATION_VIOLATION);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_AUTHORIZATION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.TravelPolicyProperties_AUTHORIZATION_VIOLATION_X, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            TravelPolicyPropertiesProvider ps = (TravelPolicyPropertiesProvider)propertySet;
            return Boolean.valueOf(ps.getMatchType() == TravelPolicyMatchType.VIOLATION).equals(value);
        }
    }
    ,
    TRAVEL_POLICY_AUTHORIZATION_STRICT_VIOLATION{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyProperties_AUTHORIZATION_STRICT_VIOLATION);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_AUTHORIZATION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.TravelPolicyProperties_AUTHORIZATION_STRICT_VIOLATION_X, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            TravelPolicyPropertiesProvider ps = (TravelPolicyPropertiesProvider)propertySet;
            return Boolean.valueOf(ps.getMatchType() == TravelPolicyMatchType.STRICT_VIOLATION).equals(value);
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();
}

