/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.vat;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.rules.vat.Targets;
import com.gridnine.xtrip.common.model.rules.vat.VatActionSet;
import com.gridnine.xtrip.common.model.rules.vat.VatRulesHelper;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import java.util.List;
import java.util.stream.Collectors;

public enum Actions implements RuleAction
{
    RECALCULATE_PRODUCT_VAT{

        public String getDisplayName() {
            return L10n.get((String)Messages.VatActions_recalculateProductVat);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.VAT_CALCULATION.getId()};
        }

        public String getRendererId() {
            return ValueTypes.VAT_CALCULATION_DATA.name();
        }

        public void buildInfo(StringBuilder buf, Object value) {
            List vatCalculationData = (List)value;
            buf.append(L10n.get((String)Messages.VatActions_recalculateProductVatInfo));
            buf.append(": ");
            buf.append(vatCalculationData.stream().map(VatRulesHelper::vatCalculationDataToString).collect(Collectors.joining("; ")));
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            VatActionSet actionSet = (VatActionSet)proxy.getActionSet();
            List data = (List)value;
            actionSet.getVatCalculationData().addAll(data);
            proxy.getAppliedRuleCategories().add(VatRulesHelper.getRuleCategoryValue(data));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return VatRulesHelper.getRuleCategoryValue((List)value);
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();
}

