/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.vat;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.AgreementType;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;

public class VatPropertySet {
    private final RuleProxy<? extends VatPropertySet, ?> proxy;
    private ExtendedProductType productType;
    private EntityReference<Organization> supplier;
    private AgreementType vendorAgreementType;
    private AgreementType clientAgreementType;

    public VatPropertySet(RuleProxy<? extends VatPropertySet, ?> proxy) {
        this.proxy = proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(BaseProduct product) {
        RuleLogTracer tracer = this.proxy.getTracer();
        tracer.traceEnteringMethod(VatPropertySet.class, "init()", new String[0]);
        try {
            EntityContainer contract;
            GeneralProductContractRelationData clientRelation;
            EntityContainer contract2;
            ProductHandler<BaseProduct> handler = ProductHandler.of(product);
            this.productType = new ExtendedProductType();
            this.productType.setProductType(handler.getProductType(product));
            this.productType.setProductDescription(handler.getUniversalProductDescription(product));
            this.supplier = GeneralProductHelper.getSupplier(product);
            GeneralProductContractRelationData vendorRelation = GeneralProductHelper.getVendorContractRelation(product);
            if (vendorRelation != null && (contract2 = EntityStorage.get().resolve(vendorRelation.getGeneralData().getContractData().getContract())) != null) {
                this.vendorAgreementType = ((Contract)contract2.getEntity()).getAgreementType();
            }
            if ((clientRelation = GeneralProductHelper.getClientContractRelation(product)) != null && (contract = EntityStorage.get().resolve(clientRelation.getGeneralData().getContractData().getContract())) != null) {
                this.clientAgreementType = ((Contract)contract.getEntity()).getAgreementType();
            }
        }
        finally {
            tracer.traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            tracer.traceExitingMethod(VatPropertySet.class, "init()", new String[0]);
        }
    }

    public ExtendedProductType getProductType() {
        return this.productType;
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public AgreementType getVendorAgreementType() {
        return this.vendorAgreementType;
    }

    public AgreementType getClientAgreementType() {
        return this.clientAgreementType;
    }
}

