/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.vat;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatCalculationData;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.vat.Targets;
import com.gridnine.xtrip.common.model.rules.vat.VatActionSet;
import com.gridnine.xtrip.common.model.rules.vat.VatPropertySet;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VatRulesHelper {
    static final Logger log = LoggerFactory.getLogger(VatRulesHelper.class);
    public static final String RULE_CATEGORY_VAT = "rule_category_vat";

    public static <T extends BaseProduct> List<VatCalculationData> applyVatCalculationRules(T product, EntityContainer<Contract> contract) {
        if (contract == null) {
            return null;
        }
        Date date = (Date)MiscUtil.guarded((Object)ProductHandler.of(product).findIssueDate(product), Date::new);
        RuleProxy proxy = new RuleProxy();
        VatPropertySet propertySet = new VatPropertySet(proxy);
        propertySet.init(product);
        VatActionSet actionSet = new VatActionSet();
        proxy.setProxyType(Targets.VAT_CALCULATION.getId());
        proxy.setProxyDate(date);
        proxy.setPropertySet((Object)propertySet);
        proxy.setActionSet((Object)actionSet);
        List<EntityContainer<? extends BaseRulesContainer>> rules = ProfileHelper.getRuleContainers(contract, date, Collections.singleton(Targets.VAT_CALCULATION.getId()));
        try {
            for (EntityContainer<? extends BaseRulesContainer> rule : rules) {
                RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet());
            }
            HashSet<String> appliedRulesLocal = new HashSet<String>(proxy.getAppliedRules());
            if (!appliedRulesLocal.isEmpty()) {
                product.getReservation().getBookingFile().getAppliedRules().addAll(RulesHelper.calcAppliedRulesToBooking(proxy, appliedRulesLocal, rules, product, contract));
            }
            return actionSet.getVatCalculationData();
        }
        catch (Exception e) {
            log.error(String.format("failed applying vat calculation rules from contract %s for product %s", ((Contract)contract.getEntity()).toString(), GeneralProductHelper.getProductTitle(product)), (Throwable)e);
            proxy.getTracer().traceError(String.format("failed applying vat calculation rules from contract %s", ((Contract)contract.getEntity()).toString()), (Throwable)e);
            return null;
        }
    }

    public static String getRuleCategoryValue(List<VatCalculationData> vatCalculationData) {
        if (vatCalculationData == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(RULE_CATEGORY_VAT);
        Map<VatBasisType, List> data = vatCalculationData.stream().collect(Collectors.toMap(VatCalculationData::getBasisType, d -> {
            if (d.getBasisType() == VatBasisType.TAXES && d.getTaxesCodes().isEmpty()) {
                return Collections.singletonList("ALL");
            }
            return d.getTaxesCodes().stream().filter(TextUtil::nonBlank).map(code -> code.trim().toUpperCase()).distinct().sorted().collect(Collectors.toList());
        }, (first, second) -> {
            ArrayList result = new ArrayList(first);
            result.addAll(second);
            return result.stream().distinct().sorted().collect(Collectors.toList());
        }));
        List vatBasisTypes = data.keySet().stream().sorted((o1, o2) -> MiscUtil.compare((Comparable)((Object)o1.name()), (Comparable)((Object)o2.name()))).collect(Collectors.toList());
        for (VatBasisType vatBasisType : vatBasisTypes) {
            if (builder.length() != 0) {
                builder.append("_");
            }
            builder.append(vatBasisType.name());
            List taxesCodes = data.get(vatBasisType);
            if (taxesCodes == null || taxesCodes.isEmpty()) continue;
            builder.append(":");
            builder.append(String.join((CharSequence)", ", taxesCodes));
        }
        return builder.toString();
    }

    public static String vatCalculationDataToString(VatCalculationData data) {
        StringBuilder builder = new StringBuilder();
        builder.append(data.getBasisType() != null ? data.getBasisType().toString() : null);
        if (data.getBasisType() == VatBasisType.TAXES && !data.getTaxesCodes().isEmpty()) {
            builder.append(" ").append(String.join((CharSequence)", ", data.getTaxesCodes()));
        }
        builder.append(": ").append(VatRulesHelper.vatRateToString(data.getVatRate()));
        return builder.toString();
    }

    private static String vatRateToString(Double object) {
        String result = object == null || object == -1.0 ? L10n.get((String)Messages.withoutVat) : object + " %";
        return result;
    }
}

