/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.security.acl.resource;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.security.acl.helper.AclModelRulesHelper;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclEntityResources;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclResourcePropertyConditions;
import com.gridnine.xtrip.common.security.acl.helper.AclRulesHelper;
import com.gridnine.xtrip.common.security.acl.resource.AclMatchable;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProperty;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyType;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProxy;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcesEnvironment;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourcePropertyConditions;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum ModelAclBookingFileResourceProperties implements AclResourceProperty,
AclMatchable
{
    NUMBER{

        @Override
        public String getIdSuffix() {
            return "number";
        }

        public String getName() {
            return "\u041d\u043e\u043c\u0435\u0440";
        }

        public Class<?> getType() {
            return String.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.STRING.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.STRING_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((BookingFile)object).getNumber());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                String number = (String)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)number, (Object)((String)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)number, (Object)((String)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)number, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)number, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NULL.getId().equals(condition.getId())) {
                    return AclRulesHelper.isNull((Object)number);
                }
                if (StandardAclResourcePropertyConditions.NOT_NULL.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isNull((Object)number);
                }
            }
            return true;
        }
    }
    ,
    AGENCY{

        @Override
        public String getIdSuffix() {
            return "agency";
        }

        public String getName() {
            return "\u0410\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), BookingHelper.getAgency((BookingFile)object));
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference agency = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)agency, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)agency, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)agency, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)agency, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyOrganizations((EntityReference<Organization>)agency, userId);
                }
            }
            return true;
        }
    }
    ,
    SUBAGENCY{

        @Override
        public String getIdSuffix() {
            return "subagency";
        }

        public String getName() {
            return "\u0421\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), BookingHelper.getSubagency((BookingFile)object));
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference subagency = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)subagency, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)subagency, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)subagency, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)subagency, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyOrganizations((EntityReference<Organization>)subagency, userId);
                }
            }
            return true;
        }
    }
    ,
    BRANCH{

        @Override
        public String getIdSuffix() {
            return "branch";
        }

        public String getName() {
            return "\u041f\u043e\u0434\u0440\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u0438\u0435";
        }

        public Class<?> getType() {
            return Branch.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_SALES_POINTS_BRANCHES.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), BookingHelper.getBranch((BookingFile)object));
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference branch = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)branch, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)branch, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)branch, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)branch, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_SALES_POINTS_BRANCHES.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMySalesPointsBranches((EntityReference<Branch>)branch, userId);
                }
            }
            return true;
        }
    }
    ,
    SALES_POINT{

        @Override
        public String getIdSuffix() {
            return "salesPoint";
        }

        public String getName() {
            return "\u0422\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436";
        }

        public Class<?> getType() {
            return SalesPoint.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_SALES_POINTS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), BookingHelper.getSalesPoint((BookingFile)object));
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference salesPoint = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)salesPoint, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)salesPoint, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)salesPoint, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)salesPoint, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_SALES_POINTS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMySalesPoints((EntityReference<SalesPoint>)salesPoint, userId);
                }
            }
            return true;
        }
    }
    ,
    CLIENT{

        @Override
        public String getIdSuffix() {
            return "client";
        }

        public String getName() {
            return "\u041a\u043b\u0438\u0435\u043d\u0442";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((BookingFile)object).getCustomerProfile());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference client = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)client, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)client, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)client, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)client, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyOrganizations((EntityReference<Organization>)client, userId);
                }
            }
            return true;
        }
    }
    ,
    ISSUE_DATE{

        @Override
        public String getIdSuffix() {
            return "issueDate";
        }

        public String getName() {
            return "\u0414\u0430\u0442\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0438";
        }

        public Class<?> getType() {
            return Date.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId(), StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId(), StandardAclResourcePropertyConditions.TODAY.getId(), StandardAclResourcePropertyConditions.YESTERDAY.getId(), StandardAclResourcePropertyConditions.CURRENT_DECADE.getId(), StandardAclResourcePropertyConditions.LAST_DECADE.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.DATE_TIME.name();
            }
            if (StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId().equals(conditionId) || StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId().equals(conditionId)) {
                return AclResourcePropertyType.DATE_TIME_INTERVAL.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((BookingFile)object).getReservations().stream().flatMap(item -> item.getProducts().stream()).map(item -> GeneralProductHelper.getHandler(item).findIssueDate((BaseProduct)item)).reduce(null, (xva$0, xva$1) -> MiscUtil.minimum((Date[])new Date[]{xva$0, xva$1})));
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                Date issueDate = (Date)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)issueDate, (Object)((Date)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)issueDate, (Object)((Date)value));
                }
                if (StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId().equals(condition.getId())) {
                    return AclRulesHelper.isWithin((Date)issueDate, (DateInterval)((DateInterval)value));
                }
                if (StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isWithin((Date)issueDate, (DateInterval)((DateInterval)value));
                }
                if (StandardAclResourcePropertyConditions.TODAY.getId().equals(condition.getId())) {
                    return AclRulesHelper.isToday((Date)issueDate);
                }
                if (StandardAclResourcePropertyConditions.YESTERDAY.getId().equals(condition.getId())) {
                    return AclRulesHelper.isYesterday((Date)issueDate);
                }
                if (StandardAclResourcePropertyConditions.CURRENT_DECADE.getId().equals(condition.getId())) {
                    return AclRulesHelper.isCurrentDecade((Date)issueDate);
                }
                if (StandardAclResourcePropertyConditions.LAST_DECADE.getId().equals(condition.getId())) {
                    return AclRulesHelper.isLastDecade((Date)issueDate);
                }
                if (StandardAclResourcePropertyConditions.NULL.getId().equals(condition.getId())) {
                    return AclRulesHelper.isNull((Object)issueDate);
                }
                if (StandardAclResourcePropertyConditions.NOT_NULL.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isNull((Object)issueDate);
                }
            }
            return true;
        }
    };


    public abstract String getIdSuffix();

    public String getId() {
        return String.format("%s.%s", this.getResourceId(), this.getIdSuffix());
    }

    public String getResourceId() {
        return ModelAclEntityResources.ENTITY_BOOKING_FILE.getId();
    }

    public String getInfo(AclResourcePropertyCondition condition, Object value) {
        AclResourcesEnvironment environment = (AclResourcesEnvironment)Environment.getPublished(AclResourcesEnvironment.class);
        String propertyName = this.getName();
        String resourceName = environment.getResource(this.getResourceId()).getName();
        return AclRulesHelper.getInfo((String)String.format("%s (%s)", propertyName, resourceName), (AclResourcePropertyCondition)condition, (Object)value);
    }
}

