/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.security.acl.resource;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.security.acl.helper.AclModelRulesHelper;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclEntityResources;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclResourcePropertyConditions;
import com.gridnine.xtrip.common.security.acl.helper.AclRulesHelper;
import com.gridnine.xtrip.common.security.acl.resource.AclMatchable;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProperty;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyType;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProxy;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcesEnvironment;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourcePropertyConditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum ModelAclContractResourceProperties implements AclResourceProperty,
AclMatchable
{
    TYPE{

        @Override
        public String getIdSuffix() {
            return "type";
        }

        public String getName() {
            return "\u0422\u0438\u043f";
        }

        public Class<?> getType() {
            return ContractType.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENUM.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENUM_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((Contract)object).getContractType());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                ContractType type = (ContractType)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)type, (Object)((ContractType)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)type, (Object)((ContractType)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)type, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)type, (Collection)((List)value));
                }
            }
            return true;
        }
    }
    ,
    BLANK_OWNER{

        @Override
        public String getIdSuffix() {
            return "blankOwner";
        }

        public String getName() {
            return "\u0412\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0431\u043b\u0430\u043d\u043a\u043e\u0432";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((Contract)object).getVendor());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference blankOwner = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)blankOwner, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)blankOwner, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)blankOwner, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)blankOwner, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyOrganizations((EntityReference<Organization>)blankOwner, userId);
                }
            }
            return true;
        }
    }
    ,
    SUPPLIER{

        @Override
        public String getIdSuffix() {
            return "supplier";
        }

        public String getName() {
            return "\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((Contract)object).getSupplier());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference supplier = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)supplier, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)supplier, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)supplier, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)supplier, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyOrganizations((EntityReference<Organization>)supplier, userId);
                }
            }
            return true;
        }
    }
    ,
    AGENCY_OR_CLIENT{

        @Override
        public String getIdSuffix() {
            return "agencyOrClient";
        }

        public String getName() {
            return "\u0410\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e/\u041a\u043b\u0438\u0435\u043d\u0442";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            ArrayList<EntityReference> organizations = new ArrayList<EntityReference>();
            for (ContractCustomerInfo info : ((Contract)object).getCustomers()) {
                organizations.add(info.getCustomer());
            }
            proxy.getProperties().put(this.getId(), organizations);
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                List organizations = (List)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Collection)organizations, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Collection)organizations, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Collection)organizations, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Collection)organizations, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyOrganizations(organizations, userId);
                }
            }
            return true;
        }
    }
    ,
    DISABLED{

        @Override
        public String getIdSuffix() {
            return "disabled";
        }

        public String getName() {
            return "\u041d\u0435 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u0432 \u0441\u043f\u0438\u0441\u043a\u0430\u0445";
        }

        public Class<?> getType() {
            return Boolean.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.YES.getId(), StandardAclResourcePropertyConditions.NO.getId()));
        }

        public String getRendererId(String conditionId) {
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((Contract)object).isDisabled());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                Boolean disabled = (Boolean)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.YES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)disabled, (Object)Boolean.TRUE);
                }
                if (StandardAclResourcePropertyConditions.NO.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)disabled, (Object)Boolean.FALSE);
                }
            }
            return true;
        }
    };


    public abstract String getIdSuffix();

    public String getId() {
        return String.format("%s.%s", this.getResourceId(), this.getIdSuffix());
    }

    public String getResourceId() {
        return ModelAclEntityResources.ENTITY_CONTRACT.getId();
    }

    public String getInfo(AclResourcePropertyCondition condition, Object value) {
        AclResourcesEnvironment environment = (AclResourcesEnvironment)Environment.getPublished(AclResourcesEnvironment.class);
        String propertyName = this.getName();
        String resourceName = environment.getResource(this.getResourceId()).getName();
        return AclRulesHelper.getInfo((String)String.format("%s (%s)", propertyName, resourceName), (AclResourcePropertyCondition)condition, (Object)value);
    }
}

