/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.security.acl.resource;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.DebitBankTransferOrder;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.security.acl.helper.AclModelRulesHelper;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclEntityResources;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclResourcePropertyConditions;
import com.gridnine.xtrip.common.security.acl.helper.AclRulesHelper;
import com.gridnine.xtrip.common.security.acl.resource.AclMatchable;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProperty;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyType;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProxy;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcesEnvironment;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourcePropertyConditions;
import com.gridnine.xtrip.common.util.DateInterval;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum ModelAclDebitBankTransferOrderResourceProperties implements AclResourceProperty,
AclMatchable
{
    NUMBER{

        @Override
        public String getIdSuffix() {
            return "number";
        }

        public String getName() {
            return "\u041d\u043e\u043c\u0435\u0440";
        }

        public Class<?> getType() {
            return String.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.STRING.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.STRING_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((DebitBankTransferOrder)object).getNumber());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                String number = (String)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)number, (Object)((String)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)number, (Object)((String)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)number, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)number, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NULL.getId().equals(condition.getId())) {
                    return AclRulesHelper.isNull((Object)number);
                }
                if (StandardAclResourcePropertyConditions.NOT_NULL.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isNull((Object)number);
                }
            }
            return true;
        }
    }
    ,
    DATE{

        @Override
        public String getIdSuffix() {
            return "date";
        }

        public String getName() {
            return "\u0414\u0430\u0442\u0430";
        }

        public Class<?> getType() {
            return Date.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId(), StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId(), StandardAclResourcePropertyConditions.TODAY.getId(), StandardAclResourcePropertyConditions.YESTERDAY.getId(), StandardAclResourcePropertyConditions.CURRENT_DECADE.getId(), StandardAclResourcePropertyConditions.LAST_DECADE.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.DATE_TIME.name();
            }
            if (StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId().equals(conditionId) || StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId().equals(conditionId)) {
                return AclResourcePropertyType.DATE_TIME_INTERVAL.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((DebitBankTransferOrder)object).getDate());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                Date date = (Date)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)date, (Object)((Date)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)date, (Object)((Date)value));
                }
                if (StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId().equals(condition.getId())) {
                    return AclRulesHelper.isWithin((Date)date, (DateInterval)((DateInterval)value));
                }
                if (StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isWithin((Date)date, (DateInterval)((DateInterval)value));
                }
                if (StandardAclResourcePropertyConditions.TODAY.getId().equals(condition.getId())) {
                    return AclRulesHelper.isToday((Date)date);
                }
                if (StandardAclResourcePropertyConditions.YESTERDAY.getId().equals(condition.getId())) {
                    return AclRulesHelper.isYesterday((Date)date);
                }
                if (StandardAclResourcePropertyConditions.CURRENT_DECADE.getId().equals(condition.getId())) {
                    return AclRulesHelper.isCurrentDecade((Date)date);
                }
                if (StandardAclResourcePropertyConditions.LAST_DECADE.getId().equals(condition.getId())) {
                    return AclRulesHelper.isLastDecade((Date)date);
                }
                if (StandardAclResourcePropertyConditions.NULL.getId().equals(condition.getId())) {
                    return AclRulesHelper.isNull((Object)date);
                }
                if (StandardAclResourcePropertyConditions.NOT_NULL.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isNull((Object)date);
                }
            }
            return true;
        }
    }
    ,
    ORGANIZATION{

        @Override
        public String getIdSuffix() {
            return "organization";
        }

        public String getName() {
            return "\u041f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044c";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((DebitBankTransferOrder)object).getOrganization());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference customer = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)customer, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)customer, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)customer, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)customer, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyOrganizations((EntityReference<Organization>)customer, userId);
                }
            }
            return true;
        }
    }
    ,
    PAYER{

        @Override
        public String getIdSuffix() {
            return "payer";
        }

        public String getName() {
            return "\u041f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((DebitBankTransferOrder)object).getPayer());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference payer = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)payer, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)payer, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)payer, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)payer, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyOrganizations((EntityReference<Organization>)payer, userId);
                }
            }
            return true;
        }
    };


    public abstract String getIdSuffix();

    public String getId() {
        return String.format("%s.%s", this.getResourceId(), this.getIdSuffix());
    }

    public String getResourceId() {
        return ModelAclEntityResources.ENTITY_DEBIT_BANK_TRANSFER_ORDER.getId();
    }

    public String getInfo(AclResourcePropertyCondition condition, Object value) {
        AclResourcesEnvironment environment = (AclResourcesEnvironment)Environment.getPublished(AclResourcesEnvironment.class);
        String propertyName = this.getName();
        String resourceName = environment.getResource(this.getResourceId()).getName();
        return AclRulesHelper.getInfo((String)String.format("%s (%s)", propertyName, resourceName), (AclResourcePropertyCondition)condition, (Object)value);
    }
}

