/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.security.acl.resource;

import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclIndexResourceOwnershipProperty;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclResourcePropertyConditions;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyType;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourcePropertyConditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelAclHoldingIndexResourceOwnershipProperty
extends ModelAclIndexResourceOwnershipProperty {
    private static final Logger log = LoggerFactory.getLogger(ModelAclHoldingIndexResourceOwnershipProperty.class);

    public ModelAclHoldingIndexResourceOwnershipProperty(IndexType index, String propertyId, String propertyName, String propertyType) {
        super(index, propertyId, propertyName, propertyType);
    }

    public Set<String> getConditionIds() {
        return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS.getId(), ModelAclResourcePropertyConditions.MY_CHILDREN_ORGANIZATIONS_HOLDINGS.getId()));
    }

    public String getRendererId(String conditionId) {
        if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
            return AclResourcePropertyType.ENTITY_LIST.name();
        }
        return AclResourcePropertyType.NULL.name();
    }

    public SearchCriterion getQuery(AclResourcePropertyCondition condition, Object value, String userId) {
        if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
            return this.createContainerUidIncludesCriterion((Iterable)value);
        }
        if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
            return this.createContainerUidNotIncludesCriterion((Iterable)value);
        }
        if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS.getId().equals(condition.getId())) {
            ArrayList<EntityReference<? extends BaseEntity>> holdings = new ArrayList<EntityReference<? extends BaseEntity>>();
            try {
                EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
                if (person != null && ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS.getId().equals(condition.getId())) {
                    holdings.addAll(ProfileHelper.getOrganizationHoldings(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date())));
                }
            }
            catch (Exception e) {
                log.error("unable to collect entities", (Throwable)e);
            }
            return this.createContainerUidIncludesCriterion(holdings);
        }
        if (ModelAclResourcePropertyConditions.MY_CHILDREN_ORGANIZATIONS_HOLDINGS.getId().equals(condition.getId())) {
            ArrayList<EntityReference<? extends BaseEntity>> holdings = new ArrayList<EntityReference<? extends BaseEntity>>();
            try {
                EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
                if (person != null) {
                    Collection<EntityReference<Organization>> childrenOrganizations = ProfileHelper.getOrganizationChildren(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date()));
                    holdings.addAll(ProfileHelper.getOrganizationHoldings(childrenOrganizations));
                }
            }
            catch (Exception e) {
                log.error("unable to collect entities", (Throwable)e);
            }
            return this.createContainerUidIncludesCriterion(holdings);
        }
        return null;
    }
}

